/*******************************************************************************
 * Copyright (c) 2004, 2010 IBM Corporation.
 * All rights reserved. 
 * 20100318:jta Updated collapse function in case browser considers text nodes
 * Updated 9/2013 to reload page which twistie is expanded or collapsed.  
 *******************************************************************************/

/*
Example of calling this function:
<div class="collapseheadlearnmore"><a href="javascript:void(0)" class="collapsehead" onclick="collapse(this)">Learn more about something</a></div><div class="collapsecontent">This section should be collapsed and hidden.</div>
The collapse effect also takes advantage of styles defined in tutorials.css
*/
function kc_resize(){

    var container = window.parent.dojo.query(".topicIFrameContainer");
    if (container && container[0]) {
        var kcFrameWidget = window.parent.dijit.byNode(container[0]);
        kcFrameWidget._onIFrameResize();
    }
}

function collapse(loc){
	
	//Navigate to the content division using DOM, then change its style
	var foc=loc.parentNode.parentNode;
	for (i=0;i<foc.childNodes.length;i++) {
		var foc2=foc.childNodes[i];
		if (foc2.attributes) {
			for (j=0;j<foc2.attributes.length;j++) {
				if (foc2.attributes[j].nodeName.toLowerCase() == 'class') {
			   		if (foc2.attributes[j].nodeValue == 'collapsecontent') {
			      		foc2.style.display=foc2.style.display=='block'?'none':'block';
						break;
			   		}
				}
		   	}
		}
	}
	
	//Find the header anchor by navigating the DOM tree, then change its class attribute to use a different style
	//var headA = loc.parentNode.firstChild;
	var headA = loc.parentNode;
	for (i=0;i<headA.childNodes.length;i++) {
		var headB=headA.childNodes[i];
		if (headB.attributes) {
			for (j=0;j<headB.attributes.length;j++) {
				if (headB.attributes[j].nodeName.toLowerCase() == 'class') {
			   		if ((headB.attributes[j].nodeValue == 'collapsehead') || (headB.attributes[j].nodeValue == 'collapseheadopen')) {
			      		headB.className=headB.className=='collapsehead'?'collapseheadopen':'collapsehead';
						break;
			   		}
				}
		   	}
		}
	}
	  kc_resize();
}

/*
*
* These functions are used by Tours in the gallery
*
*
*/

function popup_window( url ) { 
	popup = window.open(url + "?noframes=true", "touregl", "toolbar=no,scrollbars=yes,location=no,statusbar=no,menubar=no,resizable=no,width=1021,height=510,left=0,top=0" ); 
	popup.focus(); 
}

function popup_html( url, id, width, height ) { 
	popup = window.open( url, id, 'toolbar=no,scrollbars=yes,location=no,statusbar=no,menubar=no,resizable=yes,width=' + width + ',height=' + height + ',left=0,top=0' ); 
	popup.focus(); 
}
