/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.viewers;

import com.ibm.cic.common.core.repository.RepositoryDescriptor;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.ui.internal.Messages;
import com.ibm.cic.common.ui.services.UiServices;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PropertyTable {
    private Table settingsTable;
    private TableEditor tableEditor;
    private int inputActiveCol;
    private List properties;
    private String repType;
    private final List listeners = new ArrayList();
    private static final char ECHO_CHAR = '*';

    public PropertyTable(Composite parent, boolean formStyle, FormToolkit toolkit, List nameValueList, String type, int hSpan) {
        this.properties = nameValueList;
        this.repType = type;
        int style = 66304;
        this.settingsTable = formStyle ? toolkit.createTable(parent, style | toolkit.getBorderStyle()) : new Table(parent, style | 0x800);
        GridData data = new GridData(1808);
        data.heightHint = this.settingsTable.getItemHeight() * 6;
        data.horizontalSpan = hSpan;
        data.horizontalIndent = 2;
        data.verticalIndent = 2;
        this.settingsTable.setLayoutData((Object)data);
        if (formStyle) {
            UiServices.getInstance().paintBordersFor(toolkit, parent);
        }
        this.settingsTable.setHeaderVisible(true);
        this.settingsTable.setLinesVisible(true);
        TableColumn col1 = new TableColumn(this.settingsTable, 16384);
        col1.setText(Messages.AddRepositoryDialog_specialSettings_Name);
        col1.setWidth(150);
        TableColumn col2 = new TableColumn(this.settingsTable, 16384);
        col2.setText(Messages.AddRepositoryDialog_specialSettings_Value);
        col2.setWidth(250);
        this.populateTableContents();
        if (this.tableEditor != null) {
            Control existingEditor = this.tableEditor.getEditor();
            if (existingEditor != null && !existingEditor.isDisposed()) {
                existingEditor.dispose();
            }
        } else {
            this.tableEditor = new TableEditor(this.settingsTable);
            this.tableEditor.horizontalAlignment = 16384;
            this.tableEditor.grabHorizontal = true;
        }
        this.settingsTable.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                try {
                    int inputXPos = e.x;
                    int inputYPos = e.y;
                    if (PropertyTable.this.settingsTable == null) {
                        return;
                    }
                    TableItem[] items = PropertyTable.this.settingsTable.getSelection();
                    if (items.length == 0) {
                        return;
                    }
                    Rectangle b0 = items[0].getBounds(0);
                    Rectangle b1 = items[0].getBounds(1);
                    Point px = new Point(inputXPos, inputYPos);
                    if (b0.contains(px)) {
                        PropertyTable.this.inputActiveCol = 0;
                    }
                    if (b1.contains(px)) {
                        PropertyTable.this.inputActiveCol = 1;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.settingsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){
            TableItem item = null;

            public void widgetSelected(SelectionEvent e) {
                try {
                    int inputActiveRow;
                    Control existingEditor = PropertyTable.this.tableEditor.getEditor();
                    if (existingEditor != null && !existingEditor.isDisposed()) {
                        existingEditor.dispose();
                    }
                    if ((inputActiveRow = PropertyTable.this.settingsTable.getSelectionIndex()) == -1) {
                        return;
                    }
                    this.item = PropertyTable.this.settingsTable.getItem(inputActiveRow);
                    String name = this.item.getText(0);
                    if (!name.equals("Type")) {
                        PropertyTable.this.tableEditor.setEditor(this.createEditor(this.item), this.item, PropertyTable.this.inputActiveCol);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            private Control createEditor(TableItem theItem) {
                try {
                    if (PropertyTable.this.inputActiveCol == 1) {
                        Composite editorComposite = new Composite((Composite)PropertyTable.this.settingsTable, 0);
                        GridLayout editorLayout = new GridLayout();
                        editorLayout.numColumns = 1;
                        editorLayout.marginHeight = 0;
                        editorLayout.marginWidth = 0;
                        editorLayout.verticalSpacing = 0;
                        editorLayout.horizontalSpacing = 0;
                        editorComposite.setLayout((Layout)editorLayout);
                        GridData editorData = new GridData(1808);
                        editorComposite.setLayoutData((Object)editorData);
                        final String name = theItem.getText(0);
                        boolean passwordField = PropertyTable.this.isPasswordParameter(name);
                        Text text = null;
                        if (passwordField) {
                            text = new Text(editorComposite, 0x400004);
                            text.setEchoChar('*');
                            String realText = "";
                            if (PropertyTable.this.properties != null && !PropertyTable.this.properties.isEmpty()) {
                                for (Map nameValueMap : PropertyTable.this.properties) {
                                    String nameTag = (String)nameValueMap.keySet().iterator().next();
                                    if (!nameTag.equals(name)) continue;
                                    realText = (String)nameValueMap.get(name);
                                }
                            }
                            text.setText(realText);
                        } else {
                            text = new Text(editorComposite, 4);
                            text.setText(theItem.getText(PropertyTable.this.inputActiveCol));
                        }
                        text.setLayoutData((Object)new GridData(1808));
                        final Text finalText = text;
                        final boolean finalPwdField = passwordField;
                        text.addFocusListener(new FocusListener(){

                            public void focusGained(FocusEvent e) {
                            }

                            public void focusLost(FocusEvent e) {
                                if (PropertyTable.this.properties != null && !PropertyTable.this.properties.isEmpty()) {
                                    for (Map nameValueMap : PropertyTable.this.properties) {
                                        String nameTag = (String)nameValueMap.keySet().iterator().next();
                                        if (!nameTag.equals(name)) continue;
                                        nameValueMap.put(name, finalText.getText().trim());
                                    }
                                }
                                if (finalPwdField) {
                                    PropertyTable.this.settingsTable.getItem(PropertyTable.this.settingsTable.getSelectionIndex()).setText(PropertyTable.this.inputActiveCol, PropertyTable.this.getEchoString(finalText.getText().trim()));
                                } else {
                                    PropertyTable.this.settingsTable.getItem(PropertyTable.this.settingsTable.getSelectionIndex()).setText(PropertyTable.this.inputActiveCol, finalText.getText().trim());
                                }
                                PropertyTable.this.firePropertyChangeEvent(null);
                            }
                        });
                        text.setFocus();
                        return editorComposite;
                    }
                    return null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
        });
    }

    public Table getTable() {
        return this.settingsTable;
    }

    public void populateTableContents() {
        Control existingEditor;
        this.settingsTable.removeAll();
        if (this.tableEditor != null && (existingEditor = this.tableEditor.getEditor()) != null && !existingEditor.isDisposed()) {
            existingEditor.dispose();
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            for (Map nameValue : this.properties) {
                String name = null;
                String value = null;
                Set keys = nameValue.keySet();
                if (keys != null && !keys.isEmpty()) {
                    name = (String)keys.iterator().next();
                }
                if ((value = (String)nameValue.get(name)) == null) {
                    value = "";
                }
                TableItem item = new TableItem(this.settingsTable, 0);
                if (this.isPasswordParameter(name)) {
                    item.setText(new String[]{name, this.getEchoString(value)});
                    continue;
                }
                item.setText(new String[]{name, value});
            }
        }
    }

    public void setProperties(List changedProperties) {
        this.properties = changedProperties;
    }

    private String getEchoString(String value) {
        StringBuffer buffer = new StringBuffer(value.length());
        int i = 0;
        while (i < value.length()) {
            buffer.append('*');
            ++i;
        }
        return buffer.toString();
    }

    public void addPropertyListeners(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((IPropertyChangeListener)it.next()).propertyChange(event);
        }
    }

    private boolean isPasswordParameter(String parameterName) {
        Object type;
        RepositoryDescriptor de;
        int n;
        int n2;
        RepositoryDescriptor[] repositoryDescriptorArray;
        RepositoryDescriptor repDescriptor = null;
        RepositoryDescriptor[] des = RepositoryGroup.getDefault().getRepositoryDescriptors();
        if (this.repType != null && this.repType.length() > 0) {
            repositoryDescriptorArray = des;
            n2 = des.length;
            n = 0;
            while (n < n2) {
                de = repositoryDescriptorArray[n];
                type = de.getType();
                if (((String)type).equals(this.repType)) {
                    repDescriptor = de;
                    break;
                }
                ++n;
            }
        }
        if (repDescriptor != null) {
            RepositoryDescriptor.RepositoryParameter[] pars = repDescriptor.getRepositoryParameters();
            type = pars;
            int n3 = pars.length;
            n2 = 0;
            while (n2 < n3) {
                RepositoryDescriptor.RepositoryParameter par = type[n2];
                String name = par.tag.label();
                if (name.equals(parameterName)) {
                    return par.isPassword;
                }
                ++n2;
            }
        } else {
            repositoryDescriptorArray = des;
            n2 = des.length;
            n = 0;
            while (n < n2) {
                RepositoryDescriptor.RepositoryParameter[] pars;
                de = repositoryDescriptorArray[n];
                RepositoryDescriptor.RepositoryParameter[] repositoryParameterArray = pars = de.getRepositoryParameters();
                int n4 = pars.length;
                int n5 = 0;
                while (n5 < n4) {
                    RepositoryDescriptor.RepositoryParameter par = repositoryParameterArray[n5];
                    String name = par.tag.label();
                    if (name.equals(parameterName)) {
                        return par.isPassword;
                    }
                    ++n5;
                }
                ++n;
            }
        }
        return false;
    }
}

