/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.licensePanel;

import com.ibm.cic.common.core.console.shared.manager.licensePanel.LicensePageData;
import com.ibm.cic.common.core.internal.LicenseFactory;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import com.ibm.cic.common.ui.internal.licensePanel.BaseEclipseStyleLicensePage;
import com.ibm.cic.common.ui.internal.licensePanel.LicenseTreeViewer;
import com.ibm.cic.common.ui.internal.licensePanel.Messages;
import com.ibm.cic.common.ui.services.IStyledText;
import com.ibm.cic.common.ui.services.UiServices;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class LicensePart {
    protected LicenseTreeViewer licenseList;
    protected LicenseContentProvider contentProvider;
    protected LicenseFactory.License[] licenseArray;
    protected LicensePageData licensePageData;
    protected IStyledText text;
    protected Button acceptButton;
    protected Button declineButton;
    protected Button printButton;
    protected Combo viewInLangButton;
    protected Composite clientArea;
    protected LicensePageData.LanguageChoice currentLanguageChoice = new LicensePageData.LanguageChoice();
    protected LicenseFactory.License currentLicense = null;
    protected Object lastSelection = null;
    protected List currentLicenseNode;
    protected BaseEclipseStyleLicensePage parentPage;

    public LicensePart(BaseEclipseStyleLicensePage parentPage) {
        this.parentPage = parentPage;
    }

    public void resetButtons() {
        this.acceptButton.setSelection(false);
        this.declineButton.setSelection(false);
    }

    public void createControl(Composite parent) {
        this.clientArea = this.getToolkit().createComposite(parent);
        final TableWrapLayout clientLayout = new TableWrapLayout();
        clientLayout.numColumns = 2;
        this.clientArea.setLayout((Layout)clientLayout);
        TableWrapData twd = new TableWrapData(256, 256);
        this.clientArea.setLayoutData((Object)twd);
        if (this.hasMultipleLicenses()) {
            Listener[] existingListener;
            this.licenseList = new LicenseTreeViewer(this.clientArea, 2820);
            this.contentProvider = new LicenseContentProvider();
            this.licenseList.setContentProvider((IContentProvider)this.contentProvider);
            this.licenseList.setSorter(new LicenseSorter());
            this.licenseList.setAutoExpandLevel(-1);
            final Tree tree = this.licenseList.getTree();
            Listener[] listenerArray = existingListener = tree.getListeners(1);
            int n = existingListener.length;
            int n2 = 0;
            while (n2 < n) {
                Listener element = listenerArray[n2];
                tree.removeListener(1, element);
                ++n2;
            }
            this.licenseList.getTree().addListener(1, new Listener(){

                public void handleEvent(Event e) {
                    if (e.type == 1) {
                        if (e.keyCode == 0x1000002 && e.stateMask == 0) {
                            TreeItem previousSelection = null;
                            TreeItem[] selections = tree.getSelection();
                            if (selections != null && selections.length > 0) {
                                previousSelection = selections[0];
                            }
                            final TreeItem finalPreviousSelection = previousSelection;
                            DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    int index;
                                    TreeItem[] selection = tree.getSelection();
                                    if (selection != null && selection.length > 0 && (this).LicensePart.this.currentLicenseNode != null && finalPreviousSelection == selection[0] && (index = (this).LicensePart.this.currentLicenseNode.indexOf(selection[0])) < (this).LicensePart.this.currentLicenseNode.size() - 1) {
                                        TreeItem downLicenseItem = (TreeItem)(this).LicensePart.this.currentLicenseNode.get(index + 1);
                                        (this).LicensePart.this.licenseList.setSelection((ISelection)new StructuredSelection(downLicenseItem.getData()), true);
                                    }
                                }
                            });
                        } else if (e.keyCode == 0x1000001 && e.stateMask == 0) {
                            TreeItem previousSelection = null;
                            TreeItem[] selections = tree.getSelection();
                            if (selections != null && selections.length > 0) {
                                previousSelection = selections[0];
                            }
                            final TreeItem finalPreviousSelection = previousSelection;
                            DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    int index;
                                    TreeItem[] selection = tree.getSelection();
                                    if (selection != null && selection.length > 0 && (this).LicensePart.this.currentLicenseNode != null && finalPreviousSelection == selection[0] && (index = (this).LicensePart.this.currentLicenseNode.indexOf(selection[0])) > 0) {
                                        TreeItem upLicenseItem = (TreeItem)(this).LicensePart.this.currentLicenseNode.get(index - 1);
                                        (this).LicensePart.this.licenseList.setSelection((ISelection)new StructuredSelection(upLicenseItem.getData()), true);
                                    }
                                }
                            });
                        }
                    }
                }
            });
            this.licenseList.addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object selectedElement;
                    StructuredSelection structuredSelection;
                    ISelection selection = event.getSelection();
                    if (selection instanceof StructuredSelection && !(structuredSelection = (StructuredSelection)selection).isEmpty() && (selectedElement = structuredSelection.getFirstElement()) != null && !selectedElement.equals(LicensePart.this.lastSelection)) {
                        LicensePart.this.lastSelection = selectedElement;
                        if (selectedElement instanceof LicensePageData.ILicenseNode) {
                            LicensePart.this.licenseList.setLastSelection((LicensePageData.ILicenseNode)selectedElement);
                            LicenseFactory.License license = ((LicensePageData.ILicenseNode)selectedElement).getLicense();
                            LicensePart.this.setLicenseText(license);
                        }
                    }
                }
            });
            TableWrapData data = new TableWrapData(2, 256);
            data.maxWidth = 500;
            data.heightHint = this.licenseList.getTree().getItemHeight() * 8;
            this.licenseList.getControl().setLayoutData((Object)data);
        }
        Composite textContainer = this.getToolkit().createComposite(this.clientArea);
        textContainer.setLayout((Layout)new TextWrapLayout());
        this.text = UiServices.getInstance().createStyledText(textContainer, 2634);
        this.getToolkit().adapt(this.text.getControl(), true, false);
        final TableWrapData textData = new TableWrapData(256, 256);
        textData.colspan = this.hasMultipleLicenses() ? 1 : 2;
        textContainer.setLayoutData((Object)textData);
        final Composite buttonContainer = this.getToolkit().createComposite(this.clientArea);
        TableWrapData data = new TableWrapData(256, 64);
        data.colspan = 2;
        buttonContainer.setLayoutData((Object)data);
        TableWrapLayout buttonLayout = new TableWrapLayout();
        buttonLayout.numColumns = this.defaultLocaleIsEnglish() ? 2 : 3;
        buttonLayout.leftMargin = 0;
        buttonLayout.rightMargin = 0;
        buttonContainer.setLayout((Layout)buttonLayout);
        textData.heightHint = this.calculateTextHeigh(clientLayout, buttonContainer);
        this.clientArea.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                textData.heightHint = LicensePart.this.calculateTextHeigh(clientLayout, buttonContainer);
                LicensePart.this.clientArea.layout();
            }
        });
        if (Platform.getOS().equals("linux") || Platform.getOS().equals("solaris") || Platform.getOS().equals("aix")) {
            this.clientArea.addListener(9, new Listener(){
                private boolean layoutCalled = false;

                public void handleEvent(Event event) {
                    if (!this.layoutCalled) {
                        this.layoutCalled = true;
                        LicensePart.this.clientArea.layout();
                    }
                }
            });
        }
        Composite radioButtonContainer = this.getToolkit().createComposite(buttonContainer);
        TableWrapData radioContainerData = new TableWrapData(256, 64);
        radioButtonContainer.setLayoutData((Object)radioContainerData);
        TableWrapLayout radioButtonContainerLayout = new TableWrapLayout();
        radioButtonContainerLayout.leftMargin = 0;
        radioButtonContainerLayout.topMargin = 0;
        radioButtonContainer.setLayout((Layout)radioButtonContainerLayout);
        this.acceptButton = this.getToolkit().createButton(radioButtonContainer, LicensePageData.getAcceptanceStatement((boolean)this.hasMultipleLicenses()), 16);
        this.acceptButton.setLayoutData((Object)new TableWrapData(2, 16));
        this.acceptButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicensePart.this.parentPage.setErrorMessage(null);
                LicensePart.this.parentPage.setPageComplete(true);
            }
        });
        this.declineButton = this.getToolkit().createButton(radioButtonContainer, LicensePageData.getDeclinedStatement((boolean)this.hasMultipleLicenses()), 16);
        this.declineButton.setLayoutData((Object)new TableWrapData(2, 16));
        this.declineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicensePart.this.parentPage.setErrorMessage(LicensePart.this.parentPage.getDeclineMessage());
                LicensePart.this.parentPage.setPageComplete(false);
            }
        });
        if (!this.defaultLocaleIsEnglish()) {
            this.viewInLangButton = new Combo(buttonContainer, 8);
            String[] biLangChoices = LicensePageData.getBiLangSelection();
            this.viewInLangButton.setItems(biLangChoices);
            this.viewInLangButton.select(LicensePageData.getNonEnglishIndex((String[])biLangChoices));
            TableWrapData viewInLangData = new TableWrapData(8, 16);
            this.viewInLangButton.setLayoutData((Object)viewInLangData);
            this.viewInLangButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int selectionIndex = LicensePart.this.viewInLangButton.getSelectionIndex();
                    LicensePart.this.currentLanguageChoice.setEnglish(LicensePageData.isEnglishIndex((String[])LicensePageData.getBiLangSelection(), (int)selectionIndex));
                    if (LicensePart.this.currentLanguageChoice.isEnglish()) {
                        LicensePart.this.setLicenseTextWithLocale(LicensePart.this.currentLicense, new Locale("en"));
                    } else {
                        LicensePart.this.setLicenseTextWithLocale(LicensePart.this.currentLicense, Locale.getDefault());
                    }
                    LicensePart.this.resetLicenseTextOrientation(LicensePart.this.currentLanguageChoice.isEnglish());
                }
            });
        }
        this.createPrintControls(buttonContainer);
        if (this.parentPage.isAcceptLicense) {
            this.acceptButton.setSelection(true);
        }
        if (this.licenseList != null) {
            this.licensePageData = new LicensePageData(this.licenseArray);
        }
    }

    protected void createPrintControls(Composite buttonContainer) {
        this.printButton = this.getToolkit().createButton(buttonContainer, Messages.LicensePage_printButton, 8);
        TableWrapData printBtnData = new TableWrapData(8, 16);
        this.printButton.setLayoutData((Object)printBtnData);
    }

    public LicenseTreeViewer getLicenseList() {
        return this.licenseList;
    }

    private boolean defaultLocaleIsEnglish() {
        return LicensePageData.defaultLocaleIsEnglish();
    }

    public void generateLicenseTreeNodes(LicenseFactory.License[] lics) {
        this.licensePageData.addLicenses(lics);
    }

    private FormToolkit getToolkit() {
        return this.parentPage.getFormToolkit();
    }

    public LicensePageData getLicensePageData() {
        return this.licensePageData;
    }

    public void generateLicenseNodeList() {
        this.currentLicenseNode = new ArrayList();
        TreeItem[] nodes = this.licenseList.getTree().getItems();
        if (nodes != null && nodes.length > 0) {
            TreeItem[] treeItemArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem node = treeItemArray[n2];
                if (node.getData() instanceof LicensePageData.ILicenseNode) {
                    this.currentLicenseNode.add(node);
                }
                this.traverseTreeItem(node, this.currentLicenseNode);
                ++n2;
            }
        }
    }

    private void traverseTreeItem(TreeItem item, List result) {
        TreeItem[] children = item.getItems();
        if (children != null && children.length > 0) {
            TreeItem[] treeItemArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem element = treeItemArray[n2];
                if (element.getData() instanceof LicensePageData.ILicenseNode) {
                    result.add(element);
                }
                this.traverseTreeItem(element, result);
                ++n2;
            }
        }
    }

    private int calculateTextHeigh(TableWrapLayout clientLayout, Composite buttonContainer) {
        int height = this.clientArea.getClientArea().height - buttonContainer.computeSize((int)-1, (int)-1).y - clientLayout.verticalSpacing - clientLayout.topMargin - clientLayout.bottomMargin;
        return height;
    }

    private void setLicenseTextWithLocale(LicenseFactory.License license, Locale locale) {
        if (license == null) {
            this.text.setText("");
        } else {
            try {
                String localizedLicenseText = license.getLicenseText(locale);
                this.text.setText(localizedLicenseText);
            }
            catch (IOException iOException) {
                this.text.setText(LicensePageData.getLicensePageProblems());
            }
        }
    }

    private void enableLangButton(boolean enable) {
        if (this.viewInLangButton != null) {
            this.viewInLangButton.setEnabled(enable);
        }
    }

    protected void resetLicenseTextOrientation(boolean englishLicense) {
        if (CommonUIUtils.runningBiDiLocale()) {
            int orientation = 0x2000000;
            this.text.setOrientation(orientation);
            this.text.getParent().layout();
        }
    }

    protected void setLicenseText(LicenseFactory.License license) {
        this.currentLicense = license;
        if (license == null) {
            this.text.setText("");
            this.enableLangButton(false);
            return;
        }
        try {
            LicensePageData.LanguageChoicesForLicense langChoices = LicensePageData.LanguageChoicesForLicense.create((LicenseFactory.License)license);
            String chosenText = langChoices.getLicenseText(this.currentLanguageChoice);
            this.text.setText(chosenText != null ? chosenText : langChoices.getEnglishLicenseText());
            this.resetLicenseTextOrientation(langChoices.hasOnlyEnglishLicenseText() || this.currentLanguageChoice.isEnglish());
            if (this.viewInLangButton != null) {
                this.enableLangButton(true);
                String[] choices = langChoices.getLanguageChoices();
                this.viewInLangButton.setItems(choices);
                if (langChoices.hasOnlyEnglishLicenseText()) {
                    this.viewInLangButton.select(LicensePageData.getEnglishIndex((String[])choices));
                    this.currentLanguageChoice.setEnglish(true);
                } else if (this.currentLanguageChoice.isEnglish()) {
                    this.viewInLangButton.select(LicensePageData.getEnglishIndex((String[])choices));
                } else {
                    this.viewInLangButton.select(LicensePageData.getNonEnglishIndex((String[])choices));
                }
            }
        }
        catch (IOException e) {
            this.text.setText(LicensePageData.getLicensePageProblems());
            if (this.viewInLangButton != null) {
                this.viewInLangButton.select(0);
                this.currentLanguageChoice.setEnglish(false);
            }
            CicCommonUiPlugin.logException(e);
        }
    }

    protected boolean hasMultipleLicenses() {
        if (this.parentPage.multipleLicenseMode) {
            return true;
        }
        return this.licenseArray.length != 1;
    }

    public Control getControl() {
        return this.clientArea;
    }

    protected Collection getRootNodes() {
        if (this.licensePageData != null) {
            return this.licensePageData.getRootNodes();
        }
        return null;
    }

    protected LicenseFactory.License[] getLicenseArray() {
        return this.licenseArray;
    }

    protected void setLicenseArray(LicenseFactory.License[] licenseArray) {
        this.licenseArray = licenseArray;
    }

    protected void refreshLicenses(LicenseFactory.License[] licenses) {
        this.setLicenseArray(licenses);
        this.licensePageData = new LicensePageData(this.licenseArray);
    }

    private static class LicenseContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private LicenseContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof LicensePageData.IGroupingNode) {
                LicensePageData.IGroupingNode parentNode = (LicensePageData.IGroupingNode)parentElement;
                Collection subGroups = parentNode.getSubGroups();
                LicensePageData.ILicenseNode[] lics = parentNode.getLicenses();
                ArrayList<LicensePageData.ILicenseNode> licenseArray = new ArrayList<LicensePageData.ILicenseNode>(Arrays.asList(lics));
                licenseArray.addAll(subGroups);
                return licenseArray.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof LicensePageData.IGroupingNode) {
                return ((LicensePageData.IGroupingNode)element).getParentNode();
            }
            if (element instanceof LicensePageData.ILicenseNode) {
                return ((LicensePageData.ILicenseNode)element).getParentNode();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof LicensePageData.IGroupingNode;
        }
    }

    private static class LicenseSorter
    extends ViewerSorter {
        private LicenseSorter() {
        }

        public int category(Object element) {
            return LicensePageData.sortRanking((Object)element);
        }
    }

    private static class TextWrapLayout
    extends Layout
    implements ILayoutExtension {
        private TextWrapLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            IStyledText text = this.getText(composite);
            if (text == null) {
                return new Point(0, 0);
            }
            return text.computeSize(wHint, hHint, flushCache);
        }

        protected void layout(Composite composite, boolean flushCache) {
            IStyledText text = this.getText(composite);
            if (text != null) {
                Rectangle clientArea = composite.getClientArea();
                text.setBounds(0, 0, clientArea.width, clientArea.height);
            }
        }

        public int computeMaximumWidth(Composite parent, boolean changed) {
            IStyledText text = this.getText(parent);
            if (text != null) {
                Point point = text.computeSize(-1, -1);
                return point.x;
            }
            return 0;
        }

        public int computeMinimumWidth(Composite parent, boolean changed) {
            return 245;
        }

        private IStyledText getText(Composite composite) {
            Control[] children = composite.getChildren();
            if (children.length == 1) {
                return (IStyledText)children[0];
            }
            return null;
        }
    }
}

