/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.licensePanel;

import com.ibm.cic.common.core.console.shared.manager.licensePanel.LicensePageData;
import com.ibm.cic.common.core.internal.LicenseFactory;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.ui.internal.licensePanel.LicensePart;
import com.ibm.cic.common.ui.internal.licensePanel.Messages;
import com.ibm.cic.common.ui.internal.wizardry.AbstractCicWizardPage;
import com.ibm.cic.common.ui.services.UiServices;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BaseEclipseStyleLicensePage
extends AbstractCicWizardPage {
    protected LicenseFactory.License[] licenses;
    protected LicensePart licensePart;
    protected boolean multipleLicenseMode;
    protected boolean isAcceptLicense = false;

    public BaseEclipseStyleLicensePage(FormToolkit toolkit, LicenseFactory.License[] licenses) {
        super(Messages.LicensePage_title, toolkit, Messages.LicensePage_title, LicensePageData.getReadCarefullyStatement());
        this.licenses = licenses;
        this.toolkit = toolkit;
    }

    public BaseEclipseStyleLicensePage(FormToolkit toolkit) {
        this(toolkit, new LicenseFactory.License[0]);
    }

    public BaseEclipseStyleLicensePage(FormToolkit toolkit, boolean forceMultiple) {
        this(toolkit, new LicenseFactory.License[0]);
        this.multipleLicenseMode = forceMultiple;
    }

    public FormToolkit getFormToolkit() {
        return this.toolkit;
    }

    @Override
    public void createControl(Composite parent) {
        this.licensePart = UiServices.getInstance().createLicensePart(this);
        this.licenses = LicenseFactory.getInstance().sortLicensesArray(this.licenses);
        this.licensePart.setLicenseArray(this.licenses);
        this.licensePart.createControl(parent);
        if (this.isAcceptLicense) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
        this.setControl(this.licensePart.getControl());
    }

    public boolean isPageComplete() {
        if (this.shouldSkip()) {
            return true;
        }
        return super.isPageComplete();
    }

    @Override
    protected void setFocus() {
        this.licensePart.getControl().setFocus();
        if (this.licenses != null && this.licensePart.licenseList != null) {
            LicensePageData.ILicenseNode primaryLicenseNode;
            LicenseFactory.License primaryLicense;
            ISelection selection;
            LicenseFactory.License[] existingLicenseArray = this.licensePart.getLicenseArray();
            if (existingLicenseArray == null || existingLicenseArray.length == 0) {
                this.licensePart.setLicenseArray(this.licenses);
                this.licensePart.generateLicenseTreeNodes(this.licenses);
            }
            this.licensePart.licenseList.setInput(this.licensePart.getRootNodes());
            Control control = this.licensePart.getControl();
            if (control instanceof Composite) {
                ((Composite)control).layout();
            }
            if ((selection = this.licensePart.licenseList.getSelection()) instanceof IStructuredSelection && this.licenses.length > 0 && (primaryLicense = this.getPrimary()) != null && (primaryLicenseNode = this.licensePart.getLicensePageData().getLicenseNode(primaryLicense)) != null) {
                this.licensePart.licenseList.setSelection((ISelection)new StructuredSelection((Object)primaryLicenseNode));
                this.licensePart.licenseList.expandToLevel(primaryLicenseNode, -1);
            }
            this.licensePart.generateLicenseNodeList();
        } else if (this.licenses != null && this.licenses.length == 1) {
            this.licensePart.setLicenseText(this.licenses[0]);
        }
    }

    private LicenseFactory.License getPrimary() {
        LicenseFactory.License[] licenseArray = this.licenses;
        int n = this.licenses.length;
        int n2 = 0;
        while (n2 < n) {
            LicenseFactory.License license = licenseArray[n2];
            if (license.isPrimary()) {
                return license;
            }
            ++n2;
        }
        return this.licenses[0];
    }

    public static LicenseFactory.License[] fetchLicenses(IOfferingOrFix[] offeringsOrFixes) {
        ArrayList<LicenseFactory.License> licenseList = new ArrayList<LicenseFactory.License>();
        IOfferingOrFix[] iOfferingOrFixArray = offeringsOrFixes;
        int n = offeringsOrFixes.length;
        int n2 = 0;
        while (n2 < n) {
            IOfferingOrFix offeringOrFix = iOfferingOrFixArray[n2];
            LicenseFactory.License[] licensesForOfferingOrFix = LicenseFactory.getInstance().findLicenseTextFor(offeringOrFix);
            if (licensesForOfferingOrFix.length > 0) {
                licenseList.addAll(Arrays.asList(licensesForOfferingOrFix));
            }
            ++n2;
        }
        return licenseList.toArray(new LicenseFactory.License[licenseList.size()]);
    }

    protected void refreshLicenses() {
        this.licensePart.refreshLicenses(this.licenses);
    }

    protected String getDeclineMessage() {
        return null;
    }
}

