/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.dialogs;

import com.ibm.cic.common.ui.internal.Messages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PasswordKeyDialog
extends TitleAreaDialog {
    private Text pwdText;
    private Text pwdReText;
    private String password;

    public PasswordKeyDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public String getPasswordKey() {
        return this.password;
    }

    public void create() {
        super.create();
        this.setMessage(Messages.PasswordKey_title_explanation);
        this.setTitle(Messages.UserPasswordDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Font font = parentComposite.getFont();
        Composite comp = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        comp.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 1, true, false);
        comp.setLayoutData((Object)gridData);
        Label fillerLabel = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        fillerLabel.setLayoutData((Object)gd);
        Label pwdLabel = new Label(comp, 0);
        pwdLabel.setFont(font);
        pwdLabel.setText(Messages.PasswordKey_password_label);
        this.pwdText = new Text(comp, 0x400000);
        this.pwdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PasswordKeyDialog.this.clearError();
            }
        });
        GridData data = new GridData(4, 1, true, false);
        this.pwdText.setLayoutData((Object)data);
        Label pwdReLabel = new Label(comp, 0);
        pwdReLabel.setFont(font);
        pwdReLabel.setText(Messages.PasswordKey_re_password_label);
        this.pwdReText = new Text(comp, 0x400000);
        this.pwdReText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PasswordKeyDialog.this.clearError();
            }
        });
        data = new GridData(4, 1, true, false);
        this.pwdReText.setLayoutData((Object)data);
        return parentComposite;
    }

    private void clearError() {
        this.setErrorMessage(null);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(Messages.PasswordKey_title);
        super.configureShell(newShell);
    }

    protected void okPressed() {
        String pwdRe;
        String pwd = this.pwdText.getText().trim();
        if (!pwd.equals(pwdRe = this.pwdReText.getText().trim())) {
            this.setErrorMessage(Messages.PasswordKey_passwords_do_not_match);
            this.pwdReText.setFocus();
            return;
        }
        if (pwd.length() == 0) {
            this.setErrorMessage(Messages.PasswordKey_password_cannot_be_empty);
            this.pwdText.setFocus();
            return;
        }
        this.password = pwd;
        super.okPressed();
    }
}

