/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.internal.actions;

import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;

public class ShowViewAction
extends Action {
    private IWorkbenchWindow window;
    private final IViewDescriptor viewDesc;
    private final IPerspectiveDescriptor perspDesc;

    public ShowViewAction(IWorkbenchWindow window, String perspId, String viewId) {
        this(window, PlatformUI.getWorkbench().getViewRegistry().find(viewId), PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(perspId));
    }

    public ShowViewAction(IWorkbenchWindow window, IViewDescriptor viewDesc, IPerspectiveDescriptor perspDesc) {
        String label = viewDesc.getLabel();
        this.setText(label);
        this.setImageDescriptor(viewDesc.getImageDescriptor());
        this.setToolTipText(label);
        this.setId(viewDesc.getId());
        this.window = window;
        this.viewDesc = viewDesc;
        this.perspDesc = perspDesc;
    }

    public void run() {
        this.open();
    }

    public IViewPart open() {
        IViewPart view = null;
        IWorkbenchPage page = this.window.getActivePage();
        if (page != null) {
            if (this.perspDesc != null) {
                page.setPerspective(this.perspDesc);
            }
            try {
                view = page.showView(this.viewDesc.getId());
            }
            catch (PartInitException e) {
                CicCommonUiPlugin.logException(e);
            }
        }
        return view;
    }

    protected void setWindow(IWorkbenchWindow workbenchWindow) {
        this.window = workbenchWindow;
    }

    protected IWorkbenchWindow getWindow() {
        return this.window;
    }

    protected IViewDescriptor getViewDes() {
        return this.viewDesc;
    }

    protected IPerspectiveDescriptor getPerspectiveDes() {
        return this.perspDesc;
    }
}

