/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMUtils;
import com.ibm.jvm.j9.dump.systemdump.ClassField;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9Static;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;

public class J9Object {
    private long oAddr;
    private long classId;
    private long flags;
    private long lockInfo;
    private int heapId;
    private static Dump theDump;
    private static int ptrSize;
    private boolean instanceOfClass;
    private boolean isArray;
    private int instanceSize;
    private int elementCount;
    private int elementSize;

    protected J9Object(long address, long classId, int heap, int instanceSize) {
        this.oAddr = address;
        this.classId = classId;
        this.heapId = heap;
        this.instanceSize = instanceSize;
    }

    public J9Object(long address, int heap) {
        this.heapId = heap;
        this.oAddr = address;
        if (null == theDump && !(theDump = DumpConsole.getTheDump()).is32bit()) {
            ptrSize = 8;
        }
        J9Class theClass = null;
        try {
            this.classId = theDump.readPtr(this.oAddr);
            if (theDump.getIntVersion() == 22) {
                this.flags = theDump.readPtr(this.oAddr + (long)ptrSize);
            } else if (theDump.seekToMemoryAddress(this.oAddr + (long)ptrSize) > 0L) {
                this.flags = theDump.readIntEx();
            }
            this.lockInfo = theDump.readPtr(this.oAddr + (long)(2 * ptrSize));
            theClass = J9JVMConsole.getClass(this.classId);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (null == theClass) {
            this.classId = -1L;
        } else if (theClass.isArrayClass()) {
            this.isArray = true;
            int sizeOffset = theClass.getSizeOffset();
            long size = 0L;
            try {
                if (theDump.getIntVersion() == 22) {
                    size = theDump.readPtr(this.oAddr + (long)sizeOffset);
                } else if (theDump.seekToMemoryAddress(this.oAddr + (long)sizeOffset) > 0L) {
                    size = theDump.readIntEx();
                }
                this.elementCount = (int)size;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (theClass.isSizedAsElements()) {
                long leaf = theClass.getLeaf();
                J9Class leafClass = J9JVMUtils.findClass(leaf);
                this.elementSize = leafClass.getArrayElementSize();
                if (-1 == this.elementSize || theClass.getArity() > 1) {
                    this.elementSize = ptrSize;
                }
                this.instanceSize = theClass.getFirstElementOffset() + (int)size * this.elementSize;
            } else {
                this.instanceSize = theClass.getFirstElementOffset() + (int)size;
            }
        } else {
            this.instanceSize = theClass.getInstanceSize();
        }
        J9Class c = this.getClassForObject();
        if (c != null && c.getName().equals("java/lang/Class")) {
            this.instanceOfClass = true;
            int sizeOffset = theClass.getSizeOffset();
            long size = 0L;
            try {
                this.instanceSize = (int)theDump.readPtr(this.oAddr + (long)sizeOffset);
                this.instanceSize += sizeOffset;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    public static long[] getObjectRefs(long addr) {
        long[] references = null;
        J9Object o = new J9Object(addr, -1);
        references = o.getObjectRefs();
        return references;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        J9Class myClass = this.getClassForObject();
        String name = myClass.getName();
        String leafName = "";
        int arity = 0;
        if (name.startsWith("[")) {
            int lastSB = name.lastIndexOf("[");
            leafName = name.substring(lastSB);
            name = name.substring(0, lastSB) + leafName;
            arity = myClass.getArity();
        }
        sb.append("\n " + name + "@0x" + Long.toHexString(this.oAddr));
        if (name.equals("java/lang/Class")) {
            J9Class j9c = J9JVMConsole.getClass(this.oAddr);
            name = j9c.getName();
            if (name.startsWith("[")) {
                // empty if block
            }
            sb.append("\n\tClass definition of: " + name);
        }
        if (!this.isArray) {
            sb.append("\n " + myClass.formatObject(this.oAddr));
        } else {
            String prim = "primitive";
            if (!this.isPrimitiveArray()) {
                prim = "non-primitive";
            }
            if (1 == arity) {
                sb.append("\n It's an Array object: " + prim + ": filled with - " + leafName);
            } else {
                sb.append("\n It's an Array of Array objects: " + prim + ": filled with - ");
                for (int i = 0; i < arity - 1; ++i) {
                    sb.append("[");
                }
                sb.append(leafName);
            }
            sb.append("\n\t instance size = " + this.getInstanceSize());
            sb.append("\n\t " + this.elementCount + " elements , element size = " + this.elementSize);
            sb.append("\n\t arity is " + myClass.getArity());
        }
        return sb.toString();
    }

    public long getObjectAddress() {
        return this.oAddr;
    }

    public long[] getObjectRefs() {
        return this.getObjectRefs(false);
    }

    public long[] getObjectRefs(boolean incNulls) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (null == theDump && !(theDump = DumpConsole.getTheDump()).is32bit()) {
            ptrSize = 8;
        }
        J9Class theClass = this.getClassForObject();
        Vector v = null;
        if (this.isInstanceOfClass()) {
            v = theClass.getStatics();
        } else {
            if (this.isArray) {
                if (theClass.isPrimitiveArray() && theClass.getArity() == 1) {
                    return null;
                }
                int count = 0;
                int offset = theClass.getFirstElementOffset();
                long ptr = 0L;
                long[] refs = new long[this.elementCount];
                for (int i = 0; i < this.elementCount; ++i) {
                    try {
                        ptr = theDump.readPtr(this.oAddr + (long)offset);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    if (incNulls || ptr != 0L) {
                        refs[count] = ptr;
                        ++count;
                    }
                    offset += this.elementSize;
                }
                if (0 == count) {
                    return null;
                }
                long[] trueRefs = new long[count];
                for (int i = 0; i < count; ++i) {
                    trueRefs[i] = refs[i];
                }
                return trueRefs;
            }
            v = theClass.getFields();
        }
        int numfields = v.size();
        if (numfields > 0) {
            for (int i = 0; i < v.size(); ++i) {
                if (this.isInstanceOfClass()) {
                    J9Static aStatic = (J9Static)v.get(i);
                    if (!aStatic.getSignature().startsWith("L") || 0L == aStatic.getValue()) continue;
                    result.add(new Long(aStatic.getValue()));
                    continue;
                }
                ClassField f = (ClassField)v.get(i);
                String sig = f.getSignature();
                boolean bItsARef = false;
                if (sig.startsWith("L") || sig.startsWith("[")) {
                    bItsARef = true;
                }
                if (!bItsARef) continue;
                int offset = f.getOffset();
                long ptr = 0L;
                try {
                    ptr = theDump.readPtr(this.oAddr + (long)offset);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (-1L == ptr) continue;
                result.add(new Long(ptr));
            }
        }
        if (0 == result.size()) {
            return null;
        }
        long[] references = new long[result.size()];
        Long[] resultArr = result.toArray(new Long[0]);
        for (int i = 0; i < resultArr.length; ++i) {
            references[i] = resultArr[i];
        }
        return references;
    }

    public J9Class getClassForObject() {
        return J9JVMConsole.getClass(this.classId);
    }

    public boolean isInstanceOfClass() {
        return this.instanceOfClass;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isPrimitiveArray() {
        J9Class theClass = this.getClassForObject();
        return theClass.isPrimitiveArray();
    }

    public byte getPrimitiveArrayType() {
        J9Class theClass = this.getClassForObject();
        long leaf = theClass.getLeaf();
        J9Class leafClass = J9JVMUtils.findClass(leaf);
        return leafClass.getArrayType();
    }

    public String getArrayTypeAsString() {
        J9Class theClass = this.getClassForObject();
        long leaf = theClass.getLeaf();
        J9Class leafClass = J9JVMUtils.findClass(leaf);
        return leafClass.getName();
    }

    public int getInstanceSize() {
        return this.instanceSize;
    }

    public int getHeapId() {
        return this.heapId;
    }

    public int getElementSize() {
        return this.elementSize;
    }

    public int getElementCount() {
        return this.elementCount;
    }

    public long getFlags() {
        return this.flags;
    }

    public long getHashCode() {
        long hashCode = this.flags >> 16 & 0x7FFFL;
        hashCode |= hashCode << 16;
        return hashCode;
    }

    public long getLockInfo() {
        return this.lockInfo;
    }

    public byte[] getBytes() {
        byte[] objectBytes = new byte[this.instanceSize];
        try {
            if (theDump.seekToMemoryAddress(this.oAddr) > 0L) {
                theDump.readEx(objectBytes);
            }
        }
        catch (IOException ioe) {
            objectBytes = null;
        }
        return objectBytes;
    }

    public byte[] getBytes(int start, int length) {
        byte[] objectBytes = null;
        if (length > 0 && start < this.instanceSize) {
            objectBytes = new byte[length];
            try {
                if (theDump.seekToMemoryAddress(this.oAddr + (long)start) > 0L) {
                    theDump.readEx(objectBytes);
                }
            }
            catch (IOException ioe) {
                objectBytes = null;
            }
        }
        return objectBytes;
    }

    static {
        ptrSize = 4;
    }
}

