/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.systemdump.ClassField;
import com.ibm.jvm.j9.dump.systemdump.J9Class;

public class J9Method {
    private J9Class myClass;
    String methodName;
    long id;
    String signature;
    long bcStart;
    long bcEnd;
    long jitStart;
    long jitEnd;
    long jitId;
    String idAsString;
    int modifiers;

    public J9Method(J9Class ownerClass, String idString, String name, String sig, String modifiersIn) {
        this.myClass = ownerClass;
        this.methodName = name;
        this.signature = sig;
        this.idAsString = idString;
        this.id = DumpUtils.parseLongHex(idString);
        this.modifiers = (int)DumpUtils.parseLongHex(modifiersIn);
        J9JVMConsole.addCodeId(this);
        ownerClass.addMethod(this);
    }

    public static String getMethodForAddress(long address) {
        String retString = null;
        return retString;
    }

    public void addBytecode(String start, String end) {
        String temp = DumpUtils.stripOff0x(start);
        this.bcStart = DumpUtils.parseLongHex(temp);
        temp = DumpUtils.stripOff0x(end);
        this.bcEnd = DumpUtils.parseLongHex(temp);
    }

    public void addJitcode(String start, String end, String id) {
        String temp = DumpUtils.stripOff0x(start);
        this.jitStart = DumpUtils.parseLongHex(temp);
        temp = DumpUtils.stripOff0x(end);
        this.jitEnd = DumpUtils.parseLongHex(temp);
        temp = DumpUtils.stripOff0x(id);
        this.jitId = DumpUtils.parseLongHex(temp);
        J9JVMConsole.addJitCodeId(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\tname: " + this.methodName);
        sb.append("  \tsig: " + this.signature);
        sb.append("  \tid: 0x" + Long.toHexString(this.id));
        sb.append("  \tmodifiers: " + ClassField.convertModifier(this.modifiers));
        if (this.bcStart != 0L && this.bcEnd != 0L) {
            sb.append("\n\t\t\tBytecode start=0x" + Long.toHexString(this.bcStart) + "   end=0x" + Long.toHexString(this.bcEnd));
        }
        if (this.jitStart != 0L && this.jitEnd != 0L) {
            sb.append("\n\t\t\tJit code start=0x" + Long.toHexString(this.jitStart) + "   end=0x" + Long.toHexString(this.jitEnd) + "    id=" + Long.toHexString(this.jitId));
        }
        return sb.toString();
    }

    public long getId() {
        return this.id;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getIdAsString() {
        return this.idAsString;
    }

    public String getSignature() {
        return this.signature;
    }

    public long getBcEnd() {
        return this.bcEnd;
    }

    public long getBcStart() {
        return this.bcStart;
    }

    public long getJitEnd() {
        return this.jitEnd;
    }

    public long getJitStart() {
        return this.jitStart;
    }

    public long getJitId() {
        return this.jitId;
    }

    public J9Class getMyClass() {
        return this.myClass;
    }

    public int getModifiers() {
        return this.modifiers;
    }
}

