/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.commandconsole;

import com.ibm.jvm.j9.dump.commandconsole.Console;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class DvNamesIndexFile {
    private String name;
    private TreeMap objectIndex;
    private static RandomAccessFile dataFile;
    public boolean isComplete = false;
    private long NamesOffset;
    private long ClassNameData;
    public static final int SORT_BY_NAME = 0;
    public static final int SORT_BY_COUNT = 1;
    public static final int SORT_BY_TOTAL_SIZE = 2;
    private static final int VERSION = 1;
    private static String dataFileIdentifier;
    private static String classNameDataIdentifier;

    public DvNamesIndexFile(String fileName, long checkSum) throws IOException {
        String workdir = Console.getProperty("WORKDIR");
        if (null != workdir && !fileName.startsWith(workdir)) {
            File file = new File(fileName);
            fileName = workdir + File.separator + file.getName();
        }
        try {
            dataFile = new RandomAccessFile(fileName + ".jfod", "r");
            this.name = fileName + ".jfod";
            if (this.checkHeader(dataFile, checkSum) && this.ClassNameData != 0L) {
                dataFile.seek(this.ClassNameData);
                byte[] eyeCatcher = new byte[4];
                dataFile.readFully(eyeCatcher);
                if (new String(eyeCatcher).equals(classNameDataIdentifier)) {
                    this.objectIndex = new TreeMap();
                    int numEntries = dataFile.readInt();
                    for (int i = 0; i < numEntries; ++i) {
                        JClass jclass = new JClass(dataFile);
                        this.objectIndex.put(jclass.name, jclass);
                    }
                    this.isComplete = true;
                    return;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        dataFile = new RandomAccessFile(fileName + ".jfod", "rw");
        this.name = fileName + ".jfod";
        this.writeHeader(dataFile, checkSum);
        this.NamesOffset = dataFile.getFilePointer();
        dataFile.writeLong(0L);
        dataFile.writeLong(0L);
        this.objectIndex = new TreeMap();
    }

    private boolean checkHeader(DataInput stream, long checkSum) throws IOException {
        byte[] identifier = new byte[4];
        stream.readFully(identifier);
        int version = stream.readInt();
        long sum = stream.readLong();
        this.NamesOffset = dataFile.getFilePointer();
        this.ClassNameData = stream.readLong();
        return new String(identifier).equals(dataFileIdentifier) && version == 1 && checkSum == sum && this.ClassNameData != 0L;
    }

    public String getName() {
        return this.name;
    }

    private void writeHeader(DataOutput stream, long checkSum) throws IOException {
        stream.write(dataFileIdentifier.getBytes());
        stream.writeInt(1);
        stream.writeLong(checkSum);
    }

    public void commit() {
        if (this.isComplete) {
            return;
        }
        try {
            dataFile.seek(this.NamesOffset);
            dataFile.writeLong(dataFile.length());
            dataFile.seek(dataFile.length());
            dataFile.write(classNameDataIdentifier.getBytes());
            dataFile.writeInt(this.objectIndex.size());
            for (Object className : this.objectIndex.keySet()) {
                JClass jclass = (JClass)this.objectIndex.get(className);
                jclass.write(dataFile);
            }
        }
        catch (Exception e) {
            Console.reportError("JVMDF0001: Unable to write the NamesIndex file ", e);
        }
        this.isComplete = true;
    }

    public int getInstanceCountForClass(String className) {
        int count = 0;
        JClass jclass = this.getClass(className);
        if (jclass != null) {
            count = jclass.count;
        }
        return count;
    }

    public long getInstanceSizeForClass(String className) {
        long size = 0L;
        JClass jclass = this.getClass(className);
        if (jclass != null) {
            size = jclass.totalSize / (long)jclass.count;
        }
        return size;
    }

    private JClass getClass(String className) {
        JClass jclass = (JClass)this.objectIndex.get(className.intern());
        return jclass;
    }

    public long[] getInstancesForClass(String className) {
        JClass jclass = this.getClass(className);
        if (jclass == null) {
            return null;
        }
        int count = jclass.count;
        int index = 0;
        long[] list = new long[count];
        Iterator instanceIterator = jclass.getIterator();
        while (instanceIterator.hasNext()) {
            JInstance instance = (JInstance)instanceIterator.next();
            list[index] = instance.address;
            ++index;
        }
        return list;
    }

    public long getInstancesForClass(String className, int startpoint, long ongoingmemory, long[] rLongArray) {
        int tooMany;
        Arrays.fill(rLongArray, 0L);
        JClass jclass = this.getClass(className);
        if (jclass == null) {
            return 0L;
        }
        int capacity = rLongArray.length;
        Iterator keyIterator = jclass.getIterator();
        for (tooMany = jclass.count - startpoint - capacity; tooMany > 0; --tooMany) {
            keyIterator.next();
        }
        int index = rLongArray.length - 1 + tooMany;
        while (keyIterator.hasNext()) {
            rLongArray[index--] = (Long)keyIterator.next();
        }
        return rLongArray[rLongArray.length - 1 + tooMany];
    }

    public Vector getAllClassNames() {
        return new Vector(this.objectIndex.keySet());
    }

    public Vector summary(int sortCriterion, boolean ascendingOrder) {
        int incr;
        int index;
        Vector<String> output = new Vector<String>(this.objectIndex.size());
        if (ascendingOrder) {
            index = 0;
            incr = 1;
        } else {
            index = this.objectIndex.size() - 1;
            incr = -1;
        }
        long totalBytes = 0L;
        long totalObjects = 0L;
        if (sortCriterion == 0) {
            for (Object className : this.objectIndex.keySet()) {
                JClass jclass = (JClass)this.objectIndex.get(className);
                output.add(index, new String(jclass.name + " : " + jclass.count + "   " + jclass.totalSize + " bytes"));
                index += incr;
                totalObjects += (long)jclass.count;
                totalBytes += jclass.totalSize;
            }
        } else {
            TreeSet<JClass> list = null;
            switch (sortCriterion) {
                case 1: {
                    list = new TreeSet<JClass>(new CompareByCount());
                    break;
                }
                case 2: {
                    list = new TreeSet(new CompareByTotalSize());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("JVMDF005: Invalid sort criterion " + sortCriterion);
                }
            }
            for (JClass jclass : this.objectIndex.values()) {
                list.add(jclass);
                totalObjects += (long)jclass.count;
                totalBytes += jclass.totalSize;
            }
            for (JClass jclass : list) {
                output.add(index, new String(jclass.name + " : " + jclass.count + "   " + jclass.totalSize + " bytes"));
                index += incr;
            }
        }
        output.add("");
        output.add(new String("Total number of objects = " + totalObjects + " Total byte count = " + totalBytes));
        return output;
    }

    public boolean write(J9Object o) {
        int instantSize = o.getInstanceSize();
        int heap = o.getHeapId();
        J9Class objectClass = o.getClassForObject();
        String className = objectClass == null ? "<unknown>" : objectClass.getName();
        this.write(className, o.getObjectAddress(), (short)heap, instantSize);
        return false;
    }

    public boolean write(String className, long objectAddress, short heapId, long objLen) {
        JClass jclass = this.getClass(className);
        if (jclass == null) {
            jclass = new JClass(className);
            this.objectIndex.put(jclass.name, jclass);
        }
        ++jclass.count;
        jclass.totalSize += objLen;
        JInstance jinstance = new JInstance(objectAddress, jclass.jinstance);
        try {
            jclass.jinstance = dataFile.getFilePointer();
            jinstance.write();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void closeDataFile() {
        if (dataFile != null) {
            try {
                dataFile.close();
            }
            catch (IOException ioe) {
                System.out.println("IOException occurred when closing the JFOD file.");
            }
        }
    }

    static {
        dataFileIdentifier = "JFOD";
        classNameDataIdentifier = "JFNI";
    }

    private class CompareByCount
    implements Comparator {
        private CompareByCount() {
        }

        public int compare(Object o1, Object o2) {
            JClass jclass1 = (JClass)o1;
            JClass jclass2 = (JClass)o2;
            int diff = jclass1.count - jclass2.count;
            if (diff != 0) {
                return diff;
            }
            return jclass1.name.compareTo(jclass2.name);
        }

        public boolean equals(Object o) {
            JClass jclass = (JClass)o;
            return this.compare(this, o) == 0;
        }
    }

    private class CompareByTotalSize
    implements Comparator {
        private CompareByTotalSize() {
        }

        public int compare(Object o1, Object o2) {
            JClass jclass1 = (JClass)o1;
            JClass jclass2 = (JClass)o2;
            return (int)(jclass1.totalSize - jclass2.totalSize);
        }

        public boolean equals(Object o) {
            JClass jclass = (JClass)o;
            return this.compare(this, o) == 0;
        }
    }

    private class InstanceIterator
    implements Iterator {
        JInstance instance;

        InstanceIterator(long offset) {
            try {
                this.instance = new JInstance(offset);
            }
            catch (IOException e) {
                Console.reportError("JVMDF0001: Unable to write the NamesIndex file ", e);
                this.instance = null;
            }
        }

        public boolean hasNext() {
            return this.instance != null;
        }

        public Object next() {
            JInstance savedInstance = this.instance;
            if (this.instance.nextRecord == 0L) {
                this.instance = null;
            } else {
                try {
                    this.instance = new JInstance(this.instance.nextRecord);
                }
                catch (IOException e) {
                    Console.reportError("JVMDF003: Unable to read index data file. ", e);
                    this.instance = null;
                }
            }
            return savedInstance;
        }

        public void remove() {
            throw new RuntimeException("JVMDF004: No DvNamesIndex$InstanceIterator.remove method.");
        }
    }

    private class JClass {
        String name;
        long jinstance;
        long totalSize;
        int count = 0;

        JClass(String name) {
            this.name = name.intern();
        }

        Iterator getIterator() {
            return new InstanceIterator(this.jinstance);
        }

        void write(DataOutput stream) throws IOException {
            stream.writeInt(this.name.length());
            stream.write(this.name.getBytes());
            stream.writeLong(this.jinstance);
            stream.writeLong(this.totalSize);
            stream.writeInt(this.count);
        }

        JClass(DataInput stream) throws IOException {
            int strlen = stream.readInt();
            byte[] nameBuffer = new byte[strlen];
            stream.readFully(nameBuffer);
            this.name = new String(nameBuffer).intern();
            this.jinstance = stream.readLong();
            this.totalSize = stream.readLong();
            this.count = stream.readInt();
        }
    }

    private class JInstance {
        long address;
        long nextRecord;

        JInstance(long address, long nextRecord) {
            this.address = address;
            this.nextRecord = nextRecord;
        }

        JInstance(long offset) throws IOException {
            dataFile.seek(offset);
            this.address = dataFile.readLong();
            this.nextRecord = dataFile.readLong();
        }

        private void write() throws IOException {
            dataFile.writeLong(this.address);
            dataFile.writeLong(this.nextRecord);
        }
    }
}

