/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.history.impl;

import com.ibm.cic.agent.internal.core.history.impl.IXMLElement;
import com.ibm.cic.common.core.utils.XMLUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class XMLElement
implements IXMLElement {
    private final String name;
    private final List children = new ArrayList();
    private final Map attributes = new HashMap();

    public XMLElement(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addAttribute(String attrName, String attrValue) {
        this.attributes.put(attrName, attrValue);
    }

    @Override
    public Iterator getChildren() {
        return this.children.iterator();
    }

    @Override
    public String getAttribute(String attrName) {
        return (String)this.attributes.get(attrName);
    }

    @Override
    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    @Override
    public void addChild(IXMLElement child) {
        this.children.add(child);
    }

    @Override
    public IXMLElement getChild(int index) {
        return (IXMLElement)this.children.get(index);
    }

    @Override
    public void save(PrintWriter output) {
        output.print(this.toString());
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append('<').append(this.getName());
        for (String attrName : this.attributes.keySet()) {
            String attrValue = (String)this.attributes.get(attrName);
            result.append(String.valueOf(' ') + attrName + "='" + XMLUtil.escape((String)attrValue) + '\'');
        }
        result.append('>').append(Logger.NEWLINE);
        for (IXMLElement child : this.children) {
            result.append(child.toString());
        }
        result.append("</").append(this.getName()).append('>').append(Logger.NEWLINE);
        return result.toString();
    }

    @Override
    public int getNumberofChildren() {
        return this.children.size();
    }

    @Override
    public List getChildrenAsList() {
        return this.children;
    }
}

