/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.history.impl;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.internal.core.history.IActivity;
import com.ibm.cic.agent.internal.core.history.IHistory;
import com.ibm.cic.agent.internal.core.history.IHistoryListener;
import com.ibm.cic.agent.internal.core.history.IProfileInfo;
import com.ibm.cic.agent.internal.core.history.impl.ActivityImpl;
import com.ibm.cic.agent.internal.core.history.impl.HistoryModel;
import com.ibm.cic.agent.internal.core.history.impl.HistoryParser;
import com.ibm.cic.agent.internal.core.history.impl.HistoryUtil;
import com.ibm.cic.agent.internal.core.history.impl.IXMLElement;
import com.ibm.cic.agent.internal.core.history.impl.XMLElement;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Plugin;

public class HistoryImpl
implements IHistory {
    private IXMLElement rootElement = null;
    private final IProfileInfo profileInfo;
    private final HistoryParser historyParser = new HistoryParser(AgentActivator.getDefault().getContext());
    List listeners = new ArrayList();
    List newActivities = new ArrayList();
    private static final Logger log = Logger.getLogger(Agent.class, (Plugin)AgentActivator.getDefault());

    public HistoryImpl(IProfileInfo profileInfo) {
        this.profileInfo = profileInfo;
        this.load();
    }

    @Override
    public void addListener(IHistoryListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void commit() throws FileNotFoundException {
        File file = new File(this.profileInfo.getHistoryFilePath());
        File parentDir = file.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        HistoryUtil.createXSLFile(parentDir, "history.xsl");
        PrintWriter writer = new PrintWriter(Encodings.UTF8.writer(new File(this.profileInfo.getHistoryFilePath())));
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        writer.println("<?xml-stylesheet type=\"text/xsl\" href=\"history.xsl\"?>");
        this.rootElement.save(writer);
        writer.close();
        this.newActivities.clear();
    }

    @Override
    public IActivity createActivity(int activityType) {
        ActivityImpl activity = new ActivityImpl(activityType);
        activity.setHistory(this);
        this.rootElement.addChild(activity);
        return activity;
    }

    @Override
    public Iterator getActivities() {
        return this.rootElement.getChildren();
    }

    @Override
    public Iterator getAllListeners() {
        return this.listeners.iterator();
    }

    private void load() {
        File historyFile = new File(this.getHistoryFilePath());
        if (historyFile.exists()) {
            try {
                this.rootElement = this.historyParser.parse(historyFile, HistoryModel.getRootRule());
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.rootElement = new XMLElement("install-history");
            }
        } else {
            this.rootElement = new XMLElement("install-history");
        }
        if (this.rootElement != null) {
            Iterator iterator = this.rootElement.getChildren();
            while (iterator.hasNext()) {
                IActivity activity = (IActivity)iterator.next();
                activity.setHistory(this);
            }
        }
    }

    @Override
    public void endActivity(IActivity activity) {
        this.newActivities.add(activity);
        for (IHistoryListener listener : this.listeners) {
            listener.historyUpdated(new IActivity[]{activity});
        }
    }

    @Override
    public IProfileInfo getProfileInfo() {
        return this.profileInfo;
    }

    @Override
    public boolean removeListener(IHistoryListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void removeAllListeners() {
        this.listeners.clear();
    }

    @Override
    public IActivity[] getNewActivities() {
        return this.newActivities.toArray(new IActivity[this.newActivities.size()]);
    }

    @Override
    public String getHistoryFilePath() {
        return this.profileInfo.getHistoryFilePath();
    }
}

