/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.debug;

import com.ibm.cic.agent.core.AbstractInstallOperation;
import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.IAgentEventManager;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.InstallOperationEventManager;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.core.InstallOrderManager;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.debug.InstallOperationDebugTarget;
import com.ibm.cic.agent.internal.core.debug.InstallOperationDebugThread;
import com.ibm.cic.agent.internal.core.debug.InstallOperationDebugValue;
import com.ibm.cic.agent.internal.core.debug.InstallOperationDebugVariable;
import com.ibm.cic.common.core.internal.debug.IInstallOperationDebugEvents;
import com.ibm.cic.common.core.internal.debug.IInstallOperationDebugTarget;
import com.ibm.cic.common.core.internal.debug.IInstallOperationDebugThread;
import com.ibm.cic.common.core.internal.debug.IInstallOperationDebugVariable;
import com.ibm.cic.common.core.internal.utils.CicCommonCorePluginTrace;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallableUnitContainer;
import com.ibm.cic.common.core.model.IInstallationContext;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.core.model.Phases;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.IdentityUtil;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;

public class InstallOperationDebug
implements InstallOperationEventManager.IInstallOperationListener,
IAgentEventManager.AgentSessionListener {
    private static final CicCommonCorePluginTrace trace = AgentActivator.getDefault().getTrace();
    private static final AgentJob[] EMPTY_JOBS = new AgentJob[0];
    private static final String LINE_BREAKPOINT_ID = "line";
    private static final String START_BREAKPOINT_ID = "start";
    private static final String SEPARATOR = ":";
    private static final String[] OLD_RMI_REGISTRY_PORT_VMARGS = new String[]{"INSTALL_OPERATION_DEBUG_RMI_REGISTRY_PORT", "install.operation.debug.rmi.registry.port"};
    private static final int RMI_API_VERSION = OLD_RMI_REGISTRY_PORT_VMARGS.length;
    private static final Action DEFAULT_ACTION = new Action();
    public static final Action ERROR_ACTION = new Action(){

        @Override
        public IStatus perform(AbstractInstallOperation op, IStatus status, IProgressMonitor monitor) {
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                return super.perform(op, status, monitor);
            }
            Status forceStatus = new Status(4, Agent.PI_AGENT, 0, "Operation forced to fail by debugger", null);
            super.perform(op, (IStatus)forceStatus, monitor);
            return forceStatus;
        }
    };
    public static final Action CANCEL_ACTION = new Action(){

        @Override
        public IStatus perform(AbstractInstallOperation op, IStatus status, IProgressMonitor monitor) {
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                return super.perform(op, status, monitor);
            }
            Status forceStatus = new Status(8, Agent.PI_AGENT, 0, "Operation forcibly canceled by debugger", null);
            super.perform(op, (IStatus)forceStatus, monitor);
            monitor.setCanceled(true);
            return Status.OK_STATUS;
        }
    };
    public static final InstallOperationDebug INSTANCE = new InstallOperationDebug();
    private int localRegistryPort = -1;
    private Registry localRegistry = null;
    private IInstallOperationDebugEvents remoteEvents = null;
    private Stepping stepping = null;
    private boolean isFirstOperation = true;
    private boolean suspended = false;
    private ResumeAction resumeAction = null;
    private String statusText = null;
    private InstallOrderManager.EngineOperation[] engineOperations = null;
    private InstallOrderManager.EngineOperation engineOperation = null;
    private String enginePhase = null;
    private InstallableUnitPair pair = null;
    private AbstractInstallOperation installOperation = null;
    private boolean traceInstallOperations = false;
    private final HashSet<String> breakpoints = new HashSet();
    private boolean breakpointsEnabled = false;
    private String directorThreadName = null;
    private AgentJob[] sessionJobs = EMPTY_JOBS;
    private AgentJob[] groupJobs = EMPTY_JOBS;

    @Override
    public synchronized InstallOperationEventManager.IAction perform(AbstractInstallOperation op, CicMultiStatus result, IProgressMonitor monitor) {
        if (InstallOperationDebug.trace.traceEntering) {
            trace.entering((Object)this.toString(op));
        }
        if (this.shouldIgnore(op)) {
            this.installOperation = null;
        } else {
            this.installOperation = op;
            try {
                String breakpointId = this.getLineBreakpointId(op);
                if (this.matchingBreakpoint(breakpointId)) {
                    this.stepping = null;
                    this.suspendByBreakpoint(op, breakpointId);
                } else if (this.stepping != null && this.stepping.isComplete(op)) {
                    this.stepping = null;
                    this.suspendByStepEnd(op);
                } else if (this.isFirstOperation) {
                    this.isFirstOperation = false;
                    breakpointId = this.getStartBreakpointId();
                    if (this.matchingBreakpoint(breakpointId)) {
                        this.suspendByBreakpoint(op, breakpointId);
                    }
                }
                if (this.traceInstallOperations) {
                    System.out.println(this.toString(op));
                }
            }
            catch (Exception e) {
                result.add((IStatus)Statuses.ERROR.get((Throwable)e, e.getMessage(), new Object[0]));
            }
        }
        ResumeAction resAction = this.resumeAction;
        this.resumeAction = null;
        Action beforeAction = DEFAULT_ACTION;
        Action afterAction = DEFAULT_ACTION;
        if (resAction != null && resAction.enabled) {
            Action action;
            Action action2 = action = ForceStatus.ERROR.equals((Object)resAction.forceStatus) ? ERROR_ACTION : CANCEL_ACTION;
            if (When.BEFORE.equals((Object)resAction.when)) {
                beforeAction = action;
            } else {
                afterAction = action;
            }
        }
        this.statusText = null;
        result.add(beforeAction.perform(op, Status.OK_STATUS, monitor));
        trace.exiting();
        return afterAction;
    }

    private boolean shouldIgnore(AbstractInstallOperation op) {
        IInstallableUnit unit = op.getUnit();
        IInstallableUnitContainer parent = unit.getParent();
        if (parent == null) {
            return true;
        }
        if (parent instanceof IOfferingOrFix) {
            return true;
        }
        return parent instanceof IInstallationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchingBreakpoint(String breakpointId) {
        HashSet<String> hashSet = this.breakpoints;
        synchronized (hashSet) {
            return this.breakpointsEnabled && this.breakpoints.contains(breakpointId);
        }
    }

    public synchronized void setDebugEvents(IInstallOperationDebugEvents debugEvents) {
        this.remoteEvents = debugEvents;
        this.notifyAll();
    }

    public synchronized void setTraceInstallOperations(boolean value) {
        if (value != this.traceInstallOperations) {
            this.traceInstallOperations = value;
            if (this.traceInstallOperations) {
                System.out.println("Tracing install operations.");
            } else {
                System.out.println("No longer tracing install operations.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setLineBreakpoint(String sourceFileName, int lineNumber) {
        String breakpointId = this.getLineBreakpointId(sourceFileName, lineNumber);
        HashSet<String> hashSet = this.breakpoints;
        synchronized (hashSet) {
            this.breakpoints.add(breakpointId);
        }
        return breakpointId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setStartBreakpoint() {
        String breakpointId = this.getStartBreakpointId();
        HashSet<String> hashSet = this.breakpoints;
        synchronized (hashSet) {
            this.breakpoints.add(breakpointId);
        }
        return breakpointId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBreakpoint(String breakpointId) {
        HashSet<String> hashSet = this.breakpoints;
        synchronized (hashSet) {
            this.breakpoints.remove(breakpointId);
        }
    }

    public synchronized void setBreakpointsEnabled(boolean enabled) {
        this.breakpointsEnabled = enabled;
    }

    public synchronized void step() throws IOException {
        this.stepping = new SteppingOverInstallOperation();
        this.resumeByStepOver();
    }

    public synchronized void stepOverUnit() throws IOException {
        this.stepping = new SteppingOverUnit();
        this.resumeByStepOver();
    }

    public synchronized void stepOverEnginePhase() throws IOException {
        this.stepping = new SteppingOverEnginePhase();
        this.resumeByStepOver();
    }

    public synchronized void stepOverEngineOperation() throws IOException {
        this.stepping = new SteppingOverEngineOperation(null, null);
        this.resumeByStepOver();
    }

    public synchronized void stepToSelectedUnit(String parentId, String unitId, String unitVersion) throws IOException {
        this.stepping = new SteppingToSelectedUnit(parentId, unitId, new Version(unitVersion));
        this.resumeByStepOver();
    }

    public synchronized void suspend() throws IOException {
        if (this.isSuspended()) {
            return;
        }
        this.suspendByClientRequest(this.installOperation);
    }

    public synchronized void resumeByClient() throws IOException {
        this.remoteEvents.resumedByClient(this.directorThreadName);
        this.doResume();
    }

    public synchronized void resumeByClientWithError() throws IOException {
        if (this.resumeAction != null) {
            this.resumeAction.enabled = true;
            this.resumeAction.forceStatus = ForceStatus.ERROR;
            this.resumeAction.when = When.BEFORE;
        }
        this.remoteEvents.resumedByClient(this.directorThreadName);
        this.doResume();
    }

    public synchronized boolean canResumeWithError() {
        return this.resumeAction != null;
    }

    public synchronized void resumeByStepOver() throws IOException {
        this.remoteEvents.resumedByStepOver(this.directorThreadName);
        this.doResume();
    }

    private synchronized void doResume() {
        this.suspended = false;
        this.notifyAll();
    }

    public synchronized void terminate() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus start() {
        trace.entering();
        int rmiApiVersion = this.getRmiApiVersion();
        if (rmiApiVersion != RMI_API_VERSION) {
            trace.exiting((Object)"Invalid install operations API version");
            return Statuses.ERROR.get("Invalid install operations debugger API version (expected: {0}, actual: {1}).  Try using the latest PDev and IM versions.", new Object[]{RMI_API_VERSION, rmiApiVersion});
        }
        InstallOperationDebug installOperationDebug = this;
        synchronized (installOperationDebug) {
            this.localRegistry = null;
            this.remoteEvents = null;
            this.stepping = null;
            this.isFirstOperation = true;
            this.suspended = false;
            this.resumeAction = null;
            this.statusText = null;
            this.engineOperations = null;
            this.engineOperation = null;
            this.enginePhase = null;
            this.pair = null;
            this.installOperation = null;
            this.breakpoints.clear();
            this.directorThreadName = null;
            this.localRegistryPort = this.getRegistryPort();
            if (this.localRegistryPort == -1) {
                trace.exiting((Object)"no connection required");
                return Status.OK_STATUS;
            }
        }
        try {
            IInstallOperationDebugEvents events;
            InstallOperationDebugTarget debugTarget = new InstallOperationDebugTarget();
            InstallOperationDebug installOperationDebug2 = this;
            synchronized (installOperationDebug2) {
                this.localRegistry = LocateRegistry.createRegistry(this.localRegistryPort);
                String bindName = IInstallOperationDebugTarget.class.getName();
                this.localRegistry.bind(bindName, debugTarget);
                events = this.waitForSetEvents();
            }
            events.started((IInstallOperationDebugTarget)debugTarget);
            trace.println("connection successful");
            InstallOperationEventManager.INSTANCE.addListener(this);
        }
        catch (Exception e) {
            Logger.getGlobalLogger().error((Throwable)e);
        }
        IAgentEventManager eventManager = Agent.getInstance().getEventManager();
        eventManager.addInstallSessionListener(this);
        eventManager.addUninstallSessionListener(this);
        trace.exiting();
        return Status.OK_STATUS;
    }

    public synchronized void stop() {
        trace.entering();
        IAgentEventManager eventManager = Agent.getInstance().getEventManager();
        eventManager.removeInstallSessionListener(this);
        eventManager.removeUninstallSessionListener(this);
        InstallOperationEventManager.INSTANCE.removeListener(this);
        this.directorThreadName = null;
        this.breakpoints.clear();
        this.stepping = null;
        this.isFirstOperation = true;
        this.engineOperations = null;
        this.engineOperation = null;
        this.enginePhase = null;
        this.pair = null;
        this.installOperation = null;
        if (this.remoteEvents != null) {
            try {
                if (this.isSuspended()) {
                    this.resumeByClient();
                }
                this.remoteEvents.terminated();
            }
            catch (Exception e) {
                Logger.getGlobalLogger().error((Throwable)e);
            }
            this.remoteEvents = null;
        }
        this.localRegistry = null;
        this.localRegistryPort = -1;
        this.suspended = false;
        this.resumeAction = null;
        this.statusText = null;
        trace.exiting();
    }

    public synchronized AgentJob[] getJobs() {
        return this.sessionJobs;
    }

    public synchronized AgentJob[] getGroupJobs() {
        return this.groupJobs;
    }

    private synchronized void setGroupJobs() {
        AgentJob job;
        Profile profile;
        Profile profile2 = profile = this.engineOperations == null || this.engineOperations.length == 0 ? null : this.engineOperations[0].getContext().getEnclosingProfile();
        if (profile == null) {
            this.groupJobs = EMPTY_JOBS;
            return;
        }
        AgentJob[] jobs = this.getJobs();
        ArrayList<AgentJob> grpJobs = new ArrayList<AgentJob>(jobs.length);
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            job = agentJobArray[n2];
            if (profile.equals(job.getProfile())) {
                grpJobs.add(job);
            }
            ++n2;
        }
        this.groupJobs = grpJobs.toArray(new AgentJob[grpJobs.size()]);
        if (this.traceInstallOperations) {
            agentJobArray = this.groupJobs;
            n = this.groupJobs.length;
            n2 = 0;
            while (n2 < n) {
                job = agentJobArray[n2];
                System.out.println(job.toString());
                ++n2;
            }
        }
    }

    public synchronized void setEngineOperations(List<InstallOrderManager.EngineOperation> engineOperations) {
        trace.entering(engineOperations);
        if (this.remoteEvents != null) {
            try {
                this.directorThreadName = Thread.currentThread().getName();
                this.engineOperations = engineOperations == null ? null : engineOperations.toArray(new InstallOrderManager.EngineOperation[engineOperations.size()]);
                this.installOperation = null;
                this.isFirstOperation = true;
                this.setInstallOrder();
                this.setGroupJobs();
                this.setSourceContainers();
                if (engineOperations == null) {
                    this.remoteEvents.threadTerminated(this.directorThreadName);
                } else {
                    InstallOperationDebugThread thread = new InstallOperationDebugThread(this.directorThreadName);
                    this.remoteEvents.threadStarted(this.directorThreadName, (IInstallOperationDebugThread)thread);
                }
            }
            catch (IOException e) {
                Logger.getGlobalLogger().error((Throwable)e);
            }
        }
        trace.exiting();
    }

    protected synchronized InstallOrderManager.EngineOperation[] getEngineOperations() {
        return this.engineOperations;
    }

    public synchronized void setEngineOperation(InstallOrderManager.EngineOperation engineOperation) {
        trace.entering((Object)engineOperation);
        this.engineOperation = engineOperation;
        this.installOperation = null;
        trace.exiting();
    }

    protected synchronized InstallOrderManager.EngineOperation getEngineOperation() {
        return this.engineOperation;
    }

    protected synchronized int getEngineOperationId() {
        return this.engineOperation == null ? -1 : this.engineOperation.getId();
    }

    public synchronized void setEnginePhase(String enginePhase) {
        trace.entering((Object)enginePhase);
        this.enginePhase = enginePhase;
        this.installOperation = null;
        trace.exiting();
    }

    protected synchronized String getEnginePhase() {
        return this.enginePhase;
    }

    public synchronized void setPair(InstallableUnitPair pair) {
        trace.entering((Object)pair);
        this.pair = pair;
        this.installOperation = null;
        trace.exiting();
    }

    protected synchronized InstallableUnitPair getPair() {
        return this.pair;
    }

    protected synchronized AbstractInstallOperation getInstallOperation() {
        return this.installOperation;
    }

    public synchronized void reverseInstallOrderPairs() {
        trace.entering();
        if (this.remoteEvents != null) {
            try {
                this.remoteEvents.reverseInstallOrderPairs();
            }
            catch (IOException e) {
                Logger.getGlobalLogger().error((Throwable)e);
            }
        }
        trace.exiting();
    }

    protected synchronized ResumeAction getResumeAction() {
        return this.resumeAction;
    }

    protected synchronized String getStatusText() {
        return this.statusText;
    }

    protected String getSourceFileName(AbstractInstallOperation op) {
        IInstallableUnit unit = op.getUnit();
        IInstallableUnitContainer parent = unit.getParent();
        ICicLocation location = parent == null ? null : parent.getLocation();
        return location == null ? null : location.getFileName();
    }

    protected synchronized String substituteVariables(String s) {
        try {
            if (this.installOperation != null) {
                return this.installOperation.performVariableSubstitutions(s, true, false, AbstractVariableSubstitution.AllowAbsolutePath.FALSE);
            }
        }
        catch (AbstractVariableSubstitution.VariableSubstitutionException variableSubstitutionException) {}
        return null;
    }

    private String getLineBreakpointId(AbstractInstallOperation op) {
        return this.getLineBreakpointId(this.getSourceFileName(op), op.getOperationData().getLineNumber());
    }

    private String getLineBreakpointId(String sourceFileName, int lineNumber) {
        return "line:" + sourceFileName + SEPARATOR + lineNumber;
    }

    private String getStartBreakpointId() {
        return START_BREAKPOINT_ID;
    }

    private synchronized void sendSuspendEvent(AbstractInstallOperation op, IInstallOperationDebugEvents.SuspendCause cause, String ... additionalInfo) throws IOException {
        int lineNumber;
        String sourceFileName;
        int opIndex;
        String opName;
        String unitVersion;
        String unitId;
        String unitParentId;
        String iuPhase;
        boolean undoing;
        int engineOperationId;
        if (this.engineOperation != null) {
            engineOperationId = this.engineOperation.getId();
            InstallContext installContext = this.engineOperation.getContext();
            undoing = installContext.isAdaptorTransactionUndoing() || installContext.isInstallableUnitTransactionUndoing();
        } else {
            engineOperationId = -1;
            undoing = false;
        }
        if (op != null) {
            IInstallableUnit unit = op.getUnit();
            iuPhase = Phases.phaseToName((int)op.getPhase());
            unitParentId = unit.getParent().getIdentity().getId();
            unitId = unit.getIdentity().getId();
            unitVersion = unit.getVersion().toString();
            opName = op.getOperationData().getElementName();
            opIndex = op.getOperationIndex();
            sourceFileName = this.getSourceFileName(op);
            lineNumber = op.getOperationData().getLineNumber();
        } else {
            iuPhase = null;
            unitParentId = null;
            unitId = null;
            unitVersion = null;
            opName = null;
            opIndex = 0;
            sourceFileName = null;
            lineNumber = 0;
        }
        this.remoteEvents.suspended(this.directorThreadName, cause, engineOperationId, this.enginePhase, undoing, iuPhase, unitParentId, unitId, unitVersion, opName, opIndex, sourceFileName, lineNumber, additionalInfo);
    }

    private synchronized void suspendByClientRequest(AbstractInstallOperation op) throws IOException {
        trace.entering();
        this.prepareForSuspend(op, null, null);
        this.sendSuspendEvent(op, IInstallOperationDebugEvents.SuspendCause.CLIENT_REQUEST, new String[0]);
        trace.exiting();
    }

    private synchronized void checkIfSuspendedByClientRequest() {
        if (this.isSuspended()) {
            this.suspended = false;
            try {
                this.remoteEvents.resumedByClient(this.directorThreadName);
            }
            catch (IOException e) {
                Logger.getGlobalLogger().error((Throwable)e);
            }
        }
    }

    private synchronized void suspendByBreakpoint(AbstractInstallOperation op, String breakpointId) throws IOException {
        trace.entering();
        this.checkIfSuspendedByClientRequest();
        this.prepareForSuspend(op, new ResumeAction(), null);
        this.sendSuspendEvent(op, IInstallOperationDebugEvents.SuspendCause.BREAKPOINT, breakpointId);
        this.doSuspend();
        trace.exiting();
    }

    private synchronized void suspendByStepEnd(AbstractInstallOperation op) throws IOException {
        trace.entering();
        this.checkIfSuspendedByClientRequest();
        this.prepareForSuspend(op, new ResumeAction(), null);
        this.sendSuspendEvent(op, IInstallOperationDebugEvents.SuspendCause.STEP_END, new String[0]);
        this.doSuspend();
        trace.exiting();
    }

    private synchronized void suspendByErrorOrCancel(AbstractInstallOperation op, IStatus status) throws IOException {
        trace.entering();
        IInstallOperationDebugEvents.SuspendCause cause = StatusUtil.isCancel((IStatus)status) ? IInstallOperationDebugEvents.SuspendCause.CANCEL : IInstallOperationDebugEvents.SuspendCause.ERROR;
        String statusMessage = LogUtil.toString((IStatus)status);
        String severity = cause.name();
        String statusTxt = String.valueOf(severity) + ": " + statusMessage;
        this.checkIfSuspendedByClientRequest();
        this.prepareForSuspend(op, null, statusTxt);
        this.sendSuspendEvent(op, cause, new String[0]);
        if (this.traceInstallOperations) {
            String msg = severity;
            if (op != null) {
                String opText = INSTANCE.toString(op);
                msg = String.valueOf(msg) + ": " + opText;
            }
            msg = String.valueOf(msg) + ": " + statusMessage;
            System.err.println(msg);
        }
        this.doSuspend();
        trace.exiting();
    }

    public synchronized void suspendByErrorOrCancelInAdapterPhase(IStatus status) {
        if (this.remoteEvents != null) {
            try {
                this.suspendByErrorOrCancel(null, status);
            }
            catch (IOException e) {
                Logger.getGlobalLogger().error((Throwable)e);
            }
        }
    }

    private void prepareForSuspend(AbstractInstallOperation op, ResumeAction action, String statusTxt) {
        this.stepping = null;
        this.isFirstOperation = false;
        this.suspended = true;
        this.installOperation = op;
        this.resumeAction = action;
        this.statusText = statusTxt;
    }

    private void doSuspend() {
        while (this.isSuspended()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized boolean isSuspended() {
        return this.suspended;
    }

    public String toString(AbstractInstallOperation op) {
        StringBuilder sb = new StringBuilder();
        if (op.isUndoing()) {
            sb.append("undoing ");
        }
        sb.append(Phases.phaseToName((int)op.getPhase()));
        sb.append(SEPARATOR);
        sb.append(IdentityUtil.getQualifiedVersionedId((IInstallableUnit)op.getUnit()));
        sb.append(SEPARATOR);
        sb.append(op.getOperationData().getElementName());
        int opIndex = op.getOperationIndex();
        if (opIndex != 0) {
            sb.append(SEPARATOR);
            sb.append(opIndex);
        }
        sb.append(" (");
        sb.append(this.getSourceFileName(op));
        sb.append(SEPARATOR);
        sb.append(op.getOperationData().getLineNumber());
        sb.append(')');
        return sb.toString();
    }

    private int getRegistryPort() {
        String portProp = System.getProperty("install.operation.debug.port");
        int port = -1;
        if (portProp != null) {
            try {
                port = Integer.parseInt(portProp);
            }
            catch (Exception e) {
                Logger.getGlobalLogger().error((Throwable)e);
            }
        }
        return port;
    }

    private int getRmiApiVersion() {
        String portProp = System.getProperty("install.operation.debug.port");
        if (portProp != null) {
            return RMI_API_VERSION;
        }
        int i = 0;
        while (i < OLD_RMI_REGISTRY_PORT_VMARGS.length) {
            String oldArg = OLD_RMI_REGISTRY_PORT_VMARGS[i];
            portProp = System.getProperty(oldArg);
            if (portProp != null) {
                return i;
            }
            ++i;
        }
        return RMI_API_VERSION;
    }

    private synchronized IInstallOperationDebugEvents waitForSetEvents() {
        while (this.remoteEvents == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.remoteEvents;
    }

    private void setInstallOrder() throws IOException {
        InstallOrderVariableContainer installOrderContainer = new InstallOrderVariableContainer(this.engineOperations);
        InstallOperationDebugVariable installOrder = installOrderContainer.getVariable();
        this.remoteEvents.setInstallOrder((IInstallOperationDebugVariable)installOrder);
    }

    private void setSourceContainers() throws IOException {
        AgentJob[] jobs = this.getGroupJobs();
        LinkedHashSet<String> containers = new LinkedHashSet<String>();
        if (jobs.length != 0) {
            IOffering[] installedOfferings;
            InstallRegistry registry = InstallRegistry.getInstance();
            Profile profile = jobs[0].getProfile();
            InstallRegistry.ProfileInstallRegistry profileInstallRegistry = registry.getProfileInstallRegistry(profile);
            IRepository repo = profileInstallRegistry.getRepository();
            AgentJob[] agentJobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                IOffering registryOffering;
                String sourceContainerPath;
                AgentJob job = agentJobArray[n2];
                IOffering offering = job.getOffering();
                if (offering != null && (sourceContainerPath = this.getSourceContainerPath(repo, registryOffering = repo.findOffering(offering.getIdentity(), offering.getVersion(), null))) != null) {
                    containers.add(FileUtil.getCanonicalPath((String)sourceContainerPath));
                }
                ++n2;
            }
            IOffering[] iOfferingArray = installedOfferings = profileInstallRegistry.getInstalledOfferings();
            int n3 = installedOfferings.length;
            n = 0;
            while (n < n3) {
                IOffering offering = iOfferingArray[n];
                String sourceContainerPath = this.getSourceContainerPath(repo, offering);
                if (sourceContainerPath != null) {
                    containers.add(FileUtil.getCanonicalPath((String)sourceContainerPath));
                }
                ++n;
            }
            File fixesDir = new File(repo.getLocationStr(), "Fixes");
            if (fixesDir.isDirectory()) {
                containers.add(FileUtil.getCanonicalPath((File)fixesDir));
            }
        }
        String[] c = containers.toArray(new String[containers.size()]);
        this.remoteEvents.setSourceContainers(c);
    }

    private String getSourceContainerPath(IRepository repo, IOffering offering) {
        IContentRepository contentRepo = repo.getContentRepository((IContent)offering);
        HashMap secondary = contentRepo.getSecondaryContentInfoMap();
        if (secondary.isEmpty()) {
            return null;
        }
        String seJarSimpleName = (String)secondary.keySet().iterator().next();
        File repoLoc = new File(repo.getLocationStr());
        File offeringJarsLoc = new File(repoLoc, "Offerings");
        File seJar = new File(offeringJarsLoc, seJarSimpleName);
        if (seJar.isFile()) {
            return seJar.getPath();
        }
        return null;
    }

    @Override
    public IStatus beforeInstallSession(IAgentEventManager.AgentSessionEvent event) {
        this.sessionJobs = event.getAgentJobs();
        return Status.OK_STATUS;
    }

    @Override
    public void afterInstallSession(IAgentEventManager.AgentSessionEvent event) {
        this.sessionJobs = EMPTY_JOBS;
    }

    @Override
    public IStatus beforeUninstallSession(IAgentEventManager.AgentSessionEvent event) {
        this.sessionJobs = event.getAgentJobs();
        return Status.OK_STATUS;
    }

    @Override
    public void afterUninstallSession(IAgentEventManager.AgentSessionEvent event) {
        this.sessionJobs = EMPTY_JOBS;
    }

    private static class Action
    implements InstallOperationEventManager.IAction {
        private Action() {
        }

        @Override
        public IStatus perform(AbstractInstallOperation op, IStatus status, IProgressMonitor monitor) {
            INSTANCE.checkIfSuspendedByClientRequest();
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                try {
                    INSTANCE.suspendByErrorOrCancel(op, status);
                }
                catch (IOException e) {
                    Logger.getGlobalLogger().error((Throwable)e);
                }
            }
            return Status.OK_STATUS;
        }

        /* synthetic */ Action(Action action, Action action2) {
            this();
        }
    }

    public static enum ForceStatus {
        ERROR,
        CANCEL;

    }

    private static class InstallOrderVariableContainer
    extends TempVariableContainer {
        public InstallOrderVariableContainer(InstallOrderManager.EngineOperation[] engineOperations) throws IOException {
            super("installOrder", engineOperations);
        }

        @Override
        protected InstallOperationDebugVariable createVariable(String variableName, TempVariableContainer container) throws IOException {
            return InstallOperationDebugVariable.createArrayVariable(variableName, container, InstallOperationDebugValue.EngineOperation.TYPE_INFO);
        }
    }

    public static class ResumeAction {
        public boolean enabled = false;
        public When when = When.BEFORE;
        public ForceStatus forceStatus = ForceStatus.ERROR;

        public String toString() {
            if (!this.enabled) {
                return "disabled";
            }
            return String.valueOf(this.forceStatus.toString().toLowerCase(Locale.ENGLISH)) + ' ' + this.when.toString().toLowerCase(Locale.ENGLISH);
        }
    }

    private static abstract class Stepping {
        private Stepping() {
        }

        public abstract boolean isComplete(AbstractInstallOperation var1);
    }

    private static class SteppingOverEngineOperation
    extends Stepping {
        private final int initialEngineOperationId = INSTANCE.getEngineOperationId();

        private SteppingOverEngineOperation() {
        }

        @Override
        public boolean isComplete(AbstractInstallOperation op) {
            int engineOperationId = INSTANCE.getEngineOperationId();
            return engineOperationId != this.initialEngineOperationId;
        }

        /* synthetic */ SteppingOverEngineOperation(SteppingOverEngineOperation steppingOverEngineOperation, SteppingOverEngineOperation steppingOverEngineOperation2) {
            this();
        }
    }

    private static class SteppingOverEnginePhase
    extends SteppingOverEngineOperation {
        private final String initialEnginePhase = INSTANCE.getEnginePhase();

        private SteppingOverEnginePhase() {
        }

        @Override
        public boolean isComplete(AbstractInstallOperation op) {
            if (super.isComplete(op)) {
                return true;
            }
            String enginePhase = INSTANCE.getEnginePhase();
            return !enginePhase.equals(this.initialEnginePhase);
        }
    }

    private static class SteppingOverInstallOperation
    extends Stepping {
        private SteppingOverInstallOperation() {
        }

        @Override
        public boolean isComplete(AbstractInstallOperation op) {
            return true;
        }
    }

    private static class SteppingOverUnit
    extends SteppingOverEngineOperation {
        private String initialParentId;
        private String initialUnitId;
        private Version initialUnitVersion;

        public SteppingOverUnit() {
            AbstractInstallOperation op = INSTANCE.getInstallOperation();
            if (op == null) {
                this.initialParentId = "";
                this.initialUnitId = "";
                this.initialUnitVersion = Version.emptyVersion;
            } else {
                IInstallableUnit unit = op.getUnit();
                this.initialParentId = unit.getParent().getIdentity().getId();
                this.initialUnitId = unit.getIdentity().getId();
                this.initialUnitVersion = unit.getVersion();
            }
        }

        @Override
        public boolean isComplete(AbstractInstallOperation op) {
            if (super.isComplete(op)) {
                return true;
            }
            IInstallableUnit unit = op.getUnit();
            String parentId = unit.getParent().getIdentity().getId();
            if (!parentId.equals(this.initialParentId)) {
                return true;
            }
            String unitId = unit.getIdentity().getId();
            if (!unitId.equals(this.initialUnitId)) {
                return true;
            }
            Version unitVersion = unit.getVersion();
            return !unitVersion.equals((Object)this.initialUnitVersion);
        }
    }

    private static class SteppingToSelectedUnit
    extends Stepping {
        private static final int NOT_RELEVANT = -1;
        private int initialPhase = -1;
        private int initialEngineOperationId = -1;
        private final String selectedParentId;
        private final String selectedUnitId;
        private final Version selectedUnitVersion;

        public SteppingToSelectedUnit(String parentId, String unitId, Version unitVersion) {
            this.selectedParentId = parentId;
            this.selectedUnitId = unitId;
            this.selectedUnitVersion = unitVersion;
            AbstractInstallOperation op = INSTANCE.getInstallOperation();
            if (op != null && this.isComplete(op)) {
                this.initialPhase = op.getPhase();
                this.initialEngineOperationId = INSTANCE.getEngineOperationId();
            }
        }

        @Override
        public boolean isComplete(AbstractInstallOperation op) {
            int phase = op.getPhase();
            int engineOperationId = INSTANCE.getEngineOperationId();
            if (phase == this.initialPhase && engineOperationId == this.initialEngineOperationId) {
                return false;
            }
            IInstallableUnit unit = op.getUnit();
            String parentId = unit.getParent().getIdentity().getId();
            if (!parentId.equals(this.selectedParentId)) {
                return false;
            }
            String unitId = unit.getIdentity().getId();
            if (!unitId.equals(this.selectedUnitId)) {
                return false;
            }
            Version unitVersion = unit.getVersion();
            return unitVersion.equals((Object)this.selectedUnitVersion);
        }
    }

    private static abstract class TempVariableContainer
    extends InstallOperationDebugValue {
        private static final InstallOperationDebugValue.TypeInfo TYPE_INFO = new InstallOperationDebugValue.TypeInfo("TempVariableContainer");
        private final String varName;
        private final Object valObj;
        private InstallOperationDebugVariable var = null;

        public TempVariableContainer(String varName, Object valObj) throws IOException {
            super((InstallOperationDebugValue)null);
            this.varName = varName;
            this.valObj = valObj;
        }

        @Override
        public InstallOperationDebugValue.TypeInfo getTypeInfo() {
            return TYPE_INFO;
        }

        @Override
        public boolean hasVariables() {
            return true;
        }

        @Override
        public IInstallOperationDebugVariable[] getVariables() {
            InstallOperationDebugVariable v = this.getVariable();
            if (v == null) {
                return InstallOperationDebugVariable.EMPTY_VARIABLES;
            }
            return new IInstallOperationDebugVariable[]{this.var};
        }

        @Override
        protected Object getValueObject(String variableName) {
            return this.valObj;
        }

        protected abstract InstallOperationDebugVariable createVariable(String var1, TempVariableContainer var2) throws IOException;

        public InstallOperationDebugVariable getVariable() {
            if (this.var == null) {
                try {
                    this.var = this.createVariable(this.varName, this);
                }
                catch (IOException e) {
                    Logger.getGlobalLogger().error((Throwable)e);
                    return null;
                }
            }
            return this.var;
        }
    }

    public static enum When {
        BEFORE,
        AFTER;

    }
}

