/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.IInstallAdaptor;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.InstallContextTree;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class SafeInstallAdaptorWrapper
implements IInstallAdaptor,
IAdaptable {
    private final IInstallAdaptor adaptor;

    public SafeInstallAdaptorWrapper(IInstallAdaptor adaptor) {
        this.adaptor = adaptor;
    }

    private IStatus exceptionError(Throwable t) {
        return Statuses.ERROR.get(t, t.getMessage(), new Object[0]);
    }

    @Override
    public IStatus complete(InstallContext context, IProgressMonitor monitor) {
        try {
            return this.adaptor.complete(context, monitor);
        }
        catch (Throwable t) {
            return this.exceptionError(t);
        }
    }

    @Override
    public IStatus completeSession(AgentJob[] jobs, IProgressMonitor monitor) {
        try {
            return this.adaptor.completeSession(jobs, monitor);
        }
        catch (Throwable t) {
            return this.exceptionError(t);
        }
    }

    @Override
    public String getId() {
        try {
            return this.adaptor.getId();
        }
        catch (Throwable t) {
            Logger.getGlobalLogger().error(t, t.getMessage(), new Object[0]);
            return "???Unknown???";
        }
    }

    @Override
    public IStatus initialize(InstallContext context) {
        try {
            return this.adaptor.initialize(context);
        }
        catch (Throwable t) {
            return this.exceptionError(t);
        }
    }

    @Override
    public IStatus initializeNewProfile(Profile profile) {
        try {
            return this.adaptor.initializeNewProfile(profile);
        }
        catch (Throwable t) {
            return this.exceptionError(t);
        }
    }

    @Override
    public IStatus install(InstallableUnitPair pair, InstallContext context, IProgressMonitor monitor) {
        try {
            return this.adaptor.install(pair, context, monitor);
        }
        catch (Throwable t) {
            return this.exceptionError(t);
        }
    }

    @Override
    public IStatus postInstall(InstallContext context, IProgressMonitor monitor) {
        try {
            return this.adaptor.postInstall(context, monitor);
        }
        catch (Throwable t) {
            return this.exceptionError(t);
        }
    }

    @Override
    public IStatus postInstallConfigure(InstallableUnitPair pair, InstallContext context, IProgressMonitor monitor) {
        try {
            return this.adaptor.postInstallConfigure(pair, context, monitor);
        }
        catch (Throwable t) {
            return this.exceptionError(t);
        }
    }

    @Override
    public IStatus postInstallSession(AgentJob[] jobs, IStatus sessionStatus, IProgressMonitor monitor) {
        try {
            return this.adaptor.postInstallSession(jobs, sessionStatus, monitor);
        }
        catch (Throwable t) {
            return this.exceptionError(t);
        }
    }

    @Override
    public IStatus postUninstallSession(AgentJob[] jobs, IStatus sessionStatus, IProgressMonitor monitor) {
        try {
            return this.adaptor.postUninstallSession(jobs, sessionStatus, monitor);
        }
        catch (Throwable t) {
            return this.exceptionError(t);
        }
    }

    @Override
    public IStatus preInstall(InstallContext context, IProgressMonitor monitor) {
        try {
            return this.adaptor.preInstall(context, monitor);
        }
        catch (Throwable t) {
            return this.exceptionError(t);
        }
    }

    @Override
    public IStatus preInstallConfigure(InstallableUnitPair pair, InstallContext context, IProgressMonitor monitor) {
        try {
            return this.adaptor.preInstallConfigure(pair, context, monitor);
        }
        catch (Throwable t) {
            return this.exceptionError(t);
        }
    }

    @Override
    public IStatus preInstallSession(AgentJob[] jobs, IProgressMonitor monitor) {
        try {
            return this.adaptor.preInstallSession(jobs, monitor);
        }
        catch (Throwable t) {
            return this.exceptionError(t);
        }
    }

    @Override
    public IStatus preUninstallSession(AgentJob[] jobs, IProgressMonitor monitor) {
        try {
            return this.adaptor.preUninstallSession(jobs, monitor);
        }
        catch (Throwable t) {
            return this.exceptionError(t);
        }
    }

    @Override
    public IStatus qualify(AgentJob[] jobs, InstallContextTree rootContext, Profile profile, IProgressMonitor monitor) {
        try {
            return this.adaptor.qualify(jobs, rootContext, profile, monitor);
        }
        catch (Throwable t) {
            return this.exceptionError(t);
        }
    }

    @Override
    public IStatus qualifyNewOffering(Profile profile, IOffering offering) {
        try {
            return this.adaptor.qualifyNewOffering(profile, offering);
        }
        catch (Throwable t) {
            return this.exceptionError(t);
        }
    }

    @Override
    public IStatus qualifyNewProfile(Profile profile) {
        try {
            return this.adaptor.qualifyNewProfile(profile);
        }
        catch (Throwable t) {
            return this.exceptionError(t);
        }
    }

    @Override
    public IStatus restart(InstallContext context) {
        try {
            return this.adaptor.restart(context);
        }
        catch (Throwable t) {
            return this.exceptionError(t);
        }
    }

    @Override
    public IStatus stop(IProgressMonitor monitor) {
        try {
            return this.adaptor.stop(monitor);
        }
        catch (Throwable t) {
            return this.exceptionError(t);
        }
    }

    public Object getAdapter(Class adapter) {
        try {
            if (this.adaptor instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)this.adaptor;
                return adaptable.getAdapter(adapter);
            }
        }
        catch (Throwable t) {
            Logger.getGlobalLogger().error(t, t.getMessage(), new Object[0]);
        }
        return null;
    }
}

