/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core;

import com.ibm.cic.agent.core.AbstractInstallAdaptor;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.IInstallAdaptor;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.MkdirInstallOperation;
import com.ibm.cic.agent.internal.core.InstallContextPropertyOperation;
import com.ibm.cic.common.commonNativeAdapterData.PerformCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.fileUtils.MkdirCommonNativeData;
import com.ibm.cic.common.core.model.CicFactory;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallationContext;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class InstallContextAdapter
extends AbstractInstallAdaptor
implements IInstallAdaptor {
    private static final String AdapterId = "InstallContext";
    private final InstallContext installContext;
    private final IInstallationContext contextData;

    public InstallContextAdapter(InstallContext context, IInstallationContext contextData) {
        this.installContext = context;
        this.contextData = contextData;
    }

    public IStatus installAllUnits() {
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        List units = this.contextData.getInstallableUnits();
        NullProgressMonitor monitor = new NullProgressMonitor();
        for (IInstallableUnit nextUnit : units) {
            InstallableUnitPair pair = new InstallableUnitPair(null, nextUnit);
            result.add(this.install(pair, this.installContext, (IProgressMonitor)monitor));
        }
        return result;
    }

    @Override
    public String getId() {
        return AdapterId;
    }

    @Override
    public IStatus initialize(InstallContext context) {
        IInstallableUnit unit = CicFactory.getInstance().createInstallableUnit(this.contextData.getIdentity(), this.contextData.getVersion());
        unit.setAdapterId("native");
        unit.getProperties().putAll(this.contextData.getProperties());
        return this.performPropertyOperations(30, unit, context, null);
    }

    @Override
    public IStatus install(InstallableUnitPair pair, InstallContext context, IProgressMonitor monitor) {
        if (pair.isInstall()) {
            return this.doInstall(pair.getTo(), context, monitor);
        }
        return Status.OK_STATUS;
    }

    private IStatus doInstall(IInstallableUnit unit, InstallContext context, IProgressMonitor monitor) {
        CommonAdapterData[] children;
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        result.add(this.performPropertyOperations(21, unit, context, monitor));
        if (result.isErrorOrCancel()) {
            return StatusUtil.toSingleStatus((IStatus)result);
        }
        if (Agent.getInstance().isSkipInstall()) {
            return StatusUtil.toSingleStatus((IStatus)result);
        }
        CommonAdapterData[] commonAdapterDataArray = children = unit.getAdapterData().getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            CommonAdapterData nextData = commonAdapterDataArray[n2];
            if (nextData instanceof PerformCommonNativeData) {
                CommonAdapterData[] subData;
                PerformCommonNativeData performData = (PerformCommonNativeData)nextData;
                CommonAdapterData[] commonAdapterDataArray2 = subData = nextData.getChildren();
                int n3 = subData.length;
                int n4 = 0;
                while (n4 < n3) {
                    block12: {
                        CommonAdapterData nextPerform = commonAdapterDataArray2[n4];
                        if (nextPerform instanceof MkdirCommonNativeData) {
                            MkdirInstallOperation mkdirOp;
                            block11: {
                                mkdirOp = new MkdirInstallOperation(21, unit, context, (MkdirCommonNativeData)nextPerform, performData);
                                try {
                                    context.performOperation(mkdirOp, monitor);
                                }
                                catch (CoreException e) {
                                    result.add(e.getStatus());
                                    if (!result.isErrorOrCancel()) break block11;
                                    return StatusUtil.toSingleStatus((IStatus)result);
                                }
                            }
                            try {
                                if (mkdirOp.createdDirectory()) {
                                    context.setCreatedDirectory(mkdirOp.getDirectory());
                                }
                            }
                            catch (CoreException e) {
                                result.add(e.getStatus());
                                if (!result.isErrorOrCancel()) break block12;
                                return StatusUtil.toSingleStatus((IStatus)result);
                            }
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return StatusUtil.toSingleStatus((IStatus)result);
    }

    private IStatus performPropertyOperations(int phase, IInstallableUnit unit, InstallContext context, IProgressMonitor monitor) {
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        for (Map.Entry entry : unit.getProperties().entrySet()) {
            InstallContextPropertyOperation op = new InstallContextPropertyOperation(phase, unit, context, (String)entry.getKey(), (String)entry.getValue());
            try {
                context.performOperation(op, monitor);
            }
            catch (CoreException e) {
                result.add(e.getStatus());
                if (result.isErrorOrCancel()) break;
            }
        }
        return StatusUtil.toSingleStatus((IStatus)result);
    }
}

