/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core;

import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IllegalFeatureStateException;
import com.ibm.cic.common.core.model.expander.ExpanderUtils;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class FeatureDependencies {
    private static final Logger log = Logger.getLogger();
    private final Profile profile;
    private final IOffering offering;
    private final IFeature[] features;

    public FeatureDependencies(Profile profile, IOffering offering) {
        this.profile = profile;
        this.offering = offering;
        this.features = OfferingUtil.getAllFeatures((IOffering)this.offering);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(16 * (2 + this.features.length));
        sb.append("Dependencies for ").append(this.offering.getIdentity());
        try {
            IFeature[] iFeatureArray = this.features;
            int n = this.features.length;
            int n2 = 0;
            while (n2 < n) {
                IFeature feature = iFeatureArray[n2];
                IFeature[] required = feature.getRequiredFeatures();
                if (required.length > 0) {
                    sb.append("\n  ").append(feature.getIdentity()).append(" requires:");
                    IFeature[] iFeatureArray2 = required;
                    int n3 = required.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IFeature element = iFeatureArray2[n4];
                        sb.append(' ').append(element.getIdentity());
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (IllegalFeatureStateException e) {
            ExceptionUtil.debugLogToReview((Throwable)e);
            sb.append("  <not yet computed>");
        }
        return sb.toString();
    }

    public void compute(IProgressMonitor monitor) {
        log.start(log.debug("Computing feature dependencies"));
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)this.features.length);
        IFeature[] iFeatureArray = this.features;
        int n = this.features.length;
        int n2 = 0;
        while (n2 < n) {
            IFeature feature = iFeatureArray[n2];
            if (!feature.hasState(1)) {
                sm.subTask(OfferingUtil.getFeatureName((IFeature)feature));
                this.compute(feature, (IProgressMonitor)sm.newChild(1));
                feature.setState(1);
            }
            ++n2;
        }
        sm.subTask("");
        log.stop();
        log.debug((Object)this);
    }

    private void compute(IFeature feature, IProgressMonitor monitor) {
        monitor.beginTask(null, 4);
        IContentSelector selector = feature.getSelector();
        if (selector == null) {
            monitor.done();
            return;
        }
        ArrayList<IFeature> required = new ArrayList<IFeature>();
        Set rootSelection = ExpanderUtils.computeDependentSelectors((LinkedProperties)this.profile.getAllData(), (IShareableEntity)this.offering.getAssembly(), (IContentSelector)selector);
        monitor.worked(1);
        for (IContentSelector sel : rootSelection) {
            IFeature req = this.getFeature(sel);
            if (req == null) continue;
            required.add(req);
        }
        monitor.worked(1);
        this.ensureMutualExclusivityOfFeatures(feature, required);
        monitor.worked(1);
        for (IFeature req : required) {
            if (feature.equals(req)) continue;
            feature.addRequired(req);
            req.addDependent(feature);
        }
        monitor.worked(1);
    }

    private IFeature getFeature(IContentSelector selector) {
        return OfferingUtil.getFeatureBySelectorId((IFeature[])this.features, (String)selector.getIdentity().getId());
    }

    private void ensureMutualExclusivityOfFeatures(IFeature feature, List required) {
        block0: for (IFeature req1 : required) {
            IFeatureGroup parent = req1.getParent();
            if (!parent.hasMutuallyExclusiveChildren()) continue;
            ListIterator j = required.listIterator(required.size());
            while (j.hasPrevious()) {
                IFeature req2 = (IFeature)j.previous();
                if (req1 == req2) continue block0;
                if (!parent.equals(req2.getParent())) continue;
                log.error(Messages.FeatureDependencies_Feature_Requires_Exclusive, new Object[]{feature.getIdentity(), req1.getIdentity(), req2.getIdentity()});
                j.remove();
            }
        }
    }
}

