/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.IInstallAdaptor;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.agent.internal.core.SafeInstallAdaptorWrapper;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class AdaptorManager
implements IRegistryChangeListener {
    private static final AdaptorManager instance = new AdaptorManager();
    private static final IInstallAdaptor[] NO_ADAPTERS = new IInstallAdaptor[0];
    private static final String PT_INSTALL_ADAPTORS = "installAdaptors";
    private static final String ELEMENT_INSTALL_ADAPTOR = "installAdaptor";
    private static final String ELEMENT_ADAPTOR_DATA = "data";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_TYPE = "type";
    private final Map adaptorEntries = new HashMap();
    private boolean extensionRegistryChanged = true;

    public static AdaptorManager getInstance() {
        return instance;
    }

    private AdaptorManager() {
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this, Agent.PI_AGENT);
    }

    public IInstallAdaptor getAdaptor(String id) {
        if (id == null || "".equals(id)) {
            throw new IllegalArgumentException(Messages.AdaptorManager_Null_Adaptor_Type_Argument);
        }
        try {
            this.initializeInstallAdaptors();
            AdaptorEntry entry = (AdaptorEntry)this.adaptorEntries.get(id);
            return entry == null ? null : entry.getAdaptor();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public IInstallAdaptor[] getAllAdaptors() {
        try {
            this.initializeInstallAdaptors();
            ArrayList<IInstallAdaptor> adaptors = new ArrayList<IInstallAdaptor>(this.adaptorEntries.size());
            for (AdaptorEntry entry : this.adaptorEntries.values()) {
                IInstallAdaptor adaptor = entry.getAdaptor();
                if (adaptor == null) continue;
                adaptors.add(adaptor);
            }
            return adaptors.toArray(NO_ADAPTERS);
        }
        catch (CoreException e) {
            Logger.getLogger(AdaptorManager.class).error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public IInstallAdaptor[] getCreatedAdaptors() {
        ArrayList<IInstallAdaptor> adaptors = new ArrayList<IInstallAdaptor>(this.adaptorEntries.size());
        for (AdaptorEntry entry : this.adaptorEntries.values()) {
            if (!entry.hasAdaptor()) continue;
            try {
                adaptors.add(entry.getAdaptor());
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        return adaptors.toArray(NO_ADAPTERS);
    }

    public IStatus validateInstallAdaptors(String[] requiredTypes) {
        try {
            this.initializeInstallAdaptors();
            String[] stringArray = requiredTypes;
            int n = requiredTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String requiredType = stringArray[n2];
                AdaptorEntry entry = (AdaptorEntry)this.adaptorEntries.get(requiredType);
                if (entry == null) {
                    throw AdaptorManager.coreException(NLS.bind((String)Messages.AdaptorManager_Required_Adaptor_Not_Found, (Object)requiredType));
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    private void initializeInstallAdaptors() throws CoreException {
        if (!this.extensionRegistryChanged) {
            return;
        }
        this.extensionRegistryChanged = false;
        for (Map.Entry entry : this.getConfigurationElementMap().entrySet()) {
            String id = (String)entry.getKey();
            if (this.adaptorEntries.containsKey(id)) continue;
            IConfigurationElement element = (IConfigurationElement)entry.getValue();
            this.adaptorEntries.put(id, new AdaptorEntry(element));
        }
    }

    private Map getConfigurationElementMap() throws CoreException {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(Agent.PI_AGENT, PT_INSTALL_ADAPTORS);
        if (point == null) {
            throw AdaptorManager.coreException(NLS.bind((String)Messages.AdaptorManager_No_Extension_Point, (Object)Agent.PI_AGENT, (Object)PT_INSTALL_ADAPTORS));
        }
        IExtension[] extensions = point.getExtensions();
        HashMap<String, IConfigurationElement> result = new HashMap<String, IConfigurationElement>(extensions.length);
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                String elementName = element.getName();
                if (!ELEMENT_INSTALL_ADAPTOR.equalsIgnoreCase(elementName)) {
                    if (!ELEMENT_ADAPTOR_DATA.equals(elementName)) {
                        throw AdaptorManager.coreException(NLS.bind((String)Messages.AdaptorManager_Incorrectly_Named_Extension, (Object)elementName, (Object)ELEMENT_INSTALL_ADAPTOR));
                    }
                } else {
                    String id = element.getAttribute(ATTRIBUTE_TYPE);
                    if (id == null) {
                        throw AdaptorManager.coreException(NLS.bind((String)Messages.AdaptorManager_Attribute_Not_Specified, (Object)ATTRIBUTE_TYPE));
                    }
                    if (result.containsKey(id)) {
                        throw AdaptorManager.coreException(NLS.bind((String)Messages.AdaptorManager_Conflicting_Adaptor_Types, (Object)ATTRIBUTE_TYPE, (Object)id));
                    }
                    result.put(id, element);
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    private static CoreException coreException(String msg) {
        return new CoreException((IStatus)new Status(4, Agent.PI_AGENT, 0, msg, null));
    }

    public void registryChanged(IRegistryChangeEvent event) {
        if (event.getExtensionDeltas(Agent.PI_AGENT, PT_INSTALL_ADAPTORS).length > 0) {
            this.extensionRegistryChanged = true;
        }
    }

    private static class AdaptorEntry {
        private final IConfigurationElement element;
        private boolean createdExtension = false;
        private IInstallAdaptor installAdaptor = null;

        public AdaptorEntry(IConfigurationElement element) {
            this.element = element;
        }

        public boolean hasAdaptor() {
            return this.installAdaptor != null;
        }

        public IInstallAdaptor getAdaptor() throws CoreException {
            if (!this.createdExtension) {
                this.createdExtension = true;
                String id = this.element.getAttribute(AdaptorManager.ATTRIBUTE_TYPE);
                IInstallAdaptor adaptor = (IInstallAdaptor)this.element.createExecutableExtension(AdaptorManager.ATTRIBUTE_CLASS);
                if (adaptor == null) {
                    throw AdaptorManager.coreException(NLS.bind((String)Messages.AdaptorManager_Null_Creating_Install_Adaptor_Extension, (Object)id));
                }
                if (!id.equals(adaptor.getId())) {
                    throw AdaptorManager.coreException(NLS.bind((String)Messages.AdaptorManager_Adaptor_Type_Mismatch, (Object)id, (Object)adaptor.getId()));
                }
                this.installAdaptor = new SafeInstallAdaptorWrapper(adaptor);
            }
            return this.installAdaptor;
        }

        public String toString() {
            return "AdapterEntry for " + this.element.getAttribute(AdaptorManager.ATTRIBUTE_TYPE);
        }
    }
}

