/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.sharedUI;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.CustomPanelData;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.ConCustomPanel;
import com.ibm.cic.agent.core.api.IAgentJob;
import com.ibm.cic.agent.core.api.ICustomPanel;
import com.ibm.cic.agent.core.sharedUI.CustomPanelJobPair;
import com.ibm.cic.agent.core.sharedUI.ICustomPanelFactory;
import com.ibm.cic.agent.core.sharedUI.NullCustomPanel;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.agent.core.sharedUI.WizardType;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public final class CommonCustomPanelFactory
implements ICustomPanelFactory {
    private static final String TAG_COMMON_CUSTOM_PANELS = "commonCustomPanels";
    private static final String TAG_COMMON_PANEL = "commonPanel";
    private static final String TAG_WIZARD_TYPE = "wizardType";
    private static final String ATTR_TYPE = "type";
    private static final String PROJECT_TO_SKIP_IU_CHECK = "com.ibm.cic.agent.ui.tests";
    private static final CommonCustomPanelFactory INSTANCE = new CommonCustomPanelFactory();

    public static CommonCustomPanelFactory getInstance() {
        return INSTANCE;
    }

    @Override
    @Deprecated
    public CustomPanelJobPair[] createCustomPanels(boolean consoleMode, Class<? extends ICustomPanel> panelType, WizardType type, AgentJob[] allProductJobs) throws CoreException {
        return this.createCustomPanels(consoleMode, panelType, type, allProductJobs, false);
    }

    @Override
    public CustomPanelJobPair[] createCustomPanels(boolean consoleMode, Class<? extends ICustomPanel> panelType, WizardType type, AgentJob[] allProductJobs, boolean isMultipleProfile) throws CoreException {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.cic.agent.ui", TAG_COMMON_CUSTOM_PANELS);
        if (extensionPoint == null) {
            return new CustomPanelJobPair[0];
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions.length == 0) {
            return new CustomPanelJobPair[0];
        }
        ArrayList<CustomPanelJobPair> result = new ArrayList<CustomPanelJobPair>();
        Collection<AgentJob[]> jobArrays = new ArrayList();
        if (isMultipleProfile) {
            jobArrays = AgentUtil.groupByProfile(allProductJobs, false);
        } else if (allProductJobs != null && allProductJobs.length > 0) {
            jobArrays.add(allProductJobs);
        }
        for (IAgentJob[] iAgentJobArray : jobArrays) {
            Profile profile = iAgentJobArray[0].getProfile();
            ArrayList<IExtension> extensionsInJob = new ArrayList<IExtension>(extensions.length);
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IContributor contributor = extension.getContributor();
                String name = contributor.getName();
                if (SharedUIUtils.nameIsInJobs(name, (AgentJob[])iAgentJobArray, new String[]{PROJECT_TO_SKIP_IU_CHECK})) {
                    extensionsInJob.add(extension);
                }
                ++n2;
            }
            if (extensionsInJob.isEmpty()) continue;
            ArrayList panelExtensions = new ArrayList();
            int i = 0;
            while (i < extensionsInJob.size()) {
                IExtension extension = (IExtension)extensionsInJob.get(i);
                this.parseDefinitions(extension, panelExtensions);
                ++i;
            }
            for (CommonPanelExtension commonPanelExt : panelExtensions) {
                if (!commonPanelExt.getWizardTypes().contains(type.getType())) continue;
                ICustomPanel customPanel = commonPanelExt.getCommonCustomPanel(consoleMode, panelType);
                try {
                    CustomPanelData data = new CustomPanelData(allProductJobs, iAgentJobArray);
                    customPanel.init(data);
                    customPanel.initCustomPanelData(data);
                    if (!customPanel.canAddPanel()) continue;
                    CustomPanelJobPair panelJob = new CustomPanelJobPair(customPanel, null);
                    panelJob.setProfile(profile);
                    result.add(panelJob);
                }
                catch (Exception e) {
                    IStatus status = SharedUIUtils.generateCustomPanelExceptionStatus(null, customPanel, (Throwable)e);
                    throw new CoreException(status);
                }
            }
        }
        return result.toArray(new CustomPanelJobPair[result.size()]);
    }

    private void parseDefinitions(IExtension extension, List panelExt) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(TAG_COMMON_PANEL)) {
                panelExt.add(new CommonPanelExtension(element));
            }
            ++n2;
        }
    }

    private static class CommonPanelExtension {
        private final IConfigurationElement element;
        private ICustomPanel panel;
        private Set<String> wizardTypes;

        public CommonPanelExtension(IConfigurationElement element) {
            this.element = element;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Panel for <").append(this.element.getName());
            String[] stringArray = this.element.getAttributeNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attr = stringArray[n2];
                sb.append(' ').append(attr).append("='").append(this.element.getAttribute(attr)).append('\'');
                ++n2;
            }
            sb.append('>');
            return sb.toString();
        }

        public ICustomPanel getCommonCustomPanel(boolean consoleMode, Class<? extends ICustomPanel> panelType) throws CoreException {
            if (this.panel == null) {
                String attr = "class";
                if (consoleMode) {
                    attr = panelType.equals(ConCustomPanel.class) ? "conClass" : "textClass";
                }
                if (attr.equals("textClass") && this.element.getAttribute("conClass") != null) {
                    return NullCustomPanel.INSTANCE;
                }
                if (this.element.getAttribute(attr) != null) {
                    this.panel = this.createPanel(attr, panelType);
                } else {
                    Logger.getLogger().warningNoUid("No \"{0}\" attribute in \"{1}\" element of panel {2} in {3}", new Object[]{attr, this.element.getName(), this.element.getAttribute("id"), this.element.getContributor().getName()});
                    this.panel = NullCustomPanel.INSTANCE;
                }
            }
            return this.panel;
        }

        private ICustomPanel createPanel(String attrName, Class<? extends ICustomPanel> clazz) throws CoreException {
            Object extn = this.element.createExecutableExtension(attrName);
            if (!clazz.isInstance(extn)) {
                throw new CoreException((IStatus)new Status(4, Agent.PI_AGENT, NLS.bind((String)"Class specified by \"{0}\" attribute of \"{1}\" element in {2} must be a subtype of {3}; actual type is {4}", (Object[])new Object[]{attrName, this.element.getName(), this.element.getContributor().getName(), clazz.getName(), extn.getClass().getName()})));
            }
            return (ICustomPanel)extn;
        }

        private Set<String> getWizardTypes() {
            if (this.wizardTypes == null) {
                this.wizardTypes = new LinkedHashSet<String>();
                IConfigurationElement[] iConfigurationElementArray = this.element.getChildren(CommonCustomPanelFactory.TAG_WIZARD_TYPE);
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement child = iConfigurationElementArray[n2];
                    String type = child.getAttribute(CommonCustomPanelFactory.ATTR_TYPE);
                    if (type != null && type.length() > 0) {
                        this.wizardTypes.add(type);
                    }
                    ++n2;
                }
            }
            return this.wizardTypes;
        }
    }
}

