/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.response;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.StartupManager;
import com.ibm.cic.agent.core.internal.headless.CommandFactory;
import com.ibm.cic.agent.core.internal.headless.HeadlessUtils;
import com.ibm.cic.agent.core.internal.headless.IInput;
import com.ibm.cic.agent.core.internal.headless.IPreferenceCommand;
import com.ibm.cic.agent.core.internal.headless.IServerCommand;
import com.ibm.cic.agent.core.internal.headless.ShadowProfile;
import com.ibm.cic.agent.core.internal.response.Action;
import com.ibm.cic.agent.core.internal.response.IActionElement;
import com.ibm.cic.agent.core.internal.response.IConfigElement;
import com.ibm.cic.agent.core.internal.response.IElementProxy;
import com.ibm.cic.agent.core.internal.response.IPreferenceElement;
import com.ibm.cic.agent.core.internal.response.IPreferencesElement;
import com.ibm.cic.agent.core.internal.response.IRepositoriesElement;
import com.ibm.cic.agent.core.internal.response.IRepositoryElement;
import com.ibm.cic.agent.core.internal.response.impl.Diff;
import com.ibm.cic.agent.core.internal.response.impl.DiffHelper;
import com.ibm.cic.agent.core.internal.response.impl.DiffPackage;
import com.ibm.cic.agent.core.internal.response.impl.DiffPackageGroup;
import com.ibm.cic.agent.core.internal.response.impl.DiffRoot;
import com.ibm.cic.agent.core.internal.response.impl.InstallRegistryProxy;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.RebootRequest;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;

public class Response {
    private final IInput input;
    private final IConfigElement config;

    public Response(IInput input) {
        this.input = input;
        this.config = input.getDocumentRoot().getConfig();
    }

    public IStatus execute() {
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        return result;
    }

    public IStatus initializeAgentPreferences(Agent agent) {
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        agent.initializeAgentPreferences();
        IPreferencesElement preferencesElement = null;
        if (this.config != null) {
            preferencesElement = this.config.getPreferences();
        }
        agent.initializeAgentPreferences();
        if (preferencesElement == null) {
            agent.setCleanTemporaryMode(false, false);
        } else {
            agent.setCleanTemporaryMode(preferencesElement.getAction().equals(Action.SET_LITERAL), !preferencesElement.isPersist());
        }
        if (preferencesElement != null) {
            List preferenceElements = preferencesElement.getPreference();
            for (IPreferenceElement preferenceElement : preferenceElements) {
                result.add(this.process(agent, preferenceElement));
            }
        }
        return result;
    }

    public IStatus initializeAgentRepositories(Agent agent) {
        IStatus repositoryStatus;
        IRepositoriesElement repositoriesElement;
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        IPreferencesElement preferencesElement = null;
        if (this.config != null) {
            preferencesElement = this.config.getPreferences();
        }
        if (preferencesElement != null && (repositoriesElement = preferencesElement.getRepositories()) != null) {
            List repositoryElements = repositoriesElement.getRepository();
            for (IRepositoryElement repositoryElement : repositoryElements) {
                result.add(this.process(agent, repositoryElement));
            }
        }
        if (this.input.needAccessRepositoris() && (repositoryStatus = agent.getRepositoryGroupStatus(false, (IProgressMonitor)new NullProgressMonitor())) != null && !repositoryStatus.isOK() && repositoryStatus.getSeverity() == 4) {
            result.add((IStatus)Statuses.WARNING.get(Messages.HeadlessApplication_Repositories_Not_Connected, new Object[]{repositoryStatus.getMessage()}));
            HeadlessUtils.addSpecificDisplayStatus(result, repositoryStatus);
        }
        return result;
    }

    public IStatus initiallizeAgent(Agent agent, boolean startAgent) {
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        agent.setSilentMode(true);
        if (this.config.isRebootLater()) {
            RebootRequest.setRebootLater();
        }
        result.add(this.initializeAgentPreferences(agent));
        if (StatusUtil.isErrorOrCancel((IStatus)result)) {
            return result;
        }
        if (startAgent) {
            result.add(agent.start());
            if (StatusUtil.isErrorOrCancel((IStatus)result)) {
                return result;
            }
        }
        result.add(this.initializeAgentRepositories(agent));
        if (StatusUtil.isErrorOrCancel((IStatus)result)) {
            return result;
        }
        result.add(StartupManager.getInstance().runStartups(HeadlessUtils.createProgressMonitor()));
        if (StatusUtil.isErrorOrCancel((IStatus)result)) {
            return result;
        }
        return result;
    }

    private IStatus process(Agent agent, IPreferenceElement preferenceElement) {
        IPreferenceCommand prefCmd = CommandFactory.createPreferenceCommand(preferenceElement.getName(), preferenceElement.getValue());
        prefCmd.setInput(this.input);
        return prefCmd.execute(agent, (IProgressMonitor)new NullProgressMonitor());
    }

    private IStatus process(Agent agent, IRepositoryElement repo) {
        IServerCommand srvCmd = CommandFactory.createServerCommand();
        srvCmd.addRepository(repo.getLocation(), repo.isPersist() ? IServerCommand.TemporaryLocation.NOT_TEMP : IServerCommand.TemporaryLocation.IS_TEMP);
        srvCmd.setInput(this.input);
        return srvCmd.execute(agent, (IProgressMonitor)new NullProgressMonitor());
    }

    private IStatus computeJobs(DiffPackageGroup diffPackageGroup, List jobs) {
        CicMultiStatus ret = Statuses.ST.createMultiStatus();
        ShadowProfile tempProfile = diffPackageGroup.createTempProfile();
        List diffPackages = diffPackageGroup.getDiffPackages();
        for (DiffPackage diffPackage : diffPackages) {
            ret.add(diffPackage.computeJobs(tempProfile, jobs));
            if (!StatusUtil.isErrorOrCancel((IStatus)ret)) continue;
            return ret;
        }
        return ret;
    }

    public IStatus computeJobs(List jobs) {
        CicMultiStatus ret = Statuses.ST.createMultiStatus();
        if (this.config == null) {
            return ret;
        }
        DiffRoot rootDiff = new DiffRoot();
        DiffHelper.diffReplace((IActionElement)this.config, (IElementProxy)new InstallRegistryProxy(InstallRegistry.getInstance()), (Diff)rootDiff);
        List diffs = rootDiff.getChildren();
        for (Diff diff : diffs) {
            if (!(diff instanceof DiffPackageGroup)) continue;
            ret.add(this.computeJobs((DiffPackageGroup)diff, jobs));
            if (!StatusUtil.isErrorOrCancel((IStatus)ret)) continue;
            return ret;
        }
        return ret;
    }
}

