/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.headless;

import com.ibm.cic.agent.core.AbstractJob;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.ErrorJob;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.cmd.CmdInputBuilder;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.headless.CommandFactory;
import com.ibm.cic.agent.core.internal.headless.IAbstractInstallCommand;
import com.ibm.cic.agent.core.internal.headless.ICommand;
import com.ibm.cic.agent.core.internal.headless.IInput;
import com.ibm.cic.agent.core.internal.headless.IInstallCommand;
import com.ibm.cic.agent.core.internal.headless.ILicenseCommand;
import com.ibm.cic.agent.core.internal.headless.IModifyCommand;
import com.ibm.cic.agent.core.internal.headless.IProfileCommand;
import com.ibm.cic.agent.core.internal.headless.IRollbackCommand;
import com.ibm.cic.agent.core.internal.headless.IUninstallCommand;
import com.ibm.cic.agent.core.internal.headless.IUpdateCommand;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.downloads.RememberDownloadUserPrompts;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserFeedback;
import com.ibm.cic.common.core.utils.UserFeedbackProvider;
import com.ibm.cic.common.downloads.DownloadUtil;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.licensing.common.util.PolicyManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class AgentInput {
    private static final AgentInput INSTANCE = new AgentInput();
    private static final Logger logger = Logger.getLogger(AgentInput.class);
    private IInput input = null;
    private CicMultiStatus wizardStatus = Statuses.ST.createMultiStatus();
    private final List<AgentJob> wizardJobs = new ArrayList<AgentJob>();
    private int mode = 0;
    private int wizardSubMode = 0;
    private boolean needConfigureLUMLicense = false;
    private boolean needConfigureFloatingLicense = false;
    private String quickStartMessage = null;
    private boolean profileInJobHasUserData = false;
    private final Set<String> profilesWithUserData = new HashSet<String>(1);

    public static AgentInput getInstance() {
        return INSTANCE;
    }

    private AgentInput() {
    }

    public IInput getInput() {
        return this.input;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getWizardSubMode() {
        return this.wizardSubMode;
    }

    public void setWizardSubMode(int subMode) {
        this.wizardSubMode = subMode;
    }

    public AbstractJob[] getWizardJobs() {
        return this.wizardJobs.toArray(new AbstractJob[this.wizardJobs.size()]);
    }

    public IStatus getWizardStatus() {
        return this.wizardStatus;
    }

    public boolean isNeedConfigureLUMLicense() {
        return this.needConfigureLUMLicense;
    }

    public boolean isNeedConfigureFloatingLicense() {
        return this.needConfigureFloatingLicense;
    }

    public String getQuickStartMessage() {
        return this.quickStartMessage;
    }

    public void loadInput(IProgressMonitor monitor) {
        this.input = null;
        this.wizardStatus = Statuses.ST.createMultiStatus();
        try {
            CicMultiStatus status = Statuses.ST.createMultiStatus();
            String inputPath = CmdLine.CL.getResponseFile();
            if (inputPath != null) {
                this.input = CommandFactory.createCommandScript();
                try {
                    URL url = new URL(inputPath);
                    try {
                        status = this.input.load(this.getInputStream(url, monitor));
                    }
                    catch (Exception e) {
                        status = Statuses.ERROR.get((Throwable)e, e.getMessage(), new Object[0]);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    status = this.input.load(new File(inputPath));
                }
            } else {
                String value = CmdLine.CL.getParam1StrVal("-liveInput");
                if (value != null) {
                    this.input = CommandFactory.createCommandScript();
                    status = this.input.load(Encodings.UTF8.toInputStream(value));
                }
            }
            this.addWizardInitialStatus((IStatus)status);
            if (StatusUtil.isError((IStatus)status)) {
                this.input = null;
            } else if (this.input == null) {
                this.input = CmdInputBuilder.getCommandList();
            } else {
                this.addWizardInitialStatus(this.input.substituteVariables(CmdInputBuilder.getCommandList()));
            }
        }
        catch (Exception e) {
            this.input = null;
            this.addWizardInitialStatus((IStatus)Statuses.ERROR.get((Throwable)e, e.getMessage(), new Object[0]));
        }
    }

    public void setWizardJobs(UserFeedbackProvider feedbackProvider) {
        this.wizardJobs.clear();
        this.needConfigureFloatingLicense = false;
        this.needConfigureLUMLicense = false;
        this.quickStartMessage = null;
        this.wizardSubMode = 0;
        if (this.input == null || this.mode != 1) {
            this.mode = 0;
            return;
        }
        if (this.input.isNewFormat()) {
            List agentJobs = this.input.getInputAsJobs();
            if (agentJobs.isEmpty()) {
                this.mode = 0;
            } else {
                this.wizardSubMode = 6;
                this.wizardJobs.addAll(agentJobs);
            }
            return;
        }
        Agent agent = Agent.getInstance();
        PolicyManager.reload((String)agent.getLicensePolicyFile().getAbsolutePath());
        AgentJob agentOfferingJob = null;
        int requireWizards = 0;
        boolean hasErrorJob = false;
        ICommand[] commands = this.input.getCommands(12);
        int numberOfInstallCommand = 0;
        ICommand[] iCommandArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            block56: {
                ICommand command;
                block55: {
                    AgentJob[] inputJobs;
                    IAbstractInstallCommand abstractInstallCommand;
                    block54: {
                        command = iCommandArray[n2];
                        if (!(command instanceof IAbstractInstallCommand)) break block55;
                        abstractInstallCommand = (IAbstractInstallCommand)command;
                        inputJobs = null;
                        UserFeedbackProvider oldProvider = null;
                        if (abstractInstallCommand instanceof IInstallCommand) {
                            ++numberOfInstallCommand;
                        }
                        try {
                            try {
                                oldProvider = UserFeedback.setProvider((UserFeedbackProvider)feedbackProvider);
                                inputJobs = abstractInstallCommand.getAsInputJobs(agent, true);
                            }
                            catch (Exception e) {
                                this.addWizardInitialStatus((IStatus)Statuses.ERROR.get((Throwable)e, e.getMessage(), new Object[0]));
                                UserFeedback.setProvider((UserFeedbackProvider)oldProvider);
                                break block54;
                            }
                        }
                        catch (Throwable throwable) {
                            UserFeedback.setProvider((UserFeedbackProvider)oldProvider);
                            throw throwable;
                        }
                        UserFeedback.setProvider((UserFeedbackProvider)oldProvider);
                    }
                    if (inputJobs == null) break block56;
                    AgentJob[] agentJobArray = inputJobs;
                    int n3 = inputJobs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        block58: {
                            AgentJob.AgentJobType jobType;
                            AgentJob inputJob;
                            block59: {
                                block63: {
                                    block60: {
                                        InstallJob installJob;
                                        block61: {
                                            IOffering offering;
                                            block62: {
                                                block57: {
                                                    inputJob = agentJobArray[n4];
                                                    if (!inputJob.isError()) break block57;
                                                    IStatus status = ((ErrorJob)inputJob).getErrorStatus();
                                                    this.addWizardInitialStatus(status);
                                                    hasErrorJob = true;
                                                    break block58;
                                                }
                                                jobType = inputJob.getType();
                                                if (!jobType.isInstall()) break block59;
                                                installJob = (InstallJob)inputJob;
                                                if (!CmdLine.CL.isLiveInput()) break block60;
                                                offering = installJob.getOffering();
                                                if (offering == null) break block61;
                                                if (!agent.isAgentOffering((IOfferingOrFix)offering)) break block62;
                                                this.wizardJobs.add(inputJob);
                                                agentOfferingJob = inputJob;
                                                requireWizards |= 1;
                                                break block58;
                                            }
                                            AgentUtil.ProfileOffering[] installedOfferings = AgentUtil.getInstalledOfferings(agent, offering.getIdentity());
                                            if (installedOfferings.length > 1) {
                                                requireWizards |= 0x80;
                                            } else if (installedOfferings.length == 1) {
                                                IOffering installedOffering = installedOfferings[0].getOffering();
                                                if (installedOffering.compareVersion((IContent)offering) == 0) {
                                                    installJob.setProfile(installedOfferings[0].getProfile());
                                                    installJob.setExistingOffering(installedOffering);
                                                    String licKinds = LicenseUtils.getRuntimeLicenseKinds((IOffering)installedOffering);
                                                    if ((licKinds == null || licKinds.indexOf(LicenseUtils.LICENSE_TYPE_PERM) < 0) && installJob.getPEKOffering() != null) {
                                                        this.needConfigureLUMLicense = true;
                                                        requireWizards |= 0x20;
                                                    }
                                                } else {
                                                    requireWizards |= 0x80;
                                                }
                                            } else {
                                                requireWizards = installJob.isSelected() ? (requireWizards |= 1) : (requireWizards |= 0x100);
                                            }
                                        }
                                        List pekInstallJobs = AgentUtil.getPekInstallJobs(installJob.getOffering());
                                        this.wizardJobs.addAll(pekInstallJobs);
                                        break block63;
                                    }
                                    requireWizards |= 1;
                                }
                                this.wizardJobs.add(inputJob);
                                break block58;
                            }
                            if (jobType.isModify() && abstractInstallCommand instanceof IModifyCommand) {
                                requireWizards |= 2;
                                this.wizardJobs.add(inputJob);
                            } else if (jobType.isUpdate() && abstractInstallCommand instanceof IUpdateCommand) {
                                requireWizards |= 8;
                                this.wizardJobs.add(inputJob);
                            } else if (jobType.isUninstall() && abstractInstallCommand instanceof IUninstallCommand) {
                                requireWizards |= 0x10;
                                this.wizardJobs.add(inputJob);
                            } else if (jobType.isRollback() && abstractInstallCommand instanceof IRollbackCommand) {
                                requireWizards |= 4;
                                this.wizardJobs.add(inputJob);
                            }
                        }
                        ++n4;
                    }
                    break block56;
                }
                if (command instanceof ILicenseCommand) {
                    this.needConfigureFloatingLicense = CmdLine.CL.isLiveInput();
                    requireWizards |= 0x40;
                }
            }
            ++n2;
        }
        if (CmdLine.CL.isLiveInput()) {
            if (requireWizards == 256) {
                requireWizards = 1;
            } else if ((requireWizards & 0x100) > 0) {
                requireWizards -= 256;
            }
            if (requireWizards != 1 && agentOfferingJob != null) {
                this.wizardJobs.clear();
                this.wizardJobs.add(agentOfferingJob);
                requireWizards = 1;
            } else if (numberOfInstallCommand > 1) {
                requireWizards = 128;
                this.quickStartMessage = Messages.AgentInput_PPA_0;
            } else if (requireWizards == 0) {
                this.quickStartMessage = Messages.AgentInput_PPA_2;
            } else if (requireWizards != 1 && requireWizards != 64 && requireWizards != 32) {
                this.quickStartMessage = Messages.AgentInput_PPA_1;
            }
        }
        if (hasErrorJob && this.wizardJobs.isEmpty()) {
            this.mode = 0;
        } else {
            if (this.wizardJobs.isEmpty() && this.isOlderImInstallKitInput(commands)) {
                requireWizards = 1;
            }
            switch (requireWizards) {
                case 1: {
                    this.wizardSubMode = 0;
                    break;
                }
                case 65: {
                    this.wizardSubMode = 0;
                    break;
                }
                case 16: {
                    this.wizardSubMode = 1;
                    break;
                }
                case 2: {
                    this.wizardSubMode = 2;
                    break;
                }
                case 8: {
                    this.wizardSubMode = 3;
                    break;
                }
                case 4: {
                    this.wizardSubMode = 4;
                    break;
                }
                case 32: {
                    if (CmdLine.CL.isLiveInput()) {
                        this.wizardSubMode = 5;
                        break;
                    }
                    this.wizardSubMode = 0;
                    break;
                }
                case 64: {
                    this.wizardSubMode = 5;
                    break;
                }
                case 96: {
                    if (CmdLine.CL.isLiveInput()) {
                        this.wizardSubMode = 5;
                        break;
                    }
                    this.wizardSubMode = 0;
                    break;
                }
                default: {
                    this.mode = 0;
                }
            }
        }
        this.checkUserDataInResponseFile();
    }

    private boolean isOlderImInstallKitInput(ICommand[] commands) {
        if (commands.length != 1) {
            return false;
        }
        ICommand command = commands[0];
        if (!(command instanceof IInstallCommand)) {
            return false;
        }
        IInstallCommand installCommand = (IInstallCommand)command;
        List offeringIds = installCommand.getOfferingIds();
        if (offeringIds.size() != 1) {
            return false;
        }
        return "com.ibm.cic.agent".equals(offeringIds.get(0));
    }

    private void addWizardInitialStatus(IStatus status) {
        if (this.wizardStatus.isOK() && status instanceof CicMultiStatus) {
            this.wizardStatus = (CicMultiStatus)status;
        } else {
            this.wizardStatus.add(status);
            String msg = this.wizardStatus.getMessage();
            if (msg == null || msg.equals("")) {
                this.wizardStatus.setMessage(status.getMessage());
            } else {
                this.wizardStatus.setMessage(String.valueOf(msg) + "\n" + status.getMessage());
            }
        }
    }

    public InputStream getInputStream(URL url, IProgressMonitor monitor) throws Exception {
        RememberDownloadUserPrompts rememberPrompts = new RememberDownloadUserPrompts();
        try {
            InputStream stream = DownloadUtil.getStreamForURL((URL)url, (IProgressMonitor)monitor);
            InputStream inputStream = this.logResponseAndCreateInputStream(stream);
            return inputStream;
        }
        finally {
            rememberPrompts.forget();
            monitor.done();
        }
    }

    private InputStream logResponseAndCreateInputStream(InputStream inputStream) throws IOException {
        String str = FileUtil.readStream((InputStream)inputStream);
        logger.info(str);
        return new BufferedInputStream(Encodings.UTF8.toInputStream(str));
    }

    private void checkUserDataInResponseFile() {
        IProfileCommand[] profileCommands;
        if (this.input == null || this.mode != 1) {
            return;
        }
        IProfileCommand[] iProfileCommandArray = profileCommands = this.input.getProfileCommands();
        int n = profileCommands.length;
        int n2 = 0;
        while (n2 < n) {
            IProfileCommand command = iProfileCommandArray[n2];
            if (command.hasUserDataSpecified()) {
                this.profilesWithUserData.add(command.getProfileId());
            }
            ++n2;
        }
    }

    public boolean showValidationResult() {
        return this.profileInJobHasUserData;
    }

    public void checkUserDataInProfile(List<Profile> profileInJob) {
        for (Profile profile : profileInJob) {
            if (!this.profilesWithUserData.contains(profile.getProfileId())) continue;
            this.profileInJobHasUserData = true;
            return;
        }
        this.profileInJobHasUserData = false;
    }
}

