/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.expander;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.internal.expander.ExpansionResult;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.ExtensionCategory;
import com.ibm.cic.common.core.model.FeatureKind;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.FilterCollectionUtil;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.Check;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.MapList;
import com.ibm.cic.common.core.utils.NoTaskNameProgressMonitor;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;

public class RecommendedProfiles {
    private static final Logger myLog = Logger.getLogger(RecommendedProfiles.class);
    private static final IStatus NO_INFO_STATUS = Statuses.ERROR.get(Messages.Agent_Compatibility_Information_Not_Available, new Object[0]);
    private static final FeatureKind[] FEATURE_ORDER = new FeatureKind[]{FeatureKind.OPTIONAL_NOT_SELECTED, FeatureKind.OPTIONAL_SELECTED, FeatureKind.REQUIRED_VISIBLE};
    private final Agent agent;
    private final IOffering[] offerings;
    private final AgentJob[] jobs;
    private final Map profileStatusMap;
    private final MapList profileLists = new MapList();
    private final FilterCollectionUtil.CollectionFilter OK_FILTER = new FilterCollectionUtil.CollectionFilter(){

        public boolean include(Object o) {
            IStatus status = (IStatus)RecommendedProfiles.this.profileStatusMap.get(o);
            return status == NO_INFO_STATUS;
        }
    };

    public RecommendedProfiles(Agent agent, IOffering[] offerings, Map profileStatusMap) {
        this.agent = agent;
        this.offerings = offerings;
        this.profileStatusMap = profileStatusMap == null ? new HashMap() : profileStatusMap;
        this.jobs = new AgentJob[this.offerings.length];
        int i = 0;
        while (i < this.offerings.length) {
            this.jobs[i] = new InstallJob(null, (IOfferingOrFix)this.offerings[i], new IFeature[0]);
            ++i;
        }
    }

    public Profile[] getRecommendedProfiles(IProgressMonitor monitor) throws CoreException {
        Profile[] profiles;
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, Messages.Agent_Finding_Compatible_Package_Groups).split(1, 5);
        Profile[] profileArray = profiles = this.agent.getNormalProfiles();
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            if (profile.shouldBeVisible()) {
                IStatus status = AgentUtil.validateCompatibleOfferings(profile, this.offerings);
                if (status.isOK()) {
                    status = AgentUtil.validateInstallDirectoryPermissions(profile.getInstallLocation());
                }
                if (!status.isOK()) {
                    myLog.debug("Not {0} due to {1}", new Object[]{profile.getProfileId(), status});
                } else {
                    status = NO_INFO_STATUS;
                }
                this.profileStatusMap.put(profile, status);
            }
            ++n2;
        }
        this.prepareAndResolveOfferings(pm.next());
        this.tryExpand(pm.next());
        return this.getProfiles();
    }

    private void prepareAndResolveOfferings(IProgressMonitor monitor) throws CoreException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 * this.offerings.length));
        IOffering[] iOfferingArray = this.offerings;
        int n = this.offerings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering offering = iOfferingArray[n2];
            IStatus status = this.agent.prepare((IOfferingOrFix)offering, ExtensionCategory.ALL, (IProgressMonitor)sm.newChild(1));
            if (status.isOK()) {
                status = RepositoryUtils.resolve((IOfferingOrFix)offering, (IProgressMonitor)new NoTaskNameProgressMonitor((IProgressMonitor)sm.newChild(1)));
            }
            if (!status.isOK()) {
                throw new CoreException(status);
            }
            ++n2;
        }
    }

    private void tryExpand(IProgressMonitor monitor) throws CoreException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)this.profileStatusMap.size());
        Iterator i = this.getOkProfilesIterator();
        while (i.hasNext()) {
            Profile profile = (Profile)i.next();
            AgentJob[] agentJobArray = this.jobs;
            int n = this.jobs.length;
            int n2 = 0;
            while (n2 < n) {
                AgentJob job = agentJobArray[n2];
                job.setProfile(profile);
                ++n2;
            }
            IStatus status = AgentUtil.validateCompatibleJobs(this.jobs);
            if (status.isOK()) {
                status = this.tryExpand(profile, (IProgressMonitor)sm.newChild(1));
            }
            if (!status.isOK()) {
                myLog.debug("Not {0} due to {1}", new Object[]{profile.getProfileId(), status});
            }
            if (sm.isCanceled() || status.matches(8)) {
                throw new CoreException((IStatus)ICicStatus.CANCEL_STATUS);
            }
            this.profileStatusMap.put(profile, status);
        }
    }

    private IStatus tryExpand(Profile profile, IProgressMonitor monitor) {
        IStatus status = null;
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)FEATURE_ORDER.length);
        FeatureKind[] featureKindArray = FEATURE_ORDER;
        int n = FEATURE_ORDER.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureKind kind = featureKindArray[n2];
            status = this.tryExpand(profile, kind, (IProgressMonitor)sm.newChild(1));
            if (status.isOK()) {
                this.profileLists.add((Object)kind, (Object)profile);
                myLog.debug("Profile {0} OK for {1}", new Object[]{profile.getProfileId(), kind});
                break;
            }
            if (status.matches(8)) {
                return status;
            }
            ++n2;
        }
        return status;
    }

    private IStatus tryExpand(Profile profile, FeatureKind kind, IProgressMonitor monitor) {
        AgentJob[] agentJobArray = this.jobs;
        int n = this.jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            job.setFeatures(RecommendedProfiles.getFeatures(job.getOffering(), kind));
            ++n2;
        }
        return ExpansionResult.expand(this.jobs, monitor).getStatus();
    }

    private static List getFeatures(IOffering offering, FeatureKind kind) {
        IFeature[] features = kind == FeatureKind.REQUIRED_VISIBLE ? OfferingUtil.getRequiredFeatures((IOffering)offering) : (kind == FeatureKind.OPTIONAL_SELECTED ? OfferingUtil.getDefaultFeatures((IOffering)offering) : (kind == FeatureKind.OPTIONAL_NOT_SELECTED ? OfferingUtil.getAllFeatures((IOffering)offering) : null));
        return new ArrayList<IFeature>(Arrays.asList((IFeature[])Check.notNull((Object)features)));
    }

    private Profile[] getProfiles() {
        ArrayList profiles = new ArrayList(this.profileStatusMap.size());
        FeatureKind[] featureKindArray = FEATURE_ORDER;
        int n = FEATURE_ORDER.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureKind element = featureKindArray[n2];
            profiles.addAll(this.profileLists.get((Object)element));
            ++n2;
        }
        return profiles.toArray(new Profile[profiles.size()]);
    }

    private Iterator getOkProfilesIterator() {
        return new FilterCollectionUtil.FilterIterator(this.profileStatusMap.keySet().iterator(), this.OK_FILTER);
    }
}

