/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.expander;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.internal.expander.ExpansionResult;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class FeatureDependencyChecker {
    private static final Logger log = Logger.getLogger();
    private final Collection<AgentJob[]> profileJobsList;

    public FeatureDependencyChecker(Collection<AgentJob> jobs) {
        this.profileJobsList = AgentUtil.groupByProfile(AgentJob.toArray(jobs), false);
    }

    public IStatus perform(IProgressMonitor monitor) {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, this.profileJobsList.size());
        for (AgentJob[] profileJobs : this.profileJobsList) {
            IStatus status = this.doPerform(profileJobs[0].getProfile(), profileJobs, pm.next());
            if (!status.isOK()) {
                return status;
            }
            if (!pm.isCanceled()) continue;
            return ICicStatus.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private IStatus doPerform(Profile profile, AgentJob[] jobs, IProgressMonitor monitor) {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, jobs.length + 2);
        if (!ExpansionResult.expand(jobs, pm.next()).hasToleranceError()) {
            return Status.OK_STATUS;
        }
        ArrayList<AgentJob> extensions = new ArrayList<AgentJob>();
        ArrayList<AgentJob> others = new ArrayList<AgentJob>();
        Object object = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = object[n2];
            IOffering offering = job.getOffering();
            if (offering != null) {
                IStatus status = RepositoryUtils.resolve((IOfferingOrFix)offering, (IProgressMonitor)pm.next());
                if (!status.isOK()) {
                    return status;
                }
                if (Agent.isExtensionOffering((IOfferingOrFix)offering)) {
                    extensions.add(job);
                } else {
                    others.add(job);
                }
            }
            ++n2;
        }
        if (extensions.isEmpty()) {
            return Status.OK_STATUS;
        }
        AgentJob[] tryJobs = new AgentJob[others.size() + 1];
        others.toArray(tryJobs);
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        pm.splitNext(extensions.size());
        object = extensions.iterator();
        while (object.hasNext()) {
            AgentJob job;
            tryJobs[tryJobs.length - 1] = job = (AgentJob)object.next();
            ExpansionResult expansionResult = ExpansionResult.expand(tryJobs, pm.next());
            if (!expansionResult.hasToleranceError()) continue;
            IStatus error = FeatureDependencyChecker.makeUnresolvedRequirementsError(job.getOffering(), job.getProfile(), expansionResult.getStatus());
            log.info(Messages.Agent_Compatibility_Error, new Object[]{OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)job.getOffering()), Util.toFeatureIdString((IFeature[])job.getFeaturesArray()), error});
            status.add(error);
        }
        return status;
    }

    static IStatus makeUnresolvedRequirementsError(IOffering offering, Profile profile, IStatus status) {
        CicMultiStatus error = Statuses.ERROR.getMultiStatus(Messages.AgentUtil_Installation_Package_Requires_External_Components, new Object[]{offering.getName(), AgentUtil.getOfferingHintMessage(offering)});
        error.setCode(FeatureDependencyChecker.isOfferingHintContainPackageOnly(offering) ? 402 : 401);
        error.add((IStatus)Statuses.WARNING.getMultiStatus(status.getChildren(), Messages.AgentUtil_External_Components_List, new Object[]{profile.getProfileId()}));
        error.add((IStatus)Statuses.WARNING.getMultiStatus(status.getChildren(), Messages.AgentUtil_External_Components_List, new Object[]{profile.getProfileId()}));
        return error;
    }

    private static boolean isOfferingHintContainPackageOnly(IOffering offering) {
        String hintProperty = offering.getProperties().getProperty("offering.dependencies.hint", "").trim();
        if (hintProperty.length() == 0) {
            return false;
        }
        String[] stringArray = hintProperty.split("\\s*;\\s*");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String hint = stringArray[n2];
            String[] info = hint.trim().split("\\s*,\\s*");
            if (info.length > 2) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

