/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.expander;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.internal.expander.ExpansionResult;
import com.ibm.cic.agent.core.internal.expander.FeatureDependencyChecker;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

class CompatibilityCheck {
    private static final Logger log = Logger.getLogger(CompatibilityCheck.class);
    private final Profile profile;
    private final IStatus status;

    public CompatibilityCheck(Profile profile, IStatus status) {
        this.profile = profile;
        this.status = status;
    }

    public String toString() {
        return "CompatibilityCheck: " + LogUtil.toString((IStatus)this.status);
    }

    public IStatus perform(AgentJob[] jobs, int packageCount) {
        assert (!this.status.isOK());
        assert (jobs.length > 0);
        IStatus newStatus = this.doPerform(jobs);
        if (newStatus == null) {
            newStatus = this.status;
            if (newStatus instanceof CicMultiStatus && (newStatus.getMessage().isEmpty() || newStatus.getCode() == 200)) {
                CicMultiStatus ms = (CicMultiStatus)newStatus;
                ms.setMessage(packageCount == 1 ? Messages.AgentSelectorExpander_Invalid_Package : Messages.AgentSelectorExpander_Incompatible_Packages);
                ms.setCode(0);
            }
        } else if (newStatus instanceof Status) {
            CicMultiStatus ms = Statuses.ST.createMultiStatusFromStatus(newStatus);
            ms.addAll(this.status);
            newStatus = ms;
        } else {
            log.status(this.status);
        }
        return newStatus;
    }

    private IStatus doPerform(AgentJob[] jobsArray) {
        AgentJob job;
        ArrayList<AgentJob> jobs = new ArrayList<AgentJob>(jobsArray.length);
        AgentJob[] agentJobArray = jobsArray;
        int n = jobsArray.length;
        int n2 = 0;
        while (n2 < n) {
            job = agentJobArray[n2];
            IOffering offering = job.getOffering();
            if (offering != null) {
                jobs.add(job);
            }
            ++n2;
        }
        if (jobs.isEmpty()) {
            return null;
        }
        if (jobs.size() == 1 && CompatibilityCheck.isExtension(job = (AgentJob)jobs.get(0)) && !job.getType().isUninstall()) {
            return FeatureDependencyChecker.makeUnresolvedRequirementsError(job.getOffering(), this.profile, this.status);
        }
        if (!this.isCompatible(null, jobs)) {
            JobPair try1 = null;
            try1 = jobs.size() == 2 ? new JobPair((AgentJob)jobs.get(0), (AgentJob)jobs.get(1)) : this.findIncompatibleJobs(jobs, jobs, null);
            if (try1 != null) {
                return this.getError(try1);
            }
        }
        ArrayList<AgentJob> full = new ArrayList<AgentJob>();
        ArrayList<AgentJob> extn = new ArrayList<AgentJob>();
        CompatibilityCheck.getInstalledOfferingJobs(this.profile, full, extn);
        if (extn.isEmpty() && (full.isEmpty() || CompatibilityCheck.isUpdateOfOnlyOffering(jobs, full))) {
            return null;
        }
        JobPair try2 = this.findIncompatibleJobs(jobs, extn, full);
        if (try2 != null) {
            try2 = CompatibilityCheck.fixUninstallError(try2, extn);
            return this.getError(try2);
        }
        JobPair try3 = this.findIncompatibleJobs(jobs, full, null);
        if (try3 != null) {
            return this.getError(try3);
        }
        if (jobs.size() == 1) {
            return this.getError(new JobPair((AgentJob)jobs.get(0), null));
        }
        return null;
    }

    private static boolean isUpdateOfOnlyOffering(List<AgentJob> jobs, List<AgentJob> installedJobs) {
        if (jobs.size() != 1 || installedJobs.size() != 1) {
            return false;
        }
        AgentJob job = jobs.get(0);
        AgentJob installedJob = installedJobs.get(0);
        return job.getType().isUpdate() && CompatibilityCheck.sameOffering(job, installedJob);
    }

    private JobPair findIncompatibleJobs(List<AgentJob> toTry, List<AgentJob> with, List<AgentJob> others) {
        if (toTry.isEmpty() || with.isEmpty()) {
            return null;
        }
        if (others == null) {
            others = Collections.emptyList();
        }
        ArrayList<AgentJob> allJobs = new ArrayList<AgentJob>(toTry.size() + with.size() + others.size());
        allJobs.addAll(toTry);
        Util.addUnique(allJobs, with);
        Util.addUnique(allJobs, others);
        for (AgentJob job1 : toTry) {
            if (!this.isCompatible(job1, allJobs)) continue;
            for (AgentJob job2 : with) {
                if (CompatibilityCheck.sameOffering(job1, job2) || !this.isCompatible(job2, allJobs)) continue;
                return new JobPair(job1, job2);
            }
            if (!job1.isUninstall()) continue;
            return new JobPair(job1, null);
        }
        return null;
    }

    private boolean isCompatible(AgentJob omit, List<AgentJob> jobs) {
        ArrayList<AgentJob> toTry = new ArrayList<AgentJob>(jobs.size());
        HashSet<IIdentity> omitSet = new HashSet<IIdentity>();
        for (AgentJob job : jobs) {
            if (job == omit || !omitSet.add(job.getOffering().getIdentity())) continue;
            toTry.add(job);
        }
        if (toTry.isEmpty()) {
            return true;
        }
        ExpansionResult expansionResult = ExpansionResult.expandWithoutInstalled(AgentJob.toArray(toTry), null);
        if (expansionResult.isOK()) {
            log.debug("Compatible: {0}", new Object[]{expansionResult});
            return true;
        }
        log.debug("Not Compatible: {0}", new Object[]{expansionResult});
        return false;
    }

    private static boolean sameOffering(AgentJob job1, AgentJob job2) {
        return job1.getOffering().getIdentity().equals(job2.getOffering().getIdentity());
    }

    private static void getInstalledOfferingJobs(Profile profile, List<AgentJob> full, List<AgentJob> extn) {
        IOffering[] installedOfferings;
        InstallRegistry.ProfileInstallRegistry registry = profile.getInstallRegistry();
        IOffering[] iOfferingArray = installedOfferings = registry.getInstalledOfferings();
        int n = installedOfferings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering offering = iOfferingArray[n2];
            InstallJob job = new InstallJob(profile, (IOfferingOrFix)offering, registry.getInstalledFeaturesAsArray(offering));
            if (CompatibilityCheck.isExtension(job)) {
                extn.add(job);
            } else {
                full.add(job);
            }
            ++n2;
        }
    }

    private IStatus getError(JobPair pair) {
        AgentJob job = pair.job1;
        AgentJob other = pair.job2;
        AgentJob.AgentJobType subType = job.getSubType();
        String name = job.getOffering().getName();
        String version = OfferingUtil.getDisplayableVersion((IOfferingOrFix)job.getOffering());
        String key = null;
        Object[] args = null;
        int code = this.status.getCode();
        if (other == null) {
            key = subType.isInstall() ? Messages.AgentSelectorExpander_Install_Not_Compatible_Others : (subType.isUpdate() ? Messages.AgentSelectorExpander_Update_Not_Compatible_Others : (subType.isRollback() ? Messages.AgentSelectorExpander_Rollback_Not_Compatible_Others : (subType.isUninstall() ? Messages.AgentSelectorExpander_Cannot_Uninstall_Due_To_Extension2 : (subType.isModify() ? Messages.AgentSelectorExpander_Modify_Not_Compatible_Others : null))));
            args = new String[]{name, version};
        } else {
            String otherName = other.getOffering().getName();
            String otherVersion = OfferingUtil.getDisplayableVersion((IOfferingOrFix)other.getOffering());
            if (!subType.isUninstall()) {
                key = subType.isInstall() ? (CompatibilityCheck.isExtension(job) || CompatibilityCheck.isExtension(other) ? Messages.AgentSelectorExpander_Install_Not_Compatible_Extension : Messages.AgentSelectorExpander_Install_Not_Compatible) : (subType.isUpdate() ? Messages.AgentSelectorExpander_Update_Not_Compatible : (subType.isRollback() ? Messages.AgentSelectorExpander_Rollback_Not_Compatible : null));
                args = new String[]{name, version, otherName, otherVersion};
            } else if (CompatibilityCheck.isExtension(other)) {
                key = Messages.AgentSelectorExpander_Cannot_Uninstall_Due_To_Extension;
                args = new String[]{name, otherName};
                code = 301;
            }
        }
        if (key == null) {
            log.warning("Internal error: unexpected job sub-type: {0}", new Object[]{subType});
            return null;
        }
        return Statuses.ERROR.get(code, key, args);
    }

    private static boolean isExtension(AgentJob job) {
        return Agent.isExtensionOffering((IOfferingOrFix)job.getOffering());
    }

    private static JobPair fixUninstallError(JobPair pair, List<AgentJob> extn) {
        if (pair.job1.getType().isUninstall() && pair.job2 == null) {
            for (AgentJob job : extn) {
                if (job.isUninstall()) continue;
                return new JobPair(pair.job1, job);
            }
        }
        return pair;
    }

    private static class JobPair {
        public final AgentJob job1;
        public final AgentJob job2;

        public JobPair(AgentJob job1, AgentJob job2) {
            this.job1 = job1;
            this.job2 = job2;
        }

        public String toString() {
            return String.valueOf(this.job1.toString()) + ' ' + this.job2;
        }
    }
}

