/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.internal.commands.AbstractCommand;
import com.ibm.cic.agent.core.internal.commands.XMLElement;
import com.ibm.cic.agent.core.internal.headless.IVariablesCommand;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class VariablesCommand
extends AbstractCommand
implements IVariablesCommand {
    private final Map<String, Variable> variables = new LinkedHashMap<String, Variable>();

    public VariablesCommand() {
        super("variables");
    }

    @Override
    public Variable addVariable(String name, String value) {
        Variable varIf = new Variable(name, value);
        Variable prev = this.variables.put(name, varIf);
        assert (prev == null) : name;
        this.addChild(varIf);
        return varIf;
    }

    @Override
    public IStatus execute(Agent agent, IProgressMonitor monitor) {
        return this.registerVariables();
    }

    private IStatus registerVariables() {
        if (this.getInput() != null) {
            for (XMLElement child : this.children()) {
                if (!child.getName().equals("variable")) continue;
                String name = child.getAttribute("name");
                IStatus status = this.validateName(name);
                if (!status.isOK()) {
                    return status;
                }
                String value = this.handleIf(child);
                if (value == null) {
                    value = child.getAttribute("value");
                }
                this.getInput().addVariable(name, value);
            }
        }
        return Status.OK_STATUS;
    }

    private String handleIf(XMLElement child) {
        for (XMLElement ifChild : child.children()) {
            String varValue;
            String ifName = ifChild.getAttribute("name");
            String ifEquals = ifChild.getAttribute("equals");
            if (!ifEquals.equals(varValue = this.getInput().getVariableValue(ifName))) continue;
            String ifValue = this.handleIf(ifChild);
            if (ifValue == null) {
                return ifChild.getAttribute("value");
            }
            return ifValue;
        }
        return null;
    }

    private IStatus validateName(String name) {
        IStatus retStatus = Status.OK_STATUS;
        if (!name.matches("[a-zA-Z_][0-9a-zA-Z_.]*")) {
            retStatus = Statuses.ERROR.get(Messages.VariablesCommand_InvalidVariableName, new Object[]{name});
        }
        return retStatus;
    }

    @Override
    public int getExecutionPoint() {
        return 16;
    }

    private static class Variable
    extends VariableIfContainer
    implements IVariablesCommand.IVariable {
        Variable(String name, String value) {
            super("variable");
            this.addAttribute("name", name);
            if (value != null) {
                this.addAttribute("value", value);
            }
        }
    }

    private static class VariableIf
    extends VariableIfContainer
    implements IVariablesCommand.IVariableIf {
        VariableIf(String name, String equals, String value) {
            super("if");
            this.addAttribute("name", name);
            this.addAttribute("equals", equals);
            if (value != null) {
                this.addAttribute("value", value);
            }
        }
    }

    private static class VariableIfContainer
    extends XMLElement {
        VariableIfContainer(String elemName) {
            super(elemName);
        }

        public VariableIf addIf(String name, String equals, String value) {
            VariableIf varIf = new VariableIf(name, equals, value);
            this.addChild(varIf);
            return varIf;
        }
    }
}

