/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class InputVariableSubstitution
extends AbstractVariableSubstitution {
    public static final String OS = "os";
    public static final String ARCH = "arch";
    public static final String NL = "nl";
    public static final String NAME = "name";
    public static final String INSTALL_ROOT = "installRoot";
    public static final String HOME = "home";
    public static final String PLATFORM_VAR = "platform";
    public static final String SPECIAL_FOLDER_VAR = "specialFolder";
    private final Map<String, String> cmdLineVar = new LinkedHashMap<String, String>();
    private final Map<String, String> inputFileVar = new LinkedHashMap<String, String>();

    void addCmdLineVar(String name, String value) {
        this.cmdLineVar.put(name, value);
    }

    void addInputFileVar(String name, String value) {
        this.inputFileVar.put(name, value);
    }

    @Override
    public String performVariableSubstitutions(String value) throws AbstractVariableSubstitution.VariableSubstitutionException {
        if (value == null) {
            return null;
        }
        String newValue;
        while (!(newValue = super.performVariableSubstitutions(value, AbstractVariableSubstitution.AllowAbsolutePath.TRUE)).equals(value)) {
            value = newValue;
        }
        return value;
    }

    @Override
    protected String substitute(String variableName, String variableArg, AbstractVariableSubstitution.AllowAbsolutePath allowAbsolutePath) throws AbstractVariableSubstitution.VariableSubstitutionException {
        String varValue = this.getValue(variableName, variableArg);
        if (varValue == null) {
            throw new AbstractVariableSubstitution.VariableSubstitutionException((IStatus)Statuses.ERROR.get(Messages.InputVariableSubstitution_VarNotSet, new Object[]{InputVariableSubstitution.getVarFromNameAndArg(variableName, variableArg)}));
        }
        return varValue;
    }

    @Override
    protected boolean isPathVariable(String variableName, String variableArg) {
        return variableName.equals(PLATFORM_VAR) && variableArg.equals(INSTALL_ROOT) || super.isPathVariable(variableName, variableArg);
    }

    private String getBuiltInVariable(String variableName, String variableArg) {
        String retVal = null;
        if (variableName.equals("hostName") || variableName.equals("environment") || variableName.equals("system")) {
            retVal = super.substituteNoVP(variableName, variableArg);
        } else if (variableName.equals("user")) {
            if (variableArg.equals(NAME)) {
                retVal = super.substituteNoVP("user", variableArg);
            } else if (variableArg.equals(HOME)) {
                retVal = super.substituteNoVP("homeLocation", variableArg);
            }
        } else if (variableName.equals(PLATFORM_VAR)) {
            if (variableArg.equals(OS)) {
                retVal = Platform.getOS();
            } else if (variableArg.equals(ARCH)) {
                retVal = BitModeUtils.getPlatformArch();
            } else if (variableArg.equals(NL)) {
                retVal = Platform.getNL();
            } else if (variableArg.equals(INSTALL_ROOT)) {
                retVal = super.substituteNoVP("defaultInstallRootLocation", null);
            }
        } else if (variableName.equals(SPECIAL_FOLDER_VAR) && variableArg.equals("PROGRAM_FILES")) {
            retVal = PlatformUtils.getSpecialFolder((String)"PROGRAM_FILES");
        }
        return retVal;
    }

    public IStatus validate() {
        for (Map.Entry<String, String> entry : this.cmdLineVar.entrySet()) {
            String cmdLineEntry = entry.getKey();
            if (this.inputFileVar.containsKey(cmdLineEntry)) continue;
            return Statuses.ERROR.get(Messages.InputVariableSubstitution_CmdLineVarNotDeclared, new Object[]{cmdLineEntry});
        }
        return Status.OK_STATUS;
    }

    String getValue(String var) {
        return this.getValue(InputVariableSubstitution.getVarNameFromVar(var), InputVariableSubstitution.getVarArgFromVar(var));
    }

    private String getValue(String variableName, String variableArg) {
        String retVal = null;
        if (variableArg != null) {
            retVal = this.getBuiltInVariable(variableName, variableArg);
        } else if (this.cmdLineVar.containsKey(variableName)) {
            retVal = this.cmdLineVar.get(variableName);
        } else if (this.inputFileVar.containsKey(variableName)) {
            retVal = this.inputFileVar.get(variableName);
        }
        return retVal;
    }

    Collection<String> getVariableNames() {
        return this.inputFileVar.keySet();
    }
}

