/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.cmd;

import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.commands.AbstractCommand;
import com.ibm.cic.agent.core.internal.commands.IListAvailableCommand;
import com.ibm.cic.agent.core.internal.commands.IListAvailableFixesCommand;
import com.ibm.cic.agent.core.internal.commands.IListAvailablePackagesCommand;
import com.ibm.cic.agent.core.internal.commands.IListInstallationDirectoriesCommand;
import com.ibm.cic.agent.core.internal.commands.IListInstalledFeaturesCommand;
import com.ibm.cic.agent.core.internal.commands.IListInstalledPackagesCommand;
import com.ibm.cic.agent.core.internal.commands.IViewLogCommand;
import com.ibm.cic.agent.core.internal.headless.CommandFactory;
import com.ibm.cic.agent.core.internal.headless.IGenerateResponseFileCommand;
import com.ibm.cic.agent.core.internal.headless.IImportCommand;
import com.ibm.cic.agent.core.internal.headless.IInput;
import com.ibm.cic.agent.core.internal.headless.IInstallAllCommand;
import com.ibm.cic.agent.core.internal.headless.IInstallCommand;
import com.ibm.cic.agent.core.internal.headless.IPreferenceCommand;
import com.ibm.cic.agent.core.internal.headless.IRollbackCommand;
import com.ibm.cic.agent.core.internal.headless.IServerCommand;
import com.ibm.cic.agent.core.internal.headless.IUninstallCommand;
import com.ibm.cic.agent.core.internal.headless.IUpdateAllCommand;
import com.ibm.cic.agent.core.internal.headless.IVariablesCommand;
import com.ibm.cic.agent.core.internal.headless.IViewLicenseCommand;
import com.ibm.cic.agent.core.internal.headless.InstallFixesAction;
import com.ibm.cic.common.core.cmd.CmdCommand;
import com.ibm.cic.common.core.cmd.CmdParamPackage;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Version;

public class CmdInputBuilder {
    private static IInput m_commandList = null;

    public static IInput getCommandList() {
        return m_commandList;
    }

    private static boolean handlesRepositoryCommand() {
        return CmdLine.CL.containsCommand("listAvailablePackages") || CmdLine.CL.containsCommand("listAvailable") || CmdLine.CL.containsCommand("listAvailableFixes");
    }

    public static void generateInputCommandList() {
        IInput cmdList = CmdInputBuilder.prepareCommandScript();
        CmdInputBuilder.processPortableCommand(cmdList);
        CmdInputBuilder.processInstallCommand(cmdList);
        CmdInputBuilder.processUninstallCommand(cmdList);
        CmdInputBuilder.processUninstallAllCommand(cmdList);
        CmdInputBuilder.processInstallAllCommand(cmdList);
        CmdInputBuilder.processUpdateAllCommand(cmdList);
        CmdInputBuilder.processModifyCommand(cmdList);
        CmdInputBuilder.processRollbackCommand(cmdList);
        CmdInputBuilder.processImportCommand(cmdList);
        CmdInputBuilder.processListAvailablePackagesCommand(cmdList);
        CmdInputBuilder.processListAvailableCommand(cmdList);
        CmdInputBuilder.processListInstalledPackagesCommand(cmdList);
        CmdInputBuilder.processListAvailableFixesCommand(cmdList);
        CmdInputBuilder.processListInstalledFeaturesCommand(cmdList);
        CmdInputBuilder.processListInstallationDirectoriesCommand(cmdList);
        CmdInputBuilder.processGenerateResponseFileCommand(cmdList);
        if (!CmdInputBuilder.handlesRepositoryCommand()) {
            CmdInputBuilder.processRepositoryCommand(cmdList);
        }
        CmdInputBuilder.processPreferenceCommand(cmdList);
        CmdInputBuilder.processSharedResourcesDirectory(cmdList);
        CmdInputBuilder.processViewLogCommand(cmdList);
        CmdInputBuilder.processViewLicenseCommand(cmdList);
        CmdInputBuilder.processVariableCommand(cmdList);
        m_commandList = cmdList.isEmpty() ? null : cmdList;
    }

    private static IInput prepareCommandScript() {
        IInput cmdList = CommandFactory.createCommandScript();
        cmdList.setCleanMode(true);
        cmdList.setTemporaryMode(true);
        cmdList.setAcceptLicense(CmdLine.CL.containsCommand("-acceptLicense"));
        return cmdList;
    }

    private static void processRepositoryCommand(IInput cmdList) {
        List repos = CmdLine.CL.getRepositories();
        if (!repos.isEmpty()) {
            IServerCommand serverCommand = CommandFactory.createServerCommand();
            for (String repo : repos) {
                serverCommand.addRepository(repo);
            }
            cmdList.addCommand(serverCommand);
        }
    }

    private static void processPreferenceCommand(IInput cmdList) {
        for (Map.Entry entry : CmdLine.CL.getPreferences().entrySet()) {
            CmdInputBuilder.addPreferenceCommand(cmdList, (String)entry.getKey(), (String)entry.getValue());
        }
        if (CmdLine.CL.containsCommand("-connectPassportAdvantage")) {
            CmdInputBuilder.addPreferenceCommand(cmdList, ICicPreferenceConstants.PASSPORT_ADVANTAGE_ENABLED.key(), Boolean.toString(true));
        }
    }

    private static void processVariableCommand(IInput cmdList) {
        Map<String, String> variables = CmdLine.CL.getVariables();
        if (!variables.isEmpty()) {
            IVariablesCommand varCmd = CommandFactory.createVariablesCommand();
            for (Map.Entry<String, String> entry : variables.entrySet()) {
                varCmd.addVariable(entry.getKey(), entry.getValue());
            }
            varCmd.setInput(cmdList);
            cmdList.addCommand(varCmd);
        }
    }

    private static void addPreferenceCommand(IInput cmdList, String key, String val) {
        IPreferenceCommand prefCmd = CommandFactory.createPreferenceCommand(key, val);
        cmdList.addCommand(prefCmd);
    }

    private static void processSharedResourcesDirectory(IInput cmdList) {
        String val = CmdLine.CL.getSharedResourcesDirectory();
        if (val != null) {
            CmdInputBuilder.addPreferenceCommand(cmdList, "com.ibm.cic.common.core.preferences.eclipseCache", val);
        }
    }

    private static void processEclipseLocation(AbstractCommand cmd) {
        String val = CmdLine.CL.getParam1StrVal("-eclipseLocation");
        if (val != null) {
            cmd.addData("eclipseLocation", val);
        }
    }

    private static void processPortableCommand(IInput cmdList) {
        CicCommonSettings.setPortable((boolean)CmdLine.CL.containsCommand("-portable"));
    }

    private static void processUninstallCommand(IInput cmdList) {
        if (CmdLine.CL.containsCommand("uninstall")) {
            IUninstallCommand cmd = CommandFactory.createUnInstallCommand();
            for (CmdParamPackage.IdVersionFeatures p : CmdLine.CL.getPackages("uninstall")) {
                cmd.addOffering(p.id, p.version, null, p.features, CmdLine.CL.getInstallationDirectory());
            }
            CmdInputBuilder.addProperties((AbstractCommand)((Object)cmd));
            cmd.setInput(cmdList);
            cmdList.addCommand(cmd);
        }
    }

    private static void processUninstallAllCommand(IInput cmdList) {
        if (CmdLine.CL.containsCommand("uninstallAll")) {
            IUninstallCommand cmd = CommandFactory.createUnInstallCommand();
            cmd.addOffering(null, null, null, null, CmdLine.CL.getInstallationDirectory());
            CmdInputBuilder.addProperties((AbstractCommand)((Object)cmd));
            cmd.setInput(cmdList);
            cmdList.addCommand(cmd);
        }
    }

    private static void processInstallAllCommand(IInput cmdList) {
        if (CmdLine.CL.containsCommand("installAll")) {
            IInstallAllCommand cmd = CommandFactory.createInstallAllCommand();
            if (!CmdLine.CL.containsCommand("-repositories")) {
                cmdList.setCleanMode(false);
            }
            cmd.setAcceptLicense(cmdList.isAcceptLicense());
            InstallFixesAction ifAction = null;
            String installFixesStr = CmdLine.CL.getParam1StrVal("-installFixes");
            if (installFixesStr != null) {
                ifAction = InstallFixesAction.getInstallFixesAction(installFixesStr);
            }
            cmd.addInstallFixesAttribute(ifAction);
            CmdInputBuilder.addProperties((AbstractCommand)((Object)cmd));
            cmd.setInput(cmdList);
            cmdList.addCommand(cmd);
        }
    }

    private static void processUpdateAllCommand(IInput cmdList) {
        if (CmdLine.CL.containsCommand("updateAll")) {
            IUpdateAllCommand cmd = CommandFactory.createUpdateAllCommand();
            if (!CmdLine.CL.containsCommand("-repositories")) {
                cmdList.setCleanMode(false);
            }
            InstallFixesAction ifAction = null;
            String installFixesStr = CmdLine.CL.getParam1StrVal("-installFixes");
            if (installFixesStr != null) {
                ifAction = InstallFixesAction.getInstallFixesAction(installFixesStr);
            }
            cmd.addInstallFixesAttribute(ifAction);
            cmd.addInstallLocation(CmdLine.CL.getInstallationDirectory());
            cmd.setAcceptLicense(cmdList.isAcceptLicense());
            CmdInputBuilder.addProperties((AbstractCommand)((Object)cmd));
            cmd.setInput(cmdList);
            cmdList.addCommand(cmd);
        }
    }

    private static void processInstallCommand(IInput cmdList) {
        if (CmdLine.CL.containsCommand("install")) {
            IInstallCommand cmd = CommandFactory.createInstallCommand();
            for (CmdParamPackage.IdVersionFeatures p : CmdLine.CL.getPackages("install")) {
                String version = p.version;
                if ("imcl".equals(CmdLine.CL.getParam1StrVal("-toolId")) && "com.ibm.cic.agent".equals(p.id)) {
                    CmdInputBuilder.addPreferenceCommand(cmdList, ICicPreferenceConstants.SEARCH_FOR_UPDATES.key(), Boolean.toString(true));
                    version = Version.emptyVersion.toString();
                }
                InstallFixesAction ifAction = null;
                String installFixesStr = CmdLine.CL.getParam1StrVal("-installFixes");
                if (installFixesStr != null) {
                    ifAction = InstallFixesAction.getInstallFixesAction(installFixesStr);
                }
                cmd.addOffering(p.id, version, null, p.features, CmdLine.CL.getInstallationDirectory(), ifAction);
            }
            cmd.setAcceptLicense(cmdList.isAcceptLicense());
            CmdInputBuilder.processEclipseLocation((AbstractCommand)((Object)cmd));
            cmdList.addCommand(cmd);
            CmdInputBuilder.addProperties((AbstractCommand)((Object)cmd));
            cmd.setInput(cmdList);
        }
    }

    private static void processModifyCommand(IInput cmdList) {
        if (CmdLine.CL.containsCommand("modify")) {
            String removeFeatures;
            String addFeatures = CmdLine.CL.getParam1StrVal("-addFeatures");
            if (addFeatures == null || addFeatures.length() == 0) {
                addFeatures = "-";
            }
            if ((removeFeatures = CmdLine.CL.getParam1StrVal("-removeFeatures")) != null && removeFeatures.length() > 0) {
                IUninstallCommand uninstallCmd = CommandFactory.createUnInstallCommand();
                for (CmdParamPackage.IdVersionFeatures p : CmdLine.CL.getPackages("modify")) {
                    uninstallCmd.addOffering(p.id, p.version, null, removeFeatures, CmdLine.CL.getInstallationDirectory());
                }
                uninstallCmd.setModify(true);
                cmdList.addCommand(uninstallCmd);
                uninstallCmd.setInput(cmdList);
            }
            IInstallCommand installCmd = CommandFactory.createInstallCommand();
            for (CmdParamPackage.IdVersionFeatures p : CmdLine.CL.getPackages("modify")) {
                installCmd.addOffering(p.id, p.version, null, addFeatures, CmdLine.CL.getInstallationDirectory());
            }
            installCmd.setModify(true);
            CmdInputBuilder.addProperties((AbstractCommand)((Object)installCmd));
            cmdList.addCommand(installCmd);
            installCmd.setInput(cmdList);
        }
    }

    private static void processImportCommand(IInput cmdList) {
        CmdCommand cmdCmd = CmdLine.CL.getCommand("import");
        if (cmdCmd != null) {
            IImportCommand importCmd = CommandFactory.createImportCommand();
            String installLocationStr = CmdLine.CL.getParam1StrVal("-installationDirectory");
            if (installLocationStr != null) {
                importCmd.setInstallLocation(installLocationStr);
            }
            CmdInputBuilder.processEclipseLocation((AbstractCommand)((Object)importCmd));
            CmdInputBuilder.addProperties((AbstractCommand)((Object)importCmd));
            cmdList.addCommand(importCmd);
            importCmd.setInput(cmdList);
        }
    }

    private static void addProperties(AbstractCommand cmd) {
        for (Map.Entry<String, String> entry : CmdLine.CL.getProperties().entrySet()) {
            cmd.addData(entry.getKey(), entry.getValue());
        }
    }

    private static void processListInstalledPackagesCommand(IInput cmdList) {
        CmdCommand cmdCmd = CmdLine.CL.getCommand("listInstalledPackages");
        if (cmdCmd != null) {
            IListInstalledPackagesCommand cmd = CommandFactory.createListInstalledPackagesCommand();
            cmdList.addCommand(cmd);
            cmd.setInput(cmdList);
        }
    }

    private static void processGenerateResponseFileCommand(IInput cmdList) {
        if (CmdLine.CL.containsCommand("generateResponseFile")) {
            IGenerateResponseFileCommand cmd = CommandFactory.createGenerateResponseFileCommand();
            cmdList.addCommand(cmd);
            cmd.setInput(cmdList);
            for (CmdParamPackage.IdVersionFeatures p : CmdLine.CL.getPackages("generateResponseFile")) {
                cmd.addPackage(p.id, p.version);
            }
            String output = CmdLine.CL.getParam1StrVal("-output");
            if (output != null) {
                cmd.setOutput(output);
            }
            List repos = CmdLine.CL.getRepositories();
            for (String repo : repos) {
                cmd.addRepository(repo);
            }
            String installDir = CmdLine.CL.getInstallationDirectory();
            if (installDir != null) {
                cmd.setInstallationDirectory(installDir);
            }
        }
    }

    private static void processListAvailablePackagesCommand(IInput cmdList) {
        CmdCommand cmdCmd = CmdLine.CL.getCommand("listAvailablePackages");
        if (cmdCmd != null) {
            IListAvailablePackagesCommand cmd = CommandFactory.createListAvailablePackagesCommand();
            cmdList.addCommand(cmd);
            cmd.setInput(cmdList);
        }
    }

    private static void processListAvailableCommand(IInput cmdList) {
        CmdCommand cmdCmd = CmdLine.CL.getCommand("listAvailable");
        if (cmdCmd != null) {
            IListAvailableCommand cmd = CommandFactory.createListAvailableCommand();
            cmdList.addCommand(cmd);
            cmd.setInput(cmdList);
        }
    }

    private static void processListAvailableFixesCommand(IInput cmdList) {
        CmdCommand cmdCmd = CmdLine.CL.getCommand("listAvailableFixes");
        if (cmdCmd != null) {
            IListAvailableFixesCommand cmd = CommandFactory.createListAvailableFixesCommand();
            cmdList.addCommand(cmd);
            cmd.setInput(cmdList);
        }
    }

    private static void processListInstalledFeaturesCommand(IInput cmdList) {
        CmdCommand cmdCmd = CmdLine.CL.getCommand("listInstalledFeatures");
        if (cmdCmd != null) {
            IListInstalledFeaturesCommand cmd = CommandFactory.createListInstalledFeaturesCommand();
            cmdList.addCommand(cmd);
            cmd.setInput(cmdList);
        }
    }

    private static void processListInstallationDirectoriesCommand(IInput cmdList) {
        CmdCommand cmdCmd = CmdLine.CL.getCommand("listInstallationDirectories");
        if (cmdCmd != null) {
            IListInstallationDirectoriesCommand cmd = CommandFactory.createListInstallationDirectoriesCommand();
            cmdList.addCommand(cmd);
            cmd.setInput(cmdList);
        }
    }

    private static void processRollbackCommand(IInput cmdList) {
        if (CmdLine.CL.containsCommand("rollback")) {
            IRollbackCommand cmd = CommandFactory.createRollbackCommand();
            for (CmdParamPackage.IdVersionFeatures p : CmdLine.CL.getPackages("rollback")) {
                cmd.addOffering(p.id, p.version, null, p.features, CmdLine.CL.getInstallationDirectory(), null);
            }
            cmd.setAcceptLicense(cmdList.isAcceptLicense());
            cmdList.addCommand(cmd);
            CmdInputBuilder.addProperties((AbstractCommand)((Object)cmd));
            cmd.setInput(cmdList);
        }
    }

    private static void processViewLogCommand(IInput cmdList) {
        if (CmdLine.CL.containsCommand("viewLog")) {
            String logFileName = CmdLine.CL.getParam1StrVal("viewLog");
            IViewLogCommand cmd = CommandFactory.createViewLogCommand(logFileName);
            cmdList.addCommand(cmd);
            cmd.setInput(cmdList);
        }
    }

    private static void processViewLicenseCommand(IInput cmdList) {
        if (CmdLine.CL.containsCommand("viewLicense")) {
            CmdParamPackage.IdVersionFeatures p = (CmdParamPackage.IdVersionFeatures)CmdLine.CL.getParam1ObjVal("viewLicense");
            IViewLicenseCommand cmd = CommandFactory.createViewLicenseCommand();
            cmd.setOfferingOrFix(p.id, p.version);
            cmdList.addCommand(cmd);
            cmd.setInput(cmdList);
        }
    }
}

