/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.AbstractInstallOperation;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class InstallOperationEventManager {
    public static final InstallOperationEventManager INSTANCE = new InstallOperationEventManager();
    public static final IAction NULL_ACTION = new IAction(){

        @Override
        public IStatus perform(AbstractInstallOperation op, IStatus status, IProgressMonitor monitor) {
            return Status.OK_STATUS;
        }
    };
    private final List<IInstallOperationListener> listeners = new ArrayList<IInstallOperationListener>(4);

    public void addListener(IInstallOperationListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public boolean removeListener(IInstallOperationListener listener) {
        return this.listeners.remove(listener);
    }

    protected IAction perform(AbstractInstallOperation op, CicMultiStatus result, IProgressMonitor monitor) {
        if (this.listeners.isEmpty()) {
            return NULL_ACTION;
        }
        MultiAction actions = new MultiAction(this.listeners.size());
        for (IInstallOperationListener listener : this.listeners) {
            actions.add(listener.perform(op, result, monitor));
        }
        return actions;
    }

    public static interface IAction {
        public IStatus perform(AbstractInstallOperation var1, IStatus var2, IProgressMonitor var3);
    }

    public static interface IInstallOperationListener {
        public IAction perform(AbstractInstallOperation var1, CicMultiStatus var2, IProgressMonitor var3);
    }

    private static class MultiAction
    implements IAction {
        private final List<IAction> actions;

        public MultiAction(int size) {
            this.actions = new ArrayList<IAction>(size);
        }

        public void add(IAction action) {
            this.actions.add(action);
        }

        @Override
        public IStatus perform(AbstractInstallOperation op, IStatus status, IProgressMonitor monitor) {
            if (this.actions.isEmpty()) {
                return Status.OK_STATUS;
            }
            CicMultiStatus result = Statuses.ST.createMultiStatus();
            for (IAction action : this.actions) {
                result.add(action.perform(op, status, monitor));
            }
            return StatusUtil.toSingleStatus((IStatus)result);
        }
    }
}

