/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.core.ContextLocator;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallationContext;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.core.model.InstallationContextScope;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.expander.IContextState;
import com.ibm.cic.common.core.utils.Check;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class InstallContextTree {
    private final Object parent;
    private final IContextState contextState;
    private List subTrees = null;
    private InstallContext installContext = null;
    private InstallableUnitPair.List originalPairs;
    private InstallableUnitPair.List pairs;

    public InstallContextTree(Object parent, IContextState contextState) {
        assert (contextState.isRoot() == parent instanceof Profile);
        this.parent = parent;
        this.contextState = contextState;
        for (InstallRegistry.ContextInstallRegistry childRegistry : this.getInstallRegistry().getChildRegistries()) {
            contextState.ensureSubContext((IIdentity)new SimpleIdentity(childRegistry.getId()));
        }
        for (InstallRegistry.ContextInstallRegistry element : contextState.getSubContexts()) {
            IContextState subContext = (IContextState)element;
            InstallContextTree subTree = new InstallContextTree(this, subContext);
            if (subContext.getInstallationContext() == null && subTree.getInstallRegistry().getInstallContext() == null) {
                Check.isTrue((boolean)subContext.getSubContexts().isEmpty());
                Check.isTrue((boolean)subContext.getIUs().isEmpty());
                continue;
            }
            this.addSubTree(subTree);
        }
    }

    public InstallRegistry.ContextInstallRegistry getInstallRegistry() {
        return this.getParentInstallRegistry().getContextInstallRegistry(this.getId());
    }

    private InstallRegistry.ContextInstallRegistry getParentInstallRegistry() {
        if (this.parent instanceof Profile) {
            return ((Profile)this.parent).getInstallRegistry();
        }
        return ((InstallContextTree)this.parent).getInstallRegistry();
    }

    public String getId() {
        if (this.parent instanceof Profile) {
            return ((Profile)this.parent).getRootContext().getId();
        }
        return this.contextState.getIdentity().getId();
    }

    public Profile getProfile() {
        if (this.parent instanceof Profile) {
            return (Profile)this.parent;
        }
        return ((InstallContextTree)this.parent).getProfile();
    }

    public String toString() {
        return String.valueOf(this.getId()) + " (" + (this.pairs == null ? 0 : this.pairs.size()) + " IU pairs, " + (this.subTrees == null ? 0 : this.subTrees.size()) + " sub-trees)";
    }

    public InstallContext getInstallContext() {
        return this.installContext;
    }

    public List getFullTree() {
        return this.addFullTree(new ArrayList(8));
    }

    private List addFullTree(List list) {
        list.add(this);
        for (InstallContextTree subTree : this.getSubTrees()) {
            subTree.addFullTree(list);
        }
        return list;
    }

    public InstallContextTree findSubContext(String contextId) {
        for (InstallContextTree tree : this.getFullTree()) {
            if (!tree.getId().equals(contextId)) continue;
            return tree;
        }
        return null;
    }

    public List getSubTrees() {
        return this.subTrees != null ? this.subTrees : Collections.EMPTY_LIST;
    }

    private void addSubTree(InstallContextTree subTree) {
        if (this.subTrees == null) {
            this.subTrees = new ArrayList(4);
        }
        if (!this.subTrees.isEmpty() && subTree.getId().equals("com.ibm.sdp.eclipse.ide")) {
            this.subTrees.add(0, subTree);
        } else {
            this.subTrees.add(subTree);
        }
    }

    public Collection getShareableEntities() {
        return this.contextState.getShareableEntities();
    }

    public Set getSelected(IShareableEntity se) {
        return this.contextState.getSelected(se);
    }

    public InstallableUnitPair.List getPairs() {
        this.computePairs();
        return this.pairs;
    }

    public void setPairs(InstallableUnitPair.List pairs) {
        this.computePairs();
        this.pairs = pairs;
    }

    public InstallableUnitPair.List getOriginalPairs() {
        this.computePairs();
        return this.originalPairs;
    }

    private void computePairs() {
        if (this.pairs == null) {
            Collection ius = this.contextState.getIUs();
            this.pairs = new InstallableUnitPair.List(ius.size());
            this.pairs.addAllTo(ius);
            this.pairs.addAllFrom(this.getInstallRegistry().getInstalledIUs());
            this.originalPairs = new InstallableUnitPair.UnmodifiableList(this.pairs);
        }
    }

    public IStatus resolveInstallContexts(IOffering creatingContent) {
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        for (InstallContextTree tree : this.getFullTree()) {
            tree.resolveInstallContext(creatingContent);
        }
        if (!result.isOK()) {
            result.setMessage(Messages.Director_No_Install_Context_For_Uninstall);
        }
        return result;
    }

    private IStatus resolveInstallContext(IOffering creatingContent) {
        this.installContext = this.getInstallRegistry().getInstallContext();
        return this.installContext != null ? Status.OK_STATUS : this.locateAndSetInstallContext(creatingContent);
    }

    public void installInstallContextIUs() {
        for (InstallContextTree tree : this.getFullTree()) {
            tree.getInstallContext().installIUs();
        }
    }

    private IInstallationContext getInstallationContext() {
        return this.contextState.isRoot() ? null : this.contextState.getInstallationContext();
    }

    private IStatus locateAndSetInstallContext(IOffering creatingContent) {
        InstallationContextScope scope;
        ContextLocator locator = new ContextLocator();
        Set matchingContexts = null;
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        InstallContext parentContext = this.getParentInstallRegistry().getInstallContext();
        IInstallationContext ic = this.getInstallationContext();
        InstallationContextScope installationContextScope = scope = ic == null ? InstallationContextScope.NONE_SCOPE : ic.getScope();
        if (scope.equals(InstallationContextScope.PROFILE_SCOPE)) {
            matchingContexts = locator.findMatchingContexts(ic, parentContext.getEnclosingProfile());
        } else if (scope.equals(InstallationContextScope.SYSTEM_SCOPE)) {
            matchingContexts = locator.findMatchingContexts(ic);
        } else {
            scope.equals(InstallationContextScope.NONE_SCOPE);
        }
        if (matchingContexts != null && matchingContexts.size() >= 1) {
            for (InstallContext context : matchingContexts) {
                IStatus nextStatus = context.allowsContent(creatingContent);
                if (nextStatus.isOK()) {
                    this.installContext = context;
                    return Status.OK_STATUS;
                }
                status.add(nextStatus);
            }
        }
        if (creatingContent == null) {
            status.add((IStatus)Statuses.ERROR.get(Messages.Director_Matching_Install_Context_Not_Found, new Object[]{ic.getIdentity()}));
            return status;
        }
        InstallContext context = new InstallContext(parentContext, ic);
        context.setCreatingContent((IContent)creatingContent);
        this.installContext = context;
        return Status.OK_STATUS;
    }
}

