/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.IAgentObserverRegistrar;
import com.ibm.cic.agent.core.api.IAgent;
import com.ibm.cic.agent.core.api.IAgentJob;
import com.ibm.cic.agent.core.api.ICustomPanelData;
import com.ibm.cic.agent.core.api.IProfile;
import org.eclipse.core.runtime.IAdaptable;

public class CustomPanelData
implements ICustomPanelData,
IAdaptable {
    private final IAgentJob[] allJobs;
    private final IAgentJob[] profileJobs;

    public CustomPanelData(IAgentJob[] allJobs, IAgentJob[] profileJobs) {
        this.allJobs = allJobs;
        this.profileJobs = profileJobs;
    }

    public Object getAdapter(Class adapter) {
        if (IAgent.class.equals((Object)adapter)) {
            return this.getAgent();
        }
        if (IAgentObserverRegistrar.class.equals((Object)adapter)) {
            return Agent.getInstance().getEventManager();
        }
        if (IAgentJob[].class.equals((Object)adapter) || AgentJob[].class.equals((Object)adapter)) {
            return this.getProfileJobs();
        }
        return null;
    }

    @Override
    public IAgent getAgent() {
        return Agent.getInstance();
    }

    @Override
    public IAgentJob[] getAllJobs() {
        return this.allJobs;
    }

    @Override
    public IAgentJob[] getProfileJobs() {
        return this.profileJobs;
    }

    @Override
    public IProfile getProfile() {
        IAgentJob[] jobs = this.getProfileJobs();
        if (jobs != null && jobs.length > 0) {
            IProfile profileInJob = jobs[0].getAssociatedProfile();
            if (profileInJob.getProfileKind().equals("self")) {
                return null;
            }
            return profileInJob;
        }
        return null;
    }
}

