/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import java.util.Map;
import java.util.Set;
import org.eclipse.ui.internal.preferences.IPropertyMap;
import org.eclipse.ui.internal.util.Util;

public class PropertyMapUnion
implements IPropertyMap {
    private Map values;

    public Set keySet() {
        return this.values.keySet();
    }

    public Object getValue(String propertyId, Class propertyType) {
        PropertyInfo info = (PropertyInfo)this.values.get(propertyId);
        if (info == null) {
            return null;
        }
        Object value = info.value;
        if (propertyType.isInstance(value)) {
            return value;
        }
        return null;
    }

    public boolean isCommonProperty(String propertyId) {
        PropertyInfo info = (PropertyInfo)this.values.get(propertyId);
        if (info == null) {
            return false;
        }
        return info.commonAttribute;
    }

    public boolean propertyExists(String propertyId) {
        return this.values.get(propertyId) != null;
    }

    public void setValue(String propertyId, Object newValue) {
        PropertyInfo info = new PropertyInfo(newValue, true);
        this.values.put(propertyId, info);
    }

    public void addMap(IPropertyMap toAdd) {
        Object value;
        PropertyInfo localInfo;
        Set keySet = toAdd.keySet();
        for (String key : this.keySet()) {
            localInfo = (PropertyInfo)this.values.get(key);
            if (localInfo == null) continue;
            if (toAdd.propertyExists(key)) {
                value = toAdd.getValue(key, Object.class);
                if (!Util.equals(value, toAdd.getValue(key, Object.class))) {
                    localInfo.value = null;
                }
                localInfo.commonAttribute = localInfo.commonAttribute && toAdd.isCommonProperty(key);
                continue;
            }
            localInfo.commonAttribute = false;
        }
        for (String element : keySet) {
            localInfo = (PropertyInfo)this.values.get(element);
            if (localInfo != null) continue;
            value = toAdd.getValue(element, Object.class);
            boolean isCommon = toAdd.isCommonProperty(element);
            localInfo = new PropertyInfo(value, isCommon);
            this.values.put(element, localInfo);
        }
    }

    public void removeValue(String propertyId) {
        this.values.remove(propertyId);
    }

    private static final class PropertyInfo {
        Object value;
        boolean commonAttribute;

        PropertyInfo(Object value, boolean commonAttribute) {
            this.value = value;
            this.commonAttribute = commonAttribute;
        }
    }
}

