/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.DataHeader;
import com.ibm.jvm.trace.format.api.TraceContext;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Vector;

public class ActiveSection {
    TraceContext context;
    String textSummary;
    private Vector options = new Vector();

    public ActiveSection(TraceContext context, ByteBuffer data) throws IllegalArgumentException {
        this.context = context;
        DataHeader dataHeader = new DataHeader(context, data, "UTTA");
        if (context.debugStream != null) {
            context.debug(this, 1, dataHeader);
        }
        byte[] activationData = new byte[dataHeader.length - 16];
        data.get(activationData);
        this.splitActivationData(activationData);
    }

    private void splitActivationData(byte[] data) {
        int j = 0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != 0) continue;
            if (i != j) {
                String s;
                try {
                    s = new String(data, j, i - j, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    s = new String(data, j, i - j);
                }
                this.options.add(s);
            }
            j = i + 1;
        }
        if (this.context.debugStream != null) {
            this.context.debug(this, 1, this.summary());
        }
    }

    public String toString() {
        return "Trace activation information";
    }

    public String summary() {
        if (this.textSummary == null) {
            StringBuilder s = new StringBuilder(this.toString() + ":" + System.getProperty("line.separator"));
            for (int i = 0; i < this.options.size(); ++i) {
                s.append("        ");
                s.append(this.options.get(i)).append(System.getProperty("line.separator"));
            }
            this.textSummary = s.toString();
        }
        return this.textSummary;
    }
}

