/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;

@DTFJPlugin(version="1.*", runtime=false)
public class FindCommand
extends BaseJdmpviewCommand {
    static final int text = 1;
    static final int binary = 2;
    FindAttribute findAtt = new FindAttribute();
    StringBuffer sb = new StringBuffer();
    ArrayList matches = new ArrayList();

    public FindCommand() {
        this.addCommand("find", "", "searches memory for a given string");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        if (args.length == 1) {
            String line = args[0];
            if (line.endsWith(",")) {
                line = line + "1";
            }
            String[] params = line.split(",");
            this.doCommand(params);
        } else {
            out.println("\"find\" takes a set comma separated parameters with no spaces");
        }
    }

    public void doCommand(String[] params) {
        ImageSection imageSection;
        this.sb = new StringBuffer();
        this.matches.clear();
        if (!this.isParametersValid(params)) {
            return;
        }
        this.determineModeFromPattern();
        if (!this.parseParams(params)) {
            return;
        }
        Iterator imageSections = this.ctx.getAddressSpace().getImageSections();
        while (imageSections.hasNext() && this.matches.size() <= this.findAtt.numMatchesToDisplay && !this.scanImageSection(imageSection = (ImageSection)imageSections.next())) {
        }
        if (this.matches.size() > 0) {
            this.findAtt.lastMatch = (Long)this.matches.get(this.matches.size() - 1);
        }
        this.ctx.getProperties().put("FindAttributes", this.findAtt);
        this.doPrint();
        if (this.matches.size() > 0) {
            this.printLastMatchContent();
        }
        this.restoreHexPrefix();
    }

    private void restoreHexPrefix() {
        if (this.findAtt.mode == 2) {
            this.findAtt.pattern = "0x" + this.findAtt.pattern;
        }
    }

    private void printLastMatchContent() {
        this.ctx.execute("hexdump 0x" + Long.toHexString(this.findAtt.lastMatch) + " " + this.findAtt.numBytesToPrint, this.out);
    }

    private void doPrint() {
        int size = this.matches.size();
        if (0 == size) {
            this.sb.append("No matches found.\n");
        } else {
            int limit = Math.min(this.findAtt.numMatchesToDisplay, size);
            for (int i = 0; i < limit; ++i) {
                long match = (Long)this.matches.get(i);
                this.sb.append("#" + i + ": " + "0x" + Long.toHexString(match) + "\n");
            }
        }
        this.out.print(new String(this.sb));
    }

    private boolean scanImageSection(ImageSection imageSection) {
        long imageStartAddress = imageSection.getBaseAddress().getAddress();
        long imageEndAddress = imageStartAddress + imageSection.getSize() - 1L;
        if (this.findAtt.startAddress < imageStartAddress && this.findAtt.endAddress < imageStartAddress) {
            return false;
        }
        if (this.findAtt.startAddress > imageEndAddress && this.findAtt.endAddress > imageEndAddress) {
            return false;
        }
        if (this.findAtt.startAddress >= imageStartAddress && this.findAtt.endAddress <= imageEndAddress) {
            return this.scanRegion(this.findAtt.startAddress, this.findAtt.endAddress, imageSection);
        }
        if (this.findAtt.startAddress <= imageStartAddress && this.findAtt.endAddress <= imageEndAddress && this.findAtt.endAddress >= imageStartAddress) {
            return this.scanRegion(imageStartAddress, this.findAtt.endAddress, imageSection);
        }
        if (this.findAtt.startAddress <= imageEndAddress && this.findAtt.startAddress >= imageStartAddress && this.findAtt.endAddress >= imageEndAddress) {
            return this.scanRegion(this.findAtt.startAddress, imageEndAddress, imageSection);
        }
        return this.scanRegion(imageStartAddress, imageEndAddress, imageSection);
    }

    private boolean scanRegion(long start, long end, ImageSection imageSection) {
        ImagePointer imagePointer = imageSection.getBaseAddress();
        int patternLength = this.findAtt.length();
        byte[] bytes = this.findAtt.getBytes();
        for (long i = 0L != start % (long)this.findAtt.boundary ? start - start % (long)this.findAtt.boundary + (long)this.findAtt.boundary : start; i <= end; i += (long)this.findAtt.boundary) {
            int j;
            for (j = 0; j < patternLength; ++j) {
                byte oneByte = bytes[j];
                try {
                    if (this.getByteFromImage(imagePointer, i + (long)j) != oneByte) break;
                    continue;
                }
                catch (MemoryAccessException mae) {
                    return false;
                }
            }
            if (j < patternLength) continue;
            this.matches.add(new Long(i));
            if (this.matches.size() != this.findAtt.numMatchesToDisplay) continue;
            return true;
        }
        return false;
    }

    private byte getByteFromImage(ImagePointer imagePointer, long address) throws MemoryAccessException {
        long imagePointerBaseAddress = imagePointer.getAddress();
        try {
            return imagePointer.getByteAt(address - imagePointerBaseAddress);
        }
        catch (CorruptDataException cde) {
            return 0;
        }
    }

    private boolean parseParams(String[] params) {
        this.findAtt.startAddress = params[1].equals("") ? 0L : Utils.longFromString(params[1]);
        this.findAtt.endAddress = params[2].equals("") ? Long.MAX_VALUE : Utils.longFromString(params[2]);
        if (this.findAtt.startAddress > this.findAtt.endAddress) {
            this.out.println("start address must not be greater than end address");
            return false;
        }
        if (params[3].equals("")) {
            this.findAtt.boundary = 1;
        } else {
            this.findAtt.boundary = Integer.parseInt(params[3]);
            if (this.findAtt.boundary <= 0) {
                this.out.println("memory boundary must be a positive non-zero value");
                return false;
            }
        }
        if (params[4].equals("")) {
            this.findAtt.numBytesToPrint = 256;
        } else {
            this.findAtt.numBytesToPrint = Integer.parseInt(params[4]);
            if (this.findAtt.numBytesToPrint < 0) {
                this.out.println("bytes to print must be a non-negative value");
                return false;
            }
        }
        if (params[5].equals("")) {
            this.findAtt.numMatchesToDisplay = 1;
        } else {
            this.findAtt.numMatchesToDisplay = Integer.parseInt(params[5]);
            if (this.findAtt.numMatchesToDisplay < 0) {
                this.out.println("matches to display must be a non-negative value");
                return false;
            }
        }
        return true;
    }

    private void determineModeFromPattern() {
        if (this.findAtt.pattern.startsWith("0x")) {
            this.findAtt.pattern = this.findAtt.pattern.substring(2);
            this.findAtt.mode = 2;
            this.allignBits();
        } else {
            this.findAtt.mode = 1;
        }
    }

    private void allignBits() {
        int patternLength = this.findAtt.pattern.length();
        if (0 != patternLength % 2) {
            this.findAtt.pattern = "0" + this.findAtt.pattern;
        }
    }

    private boolean isParametersValid(String[] params) {
        if (6 != params.length) {
            this.out.println("incorrect number of parameters");
            return false;
        }
        this.findAtt.pattern = params[0];
        if (this.findAtt.pattern.equals("")) {
            this.out.println("missing search pattern string");
            return false;
        }
        return true;
    }

    public void printDetailedHelp(PrintStream out) {
        out.println("searches memory for a given string\n\nparameters, comma separated: <pattern>,<start_address>,<end_address>,<memory_boundary>,<bytes_to_print>,<matches_to_display>\n\nthe find command searches for <pattern> in the memory segment from <start_address> to <end_address> inclusive, matching only addresses that start at the specified <memory_boundary>, for example 1,2,4 or 8 bytes. It displays <bytes_to_print> bytes from the final match, and lists the first <matches_to_display> matches found.\n example: find J9,,,,64,3");
    }

    class FindAttribute {
        String pattern;
        long startAddress;
        long endAddress;
        int boundary;
        int numBytesToPrint;
        int numMatchesToDisplay;
        long lastMatch;
        int mode;

        FindAttribute() {
        }

        public int length() {
            if (this.mode == 2) {
                return this.pattern.length() / 2;
            }
            return this.pattern.length();
        }

        public byte[] getBytes() {
            if (this.mode == 1) {
                return this.pattern.getBytes();
            }
            byte[] result = new byte[this.length()];
            for (int i = 0; i < this.length(); ++i) {
                result[i] = (byte)Integer.parseInt(this.pattern.substring(i * 2, i * 2 + 2), 16);
            }
            return result;
        }
    }
}

