/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.util;

import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.FileName;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Settings {
    private static final String DEFAULT_BUNDLE = "ikminit";
    private static String BUNDLE_NAME;
    private static ResourceBundle RESOURCE_BUNDLE;

    public static void setBundle(String bundle) {
        URL url;
        FileName fileName = new FileName(bundle);
        String directory = fileName.getDirectory();
        String file = fileName.getName();
        try {
            url = new URL("file:///" + directory + "/");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        RESOURCE_BUNDLE = ResourceBundle.getBundle(file, Locale.getDefault(), new URLClassLoader(new URL[]{url}));
        BUNDLE_NAME = bundle;
    }

    public static String getBundleFileName() {
        if (BUNDLE_NAME == null) {
            return null;
        }
        return new String(BUNDLE_NAME) + ".properties";
    }

    public static String getString(String key) {
        if (RESOURCE_BUNDLE == null) {
            return null;
        }
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    static {
        String bundleName = null;
        try {
            bundleName = System.getProperty("keyman.settings");
            if (bundleName == null) {
                bundleName = System.getProperty(KeymanSettings.isCLI() ? "ikeycmd.properties" : "initPropertyFile");
            }
            String s = ".properties";
            if (bundleName.endsWith(".properties")) {
                bundleName = bundleName.substring(0, bundleName.length() - ".properties".length());
            } else if (bundleName == null) {
                bundleName = DEFAULT_BUNDLE;
            }
            Settings.setBundle(bundleName);
        }
        catch (Exception e) {
            try {
                Debug.log("Error setting resource bundle to " + bundleName + ": " + e, new Object[0]);
                Settings.setBundle(DEFAULT_BUNDLE);
            }
            catch (Exception ex) {
                Debug.log("Error setting resource bundle to ikminit: " + ex, new Object[0]);
                RESOURCE_BUNDLE = null;
            }
        }
    }
}

