/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.sequence.bytes;

import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class ByteSequenceXorFactory {
    public static void stashKeyDbPwd(String storePassword, String absolutePath) throws IOException {
        byte[] buffer = new byte[129];
        byte[] pwdBuffer = storePassword.getBytes("UTF-8");
        for (int i = 0; i < 129; ++i) {
            buffer[i] = i < pwdBuffer.length ? pwdBuffer[i] : (i == pwdBuffer.length ? (byte)0 : (byte)i);
        }
        ByteSequence paddedPassword = ByteSequenceFactory.newByteSequence((byte[])buffer);
        ByteSequence key = ByteSequenceFactory.newConstantByteSequence((byte)-11, (int)129);
        ByteSequence stashedPwd = ByteSequenceXorFactory.newByteSequenceXor().xor(paddedPassword, key);
        FileOutputStream out = new FileOutputStream(absolutePath);
        ByteSequenceIterator it = stashedPwd.getIterator();
        while (it.hasNextByte()) {
            ((OutputStream)out).write(it.getNextByte());
        }
        ((OutputStream)out).close();
    }

    private ByteSequenceXorFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static ByteSequenceXor newByteSequenceXor() {
        return new ByteSequenceXorImpl();
    }

    static interface ByteSequenceXor {
        public ByteSequence xor(ByteSequence var1, ByteSequence var2) throws NullPointerException, IllegalArgumentException;
    }

    private static final class ByteSequenceXorImpl
    implements ByteSequenceXor {
        ByteSequenceXorImpl() {
        }

        public ByteSequence xor(ByteSequence seq1, ByteSequence seq2) throws NullPointerException, IllegalArgumentException {
            if (seq1 == null || seq2 == null) {
                throw new NullPointerException();
            }
            if (seq1.length() != seq2.length()) {
                throw new IllegalArgumentException();
            }
            ByteSequenceIterator it1 = seq1.getIterator();
            ByteSequenceIterator it2 = seq2.getIterator();
            byte[] bytes = new byte[seq1.length()];
            int counter = 0;
            while (it1.hasNextByte()) {
                byte b1 = it1.getNextByte();
                byte b2 = it2.getNextByte();
                bytes[counter++] = (byte)(b1 ^ b2);
            }
            return ByteSequenceFactory.newByteSequence((byte[])bytes);
        }
    }
}

