/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.keystore.entry.CMSCertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItemImpl;
import com.ibm.security.cmskeystore.CMSCertificate;
import java.security.cert.X509Certificate;

class CMSCertificateItemImpl
extends CertificateItemImpl
implements CMSCertificateItem {
    public CMSCertificateItemImpl(String label, X509Certificate cert) throws KeyManagerException {
        super(label, cert);
        if (!(cert instanceof CMSCertificate)) {
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_ENTRY_TYPE, label, cert.getClass().toString());
        }
    }

    public CMSCertificateItemImpl(CertificateItemImpl item, boolean trust) throws KeyManagerException {
        super(item.getLabel(), item.getCert());
        this.setTrusted(trust);
    }

    public boolean isTrusted() {
        return ((CMSCertificate)this.cert).isTrusted();
    }

    public void setTrusted(boolean trusted) {
        ((CMSCertificate)this.cert).setTrusted(trusted);
    }
}

