/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.keystore.EntryBagFactory;
import com.ibm.gsk.ikeyman.keystore.entry.CMSCertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.CMSKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.keystore.entry.SecretKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.UnloadableCMSCertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.UnloadableCertificateItemImpl;
import com.ibm.gsk.ikeyman.keystore.entry.UnloadableSecretKeyItem;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryMakerFactory {
    private static final EntryMaker<CMSKeyItem> cmsKeyMaker = new CMSKeyMaker();
    private static final EntryMaker<CMSCertificateItem> cmsCertificateMaker = new CMSCertMaker();
    private static final EntryMaker<CertificateItem> certMaker = new CertMaker();
    private static final EntryMaker<CertificateKeyItem> privateKeyMaker = new PrivateKeyMaker();
    private static final EntryMaker<SecretKeyItem> secretKeyMaker = new SecretKeyMaker();
    private static final ExtendedEntryMaker<CertificateItem> extendedCertMaker = new ExtendedCertMaker();
    private static final ExtendedEntryMaker<CertificateKeyItem> extendedPrivateKeyMaker = new ExtendedPrivateKeyMaker();
    private static final ExtendedEntryMaker<SecretKeyItem> extendedSecretKeyMaker = new ExtendedSecretKeyMaker();

    public static EntryMaker<CMSKeyItem> getCMSKeyMaker() {
        return cmsKeyMaker;
    }

    public static EntryMaker<CMSCertificateItem> getCMSCertMaker() {
        return cmsCertificateMaker;
    }

    public static EntryMaker<CertificateItem> getCertMaker() {
        return certMaker;
    }

    public static EntryMaker<CertificateKeyItem> getPrivateKeyMaker() {
        return privateKeyMaker;
    }

    public static EntryMaker<SecretKeyItem> getSecretKeyMaker() {
        return secretKeyMaker;
    }

    public static ExtendedEntryMaker<CertificateItem> getExtendedCertMaker() {
        return extendedCertMaker;
    }

    public static ExtendedEntryMaker<CertificateKeyItem> getExtendedPrivateKeyMaker() {
        return extendedPrivateKeyMaker;
    }

    public static ExtendedEntryMaker<SecretKeyItem> getExtendedSecretKeyMaker() {
        return extendedSecretKeyMaker;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CMSCertMaker
    implements EntryMaker<CMSCertificateItem> {
        private static final List<Class<? extends Entry>> supportedTypes = new ArrayList<Class<? extends Entry>>();

        private CMSCertMaker() {
        }

        @Override
        public CMSCertificateItem makeEntry(String alias, KeyStore.Entry entry) throws KeyManagerException {
            if (entry == null) {
                return new UnloadableCMSCertificateItem(alias, null);
            }
            if (entry instanceof KeyStore.TrustedCertificateEntry) {
                KeyStore.TrustedCertificateEntry certEntry = (KeyStore.TrustedCertificateEntry)entry;
                return EntryFactory.newCMSCertificate(alias, (X509Certificate)certEntry.getTrustedCertificate());
            }
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_ENTRY_TYPE, alias, entry.getClass().toString());
        }

        @Override
        public List<Class<? extends Entry>> getSupportedTypes() {
            return supportedTypes;
        }

        @Override
        public CMSCertificateItem makeEntry(String alias, Certificate cert) throws KeyManagerException {
            return new UnloadableCMSCertificateItem(alias, cert);
        }

        static {
            supportedTypes.add(CMSCertificateItem.class);
            supportedTypes.add(CertificateItem.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CMSKeyMaker
    implements EntryMaker<CMSKeyItem> {
        private static final List<Class<? extends Entry>> supportedTypes = new ArrayList<Class<? extends Entry>>();

        private CMSKeyMaker() {
        }

        @Override
        public List<Class<? extends Entry>> getSupportedTypes() {
            return supportedTypes;
        }

        @Override
        public CMSKeyItem makeEntry(String alias, KeyStore.Entry entry) throws KeyManagerException {
            if (entry == null) {
                return new UnloadableCertificateItemImpl(alias, null);
            }
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
                return EntryFactory.newCMSKey(alias, privateKeyEntry.getPrivateKey(), privateKeyEntry.getCertificateChain());
            }
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_ENTRY_TYPE, alias, entry.getClass().toString());
        }

        @Override
        public CMSKeyItem makeEntry(String alias, Certificate cert) throws KeyManagerException {
            return new UnloadableCertificateItemImpl(alias, cert);
        }

        static {
            supportedTypes.add(CMSKeyItem.class);
            supportedTypes.add(CertificateKeyItem.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CertMaker
    implements EntryMaker<CertificateItem> {
        private static final List<Class<? extends Entry>> supportedTypes = new ArrayList<Class<? extends Entry>>();

        private CertMaker() {
        }

        @Override
        public List<Class<? extends Entry>> getSupportedTypes() {
            return supportedTypes;
        }

        @Override
        public CertificateItem makeEntry(String alias, KeyStore.Entry entry) throws KeyManagerException {
            if (entry == null) {
                return new UnloadableCertificateItemImpl(alias, null);
            }
            if (entry instanceof KeyStore.TrustedCertificateEntry) {
                KeyStore.TrustedCertificateEntry certEntry = (KeyStore.TrustedCertificateEntry)entry;
                return EntryFactory.newCertificateItem(alias, (X509Certificate)certEntry.getTrustedCertificate());
            }
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_ENTRY_TYPE, alias, entry.getClass().toString());
        }

        @Override
        public CertificateItem makeEntry(String alias, Certificate cert) throws KeyManagerException {
            return new UnloadableCertificateItemImpl(alias, cert);
        }

        static {
            supportedTypes.add(CertificateItem.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EntryMaker<T extends Entry> {
        public T makeEntry(String var1, KeyStore.Entry var2) throws KeyManagerException;

        public T makeEntry(String var1, Certificate var2) throws KeyManagerException;

        public List<Class<? extends Entry>> getSupportedTypes();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtendedCertMaker
    implements ExtendedEntryMaker<CertificateItem> {
        private ExtendedCertMaker() {
        }

        @Override
        public List<Class<? extends Entry>> getSupportedTypes() {
            return certMaker.getSupportedTypes();
        }

        @Override
        public CertificateItem makeEntry(String alias, KeyStore.Entry entry, KeyStore.Entry certEntry) throws KeyManagerException {
            return (CertificateItem)certMaker.makeEntry(alias, entry);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ExtendedEntryMaker<T extends Entry> {
        public T makeEntry(String var1, KeyStore.Entry var2, KeyStore.Entry var3) throws KeyManagerException;

        public List<Class<? extends Entry>> getSupportedTypes();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtendedPrivateKeyMaker
    implements ExtendedEntryMaker<CertificateKeyItem> {
        private ExtendedPrivateKeyMaker() {
        }

        @Override
        public List<Class<? extends Entry>> getSupportedTypes() {
            return privateKeyMaker.getSupportedTypes();
        }

        @Override
        public CertificateKeyItem makeEntry(String alias, KeyStore.Entry entry, KeyStore.Entry certEntry) throws KeyManagerException {
            if (entry == null) {
                return new UnloadableCertificateItemImpl(alias, null);
            }
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
                KeyStore.TrustedCertificateEntry trustedEntry = (KeyStore.TrustedCertificateEntry)certEntry;
                if (certEntry == null) {
                    return EntryFactory.newKeyItem(alias, privateKeyEntry.getPrivateKey(), privateKeyEntry.getCertificateChain());
                }
                return EntryFactory.newKeyItem(alias, privateKeyEntry.getPrivateKey(), new Certificate[]{trustedEntry.getTrustedCertificate()});
            }
            if (entry instanceof EntryBagFactory.PKCS11ImplKeyStoreBag.KeyEntry) {
                EntryBagFactory.PKCS11ImplKeyStoreBag.KeyEntry privateKeyEntry = (EntryBagFactory.PKCS11ImplKeyStoreBag.KeyEntry)entry;
                KeyStore.TrustedCertificateEntry trustedEntry = (KeyStore.TrustedCertificateEntry)certEntry;
                return EntryFactory.newKeyItem(alias, privateKeyEntry.getPrivateKey(), new Certificate[]{trustedEntry.getTrustedCertificate()});
            }
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_ENTRY_TYPE, alias, entry.getClass().toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtendedSecretKeyMaker
    implements ExtendedEntryMaker<SecretKeyItem> {
        private ExtendedSecretKeyMaker() {
        }

        @Override
        public List<Class<? extends Entry>> getSupportedTypes() {
            return secretKeyMaker.getSupportedTypes();
        }

        @Override
        public SecretKeyItem makeEntry(String alias, KeyStore.Entry entry, KeyStore.Entry certEntry) throws KeyManagerException {
            return (SecretKeyItem)secretKeyMaker.makeEntry(alias, entry);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrivateKeyMaker
    implements EntryMaker<CertificateKeyItem> {
        private static final List<Class<? extends Entry>> supportedTypes = new ArrayList<Class<? extends Entry>>();

        private PrivateKeyMaker() {
        }

        @Override
        public CertificateKeyItem makeEntry(String alias, KeyStore.Entry entry) throws KeyManagerException {
            if (entry == null) {
                return new UnloadableCertificateItemImpl(alias, null);
            }
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
                return EntryFactory.newKeyItem(alias, privateKeyEntry.getPrivateKey(), privateKeyEntry.getCertificateChain());
            }
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_ENTRY_TYPE, alias, entry.getClass().toString());
        }

        @Override
        public List<Class<? extends Entry>> getSupportedTypes() {
            return supportedTypes;
        }

        @Override
        public CertificateKeyItem makeEntry(String alias, Certificate cert) throws KeyManagerException {
            return new UnloadableCertificateItemImpl(alias, cert);
        }

        static {
            supportedTypes.add(CertificateKeyItem.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SecretKeyMaker
    implements EntryMaker<SecretKeyItem> {
        private static final List<Class<? extends Entry>> supportedTypes = new ArrayList<Class<? extends Entry>>();

        private SecretKeyMaker() {
        }

        @Override
        public SecretKeyItem makeEntry(String alias, KeyStore.Entry entry) throws KeyManagerException {
            if (entry == null) {
                return new UnloadableSecretKeyItem(alias, null);
            }
            if (entry instanceof KeyStore.SecretKeyEntry) {
                KeyStore.SecretKeyEntry secretKeyEntry = (KeyStore.SecretKeyEntry)entry;
                return EntryFactory.newSecretKey(alias, secretKeyEntry.getSecretKey());
            }
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_ENTRY_TYPE, alias, entry.getClass().toString());
        }

        @Override
        public List<Class<? extends Entry>> getSupportedTypes() {
            return supportedTypes;
        }

        @Override
        public SecretKeyItem makeEntry(String alias, Certificate cert) throws KeyManagerException {
            return new UnloadableSecretKeyItem(alias, cert);
        }

        static {
            supportedTypes.add(SecretKeyItem.class);
        }
    }
}

