/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman;

import com.ibm.gsk.ikeyman.command.Command;
import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.command.KeyStoreLoaderFactory;
import com.ibm.gsk.ikeyman.command.cli.CommandParser;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.io.CommandLineDisplayer;
import com.ibm.gsk.ikeyman.io.Logger;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.gsk.ikeyman.util.TypeDisplayerFactory;

public class ikeycmd {
    public static void main(String[] args) {
        Debug.entering(args);
        try {
            String[] ikmArgs = KeymanUtil.parseJvmArgs(args);
            KeymanSettings.setCLI(true);
            Constants.Parameter.setDisplayer(TypeDisplayerFactory.newCliDisplayer());
            Constants.CommandType.setDisplayer(TypeDisplayerFactory.newCliDisplayer());
            EntryFactory.setClassDisplayer(TypeDisplayerFactory.newCliEntryDisplayer());
            KeymanUtil.validateJCEProvider();
            CommandParser parser = CommandParser.parseCommand(ikmArgs);
            if (parser.getParameters().containsKey(Constants.Parameter.UseReasonCode)) {
                parser.getParameters().remove(Constants.Parameter.UseReasonCode);
            }
            Command command = parser.getCommand();
            command.invoke(KeyStoreLoaderFactory.newBasicKeyStoreLoader(), null, new CommandLineDisplayer());
        }
        catch (KeyManagerException e) {
            Debug.throwing(e);
            Logger.showError(e);
            System.exit(e.getReason().getErrorCode());
        }
        catch (Exception e) {
            Debug.throwing(e);
            Logger.showError(e);
            System.exit(-1);
        }
        Debug.exiting();
        System.exit(0);
    }
}

