/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command.gui;

import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.command.LabelMap;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.gui.KeymanController;
import com.ibm.gsk.ikeyman.command.gui.KeymanView;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.NotImplementedException;
import com.ibm.gsk.ikeyman.event.KeyManagerEvent;
import com.ibm.gsk.ikeyman.event.KeyManagerEventListener;
import com.ibm.gsk.ikeyman.event.ProviderEvent;
import com.ibm.gsk.ikeyman.gui.AddProviderDialog;
import com.ibm.gsk.ikeyman.gui.CertificateDataDialog;
import com.ibm.gsk.ikeyman.gui.CryptoTokenDialog;
import com.ibm.gsk.ikeyman.gui.FileNameDialog;
import com.ibm.gsk.ikeyman.gui.GUIConstants;
import com.ibm.gsk.ikeyman.gui.KeySelectDialog;
import com.ibm.gsk.ikeyman.gui.PasswordPromptDialog;
import com.ibm.gsk.ikeyman.gui.SignerSelectDialog;
import com.ibm.gsk.ikeyman.gui.panels.FileNamePanelFactory;
import com.ibm.gsk.ikeyman.gui.panels.InputPanelFactory;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreInfo;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.FileName;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import java.awt.Frame;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RetrieverFactory {
    private static final Map<Constants.CommandType, Retriever> retrievers = new HashMap<Constants.CommandType, Retriever>();

    public static Retriever get(Constants.CommandType type) {
        return retrievers.get(type);
    }

    static {
        PasswordValidator certValidator = new PasswordValidator(Messages.getString("Question.NotProtectedCert"));
        PasswordValidator certReqValidator = new PasswordValidator(Messages.getString("Question.NotProtectedCertReq"));
        PasswordValidator changePasswordValidator = new PasswordValidator(Messages.getString("Question.NotProtectedChangePw"));
        retrievers.put(Constants.CommandType.CreateDB, new PromptNewDbRetriever());
        retrievers.put(Constants.CommandType.CloseDb, new SourceDbRetriever());
        retrievers.put(Constants.CommandType.CreateSSCert, new CompoundRetriever(certValidator, new SourceDbRetriever(), new CertificateDataRetriever()));
        retrievers.put(Constants.CommandType.ReceiveCert, new CompoundRetriever(certValidator, new GenericFileRetriever(GUIConstants.DialogMode.Open, FileNamePanelFactory.PanelType.AddCertificate), new SourceDbRetriever()));
        retrievers.put(Constants.CommandType.DeleteCert, new CompoundRetriever(new DeleteCertRetriever(Constants.Parameter.Label), new SourceDbRetriever()));
        retrievers.put(Constants.CommandType.DisplayCert, new CompoundRetriever(new SourceDbRetriever(), new SelectedLabelRetriever(Constants.Parameter.Label)));
        retrievers.put(Constants.CommandType.ExportCert, new CompoundRetriever(certValidator, new ExportRetriever()));
        retrievers.put(Constants.CommandType.ImportCert, new CompoundRetriever(certValidator, new ImportRetriever()));
        retrievers.put(Constants.CommandType.RecreateCertRequest, new CompoundRetriever(new GenericFileRetriever(GUIConstants.DialogMode.New, FileNamePanelFactory.PanelType.ComboLess), new SelectedLabelRetriever(Constants.Parameter.Label), new SourceDbRetriever()));
        retrievers.put(Constants.CommandType.ExtractCert, new CompoundRetriever(new GenericFileRetriever(GUIConstants.DialogMode.New, FileNamePanelFactory.PanelType.Certificate), new SelectedLabelRetriever(Constants.Parameter.Label), new SourceDbRetriever()));
        retrievers.put(Constants.CommandType.AddCertRename, new CompoundRetriever(new GenericFileRetriever(GUIConstants.DialogMode.Open, FileNamePanelFactory.PanelType.AddCertificate), new LabelSelectRetriever(), new SourceDbRetriever()));
        retrievers.put(Constants.CommandType.CreateCertRequest, new CompoundRetriever(certReqValidator, new SourceDbRetriever(), new CertRequestDataRetriever()));
        retrievers.put(Constants.CommandType.DisplayCertRequest, new CompoundRetriever(new SourceDbRetriever(), new SelectedLabelRetriever(Constants.Parameter.Label)));
        retrievers.put(Constants.CommandType.LoadDB, new PromptLoadDbRetriever());
        retrievers.put(Constants.CommandType.DeleteCertRequest, new CompoundRetriever(new DeleteCertRetriever(Constants.Parameter.Label), new SourceDbRetriever()));
        retrievers.put(Constants.CommandType.ExtractCertRequest, new CompoundRetriever(new GenericFileRetriever(GUIConstants.DialogMode.New, FileNamePanelFactory.PanelType.Certificate), new SelectedLabelRetriever(Constants.Parameter.Label), new SourceDbRetriever()));
        retrievers.put(Constants.CommandType.ConvertDB, new ConvertRetriever());
        retrievers.put(Constants.CommandType.AddProvider, new AddProviderRetriever());
        retrievers.put(Constants.CommandType.ChangeDBPassword, new CompoundRetriever(changePasswordValidator, new SourceDbRetriever(), new ChangePasswordRetriever()));
        retrievers.put(Constants.CommandType.StashDBPassword, new SourceDbRetriever());
        retrievers.put(Constants.CommandType.Version, new EmptyRetriever());
        retrievers.put(Constants.CommandType.RenameCert, new CompoundRetriever(new SourceDbRetriever(), new SelectedLabelRetriever(Constants.Parameter.Label), new QueryLabelRetriever()));
        retrievers.put(Constants.CommandType.ValidateCert, new CompoundRetriever(new SourceDbRetriever(), new SelectedLabelRetriever(Constants.Parameter.Label)));
        retrievers.put(Constants.CommandType.Populate, new CompoundRetriever(new SourceDbRetriever(), new SignerSelectRetriever()));
        retrievers.put(Constants.CommandType.CreateSecretKey, new CompoundRetriever(certValidator, new SourceDbRetriever(), new SecretKeyDataRetriever()));
        retrievers.put(Constants.CommandType.DeleteSecretKey, new CompoundRetriever(new DeleteCertRetriever(Constants.Parameter.Label), new SourceDbRetriever()));
        retrievers.put(Constants.CommandType.DisplaySecretKey, new CompoundRetriever(new SourceDbRetriever(), new SelectedLabelRetriever(Constants.Parameter.Label)));
        retrievers.put(Constants.CommandType.ImportSecretKey, new CompoundRetriever(certValidator, new ImportSecretKeyRetriever(), new SourceDbRetriever(), new EntrySelectRetriever(EntrySelectRetriever.Mode.KEYS)));
        retrievers.put(Constants.CommandType.ExportSecretKey, new CompoundRetriever(new SourceDbRetriever(), new SelectedLabelsRetriever(Constants.Parameter.Label), new ExportSecretKeyRetriever(), new EntrySelectRetriever(EntrySelectRetriever.Mode.SIGNERS)));
        retrievers.put(Constants.CommandType.RenameSecretKey, new CompoundRetriever(new SourceDbRetriever(), new SelectedLabelRetriever(Constants.Parameter.Label), new QueryLabelRetriever()));
        retrievers.put(Constants.CommandType.RefreshLists, new ExistingSourceDbRetriever());
        retrievers.put(Constants.CommandType.DisplayDBPasswordExpiry, new SourceDbRetriever());
    }

    private static abstract class AbstractRetriever
    implements Retriever {
        private AbstractRetriever() {
        }

        public void getParametersAfterError(KeymanView view, Frame parent, ParameterMap map, KeyManagerException lastException) throws KeyManagerException, CancelledException {
            throw new NotImplementedException();
        }
    }

    private static class AddProviderRetriever
    extends AbstractRetriever {
        private AddProviderRetriever() {
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException, CancelledException {
            AddProviderDialog.getProviderData(parent, map);
        }

        public void getParametersAfterError(KeymanView view, Frame parent, ParameterMap map, KeyManagerException lastException) throws KeyManagerException, CancelledException {
            AddProviderDialog.getProviderData(parent, map);
        }
    }

    private static class CertRequestDataRetriever
    extends AbstractRetriever {
        private CertRequestDataRetriever() {
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException, CancelledException {
            CertificateDataDialog.getData(parent, InputPanelFactory.InputDialogType.CertificateRequest, view.getSelectedDatabase(), false, map);
        }

        public void getParametersAfterError(KeymanView view, Frame parent, ParameterMap map, KeyManagerException lastException) throws KeyManagerException, CancelledException {
            CertificateDataDialog.getData(parent, InputPanelFactory.InputDialogType.CertificateRequest, view.getSelectedDatabase(), true, map);
        }
    }

    private static class CertificateDataRetriever
    extends AbstractRetriever {
        private CertificateDataRetriever() {
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException, CancelledException {
            CertificateDataDialog.getData(parent, InputPanelFactory.InputDialogType.SelfsignedCertificate, view.getSelectedDatabase(), false, map);
        }

        public void getParametersAfterError(KeymanView view, Frame parent, ParameterMap map, KeyManagerException lastException) throws KeyManagerException, CancelledException {
            CertificateDataDialog.getData(parent, InputPanelFactory.InputDialogType.SelfsignedCertificate, view.getSelectedDatabase(), true, map);
        }
    }

    private static class ChangePasswordRetriever
    extends AbstractRetriever {
        private Retriever selectedDb = new SourceDbRetriever();

        private ChangePasswordRetriever() {
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException, CancelledException {
            this.selectedDb.getParameters(view, parent, map);
            map.putAll(PasswordPromptDialog.getPasswordData(parent, (Constants.DatabaseType)map.get(Constants.Parameter.Type), Constants.Parameter.NewPassword, GUIConstants.DialogMode.New));
        }
    }

    private static class CompoundRetriever
    extends AbstractRetriever {
        private List<Retriever> retrievers;

        public CompoundRetriever(Retriever ... retrievers) {
            this.retrievers = Arrays.asList(retrievers);
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException, CancelledException {
            for (Retriever retriever : this.retrievers) {
                retriever.getParameters(view, parent, map);
            }
        }

        public void getParametersAfterError(KeymanView view, Frame parent, ParameterMap map, KeyManagerException lastException) throws KeyManagerException, CancelledException {
            boolean handled = false;
            for (Retriever retriever : this.retrievers) {
                try {
                    retriever.getParametersAfterError(view, parent, map, lastException);
                    handled = true;
                }
                catch (NotImplementedException e) {}
            }
            if (!handled) {
                throw new NotImplementedException();
            }
        }
    }

    private static class ConvertRetriever
    extends FileRetriever {
        private ConvertRetriever() {
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException, CancelledException {
            if (view.getSelectedDatabase() != null && view.getSelectedDatabase().getDescriptor().getType() == Constants.DatabaseType.PKCS11Direct) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.CANNOT_CONVERT_PKCS11);
            }
            ParameterMap tempMap = FileNameDialog.getFileData(parent, GUIConstants.DialogMode.New, FileNamePanelFactory.PanelType.Database, ConvertRetriever.getDatabaseFileName(view));
            map.put(Constants.Parameter.Target, tempMap.get(Constants.Parameter.DatabaseName));
            map.put(Constants.Parameter.NewFormat, tempMap.get(Constants.Parameter.Type));
            ParameterMap passwordMap = PasswordPromptDialog.getPasswordData(parent, (Constants.DatabaseType)tempMap.get(Constants.Parameter.Type), Constants.Parameter.NewPassword, GUIConstants.DialogMode.New);
            map.putAll(passwordMap);
            map.putAll(view.getSelectedDatabase().getDatabaseParameters(false));
            map.put(Constants.Parameter.OldFormat, map.get(Constants.Parameter.Type));
            map.remove(Constants.Parameter.Type);
        }
    }

    private static class DeleteCertRetriever
    extends AbstractRetriever {
        private Constants.Parameter param;

        public DeleteCertRetriever(Constants.Parameter param) {
            this.param = param;
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException, CancelledException {
            Entry selectedEntry = view.getSelectedEntry();
            int result = view.showConfirmation(Messages.getString("Question.ConfirmDelete"), Messages.getString("GUI.Title.Confirm"), 0);
            if (result != 0) {
                throw new CancelledException();
            }
            map.put(this.param, selectedEntry.getLabel());
        }
    }

    private static class EmptyRetriever
    extends AbstractRetriever {
        private EmptyRetriever() {
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException, CancelledException {
        }
    }

    private static class EntrySelectRetriever
    extends AbstractRetriever {
        private Mode mode;

        public EntrySelectRetriever(Mode mode) {
            this.mode = mode;
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException, CancelledException {
            Collection<Entry> entries;
            switch (this.mode) {
                case KEYS: {
                    entries = view.getSelectedDatabase().getPersonalCerts();
                    break;
                }
                default: {
                    entries = view.getSelectedDatabase().getSignerCerts();
                }
            }
            String selection = KeySelectDialog.getSingleSelection(parent, view.getSelectedDatabase().getDescriptor().getFileNameString(), entries);
            map.put(Constants.Parameter.KeyAlias, selection);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Mode {
            KEYS,
            SIGNERS;

        }
    }

    private static class ExistingSourceDbRetriever
    extends AbstractRetriever {
        private ExistingSourceDbRetriever() {
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException, CancelledException {
            if (view.getSelectedDatabase() == null) {
                throw new CancelledException();
            }
            map.putAll(view.getSelectedDatabase().getDatabaseParameters(false));
        }
    }

    private static class ExportRetriever
    extends ImportRetriever {
        private ExportRetriever() {
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException, CancelledException {
            map.putAll(FileNameDialog.getFileData(parent, GUIConstants.DialogMode.Open, FileNamePanelFactory.PanelType.ExportImport, ExportRetriever.getDatabaseFileName(view)));
            if (map.getCommandType().equals(Constants.CommandType.ImportCertRename)) {
                this.getImportParameters(view, parent, map);
            } else {
                this.getExportParameters(view, parent, map);
            }
        }

        private void getExportParameters(KeymanView view, Frame parent, ParameterMap params) throws KeyManagerException, CancelledException {
            params.put(Constants.Parameter.Label, view.getSelectedEntry().getLabel());
            params.putAll(view.getSelectedDatabase().getDatabaseParameters(false));
            File targetFile = new File((String)params.get(Constants.Parameter.Target));
            if (targetFile.exists()) {
                int result = view.showConfirmation(Messages.getString("Question.UpdateExistingFile"), Messages.getString("GUI.Title.Confirm"), 0);
                if (result == 0) {
                    return;
                }
                throw new CancelledException();
            }
        }
    }

    private static class ExportSecretKeyRetriever
    extends FileRetriever {
        private ExportSecretKeyRetriever() {
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException, CancelledException {
            map.putAll(FileNameDialog.getFileData(parent, GUIConstants.DialogMode.New, FileNamePanelFactory.PanelType.SecretKey, ExportSecretKeyRetriever.getDatabaseFileName(view)));
        }
    }

    private static abstract class FileRetriever
    extends AbstractRetriever {
        private FileRetriever() {
        }

        protected static FileName getDatabaseFileName(KeymanView view) {
            if (view.getSelectedDatabase() == null) {
                String defaultLocation = KeymanSettings.Setting.DefaultFileLocation.getString();
                if (!defaultLocation.endsWith(".")) {
                    defaultLocation = defaultLocation + "/.";
                }
                return new FileName(defaultLocation);
            }
            return view.getSelectedDatabase().getDescriptor().getFileName();
        }
    }

    private static class GenericFileRetriever
    extends FileRetriever {
        private GUIConstants.DialogMode mode;
        private FileNamePanelFactory.PanelType panel;

        public GenericFileRetriever(GUIConstants.DialogMode mode, FileNamePanelFactory.PanelType panel) {
            this.mode = mode;
            this.panel = panel;
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException, CancelledException {
            map.putAll(FileNameDialog.getFileData(parent, this.mode, this.panel, GenericFileRetriever.getDatabaseFileName(view)));
        }
    }

    private static class ImportRetriever
    extends FileRetriever {
        private ImportRetriever() {
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException, CancelledException {
            map.putAll(FileNameDialog.getFileData(parent, GUIConstants.DialogMode.Open, FileNamePanelFactory.PanelType.Import, ImportRetriever.getDatabaseFileName(view)));
            this.getImportParameters(view, parent, map);
        }

        protected void getImportParameters(KeymanView view, Frame parent, ParameterMap params) throws KeyManagerException, CancelledException {
            params.putAll(view.getSelectedDatabase().getDatabaseParameters(true));
            KeyStoreItemRetriever retriever = new KeyStoreItemRetriever();
            ParameterMap tempMap = new ParameterMap();
            tempMap.put(Constants.CommandType.LoadDB);
            tempMap.put(Constants.Parameter.DatabaseName, params.get(Constants.Parameter.DatabaseName));
            tempMap.put(Constants.Parameter.Type, params.get(Constants.Parameter.Type));
            KeymanController.Invoker.invoke(tempMap, retriever, null);
            if (retriever.getKeyStoreItem() == null) {
                throw new CancelledException();
            }
            LabelMap labelMap = KeySelectDialog.getLabelMap(view, parent, retriever.getKeyStoreItem().getDescriptor().getFileNameString(), retriever.getKeyStoreItem().getCertificates(), false);
            params.put(Constants.Parameter.Password, retriever.getKeyStoreItem().getDescriptor().getPassword());
            params.put(Constants.Parameter.LabelMap, labelMap);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void getParametersAfterError(KeymanView view, Frame parent, ParameterMap map, KeyManagerException lastException) throws KeyManagerException, CancelledException {
            if (map.getCommandType().equals(Constants.CommandType.ImportCertRename)) {
                if (lastException.getReason() != KeyManagerException.ExceptionReason.ENTRY_EXISTS_FOR_LABEL) throw new CancelledException();
                LabelMap currentMap = (LabelMap)map.get(Constants.Parameter.LabelMap);
                LabelMap labelMap = KeySelectDialog.getLabelMap((Frame)((Object)view), currentMap);
                map.put(Constants.Parameter.LabelMap, labelMap);
                return;
            } else {
                super.getParametersAfterError(view, parent, map, lastException);
            }
        }
    }

    private static class ImportSecretKeyRetriever
    extends FileRetriever {
        private ImportSecretKeyRetriever() {
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException, CancelledException {
            map.putAll(FileNameDialog.getFileData(parent, GUIConstants.DialogMode.Open, FileNamePanelFactory.PanelType.SecretKey, ImportSecretKeyRetriever.getDatabaseFileName(view)));
        }
    }

    private static class KeyStoreItemRetriever
    implements KeyManagerEventListener {
        private KeyStoreInfo item;

        private KeyStoreItemRetriever() {
        }

        public KeyStoreInfo getKeyStoreItem() {
            return this.item;
        }

        public void databaseChanged(KeyManagerEvent e) {
        }

        public void databaseClosed(KeyManagerEvent e) {
        }

        public void databaseOpened(KeyManagerEvent e) {
            this.item = e.getKeyStoreInfo();
        }

        public void providerAdded(ProviderEvent e) {
        }
    }

    private static class LabelSelectRetriever
    extends FileRetriever {
        private LabelSelectRetriever() {
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException, CancelledException {
            String certFile = (String)map.get(Constants.Parameter.File);
            LabelMap labelMap = KeySelectDialog.getLabelMap(view, parent, certFile, EntryFactory.loadCertificateItems(certFile, KeymanUtil.getJCEProviderName()), true);
            map.put(Constants.Parameter.LabelMap, labelMap);
        }
    }

    private static class PasswordValidator
    extends AbstractRetriever {
        private String message;

        public PasswordValidator(String message) {
            this.message = message;
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException, CancelledException {
            int result;
            if (!view.getSelectedDatabase().getDescriptor().isPasswordProtected() && (result = view.showConfirmation(this.message, Messages.getString("GUI.Title.Confirm"), 0)) == 1) {
                throw new CancelledException();
            }
        }
    }

    private static class PromptLoadDbRetriever
    extends FileRetriever {
        private PromptLoadDbRetriever() {
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException, CancelledException {
            if (view.getSelectedDatabase() != null) {
                ParameterMap tempMap = view.getSelectedDatabase().getDatabaseParameters(false);
                tempMap.put(Constants.CommandType.CloseDb);
                KeymanController.Invoker.invoke(tempMap, null, null);
            }
            map.putAll(FileNameDialog.getFileData(parent, GUIConstants.DialogMode.Open, FileNamePanelFactory.PanelType.Database, PromptLoadDbRetriever.getDatabaseFileName(view)));
            if (map.containsKey(Constants.Parameter.Crypto)) {
                String crypto = map.get(Constants.Parameter.Crypto).toString();
                Constants.DatabaseType type = crypto.equals("") ? Constants.DatabaseType.PKCS11Config : Constants.DatabaseType.PKCS11Direct;
                ParameterMap tokenData = CryptoTokenDialog.getTokenData(parent, PromptLoadDbRetriever.getDatabaseFileName(view), type, crypto);
                if (tokenData.containsOption(Constants.Option.NewSecondaryDb)) {
                    ParameterMap newDbMap = new ParameterMap();
                    newDbMap.put(Constants.Parameter.DatabaseName, tokenData.get(Constants.Parameter.SecondaryDb));
                    newDbMap.put(Constants.Parameter.Type, tokenData.get(Constants.Parameter.SecondaryDbType));
                    newDbMap.put(Constants.CommandType.CreateDB);
                    KeyStoreItemRetriever retriever = new KeyStoreItemRetriever();
                    KeymanController.Invoker.invoke(newDbMap, retriever, view);
                    tokenData.put(Constants.Parameter.SecondaryDbPassword, retriever.getKeyStoreItem().getDescriptor().getPassword());
                }
                map.putAll(tokenData);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void getParametersAfterError(KeymanView view, Frame parent, ParameterMap map, KeyManagerException lastException) throws KeyManagerException, CancelledException {
            if (lastException.getReason() == KeyManagerException.ExceptionReason.INVALID_PASSWORD) {
                ParameterMap passwordMap = PasswordPromptDialog.getPasswordData(parent, (Constants.DatabaseType)map.get(Constants.Parameter.Type), Constants.Parameter.Password, GUIConstants.DialogMode.Open);
                map.putAll(passwordMap);
                return;
            } else {
                if (lastException.getReason() != KeyManagerException.ExceptionReason.DATABASE_PASSWORD_EXPIRED) throw new CancelledException();
                int result = view.showConfirmation(Messages.getString("Question.ChangePassword"), Messages.getString("GUI.Title.Confirm"), 0);
                if (result != 0) throw new CancelledException();
                ParameterMap passwordMap = PasswordPromptDialog.getPasswordData(parent, (Constants.DatabaseType)map.get(Constants.Parameter.Type), Constants.Parameter.NewPassword, GUIConstants.DialogMode.New);
                ParameterMap changePwMap = new ParameterMap();
                changePwMap.putAll(passwordMap);
                changePwMap.putAll(map);
                changePwMap.put(Constants.CommandType.ChangeDBPassword);
                KeymanController.Invoker.invoke(changePwMap, null, null);
                map.put(Constants.Parameter.Password, passwordMap.get(Constants.Parameter.NewPassword));
            }
        }
    }

    private static class PromptNewDbRetriever
    extends FileRetriever {
        private PromptNewDbRetriever() {
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException, CancelledException {
            map.putAll(FileNameDialog.getFileData(parent, GUIConstants.DialogMode.New, FileNamePanelFactory.PanelType.Database, PromptNewDbRetriever.getDatabaseFileName(view)));
        }
    }

    private static class QueryLabelRetriever
    extends AbstractRetriever {
        private QueryLabelRetriever() {
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException, CancelledException {
            String label = null;
            label = view.getInput(Messages.getString("Label.EnterNewLabel"), Messages.getString("GUI.Title.EnterLabel"), "");
            map.put(Constants.Parameter.NewLabel, label);
        }

        public void getParametersAfterError(KeymanView view, Frame parent, ParameterMap map, KeyManagerException lastException) throws KeyManagerException, CancelledException {
            if (lastException.getReason() != KeyManagerException.ExceptionReason.ENTRY_EXISTS_FOR_LABEL) {
                throw new CancelledException();
            }
            String label = null;
            String currentLabel = (String)map.get(Constants.Parameter.NewLabel);
            label = view.getInput(Messages.getString("Label.EnterNewLabel"), Messages.getString("GUI.Title.EnterLabel"), currentLabel);
            map.put(Constants.Parameter.NewLabel, label);
        }
    }

    public static interface Retriever {
        public void getParameters(KeymanView var1, Frame var2, ParameterMap var3) throws KeyManagerException, CancelledException;

        public void getParametersAfterError(KeymanView var1, Frame var2, ParameterMap var3, KeyManagerException var4) throws KeyManagerException, CancelledException;
    }

    private static class SecretKeyDataRetriever
    extends AbstractRetriever {
        private SecretKeyDataRetriever() {
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException, CancelledException {
            CertificateDataDialog.getData(parent, InputPanelFactory.InputDialogType.SecretKey, view.getSelectedDatabase(), false, map);
        }

        public void getParametersAfterError(KeymanView view, Frame parent, ParameterMap map, KeyManagerException lastException) throws KeyManagerException, CancelledException {
            CertificateDataDialog.getData(parent, InputPanelFactory.InputDialogType.SecretKey, view.getSelectedDatabase(), true, map);
        }
    }

    private static class SelectedLabelRetriever
    extends AbstractRetriever {
        private Constants.Parameter param;

        public SelectedLabelRetriever(Constants.Parameter param) {
            this.param = param;
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException {
            Entry selectedEntry = view.getSelectedEntry();
            map.put(this.param, selectedEntry.getLabel());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SelectedLabelsRetriever
    extends AbstractRetriever {
        private static final String COLLECTION_DELIMITER = ", ";
        private Constants.Parameter param;

        public SelectedLabelsRetriever(Constants.Parameter param) {
            this.param = param;
        }

        @Override
        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException {
            Collection<Entry> selectedEntries = view.getSelectedEntries();
            map.put(this.param, SelectedLabelsRetriever.collectionToString(selectedEntries));
        }

        public static String collectionToString(Collection<Entry> col) {
            StringBuffer buf = new StringBuffer();
            for (Entry obj : col) {
                buf.append(obj.getLabel()).append(COLLECTION_DELIMITER);
            }
            return buf.toString().substring(0, buf.length() - COLLECTION_DELIMITER.length());
        }
    }

    private static class SignerSelectRetriever
    extends AbstractRetriever {
        private SignerSelectRetriever() {
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException, CancelledException {
            map.putAll(SignerSelectDialog.getData(parent));
        }
    }

    private static class SourceDbRetriever
    extends AbstractRetriever {
        private SourceDbRetriever() {
        }

        public void getParameters(KeymanView view, Frame parent, ParameterMap map) throws KeyManagerException {
            map.putAll(view.getSelectedDatabase().getDatabaseParameters(false));
        }
    }
}

