/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command.cli;

import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.cli.TokeniserFactory;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.util.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractorFactory {
    public static Extractor<Constants.Parameter, TokeniserFactory.Token<String>> newUnaryExtractor(Constants.Parameter param, Object valueIfPresent) {
        return new UnaryParameterExtractor(param, valueIfPresent);
    }

    public static Extractor<Constants.Parameter, TokeniserFactory.Token<String>> newBinaryExtractor(Constants.Parameter param) {
        return new BinaryParameterExtractor(param);
    }

    public static Extractor<Constants.Parameter, TokeniserFactory.Token<String>> newOptionalBinaryExtractor(Constants.Parameter param, Object defaultValue) {
        return new OptionalBinaryParameterExtractor(param, defaultValue);
    }

    public static Extractor<Constants.Parameter, TokeniserFactory.Token<String>> newMultiExtractor(Constants.Parameter param, Constants.Parameter ... params) {
        return new MultiOccurenceExtractor(param, params);
    }

    public static Extractor<Constants.Parameter, TokeniserFactory.Token<String>> newTaglessExtractor(Constants.Parameter param, Map<String, ? extends Object> values) {
        return new TagLessExtractor(param, values);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BinaryParameterExtractor
    extends ParameterExtractor {
        public BinaryParameterExtractor(Constants.Parameter param) {
            super(param);
        }

        @Override
        public void extract(Stack<TokeniserFactory.Token<String>> stack, ParameterMap map) throws KeyManagerException {
            Debug.entering(stack, map);
            if (!this.canExtract(stack.peek())) {
                throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_EXTRACTION_INVOKATION, stack.peek().getTag());
            }
            TokeniserFactory.Token<String> token = stack.pop();
            if (token.getData().isEmpty()) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.MISSING_VALUE_FOR_PARAMETER, this.param.toString());
            }
            if (token.getData().size() > 1) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.TOO_MANY_VALUES_FOR_TAG, this.param.toString(), token.getData().toString());
            }
            this.add(map, token.getData().get(0));
            Debug.exiting();
        }

        protected void add(ParameterMap map, Object value) throws KeyManagerException {
            if (map.containsKey(this.param)) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.TOO_MANY_PARAMETERS_FOR_TAG, this.param.toString(), "1");
            }
            map.put(this.param, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Extractor<T, F> {
        public boolean canExtract(F var1);

        public void extract(Stack<F> var1, ParameterMap var2) throws KeyManagerException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiOccurenceExtractor
    extends ParameterExtractor {
        protected List<Constants.Parameter> params = new ArrayList<Constants.Parameter>();

        public MultiOccurenceExtractor(Constants.Parameter param, Constants.Parameter ... params) {
            super(param);
            this.params.add(param);
            this.params.addAll(Arrays.asList(params));
        }

        @Override
        public void extract(Stack<TokeniserFactory.Token<String>> stack, ParameterMap map) throws KeyManagerException {
            Debug.entering(stack, map);
            if (!this.canExtract(stack.peek())) {
                throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_EXTRACTION_INVOKATION, stack.peek().getTag());
            }
            TokeniserFactory.Token<String> token = stack.pop();
            Constants.Parameter nextParam = this.getNextParameter(map);
            if (token.getData().isEmpty()) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.MISSING_VALUE_FOR_PARAMETER, this.param.toString());
            }
            if (token.getData().size() > 1) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.TOO_MANY_VALUES_FOR_TAG, this.param.toString(), token.getData().toString());
            }
            map.put(nextParam, token.getData().get(0));
            Debug.exiting();
        }

        private Constants.Parameter getNextParameter(ParameterMap map) throws KeyManagerException {
            Debug.entering(map);
            for (Constants.Parameter param : this.params) {
                if (map.containsKey(param)) continue;
                Debug.exiting(param);
                return param;
            }
            throw new KeyManagerException(KeyManagerException.ExceptionReason.TOO_MANY_PARAMETERS_FOR_TAG, this.param.toString(), this.params.size() + "");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OptionalBinaryParameterExtractor
    extends BinaryParameterExtractor {
        private Object defaultValue;

        public OptionalBinaryParameterExtractor(Constants.Parameter param, Object defaultValue) {
            super(param);
            this.defaultValue = defaultValue;
        }

        @Override
        public void extract(Stack<TokeniserFactory.Token<String>> stack, ParameterMap map) throws KeyManagerException {
            try {
                super.extract(stack, map);
            }
            catch (KeyManagerException e) {
                if (e.getReason() == KeyManagerException.ExceptionReason.MISSING_VALUE_FOR_PARAMETER) {
                    this.add(map, this.defaultValue);
                }
                throw e;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ParameterExtractor
    implements Extractor<Constants.Parameter, TokeniserFactory.Token<String>> {
        protected Constants.Parameter param;

        public ParameterExtractor(Constants.Parameter param) {
            this.param = param;
        }

        @Override
        public boolean canExtract(TokeniserFactory.Token<String> nextObject) {
            Debug.entering(nextObject);
            boolean returnValue = nextObject.getTag().toLowerCase(Locale.US).equals(this.param.toString().toLowerCase(Locale.US));
            Debug.exiting(returnValue);
            return returnValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TagLessExtractor
    extends ParameterExtractor {
        private Map<String, ? extends Object> values;

        public TagLessExtractor(Constants.Parameter param, Map<String, ? extends Object> values) {
            super(param);
            this.values = values;
        }

        @Override
        public void extract(Stack<TokeniserFactory.Token<String>> stack, ParameterMap map) throws KeyManagerException {
            Debug.entering(stack, map);
            if (!this.canExtract(stack.peek())) {
                throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_EXTRACTION_INVOKATION, stack.peek().getTag());
            }
            TokeniserFactory.Token<String> token = stack.pop();
            map.put(this.param, this.values.get(token.getTag()));
            Debug.exiting();
        }

        @Override
        public boolean canExtract(TokeniserFactory.Token<String> nextObject) {
            Debug.entering(nextObject);
            boolean returnValue = this.values.containsKey(nextObject.getTag());
            Debug.exiting(returnValue);
            return returnValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnaryParameterExtractor
    extends ParameterExtractor {
        private Object valueIfPresent;

        public UnaryParameterExtractor(Constants.Parameter param, Object valueIfPresent) {
            super(param);
            this.valueIfPresent = valueIfPresent;
        }

        @Override
        public void extract(Stack<TokeniserFactory.Token<String>> stack, ParameterMap map) throws KeyManagerException {
            Debug.entering(stack, map);
            if (!this.canExtract(stack.peek())) {
                throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.INVALID_EXTRACTION_INVOKATION, stack.peek().getTag());
            }
            stack.pop();
            map.put(this.param, this.valueIfPresent);
            Debug.exiting();
        }
    }
}

