/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserFactory {
    private static Map<Class<?>, Parser<?>> stringOrTypeParsers = new HashMap();
    private static Map<Class<?>, Parser<?>> delegateParsers = new HashMap();
    private static Map<Class<?>, Parser<?>> castParsers = new HashMap();

    public static <T> Parser<?> getStringOrTypeParser(Class<T> instanceT) {
        if (!stringOrTypeParsers.containsKey(instanceT)) {
            ParserCollection parser = new ParserCollection(new StringConstructorParser<T>(instanceT), new CastParser<T>(instanceT));
            stringOrTypeParsers.put(instanceT, parser);
        }
        return stringOrTypeParsers.get(instanceT);
    }

    public static Parser<?> getIntegerRangeParser(Integer lower, Integer upper) {
        Parser<?> parser = ParserFactory.getStringOrTypeParser(Integer.class);
        return new ValidatingParser<Integer>(parser, new RangeValidator(lower, upper));
    }

    public static <F, T> Parser<?> getDelegateParser(Class<T> instanceT, ParserDelegate<T> delegate) {
        if (!delegateParsers.containsKey(instanceT)) {
            ParserCollection parser = new ParserCollection(new ParserDelegateParser<T>(instanceT, delegate), new CastParser<T>(instanceT));
            delegateParsers.put(instanceT, parser);
        }
        return delegateParsers.get(instanceT);
    }

    public static <T> Parser<?> getCastParser(Class<T> instanceT) {
        if (!castParsers.containsKey(instanceT)) {
            ParserCollection parser = new ParserCollection(new CastParser<T>(instanceT));
            castParsers.put(instanceT, parser);
        }
        return castParsers.get(instanceT);
    }

    public static <F, T> Parser<T> getMapParser(Class<T> instanceT, Class<F> instanceF, Map<F, T> conversionMap) {
        return new ParserCollection(new MapParser<F, T>(instanceT, instanceF, conversionMap), new CastParser<T>(instanceT));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractParserItem<F, T>
    implements ParserItem<T> {
        protected Class<T> instanceT;
        protected Class<F> instanceF;

        public AbstractParserItem(Class<T> instanceT, Class<F> instanceF) {
            this.instanceT = instanceT;
            this.instanceF = instanceF;
        }

        @Override
        public boolean canParse(Object obj) {
            try {
                this.instanceF.cast(obj);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public Collection<? extends String> getValidValues() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CastParser<T>
    extends AbstractParserItem<Object, T> {
        public CastParser(Class<T> instanceT) {
            super(instanceT, Object.class);
        }

        @Override
        public T parse(Object value) {
            return this.instanceT.cast(value);
        }

        @Override
        public Collection<? extends String> getValidValues() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapParser<F, T>
    extends AbstractParserItem<F, T> {
        private final Map<F, T> conversionMap;

        public MapParser(Class<T> instanceT, Class<F> instanceF, Map<F, T> conversionMap) {
            super(instanceT, instanceF);
            this.conversionMap = conversionMap;
        }

        @Override
        public T parse(Object value) throws KeyManagerException {
            if (this.conversionMap.containsKey(value)) {
                return this.conversionMap.get(value);
            }
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_VALUE_FOR_PARAMETER, this.conversionMap.keySet().toString(), value.toString());
        }

        @Override
        public Collection<? extends String> getValidValues() {
            Set<F> keys = this.conversionMap.keySet();
            ArrayList<String> returnList = new ArrayList<String>();
            for (F key : keys) {
                returnList.add(key.toString());
            }
            return returnList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ParseValidator<T> {
        public void validate(T var1) throws KeyManagerException;

        public String getValidValues();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Parser<T> {
        public T parse(Object var1) throws KeyManagerException;

        public String getValidValues();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParserCollection<T>
    implements Parser<T> {
        private List<ParserItem<T>> parsers;

        public ParserCollection(ParserItem<T> ... parsers) {
            this.parsers = Arrays.asList(parsers);
        }

        @Override
        public T parse(Object value) throws KeyManagerException {
            for (ParserItem<T> item : this.parsers) {
                if (!item.canParse(value)) continue;
                return item.parse(value);
            }
            throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.NO_SUITABLE_PARSER, value.getClass().toString());
        }

        @Override
        public String getValidValues() {
            ArrayList<String> returnList = new ArrayList<String>();
            for (ParserItem<T> parserItem : this.parsers) {
                Collection<String> validValues = parserItem.getValidValues();
                if (validValues == null) continue;
                returnList.addAll(validValues);
            }
            return this.makeValidValuesString(returnList);
        }

        private String makeValidValuesString(List<String> list) {
            if (list.size() == 0) {
                return "";
            }
            StringBuffer returnString = new StringBuffer();
            returnString.append("<");
            for (int i = 0; i < list.size(); ++i) {
                returnString.append(list.get(i));
                if (i == list.size() - 1) continue;
                returnString.append(" | ");
            }
            returnString.append(">");
            return returnString.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ParserDelegate<T> {
        public T parse(String var1) throws KeyManagerException;

        public Collection<? extends String> getValidValues();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParserDelegateParser<T>
    extends AbstractParserItem<String, T> {
        private ParserDelegate<T> delegate;

        public ParserDelegateParser(Class<T> instanceT, ParserDelegate<T> delegate) {
            super(instanceT, String.class);
            this.delegate = delegate;
        }

        @Override
        public T parse(Object value) throws KeyManagerException {
            return this.delegate.parse(value.toString());
        }

        @Override
        public Collection<? extends String> getValidValues() {
            return this.delegate.getValidValues();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ParserItem<T> {
        public boolean canParse(Object var1);

        public T parse(Object var1) throws KeyManagerException;

        public Collection<? extends String> getValidValues();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RangeValidator
    implements ParseValidator<Integer> {
        private Integer lower;
        private Integer upper;

        public RangeValidator(Integer lower, Integer upper) {
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public String getValidValues() {
            return "<" + this.lower + " - " + this.upper + ">";
        }

        @Override
        public void validate(Integer obj) throws KeyManagerException {
            if (obj < this.lower || obj > this.upper) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_VALUE_FOR_PARAMETER, this.getValidValues(), obj.toString());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringConstructorParser<T>
    extends AbstractParserItem<String, T> {
        private Constructor<T> constructor;

        public StringConstructorParser(Class<T> instanceT) {
            super(instanceT, String.class);
            try {
                this.constructor = instanceT.getConstructor(String.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public T parse(Object value) throws KeyManagerException {
            try {
                return this.constructor.newInstance(value);
            }
            catch (Exception e) {
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    if (cause instanceof KeyManagerException) {
                        KeyManagerException temp = (KeyManagerException)cause;
                        throw new KeyManagerException(temp.getReason(), (Throwable)e, temp.getDetails());
                    }
                    if (!(cause instanceof NumberFormatException)) continue;
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_NUMBER_FORMAT, (Throwable)e);
                }
                throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.OBJECT_CONSTRUCTION_ERROR, (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValidatingParser<T>
    implements Parser<T> {
        private Parser<T> parser;
        private ParseValidator<T> validator;

        public ValidatingParser(Parser<T> parser, ParseValidator<T> validator) {
            this.parser = parser;
            this.validator = validator;
        }

        @Override
        public String getValidValues() {
            return this.validator.getValidValues();
        }

        @Override
        public T parse(Object value) throws KeyManagerException {
            T parsedValue = this.parser.parse(value);
            this.validator.validate(parsedValue);
            return parsedValue;
        }
    }
}

