/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.CMSPrivateKey;
import java.math.BigInteger;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAMultiPrimePrivateCrtKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.RSAOtherPrimeInfo;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;

public class CMSPrivateKeyFactory {
    public static CMSPrivateKey newCMSPrivateKey(PrivateKey key, boolean isDefault) throws KeyStoreException {
        if (key instanceof RSAPrivateCrtKey) {
            return new CMSPrivateKeyRSACrtImpl((RSAPrivateCrtKey)key, isDefault);
        }
        if (key instanceof RSAPrivateKey) {
            return new CMSPrivateKeyRSAImpl((RSAPrivateKey)key, isDefault);
        }
        if (key instanceof RSAMultiPrimePrivateCrtKey) {
            return new CMSPrivateKeyRSAMultiPrimeImpl((RSAMultiPrimePrivateCrtKey)key, isDefault);
        }
        if (key instanceof ECPrivateKey) {
            return new CMSPrivateKeyECImpl((ECPrivateKey)key, isDefault);
        }
        if (key instanceof DSAPrivateKey) {
            return new CMSPrivateKeyDSAImpl((DSAPrivateKey)key, isDefault);
        }
        if (key instanceof DHPrivateKey) {
            return new CMSPrivateKeyDHImpl((DHPrivateKey)key, isDefault);
        }
        throw new KeyStoreException("Invalid PrivateKey type " + key.getClass());
    }

    private static class CMSPrivateKeyDHImpl
    extends CMSPrivateKeyImpl
    implements DHPrivateKey {
        public CMSPrivateKeyDHImpl(DHPrivateKey key, boolean defaultKey) {
            super(key, defaultKey);
        }

        private DHPrivateKey getKey() {
            return (DHPrivateKey)this.getPrivateKey();
        }

        public BigInteger getX() {
            return this.getKey().getX();
        }

        public DHParameterSpec getParams() {
            return this.getKey().getParams();
        }
    }

    private static class CMSPrivateKeyDSAImpl
    extends CMSPrivateKeyImpl
    implements DSAPrivateKey {
        public CMSPrivateKeyDSAImpl(DSAPrivateKey key, boolean defaultKey) {
            super(key, defaultKey);
        }

        private DSAPrivateKey getKey() {
            return (DSAPrivateKey)this.getPrivateKey();
        }

        public BigInteger getX() {
            return this.getKey().getX();
        }

        public DSAParams getParams() {
            return this.getKey().getParams();
        }
    }

    private static class CMSPrivateKeyECImpl
    extends CMSPrivateKeyImpl
    implements ECPrivateKey {
        public CMSPrivateKeyECImpl(ECPrivateKey key, boolean defaultKey) {
            super(key, defaultKey);
        }

        private ECPrivateKey getKey() {
            return (ECPrivateKey)this.getPrivateKey();
        }

        public BigInteger getS() {
            return this.getKey().getS();
        }

        public ECParameterSpec getParams() {
            return this.getKey().getParams();
        }
    }

    private static abstract class CMSPrivateKeyImpl
    implements CMSPrivateKey {
        private boolean defaultKey;
        private PrivateKey key;

        public CMSPrivateKeyImpl(PrivateKey key, boolean defaultKey) {
            this.key = key;
            this.defaultKey = defaultKey;
        }

        public boolean isDefault() {
            return this.defaultKey;
        }

        public void setDefault(boolean isDefault) {
            this.defaultKey = isDefault;
        }

        public String getAlgorithm() {
            return this.getPrivateKey().getAlgorithm();
        }

        public byte[] getEncoded() {
            return this.getPrivateKey().getEncoded();
        }

        public String getFormat() {
            return this.getPrivateKey().getFormat();
        }

        protected final PrivateKey getPrivateKey() {
            return this.key;
        }
    }

    private static class CMSPrivateKeyRSACrtImpl
    extends CMSPrivateKeyRSAImpl
    implements RSAPrivateCrtKey {
        public CMSPrivateKeyRSACrtImpl(RSAPrivateCrtKey key, boolean defaultKey) {
            super(key, defaultKey);
        }

        private RSAPrivateCrtKey getKey() {
            return (RSAPrivateCrtKey)this.getPrivateKey();
        }

        public BigInteger getCrtCoefficient() {
            return this.getKey().getCrtCoefficient();
        }

        public BigInteger getPrimeExponentP() {
            return this.getKey().getPrimeExponentP();
        }

        public BigInteger getPrimeExponentQ() {
            return this.getKey().getPrimeExponentQ();
        }

        public BigInteger getPrimeP() {
            return this.getKey().getPrimeP();
        }

        public BigInteger getPrimeQ() {
            return this.getKey().getPrimeQ();
        }

        public BigInteger getPublicExponent() {
            return this.getKey().getPublicExponent();
        }
    }

    private static class CMSPrivateKeyRSAImpl
    extends CMSPrivateKeyImpl
    implements RSAPrivateKey {
        public CMSPrivateKeyRSAImpl(RSAPrivateKey key, boolean defaultKey) {
            super(key, defaultKey);
        }

        private RSAPrivateKey getKey() {
            return (RSAPrivateKey)this.getPrivateKey();
        }

        public BigInteger getPrivateExponent() {
            return this.getKey().getPrivateExponent();
        }

        public BigInteger getModulus() {
            return this.getKey().getModulus();
        }
    }

    private static class CMSPrivateKeyRSAMultiPrimeImpl
    extends CMSPrivateKeyRSAImpl
    implements RSAMultiPrimePrivateCrtKey {
        public CMSPrivateKeyRSAMultiPrimeImpl(RSAMultiPrimePrivateCrtKey key, boolean defaultKey) {
            super(key, defaultKey);
        }

        private RSAMultiPrimePrivateCrtKey getKey() {
            return (RSAMultiPrimePrivateCrtKey)this.getPrivateKey();
        }

        public BigInteger getCrtCoefficient() {
            return this.getKey().getCrtCoefficient();
        }

        public RSAOtherPrimeInfo[] getOtherPrimeInfo() {
            return this.getKey().getOtherPrimeInfo();
        }

        public BigInteger getPrimeExponentP() {
            return this.getKey().getPrimeExponentP();
        }

        public BigInteger getPrimeExponentQ() {
            return this.getKey().getPrimeExponentQ();
        }

        public BigInteger getPrimeP() {
            return this.getKey().getPrimeP();
        }

        public BigInteger getPrimeQ() {
            return this.getKey().getPrimeQ();
        }

        public BigInteger getPublicExponent() {
            return this.getKey().getPublicExponent();
        }
    }
}

