/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.Buffer;
import com.ibm.security.cmskeystore.BufferFactory;
import com.ibm.security.cmskeystore.ByteSequenceXorFactory;
import com.ibm.security.cmskeystore.CACertificates;
import com.ibm.security.cmskeystore.CMSCertificate;
import com.ibm.security.cmskeystore.CMSLoadParameter;
import com.ibm.security.cmskeystore.CMSPrivateKey;
import com.ibm.security.cmskeystore.CMSPrivateKeyFactory;
import com.ibm.security.cmskeystore.CMSStoreParameter;
import com.ibm.security.cmskeystore.DatabaseHashGeneratorFactory;
import com.ibm.security.cmskeystore.FileHeader;
import com.ibm.security.cmskeystore.FileHeaderFactory;
import com.ibm.security.cmskeystore.FileHeaderHashGeneratorFactory;
import com.ibm.security.cmskeystore.FileType;
import com.ibm.security.cmskeystore.IntableByteSequence;
import com.ibm.security.cmskeystore.IntableByteSequenceFactory;
import com.ibm.security.cmskeystore.KeyDatabase;
import com.ibm.security.cmskeystore.KeyDatabaseFactory;
import com.ibm.security.cmskeystore.MagicNumberValidatorFactory;
import com.ibm.security.cmskeystore.QueryableKeyDatabase;
import com.ibm.security.cmskeystore.QueryableKeyDatabaseFactory;
import com.ibm.security.cmskeystore.Record;
import com.ibm.security.cmskeystore.RecordDataHashGenerator;
import com.ibm.security.cmskeystore.RecordDataHashGeneratorFactory;
import com.ibm.security.cmskeystore.RecordEncoding;
import com.ibm.security.cmskeystore.RecordEncodingFactory;
import com.ibm.security.cmskeystore.RecordFactory;
import com.ibm.security.cmskeystore.RecordFlag;
import com.ibm.security.cmskeystore.StashedPasswordProtection;
import com.ibm.security.cmskeystore.VersionNumber;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.sequence.Sequence;
import com.ibm.security.sequence.SequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMSKeyStoreSpi
extends KeyStoreSpi {
    private int FIXED_RECORD_LENGTH = 5000;
    private static final IntableByteSequence ZERO = IntableByteSequenceFactory.newIntableByteSequence(ByteSequenceFactory.newConstantByteSequence((byte)0, 4));
    private static final IntableByteSequence ZERO_MD5_HASH = IntableByteSequenceFactory.newIntableByteSequence(ByteSequenceFactory.newConstantByteSequence((byte)0, 16));
    private static final IntableByteSequence ZERO_SHA1_HASH = IntableByteSequenceFactory.newIntableByteSequence(ByteSequenceFactory.newConstantByteSequence((byte)0, 20));
    private IntableByteSequence FIXED_RECORD_LENGTH_SEQUENCE = IntableByteSequenceFactory.newIntableByteSequence(this.FIXED_RECORD_LENGTH);
    private static final ByteSequence UNUSED_FILE_LABEL = ByteSequenceFactory.newConstantByteSequence((byte)0, 24);
    private static final String STASH_FILE_EXT = ".sth";
    private QueryableKeyDatabase cmsKeyDatabase;
    private Set<String> aliases;
    private String storePassword;
    static int version = 4;
    static boolean populate = true;
    static boolean tracing = false;
    static String traceFileName = null;
    private static PrintStream tStream = null;
    protected static String ALGORITHM_ID = "";

    static PasswordExtractor newPasswordExtractor(KeyStore.ProtectionParameter protParam) {
        if (protParam instanceof KeyStore.CallbackHandlerProtection) {
            return new PEFromCBHandler((KeyStore.CallbackHandlerProtection)protParam);
        }
        if (protParam instanceof KeyStore.PasswordProtection) {
            return new PEFromPwdProtection((KeyStore.PasswordProtection)protParam);
        }
        if (protParam instanceof StashedPasswordProtection) {
            return new PEFromStashedPwdProtection((StashedPasswordProtection)protParam);
        }
        return null;
    }

    private IntableByteSequence getFixedRecordLengthSequence() {
        if (this.FIXED_RECORD_LENGTH_SEQUENCE.toInt() != this.getFixedRecordLengh()) {
            this.FIXED_RECORD_LENGTH_SEQUENCE = IntableByteSequenceFactory.newIntableByteSequence(this.getFixedRecordLengh());
        }
        return this.FIXED_RECORD_LENGTH_SEQUENCE;
    }

    private String labelFromRecord(Record record) {
        String labelStr;
        Buffer label = record.getLabel();
        byte[] labelContent = new byte[label.getHeader().toInt()];
        try {
            label.getContent().getInputStream().read(labelContent);
            labelStr = new String(labelContent, "UTF-8");
        }
        catch (Throwable e) {
            labelStr = null;
        }
        return labelStr;
    }

    private void rebuildAliasesList() throws IOException {
        if (this.cmsKeyDatabase == null) {
            return;
        }
        this.aliases = null;
        this.aliases = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareToIgnoreCase(s2);
            }
        });
        Sequence<Record> records = this.cmsKeyDatabase.getRecords();
        for (Record record : records) {
            if (record.getRecordFlag() == RecordFlag.DELETED) continue;
            this.aliases.add(this.labelFromRecord(record));
        }
    }

    static void trace(String arg) {
        if (tracing) {
            if (tStream == null) {
                tStream = System.out;
                if (traceFileName != null) {
                    try {
                        tStream = new PrintStream(new FileOutputStream(traceFileName, true));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("Using System.out for trace");
                    }
                }
            }
            tStream.println(arg);
        }
    }

    public CMSKeyStoreSpi() {
        CMSKeyStoreSpi.trace("CMSKeyStoreSpi V" + version + " populate=" + populate);
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws UnrecoverableKeyException {
        CMSKeyStoreSpi.trace("engineGetKey(\"" + alias + "\", password)");
        if (!this.engineContainsAlias(alias)) {
            return null;
        }
        try {
            if (!this.cmsKeyDatabase.checkPassword(password)) {
                throw new UnrecoverableKeyException("Incorrect Password.");
            }
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnrecoverableKeyException("Error occured while checking the password validity: " + e.getMessage());
        }
        Record record = this.cmsKeyDatabase.getRecordByLabel(this.getCorrectCaseLabel(alias));
        if (record == null) {
            return null;
        }
        RecordEncoding encoding = record.getEncoding();
        if (!encoding.isPrivateKeyPresent()) {
            return null;
        }
        try {
            return encoding.getPrivateKey(password);
        }
        catch (Exception e) {
            throw new UnrecoverableKeyException("Error occured while extracting the private key: " + e.getMessage());
        }
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        CMSKeyStoreSpi.trace("engineGetCertificateChain(\"" + alias + "\")");
        if (!this.engineContainsAlias(alias)) {
            return null;
        }
        ArrayList<Certificate> chain = new ArrayList<Certificate>();
        int index = 0;
        try {
            Record issuerRecord;
            Record endEntityRecord = this.cmsKeyDatabase.getRecordByLabel(this.getCorrectCaseLabel(alias));
            CMSKeyStoreSpi.trace("# " + index + " \"" + this.labelFromRecord(endEntityRecord) + "\"");
            chain.add(index++, endEntityRecord.getEncoding().getCertificate());
            while ((issuerRecord = this.cmsKeyDatabase.getIssuerRecord(endEntityRecord)) != null && !issuerRecord.getSubjectNameHash().equals(endEntityRecord.getSubjectNameHash())) {
                endEntityRecord = issuerRecord;
                CMSKeyStoreSpi.trace("# " + index + " \"" + this.labelFromRecord(endEntityRecord) + "\"");
                chain.add(index++, endEntityRecord.getEncoding().getCertificate());
            }
        }
        catch (Exception e) {
            return null;
        }
        Certificate[] res = chain.toArray(new Certificate[index]);
        return res;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        CMSKeyStoreSpi.trace("engineGetCertificate(\"" + alias + "\")");
        if (!this.engineContainsAlias(alias)) {
            return null;
        }
        Record certRecord = this.cmsKeyDatabase.getRecordByLabel(this.getCorrectCaseLabel(alias));
        if (certRecord == null) {
            return null;
        }
        try {
            return certRecord.getEncoding().getCertificate();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        CMSKeyStoreSpi.trace("engineGetCreationDate(\"" + alias + "\")");
        return null;
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        String existingAlias;
        ByteSequence record;
        int id;
        CMSKeyStoreSpi.trace("engineSetKeyEntry(\"" + alias + "\", key, password, chain[" + (chain != null ? chain.length : 0) + "])");
        if (!key.getFormat().equals("PKCS#8")) {
            String msg = "This keystore allows only PKCS#8 encoded private keys";
            CMSKeyStoreSpi.trace(msg);
            throw new KeyStoreException(msg);
        }
        try {
            if (password != null && !this.cmsKeyDatabase.checkPassword(password)) {
                String msg = "Invalid password provided. Password must be null or the same as the KeyStore password.";
                CMSKeyStoreSpi.trace(msg);
                throw new KeyStoreException(msg);
            }
        }
        catch (Exception e) {
            String msg = "Error occurred while checking the password validity.";
            CMSKeyStoreSpi.trace(msg);
            throw new KeyStoreException(msg, e);
        }
        if (chain == null) {
            String msg = "Certificate chain must be provided for this keystore";
            CMSKeyStoreSpi.trace(msg);
            throw new KeyStoreException(msg);
        }
        for (int i = 0; i < chain.length; ++i) {
            if (chain[i] instanceof X509Certificate) continue;
            String msg = "One of the chain elements is not an X509Certificate";
            CMSKeyStoreSpi.trace(msg);
            throw new KeyStoreException(msg);
        }
        String signerAlias = null;
        RecordDataHashGenerator hashGen = RecordDataHashGeneratorFactory.newRecordDataHashGenerator();
        ArrayList<Record> records = new ArrayList<Record>(chain.length);
        boolean isDefault = false;
        if (key instanceof CMSPrivateKey) {
            isDefault = ((CMSPrivateKey)key).isDefault();
            CMSKeyStoreSpi.trace("isDefault = " + isDefault);
        }
        for (int i = chain.length - 1; i > 0; --i) {
            if (this.engineGetCertificateAlias(chain[i]) != null) continue;
            X500Principal x500name = ((X509Certificate)chain[i]).getSubjectX500Principal();
            if (x500name == null || x500name.toString().equals("")) {
                String msg = "The Subject DN of certificate #" + i + " is not in X.500 form";
                CMSKeyStoreSpi.trace(msg);
                throw new KeyStoreException(msg);
            }
            signerAlias = x500name.toString();
            if (this.engineContainsAlias(signerAlias)) {
                String msg = "A signer certificate with alias: " + signerAlias + " already exists but it contains a different public key";
                CMSKeyStoreSpi.trace(msg);
                throw new KeyStoreException(msg);
            }
            try {
                id = this.cmsKeyDatabase.getNextRecordID();
                byte[] signerAliasBytes = signerAlias.getBytes("UTF-8");
                ByteSequence aliasSeq = IntableByteSequenceFactory.newIntableByteSequence(signerAliasBytes.length).append(ByteSequenceFactory.newByteSequence(signerAliasBytes));
                X509Certificate certificate = (X509Certificate)chain[i];
                record = RecordFlag.CREATED.append(IntableByteSequenceFactory.newIntableByteSequence(id)).append(RecordEncodingFactory.newRecordEncoding(id, certificate, signerAlias, true)).append(BufferFactory.newBuffer(aliasSeq.getInputStream())).append(ZERO).append(hashGen.generateCertificateSignatureHash(certificate)).append(hashGen.generateTBSCertificateHash(certificate)).append(hashGen.generateSubjectNameHash(certificate)).append(hashGen.generateSubjectPublicKeyInfoHash(certificate)).append(hashGen.generateIssuerAndSerialNumberHash(certificate));
                records.add(RecordFactory.newRecord(record.getInputStream()));
                continue;
            }
            catch (Exception e) {
                String msg = "Error occurred while adding the certificate chain to KeyStore.";
                CMSKeyStoreSpi.trace(msg);
                throw new KeyStoreException(msg, e);
            }
        }
        try {
            byte[] aliasBytes = alias.getBytes("UTF-8");
            ByteSequence aliasSeq = IntableByteSequenceFactory.newIntableByteSequence(aliasBytes.length).append(ByteSequenceFactory.newByteSequence(aliasBytes));
            id = this.cmsKeyDatabase.getNextRecordID();
            X509Certificate certificate = (X509Certificate)chain[0];
            ByteSequence record2 = RecordFlag.CREATED.append(IntableByteSequenceFactory.newIntableByteSequence(id)).append(RecordEncodingFactory.newKeyRecordEncoding(id, certificate, (PrivateKey)key, this.storePassword.toCharArray(), alias, isDefault)).append(BufferFactory.newBuffer(aliasSeq.getInputStream())).append(ZERO).append(hashGen.generateCertificateSignatureHash(certificate)).append(hashGen.generateTBSCertificateHash(certificate)).append(hashGen.generateSubjectNameHash(certificate)).append(hashGen.generateSubjectPublicKeyInfoHash(certificate)).append(hashGen.generateIssuerAndSerialNumberHash(certificate));
            records.add(RecordFactory.newRecord(record2.getInputStream()));
        }
        catch (Exception e) {
            String msg = "Error occurred while adding the End Entity certificate to KeyStore.";
            CMSKeyStoreSpi.trace(msg);
            throw new KeyStoreException(msg, e);
        }
        if (this.engineContainsAlias(alias)) {
            this.engineDeleteEntry(alias);
        }
        if ((existingAlias = this.engineGetCertificateAlias(chain[0])) != null && !existingAlias.equalsIgnoreCase(alias)) {
            this.engineDeleteEntry(existingAlias);
        }
        try {
            String defaultAlias;
            if (isDefault && (defaultAlias = this.getDefaultKeyAlias()) != null) {
                Record currentDefaultRec = this.cmsKeyDatabase.getRecordByLabel(defaultAlias);
                int id2 = currentDefaultRec.getRecordId().toInt();
                X509Certificate cert = (X509Certificate)currentDefaultRec.getEncoding().getCertificate();
                PrivateKey privKey = currentDefaultRec.getEncoding().getPrivateKey(this.storePassword.toCharArray());
                hashGen = RecordDataHashGeneratorFactory.newRecordDataHashGenerator();
                record = RecordFlag.CREATED.append(currentDefaultRec.getRecordId()).append(RecordEncodingFactory.newKeyRecordEncoding(id2, cert, privKey, this.storePassword.toCharArray(), defaultAlias, false)).append(currentDefaultRec.getLabel()).append(ZERO).append(hashGen.generateCertificateSignatureHash(cert)).append(hashGen.generateTBSCertificateHash(cert)).append(hashGen.generateSubjectNameHash(cert)).append(hashGen.generateSubjectPublicKeyInfoHash(cert)).append(hashGen.generateIssuerAndSerialNumberHash(cert));
                records.add(RecordFactory.newRecord(record.getInputStream()));
                this.engineDeleteEntry(defaultAlias);
            }
        }
        catch (Exception e) {
            String msg = "Error occurred while updating the old default certificate.";
            CMSKeyStoreSpi.trace(msg);
            throw new KeyStoreException(msg);
        }
        this.resetFixedRecordLengh();
        this.setFixedRecordLengh(this.analyzeMaxRecordLength(records));
        this.setFixedRecordLengh(this.analyzeMaxRecordLength(this.cmsKeyDatabase.getRecords()));
        this.padRecords(records);
        this.padRecords(this.cmsKeyDatabase.getRecords());
        try {
            Sequence<Record> additionalRecords = SequenceFactory.newSequence(records);
            Sequence<Record> totalRecords = this.cmsKeyDatabase.getRecords().append(additionalRecords);
            ByteSequence newStoreSequence = MagicNumberValidatorFactory.MAGIC_NUMBER.append(this.cmsKeyDatabase.getHeader().getMajorVersionNumber()).append(this.cmsKeyDatabase.getHeader().getMinorVersionNumber()).append(ZERO).append(FileType.X509KEY).append(this.getFixedRecordLengthSequence()).append(IntableByteSequenceFactory.newIntableByteSequence(totalRecords.length())).append(UNUSED_FILE_LABEL).append(this.cmsKeyDatabase.getHeader().getPasswordHeaderHash()).append(this.cmsKeyDatabase.getHeader().getPasswordDatabaseHash());
            for (Record rec : totalRecords) {
                newStoreSequence = newStoreSequence.append(rec);
            }
            this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(newStoreSequence.getInputStream()));
            this.updateHeaderHashes();
            this.rebuildAliasesList();
        }
        catch (Exception e) {
            throw new KeyStoreException(e);
        }
    }

    private String getDefaultKeyAlias() throws UnsupportedEncodingException, IOException {
        Sequence<Record> records = this.cmsKeyDatabase.getKeyRecords();
        for (Record record : records) {
            if (!record.getEncoding().isDefaultKey()) continue;
            return this.labelFromRecord(record);
        }
        return null;
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        CMSKeyStoreSpi.trace("engineSetKeyEntry(\"" + alias + "\", byte[] key, Certificate[] chain) = unsupported function");
        throw new KeyStoreException("CMS cannot accept externally encoded PKCS#8 objects");
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        CMSKeyStoreSpi.trace("engineSetCertificateEntry(\"" + alias + "\", cert)");
        try {
            String existingAlias;
            if (!(cert instanceof X509Certificate)) {
                String msg = "Only X509 Certificates are expected.";
                CMSKeyStoreSpi.trace(msg);
                throw new KeyStoreException(msg);
            }
            if (this.engineContainsAlias(alias)) {
                if (!this.engineIsCertificateEntry(alias)) {
                    String msg = "Alias already exists and is associated with key entry.";
                    CMSKeyStoreSpi.trace(msg);
                    throw new KeyStoreException(msg);
                }
                this.engineDeleteEntry(alias);
            }
            boolean isTrusted = true;
            if (cert instanceof CMSCertificate) {
                isTrusted = ((CMSCertificate)cert).isTrusted();
                CMSKeyStoreSpi.trace("isTrusted = " + isTrusted);
            }
            if ((existingAlias = this.engineGetCertificateAlias(cert)) != null) {
                this.engineDeleteEntry(existingAlias);
            }
            int id = this.cmsKeyDatabase.getNextRecordID();
            byte[] aliasBytes = alias.getBytes("UTF-8");
            RecordDataHashGenerator hashGen = RecordDataHashGeneratorFactory.newRecordDataHashGenerator();
            ByteSequence aliasSeq = IntableByteSequenceFactory.newIntableByteSequence(aliasBytes.length).append(ByteSequenceFactory.newByteSequence(aliasBytes));
            X509Certificate certificate = (X509Certificate)cert;
            ByteSequence recordSequence = RecordFlag.CREATED.append(IntableByteSequenceFactory.newIntableByteSequence(id)).append(RecordEncodingFactory.newRecordEncoding(id, certificate, alias, isTrusted)).append(BufferFactory.newBuffer(aliasSeq.getInputStream())).append(ZERO).append(hashGen.generateCertificateSignatureHash(certificate)).append(hashGen.generateTBSCertificateHash(certificate)).append(hashGen.generateSubjectNameHash(certificate)).append(hashGen.generateSubjectPublicKeyInfoHash(certificate)).append(hashGen.generateIssuerAndSerialNumberHash(certificate));
            Record record = RecordFactory.newRecord(recordSequence.getInputStream());
            this.resetFixedRecordLengh();
            this.setFixedRecordLengh(record.length());
            this.setFixedRecordLengh(this.analyzeMaxRecordLength(this.cmsKeyDatabase.getRecords()));
            this.padRecord(record);
            this.padRecords(this.cmsKeyDatabase.getRecords());
            try {
                Sequence<Record> additionalRecords = SequenceFactory.newSequence(record);
                Sequence<Record> totalRecords = this.cmsKeyDatabase.getRecords().append(additionalRecords);
                ByteSequence newStoreSequence = MagicNumberValidatorFactory.MAGIC_NUMBER.append(this.cmsKeyDatabase.getHeader().getMajorVersionNumber()).append(this.cmsKeyDatabase.getHeader().getMinorVersionNumber()).append(ZERO).append(FileType.X509KEY).append(this.getFixedRecordLengthSequence()).append(IntableByteSequenceFactory.newIntableByteSequence(totalRecords.length())).append(UNUSED_FILE_LABEL).append(this.cmsKeyDatabase.getHeader().getPasswordHeaderHash()).append(this.cmsKeyDatabase.getHeader().getPasswordDatabaseHash());
                for (Record rec : totalRecords) {
                    newStoreSequence = newStoreSequence.append(rec);
                }
                this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(newStoreSequence.getInputStream()));
                this.updateHeaderHashes();
                this.rebuildAliasesList();
            }
            catch (Exception e) {
                throw new KeyStoreException(e);
            }
        }
        catch (Exception ex) {
            throw new KeyStoreException("Key Insertion Failed: " + ex.getMessage(), ex);
        }
    }

    private void updateHeaderHashes() throws NoSuchAlgorithmException, IOException {
        ByteSequence newHeaderSequence;
        FileHeader header = this.cmsKeyDatabase.getHeader();
        ByteSequence headerHash = FileHeaderHashGeneratorFactory.newFileHeaderHashGenerator(header).generateHash(header, this.storePassword);
        ByteSequence keystoreSequence = newHeaderSequence = header.getSubSequence(0, header.length() - 2 * header.getPasswordHeaderHash().length()).append(headerHash).append(header.getPasswordDatabaseHash());
        for (Record rec : this.cmsKeyDatabase.getRecords()) {
            keystoreSequence = keystoreSequence.append(rec);
        }
        KeyDatabase db = KeyDatabaseFactory.newKeyDatabase(keystoreSequence.getInputStream());
        ByteSequence dbHash = DatabaseHashGeneratorFactory.newDatabaseHashGenerator(header).generateHash(db, this.storePassword);
        header = db.getHeader();
        keystoreSequence = newHeaderSequence = header.getSubSequence(0, header.length() - header.getPasswordDatabaseHash().length()).append(dbHash);
        for (Record rec : db.getRecords()) {
            keystoreSequence = keystoreSequence.append(rec);
        }
        this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(keystoreSequence.getInputStream()));
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        try {
            CMSKeyStoreSpi.trace("engineDeleteEntry(\"" + alias + "\")");
            if (!this.engineContainsAlias(alias)) {
                return;
            }
            Record record = this.cmsKeyDatabase.getRecordByLabel(this.getCorrectCaseLabel(alias));
            Sequence<Record> allRecords = this.cmsKeyDatabase.getRecords();
            int index = allRecords.indexOf(record);
            Sequence<Record> remaining = allRecords.getSubSequence(0, index).append(allRecords.getSubSequence(index + 1, allRecords.length()));
            this.resetFixedRecordLengh();
            this.setFixedRecordLengh(this.analyzeMaxRecordLength(remaining));
            this.padRecords(remaining);
            ByteSequence newStoreSequence = MagicNumberValidatorFactory.MAGIC_NUMBER.append(this.cmsKeyDatabase.getHeader().getMajorVersionNumber()).append(this.cmsKeyDatabase.getHeader().getMinorVersionNumber()).append(ZERO).append(FileType.X509KEY).append(this.getFixedRecordLengthSequence()).append(IntableByteSequenceFactory.newIntableByteSequence(remaining.length())).append(UNUSED_FILE_LABEL).append(this.cmsKeyDatabase.getHeader().getPasswordHeaderHash()).append(this.cmsKeyDatabase.getHeader().getPasswordDatabaseHash());
            for (Record rec : remaining) {
                newStoreSequence = newStoreSequence.append(rec);
            }
            this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(newStoreSequence.getInputStream()));
            this.updateHeaderHashes();
            this.rebuildAliasesList();
        }
        catch (Exception e) {
            throw new KeyStoreException(e.getMessage(), e);
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        CMSKeyStoreSpi.trace("engineAliases() :");
        if (tracing) {
            for (String a : this.aliases) {
                CMSKeyStoreSpi.trace("alias=\"" + a + "\"");
            }
        }
        Enumeration<String> res = Collections.enumeration(this.aliases);
        return res;
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        boolean res = this.aliases.contains(alias);
        CMSKeyStoreSpi.trace("engineContainsAlias(\"" + alias + "\") = " + res);
        return res;
    }

    @Override
    public int engineSize() {
        int size = this.aliases.size();
        CMSKeyStoreSpi.trace("engineSize()=" + size);
        return size;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        Record record = this.cmsKeyDatabase.getRecordByLabel(this.getCorrectCaseLabel(alias));
        boolean res = record == null ? false : record.getEncoding().isPrivateKeyPresent();
        CMSKeyStoreSpi.trace("engineIsKeyEntry(\"" + alias + "\") = " + res);
        return res;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        boolean res = this.engineContainsAlias(alias) && !this.engineIsKeyEntry(alias);
        CMSKeyStoreSpi.trace("engineIsCertificateEntry(\"" + alias + "\") = " + res);
        return res;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        if (!(cert instanceof X509Certificate)) {
            CMSKeyStoreSpi.trace("engineGetCertificateAlias(cert) - cert not X509Certificate");
            return null;
        }
        Record record = this.cmsKeyDatabase.getRecordByCert(cert);
        if (record == null) {
            CMSKeyStoreSpi.trace("engineGetCertificateAlias(cert) = null");
            return null;
        }
        String labelStr = this.labelFromRecord(record);
        CMSKeyStoreSpi.trace("engineGetCertificateAlias(cert) = \"" + labelStr + "\"");
        return labelStr;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException {
        CMSKeyStoreSpi.trace("engineStore(stream, password)");
        if (stream == null) {
            throw new NullPointerException();
        }
        try {
            String pwd;
            if (password != null && !this.storePassword.equals(pwd = new String(password))) {
                this.updateEncryptedRecords(this.storePassword.toCharArray(), pwd.toCharArray());
                this.storePassword = pwd;
                this.updateHeaderHashes();
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        ByteSequenceIterator it = this.cmsKeyDatabase.getIterator();
        while (it.hasNextByte()) {
            stream.write(it.getNextByte());
        }
    }

    private void updateEncryptedRecords(char[] currentPassword, char[] newPassword) throws IOException, PKCSException, CertificateEncodingException, CertificateException, NoSuchAlgorithmException {
        Sequence<Record> keys = this.cmsKeyDatabase.getKeyRecords();
        HashMap<Integer, Record> newKeys = new HashMap<Integer, Record>(keys.length());
        for (Record record : keys) {
            String alias = this.labelFromRecord(record);
            RecordEncoding encoding = record.getEncoding();
            boolean defaultKey = encoding.isDefaultKey();
            RecordEncoding newEncoding = RecordEncodingFactory.newKeyRecordEncoding(record.getRecordId().toInt(), encoding.getCertificate(), encoding.getPrivateKey(currentPassword), newPassword, alias, defaultKey);
            ByteSequence newRecordSequence = record.getRecordFlag().append(record.getRecordId()).append(newEncoding).append(record.getLabel()).append(ZERO).append(record.getSignatureHash()).append(record.getUnsignedCertHash()).append(record.getSubjectNameHash()).append(record.getSubjectPublicKeyInfoHash()).append(record.getIssuerAndSerialNumberHash());
            newKeys.put(record.getRecordId().toInt(), RecordFactory.newRecord(newRecordSequence.getInputStream()));
        }
        this.padRecords(newKeys.values());
        this.padRecords(this.cmsKeyDatabase.getRecords());
        ByteSequence newKeystore = this.cmsKeyDatabase.getHeader();
        for (Record record : this.cmsKeyDatabase.getRecords()) {
            Record rec = (Record)newKeys.get(record.getRecordId().toInt());
            if (rec != null) {
                newKeystore = newKeystore.append(rec);
                continue;
            }
            newKeystore = newKeystore.append(record);
        }
        this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(newKeystore.getInputStream()));
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException {
        CMSKeyStoreSpi.trace("engineLoad(InputStream stream, char[] password)");
        if (password == null) {
            throw new IllegalArgumentException("Password is requird to create a new or load an existing KeyStore");
        }
        this.cmsKeyDatabase = null;
        this.storePassword = new String(password);
        if (stream == null) {
            CMSKeyStoreSpi.trace("new keystore - version " + version);
            try {
                ByteSequence headerSequence;
                IntableByteSequence zeroHash;
                IntableByteSequence CA_RECORD_NUMBER = IntableByteSequenceFactory.newIntableByteSequence(populate ? CACertificates.CACERTS.size() : 0);
                ArrayList<Record> records = new ArrayList<Record>();
                if (populate) {
                    Iterator<String> iterator = CACertificates.getAliases();
                    int id = 0;
                    RecordDataHashGenerator hashGen = RecordDataHashGeneratorFactory.newRecordDataHashGenerator();
                    while (iterator.hasNext()) {
                        String alias = iterator.next();
                        byte[] aliasBytes = alias.getBytes("UTF-8");
                        ByteSequence aliasSeq = IntableByteSequenceFactory.newIntableByteSequence(aliasBytes.length).append(ByteSequenceFactory.newByteSequence(aliasBytes));
                        X509Certificate certificate = (X509Certificate)CACertificates.getCACertificate(alias);
                        ByteSequence record = RecordFlag.CREATED.append(IntableByteSequenceFactory.newIntableByteSequence(++id)).append(RecordEncodingFactory.newRecordEncoding(id, certificate, alias, true)).append(BufferFactory.newBuffer(aliasSeq.getInputStream())).append(ZERO).append(hashGen.generateCertificateSignatureHash(certificate)).append(hashGen.generateTBSCertificateHash(certificate)).append(hashGen.generateSubjectNameHash(certificate)).append(hashGen.generateSubjectPublicKeyInfoHash(certificate)).append(hashGen.generateIssuerAndSerialNumberHash(certificate));
                        Record rec = RecordFactory.newRecord(record.getInputStream());
                        this.setFixedRecordLengh(rec.length());
                        records.add(rec);
                    }
                }
                if (version == 4) {
                    zeroHash = ZERO_SHA1_HASH;
                    headerSequence = MagicNumberValidatorFactory.MAGIC_NUMBER.append(VersionNumber.FOUR).append(VersionNumber.TWO).append(ZERO).append(FileType.X509KEY).append(this.getFixedRecordLengthSequence()).append(CA_RECORD_NUMBER).append(UNUSED_FILE_LABEL).append(zeroHash).append(zeroHash);
                } else {
                    zeroHash = ZERO_MD5_HASH;
                    headerSequence = MagicNumberValidatorFactory.MAGIC_NUMBER.append(VersionNumber.THREE).append(VersionNumber.TWO).append(ZERO).append(FileType.X509KEY).append(this.getFixedRecordLengthSequence()).append(CA_RECORD_NUMBER).append(UNUSED_FILE_LABEL).append(zeroHash).append(zeroHash);
                }
                FileHeader header = FileHeaderFactory.newFileHeader(headerSequence.getInputStream());
                ByteSequence headerHash = FileHeaderHashGeneratorFactory.newFileHeaderHashGenerator(header).generateHash(header, this.storePassword);
                ByteSequence keystoreSequence = headerSequence = headerSequence.getSubSequence(0, headerSequence.length() - 2 * zeroHash.length()).append(headerHash).append(zeroHash);
                for (Record r : records) {
                    this.padRecord(r);
                    keystoreSequence = keystoreSequence.append(r);
                }
                KeyDatabase db = KeyDatabaseFactory.newKeyDatabase(keystoreSequence.getInputStream());
                ByteSequence dbHash = DatabaseHashGeneratorFactory.newDatabaseHashGenerator(header).generateHash(db, this.storePassword);
                headerSequence = headerSequence.getSubSequence(0, headerSequence.length() - zeroHash.length()).append(dbHash);
                keystoreSequence = populate ? headerSequence.append(keystoreSequence.getSubSequence(headerSequence.length(), keystoreSequence.length() - 1)) : headerSequence;
                this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(keystoreSequence.getInputStream()));
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        CMSKeyStoreSpi.trace("existing");
        CMSKeyStoreSpi.trace("stream.available=" + stream.available());
        try {
            this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(stream, true));
            this.resetFixedRecordLengh();
            this.setFixedRecordLengh(this.cmsKeyDatabase.getHeader().getFixedRecordLength().toInt());
            if (password != null && !this.cmsKeyDatabase.checkKeyStoreIntegrity(password)) {
                CMSKeyStoreSpi.trace("Incorrect Password");
                throw new IOException("Incorrect Password.");
            }
            this.cmsKeyDatabase.decodeRawRecords();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Invalid KeyStore Format.", e);
        }
        this.rebuildAliasesList();
    }

    @Override
    public boolean engineEntryInstanceOf(String alias, Class<? extends KeyStore.Entry> entryClass) {
        boolean res = false;
        if (this.engineIsKeyEntry(alias)) {
            res = entryClass.isAssignableFrom(KeyStore.PrivateKeyEntry.class);
        }
        if (this.engineIsCertificateEntry(alias)) {
            res = entryClass.isAssignableFrom(KeyStore.TrustedCertificateEntry.class);
        }
        CMSKeyStoreSpi.trace("engineEntryInstanceOf(\"" + alias + "\", " + entryClass.getName() + ") = " + res);
        return res;
    }

    private String getCorrectCaseLabel(String label) {
        for (String current : this.aliases) {
            if (!label.equalsIgnoreCase(current)) continue;
            return current;
        }
        return label;
    }

    @Override
    public KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) throws KeyStoreException, UnrecoverableEntryException {
        CMSKeyStoreSpi.trace("engineGetEntry(\"" + alias + "\", ProtectionParameter)");
        KeyStore.Entry entry = null;
        try {
            if (!this.engineContainsAlias(alias)) {
                return null;
            }
            String tmpLabel = this.getCorrectCaseLabel(alias);
            Record record = this.cmsKeyDatabase.getRecordByLabel(tmpLabel);
            if (record == null) {
                throw new KeyStoreException("Couldn't find the record with alias: \n" + alias);
            }
            RecordEncoding encoding = record.getEncoding();
            if (encoding.isPrivateKeyPresent()) {
                if (protParam != null) {
                    PasswordExtractor pwextractor = CMSKeyStoreSpi.newPasswordExtractor(protParam);
                    if (pwextractor == null) {
                        throw new UnrecoverableEntryException("Invalid Protection Parameter.");
                    }
                    char[] password = pwextractor.getPassword();
                    if (password != null && !this.cmsKeyDatabase.checkPassword(password)) {
                        throw new UnrecoverableEntryException("Incorrect password provided.");
                    }
                }
                PrivateKey key = encoding.getPrivateKey(this.storePassword.toCharArray());
                Certificate[] certChain = this.engineGetCertificateChain(alias);
                CMSPrivateKey cmsKey = CMSPrivateKeyFactory.newCMSPrivateKey(key, encoding.isDefaultKey());
                entry = new KeyStore.PrivateKeyEntry(cmsKey, certChain);
            } else {
                Certificate cert = encoding.getCertificate();
                CMSCertificate cmsCert = new CMSCertificate(cert, encoding.isTrusted());
                entry = new KeyStore.TrustedCertificateEntry(cmsCert);
            }
        }
        catch (UnrecoverableEntryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KeyStoreException(e);
        }
        return entry;
    }

    public String engineTestLoad(KeyStore.LoadStoreParameter loadstoreParam) throws IOException, IllegalArgumentException {
        this.engineLoad(loadstoreParam);
        return ALGORITHM_ID;
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter loadstoreParam) throws IOException, IllegalArgumentException {
        CMSKeyStoreSpi.trace("engineLoad(LoadStoreParameter loadstoreParam)");
        if (loadstoreParam == null) {
            throw new IllegalArgumentException("CMS KeyStore requires LoadStoreParameter to load.");
        }
        if (!(loadstoreParam instanceof CMSLoadParameter) || loadstoreParam instanceof CMSStoreParameter) {
            throw new IllegalArgumentException("The provided LoadStoreParameter is not recognized");
        }
        CMSLoadParameter parameter = (CMSLoadParameter)loadstoreParam;
        PasswordExtractor extractor = CMSKeyStoreSpi.newPasswordExtractor(parameter.getProtectionParameter());
        if (extractor == null) {
            throw new IllegalArgumentException("Invalid Protection Parameter.");
        }
        FileInputStream instream = null;
        if (parameter.getKeyStoreFile() != null) {
            instream = new FileInputStream(parameter.getKeyStoreFile());
        }
        this.engineLoad(instream, extractor.getPassword());
        if (instream != null) {
            ((InputStream)instream).close();
        }
        parameter.setPasswordExpiry(this.cmsKeyDatabase.getHeader().getPasswordExpirationTime().toInt());
    }

    @Override
    public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException, IllegalArgumentException {
        CMSKeyStoreSpi.trace("engineSetEntry(\"" + alias + "\", KeyStore.Entry, KeyStore.ProtectionParameter)");
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            char[] password = null;
            if (protParam != null) {
                PasswordExtractor pwdExtractor = CMSKeyStoreSpi.newPasswordExtractor(protParam);
                if (pwdExtractor == null) {
                    throw new IllegalArgumentException("Invalid Protection Parameter.");
                }
                try {
                    password = pwdExtractor.getPassword();
                    if (password != null && !this.cmsKeyDatabase.checkPassword(password)) {
                        throw new KeyStoreException("The password supplied throug the ProtectionParameter interface is invalid, it must match the KeyStore password or null");
                    }
                }
                catch (Exception e) {
                    throw new KeyStoreException(e);
                }
            }
            KeyStore.PrivateKeyEntry privateEntry = (KeyStore.PrivateKeyEntry)entry;
            this.engineSetKeyEntry(alias, privateEntry.getPrivateKey(), this.storePassword.toCharArray(), privateEntry.getCertificateChain());
        } else if (entry instanceof KeyStore.TrustedCertificateEntry) {
            KeyStore.TrustedCertificateEntry trustedEntry = (KeyStore.TrustedCertificateEntry)entry;
            this.engineSetCertificateEntry(alias, trustedEntry.getTrustedCertificate());
        } else {
            throw new KeyStoreException("Invalid Key Entry.");
        }
    }

    @Override
    public void engineStore(KeyStore.LoadStoreParameter loadstoreParam) throws IOException, IllegalArgumentException {
        FileLock lock;
        CMSKeyStoreSpi.trace("engineStore(LoadStoreParameter)");
        if (loadstoreParam == null) {
            throw new IllegalArgumentException("CMS KeyStore requires LoadStoreParameter to store.");
        }
        if (!(loadstoreParam instanceof CMSStoreParameter)) {
            throw new IllegalArgumentException("The given LoadStoreParameter is not recognized");
        }
        CMSStoreParameter parameter = (CMSStoreParameter)loadstoreParam;
        KeyStore.ProtectionParameter protection = parameter.getProtectionParameter();
        char[] password = null;
        if (protection != null) {
            PasswordExtractor extractor = CMSKeyStoreSpi.newPasswordExtractor(protection);
            if (extractor == null) {
                throw new IllegalArgumentException("Invalid Protection Parameter.");
            }
            password = extractor.getPassword();
        }
        this.setPasswordExpiry(parameter.getPasswordExpiry());
        FileOutputStream outStream = new FileOutputStream(parameter.getKeyStoreFile(), true);
        FileChannel channel = outStream.getChannel();
        try {
            lock = channel.tryLock();
        }
        catch (OverlappingFileLockException e) {
            outStream.close();
            throw new IOException("Unable to acquire file lock for " + parameter.getKeyStoreFile());
        }
        if (lock != null) {
            channel.truncate(0L);
            BufferedOutputStream bufferedStream = new BufferedOutputStream(outStream);
            this.engineStore(bufferedStream, password);
            bufferedStream.close();
            if (parameter.isStashPassword()) {
                String kdbPath = parameter.getKeyStoreFile().getAbsolutePath();
                int index = kdbPath.lastIndexOf(46);
                if (index == -1) {
                    index = kdbPath.length();
                }
                StringBuilder builder = new StringBuilder(kdbPath.subSequence(0, index)).append(STASH_FILE_EXT);
                this.stashKeyDbPwd(builder.toString());
            }
        } else {
            outStream.close();
            throw new IOException("Unable to acquire file lock for " + parameter.getKeyStoreFile());
        }
    }

    private void setPasswordExpiry(int passwordExpiry) throws IOException {
        try {
            Sequence<Record> totalRecords = this.cmsKeyDatabase.getRecords();
            this.resetFixedRecordLengh();
            this.setFixedRecordLengh(this.analyzeMaxRecordLength(totalRecords));
            this.padRecords(totalRecords);
            ByteSequence newStoreSequence = MagicNumberValidatorFactory.MAGIC_NUMBER.append(this.cmsKeyDatabase.getHeader().getMajorVersionNumber()).append(this.cmsKeyDatabase.getHeader().getMinorVersionNumber()).append(IntableByteSequenceFactory.newIntableByteSequence(passwordExpiry)).append(FileType.X509KEY).append(this.getFixedRecordLengthSequence()).append(IntableByteSequenceFactory.newIntableByteSequence(totalRecords.length())).append(UNUSED_FILE_LABEL).append(this.cmsKeyDatabase.getHeader().getPasswordHeaderHash()).append(this.cmsKeyDatabase.getHeader().getPasswordDatabaseHash());
            for (Record rec : totalRecords) {
                newStoreSequence = newStoreSequence.append(rec);
            }
            this.cmsKeyDatabase = QueryableKeyDatabaseFactory.newQueryableKeyDatabase(KeyDatabaseFactory.newKeyDatabase(newStoreSequence.getInputStream()));
            this.updateHeaderHashes();
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    private void stashKeyDbPwd(String absolutePath) throws IOException {
        byte[] buffer = new byte[129];
        byte[] pwdBuffer = this.storePassword.getBytes("UTF-8");
        for (int i = 0; i < 129; ++i) {
            buffer[i] = i < pwdBuffer.length ? pwdBuffer[i] : (i == pwdBuffer.length ? (byte)0 : (byte)i);
        }
        ByteSequence paddedPassword = ByteSequenceFactory.newByteSequence(buffer);
        ByteSequence key = ByteSequenceFactory.newConstantByteSequence((byte)-11, 129);
        ByteSequence stashedPwd = ByteSequenceXorFactory.newByteSequenceXor().xor(paddedPassword, key);
        FileOutputStream out = new FileOutputStream(absolutePath);
        ByteSequenceIterator it = stashedPwd.getIterator();
        while (it.hasNextByte()) {
            ((OutputStream)out).write(it.getNextByte());
        }
        ((OutputStream)out).close();
    }

    private void setFixedRecordLengh(int newLengh) {
        if (newLengh > this.FIXED_RECORD_LENGTH) {
            this.FIXED_RECORD_LENGTH = (int)(Math.ceil((double)newLengh / 1000.0) * 1000.0);
        }
    }

    private void resetFixedRecordLengh() {
    }

    private int getFixedRecordLengh() {
        return this.FIXED_RECORD_LENGTH;
    }

    private int analyzeMaxRecordLength(Collection<Record> records) {
        int length = 0;
        for (Record rec : records) {
            if (rec.length() <= length) continue;
            length = rec.length();
        }
        return length;
    }

    private int analyzeMaxRecordLength(Sequence<Record> records) {
        int length = 0;
        for (Record rec : records) {
            if (rec.length() <= length) continue;
            length = rec.length();
        }
        return length;
    }

    private void padRecords(Sequence<Record> records) {
        for (Record rec : records) {
            this.padRecord(rec);
        }
    }

    private void padRecords(Collection<Record> records) {
        for (Record rec : records) {
            this.padRecord(rec);
        }
    }

    private ByteSequence padRecord(Record record) {
        return record.expand(this.getFixedRecordLengh() - record.length());
    }

    private static final class PEFromCBHandler
    implements PasswordExtractor {
        private KeyStore.CallbackHandlerProtection callbackProtection = null;
        private Callback[] callbacks = null;
        private static final String prompt = "Please Enter the KeyStore Password:";

        private PEFromCBHandler() {
        }

        PEFromCBHandler(KeyStore.CallbackHandlerProtection protParam) {
            this.callbackProtection = protParam;
            this.callbacks = new Callback[1];
        }

        public char[] getPassword() throws IOException {
            char[] password = null;
            if (this.callbacks[0] == null) {
                CallbackHandler cbHandler = this.callbackProtection.getCallbackHandler();
                PasswordCallback pwdCB = new PasswordCallback(prompt, false);
                this.callbacks[0] = pwdCB;
                try {
                    cbHandler.handle(this.callbacks);
                }
                catch (UnsupportedCallbackException e) {
                    throw new RuntimeException(e);
                }
                password = pwdCB.getPassword();
            } else {
                password = ((PasswordCallback)this.callbacks[0]).getPassword();
            }
            return password;
        }

        public void destroyPassword() {
            if (this.callbacks[0] != null) {
                ((PasswordCallback)this.callbacks[0]).clearPassword();
                this.callbacks[0] = null;
            }
        }
    }

    private static final class PEFromPwdProtection
    implements PasswordExtractor {
        KeyStore.PasswordProtection protParam;

        private PEFromPwdProtection() {
        }

        PEFromPwdProtection(KeyStore.PasswordProtection protParam) {
            this.protParam = protParam;
        }

        public char[] getPassword() {
            return this.protParam.getPassword();
        }

        public void destroyPassword() throws DestroyFailedException {
            this.protParam.destroy();
        }
    }

    private static final class PEFromStashedPwdProtection
    implements PasswordExtractor {
        StashedPasswordProtection protParam;

        private PEFromStashedPwdProtection() {
        }

        PEFromStashedPwdProtection(StashedPasswordProtection protParam) {
            this.protParam = protParam;
        }

        public char[] getPassword() throws IOException {
            return this.protParam.getPassword();
        }

        public void destroyPassword() throws DestroyFailedException {
            this.protParam.destroy();
        }
    }

    static interface PasswordExtractor {
        public char[] getPassword() throws IOException;

        public void destroyPassword() throws DestroyFailedException;
    }
}

