/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.security.Security;

public final class SecureRandom
extends SecureRandomSpi {
    private SessionManager sessionManager;
    static final long serialVersionUID = 8121567603736529455L;

    public SecureRandom() {
        Provider pkcs11Provider = Security.getProvider("IBMPKCS11Impl");
        this.sessionManager = ((IBMPKCS11Impl)pkcs11Provider).getSessionManager();
    }

    public SecureRandom(Provider p) {
        this.sessionManager = ((IBMPKCS11Impl)p).getSessionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void engineSetSeed(byte[] seed) {
        Session session = null;
        try {
            session = this.sessionManager.getOpSession();
            session.seedRandom(seed, 0, seed.length);
        }
        finally {
            this.sessionManager.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void engineNextBytes(byte[] bytes) {
        Session session = null;
        try {
            session = this.sessionManager.getOpSession();
            session.generateRandom(bytes, 0, bytes.length);
        }
        finally {
            this.sessionManager.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] engineGenerateSeed(int numBytes) {
        byte[] bytes = new byte[numBytes];
        Session session = null;
        try {
            session = this.sessionManager.getOpSession();
            session.generateRandom(bytes, 0, bytes.length);
        }
        finally {
            this.sessionManager.releaseSession(session);
        }
        return bytes;
    }
}

