/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.DSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11KeySpec;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class DSAPKCS11KeyFactory
extends KeyFactorySpi {
    private SessionManager sessionManager = null;
    private Config config = null;
    private static Debug debug1 = Debug.getInstance((String)"pkcs11impl");
    private static Debug debug2 = Debug.getInstance((String)"dsapkcs11keyfactory");
    private static Debug debug = debug1 == null ? debug2 : debug1;
    private static String className = "com.ibm.crypto.pkcs11impl.provider.DSAPKCS11KeyFactory";

    public DSAPKCS11KeyFactory(Provider provider) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DSAPKCS11KeyFactory");
        }
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "DSAPKCS11KeyFactory");
        }
    }

    public DSAPKCS11KeyFactory() {
        this(Security.getProvider("IBMPKCS11Impl"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        DSAPrivateKey privDSA = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGeneratePrivate", (Object)keySpec);
        }
        if (keySpec instanceof DSAPrivateKeySpec) {
            DSAPrivateKeySpec privateKeySpec = (DSAPrivateKeySpec)keySpec;
            BigInteger p = privateKeySpec.getP();
            BigInteger q = privateKeySpec.getQ();
            BigInteger g = privateKeySpec.getG();
            BigInteger x = privateKeySpec.getX();
            try {
                byte[] trimmedX = this.trimLeadingZeroes(x, true);
                int[] attrTypes = null;
                Object[] attrValues = null;
                PKCS11Object object = null;
                byte[] ID = null;
                Boolean isToken = Boolean.FALSE;
                Boolean isSensitive = Boolean.FALSE;
                Boolean isExtractable = Boolean.TRUE;
                ID = this.genID();
                HashMap<Integer, Object> hattrs = null;
                Set<Integer> keys = null;
                int numEles = 0;
                if (this.config != null) {
                    hattrs = this.config.getAttributes("IMPORT", PKCS11Object.PRIVATE_KEY, PKCS11Object.DSA);
                    keys = hattrs.keySet();
                    numEles = keys.size();
                    attrTypes = new int[7 + numEles];
                    attrValues = new Object[7 + numEles];
                    attrTypes[0] = 0;
                    attrTypes[1] = 256;
                    attrTypes[2] = 258;
                    attrTypes[3] = 304;
                    attrTypes[4] = 305;
                    attrTypes[5] = 306;
                    attrTypes[6] = 17;
                    attrValues[0] = PKCS11Object.PRIVATE_KEY;
                    attrValues[1] = PKCS11Object.DSA;
                    attrValues[2] = ID;
                    attrValues[3] = p;
                    attrValues[4] = q;
                    attrValues[5] = g;
                    attrValues[6] = trimmedX;
                    Iterator<Integer> it = keys.iterator();
                    int i = 1;
                    while (it.hasNext()) {
                        Integer key = it.next();
                        attrTypes[6 + i] = key;
                        attrValues[6 + i] = hattrs.get(key);
                        ++i;
                    }
                } else {
                    int[] attrTypes1 = new int[]{0, 256, 258, 2, 1, 259, 264, 304, 305, 306, 17};
                    attrTypes = attrTypes1;
                    attrValues = new Object[]{PKCS11Object.PRIVATE_KEY, PKCS11Object.DSA, ID, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, p, q, g, trimmedX};
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "P: " + p + "\n bit len: " + p.bitLength());
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "Q: " + q + "\n bit len: " + q.bitLength());
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "G: " + g + "\n bit len: " + g.bitLength());
                    debug.text(16384L, (Object)className, "engineGeneratePrivate", "X: " + x + "\n length in byte after trim: " + trimmedX.length);
                }
                Session session = null;
                boolean isSession = false;
                try {
                    session = this.sessionManager.getObjSession();
                    object = session.createObject(attrTypes, attrValues);
                    if (!session.getBoolAttributeValue(object, 1)) {
                        session.addObject();
                        isSession = true;
                    }
                    privDSA = new DSAPrivateKey(session, object, null, ID, null, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, p, q, g, x);
                }
                finally {
                    this.sessionManager.releaseSession(session);
                }
                if (isSession) {
                    privDSA.setSession(session);
                }
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePrivate");
                }
                return privDSA;
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineGeneratePrivate_1", (Throwable)e);
                    debug.exit(16384L, (Object)className, "engineGeneratePrivate");
                }
                throw new InvalidKeySpecException("Invalid key spec: " + e.getMessage() + "  Ensure that the supplied key spec does not describe a DSA Private Key longer than 1024.");
            }
        }
        if (keySpec instanceof PKCS11KeySpec) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "engineGeneratePrivate_3");
            }
            PKCS11Object object = ((PKCS11KeySpec)keySpec).getObject();
            Session session = null;
            try {
                DSAPrivateKey pkey;
                session = this.sessionManager.getOpSession();
                DSAPrivateKey dSAPrivateKey = pkey = new DSAPrivateKey(session, object, (String)session.getAttrValue(object, 3), (byte[])session.getAttrValue(object, 258), (byte[])session.getAttrValue(object, 257), (Boolean)session.getAttrValue(object, 1), (Boolean)session.getAttrValue(object, 259), (Boolean)session.getAttrValue(object, 354), (BigInteger)session.getAttrValue(object, 304), (BigInteger)session.getAttrValue(object, 305), (BigInteger)session.getAttrValue(object, 306), new BigInteger((byte[])session.getAttrValue(object, 17)));
                return dSAPrivateKey;
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineGeneratePrivate_4", (Throwable)e);
                    debug.exit(16384L, (Object)className, "engineGeneratePrivate");
                }
                throw new InvalidKeySpecException("Invalid key spec: " + e.getMessage());
            }
            finally {
                this.sessionManager.releaseSession(session);
            }
        }
        if (debug != null) {
            debug.text(16384L, (Object)className, "engineGeneratePrivate_5", "Invalid key spec");
            debug.exit(16384L, (Object)className, "engineGeneratePrivate");
        }
        throw new InvalidKeySpecException("Invalid key spec");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGeneratePublic", (Object)keySpec);
        }
        try {
            DSAPublicKey pubDSA = null;
            if (keySpec instanceof DSAPublicKeySpec) {
                DSAPublicKeySpec publicKeySpec = (DSAPublicKeySpec)keySpec;
                BigInteger p = publicKeySpec.getP();
                BigInteger q = publicKeySpec.getQ();
                BigInteger g = publicKeySpec.getG();
                BigInteger y = publicKeySpec.getY();
                int[] attrTypes = null;
                Object[] attrValues = null;
                try {
                    PKCS11Object object = null;
                    byte[] ID = null;
                    byte[] currentDSAValue = new byte[y.toByteArray().length];
                    boolean useCurrentDSAValue = true;
                    byte[] newDSAValue = null;
                    System.arraycopy(y.toByteArray(), 0, currentDSAValue, 0, y.toByteArray().length);
                    if (currentDSAValue.length == 129) {
                        if (currentDSAValue[0] != 0) throw new InvalidKeyException("Invalid key value:  The DSA key contains 129 bytes and the most signifigant byte is not zero. \n");
                        newDSAValue = new byte[currentDSAValue.length - 1];
                        System.arraycopy(currentDSAValue, 1, newDSAValue, 0, currentDSAValue.length - 1);
                        useCurrentDSAValue = false;
                    } else if (currentDSAValue.length == 128) {
                        useCurrentDSAValue = true;
                    } else if (currentDSAValue.length < 128) {
                        int numberOfMissingBytes = 128 - currentDSAValue.length;
                        if ((currentDSAValue[0] & 0x80) != 0) {
                            throw new InvalidKeyException("Invalid key value:  The DSA key contains less than 128 bytes and the most signifigant bit of the key is not zero. \n");
                        }
                        newDSAValue = new byte[currentDSAValue.length + numberOfMissingBytes];
                        for (int j = 0; j < numberOfMissingBytes; ++j) {
                            newDSAValue[j] = 0;
                        }
                        System.arraycopy(currentDSAValue, 0, newDSAValue, numberOfMissingBytes, currentDSAValue.length);
                        useCurrentDSAValue = false;
                    }
                    ID = this.genID();
                    HashMap<Integer, Object> hattrs = null;
                    Set<Integer> keys = null;
                    int numEles = 0;
                    if (this.config != null) {
                        hattrs = this.config.getAttributes("IMPORT", PKCS11Object.PUBLIC_KEY, PKCS11Object.DSA);
                        keys = hattrs.keySet();
                        numEles = keys.size();
                        attrTypes = new int[7 + numEles];
                        attrValues = new Object[7 + numEles];
                        attrTypes[0] = 0;
                        attrTypes[1] = 256;
                        attrTypes[2] = 258;
                        attrTypes[3] = 304;
                        attrTypes[4] = 305;
                        attrTypes[5] = 306;
                        attrTypes[6] = 17;
                        attrValues[0] = PKCS11Object.PUBLIC_KEY;
                        attrValues[1] = PKCS11Object.DSA;
                        attrValues[2] = ID;
                        attrValues[3] = p;
                        attrValues[4] = q;
                        attrValues[5] = g;
                        attrValues[6] = !useCurrentDSAValue ? (Object)newDSAValue : (Object)y.toByteArray();
                        Iterator<Integer> it = keys.iterator();
                        int i = 1;
                        while (it.hasNext()) {
                            Integer key = it.next();
                            attrTypes[6 + i] = key;
                            attrValues[6 + i] = hattrs.get(key);
                            ++i;
                        }
                    } else {
                        attrTypes = new int[]{0, 256, 258, 1, 266, 304, 305, 306, 17};
                        attrValues = new Object[]{PKCS11Object.PUBLIC_KEY, PKCS11Object.DSA, ID, Boolean.FALSE, Boolean.TRUE, p, q, g, !useCurrentDSAValue ? newDSAValue : y.toByteArray()};
                    }
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGeneratePublic", "P: " + p + "\n bit len: " + p.bitLength());
                        debug.text(16384L, (Object)className, "engineGeneratePublic", "Q: " + q + "\n bit len: " + q.bitLength());
                        debug.text(16384L, (Object)className, "engineGeneratePublic", "G: " + g + "\n bit len: " + g.bitLength());
                        debug.text(16384L, (Object)className, "engineGeneratePublic", "Y: " + y + "\n bit len: " + y.bitLength());
                        HexDumpEncoder encoder = new HexDumpEncoder();
                        if (!useCurrentDSAValue) {
                            String newDSAValueHexString = encoder.encodeBuffer(newDSAValue);
                            debug.text(16384L, (Object)className, "engineGeneratePublic", "newDSAValueHexString is \n" + newDSAValueHexString);
                        } else {
                            String yHexString = encoder.encodeBuffer(y.toByteArray());
                            debug.text(16384L, (Object)className, "engineGeneratePublic", "yHexString is \n" + yHexString);
                        }
                    }
                    Session session = null;
                    boolean isSession = false;
                    try {
                        session = this.sessionManager.getObjSession();
                        object = session.createObject(attrTypes, attrValues);
                        boolean isToken = false;
                        if (!session.getBoolAttributeValue(object, 1)) {
                            session.addObject();
                            isSession = true;
                        }
                        pubDSA = new DSAPublicKey(session, object, ID, null, null, Boolean.FALSE, p, q, g, y);
                    }
                    finally {
                        this.sessionManager.releaseSession(session);
                    }
                    if (isSession) {
                        pubDSA.setSession(session);
                    }
                    if (debug == null) return pubDSA;
                    debug.exit(16384L, (Object)className, "engineGeneratePublic");
                    return pubDSA;
                }
                catch (Exception e) {
                    if (debug == null) throw new InvalidKeySpecException("Invalid key spec: " + e.getMessage() + "  Ensure that the supplied key spec does not describe a DSA Public Key longer than 1024.");
                    debug.exception(16384L, (Object)className, "engineGeneratePublic_1", (Throwable)e);
                    debug.exit(16384L, (Object)className, "engineGeneratePublic");
                    throw new InvalidKeySpecException("Invalid key spec: " + e.getMessage() + "  Ensure that the supplied key spec does not describe a DSA Public Key longer than 1024.");
                }
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineGeneratePublic");
                }
                Session sess = null;
                try {
                    sess = this.sessionManager.getObjSession();
                    DSAPublicKey q = new DSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded(), sess, this.config);
                    return q;
                }
                finally {
                    this.sessionManager.releaseSession(sess);
                }
            }
            if (!(keySpec instanceof PKCS11KeySpec)) {
                if (debug == null) throw new InvalidKeySpecException("Invalid key spec");
                debug.text(16384L, (Object)className, "engineGeneratePublic_1", "Invalid Key spec");
                debug.exit(16384L, (Object)className, "engineGeneratePublic");
                throw new InvalidKeySpecException("Invalid key spec");
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "engineGeneratePublic_3");
            }
            PKCS11Object object = ((PKCS11KeySpec)keySpec).getObject();
            Session session = null;
            try {
                DSAPublicKey pubKey;
                session = this.sessionManager.getOpSession();
                DSAPublicKey dSAPublicKey = pubKey = new DSAPublicKey(session, object, (byte[])session.getAttrValue(object, 258), (byte[])session.getAttrValue(object, 257), (String)session.getAttrValue(object, 3), (Boolean)session.getAttrValue(object, 1), (BigInteger)session.getAttrValue(object, 304), (BigInteger)session.getAttrValue(object, 305), (BigInteger)session.getAttrValue(object, 306), new BigInteger((byte[])session.getAttrValue(object, 17)));
                return dSAPublicKey;
            }
            finally {
                this.sessionManager.releaseSession(session);
            }
        }
        catch (InvalidKeyException e) {
            if (debug == null) throw new InvalidKeySpecException("Invalid key spec: " + e.getMessage());
            debug.exception(16384L, (Object)className, "engineGeneratePublic_2", (Throwable)e);
            debug.exit(16384L, (Object)className, "engineGeneratePublic");
            throw new InvalidKeySpecException("Invalid key spec: " + e.getMessage());
        }
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            String keyString = key.toString();
            debug.entry(16384L, (Object)className, "engineGetKeySpec", (Object)keyString, keySpec);
        }
        try {
            Class<Object> dsaPrivKeySpec;
            Class<T> dsaPubKeySpec;
            if (key instanceof PKCS11DSAPublicKey) {
                dsaPubKeySpec = Class.forName("java.security.spec.DSAPublicKeySpec");
                Class<T> x509KeySpec = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (dsaPubKeySpec.isAssignableFrom(keySpec)) {
                    DSAPublicKey dsaPubKey = (DSAPublicKey)key;
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec", (Object)"DSAPublicKeySpec");
                    }
                    return (T)new DSAPublicKeySpec(dsaPubKey.getValue(), dsaPubKey.getPrime(), dsaPubKey.getSubprime(), dsaPubKey.getBase());
                }
                if (x509KeySpec.isAssignableFrom(keySpec)) {
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec", (Object)"X509EncodedKeySpec");
                    }
                    return (T)new X509EncodedKeySpec(key.getEncoded());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof java.security.interfaces.DSAPublicKey) {
                dsaPubKeySpec = Class.forName("java.security.spec.DSAPublicKeySpec");
                Class<T> x509KeySpec = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (dsaPubKeySpec.isAssignableFrom(keySpec)) {
                    java.security.interfaces.DSAPublicKey dsaPubKey = (java.security.interfaces.DSAPublicKey)key;
                    DSAParams dsaParms = dsaPubKey.getParams();
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec", (Object)"DSAPublicKeySpec_1");
                    }
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec", (Object)"To trim value of Y in DSA public key.");
                    }
                    BigInteger trimmed_Y = this.getTrimmedKey(dsaPubKey.getY(), false);
                    return (T)new DSAPublicKeySpec(trimmed_Y, dsaParms.getP(), dsaParms.getQ(), dsaParms.getG());
                }
                if (x509KeySpec.isAssignableFrom(keySpec)) {
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec", (Object)"X509EncodedKeySpec_1");
                    }
                    return (T)new X509EncodedKeySpec(key.getEncoded());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof PKCS11DSAPrivateKey) {
                dsaPrivKeySpec = Class.forName("java.security.spec.DSAPrivateKeySpec");
                if (dsaPrivKeySpec.isAssignableFrom(keySpec)) {
                    DSAPrivateKey dsaPrivKey = (DSAPrivateKey)key;
                    if (dsaPrivKey.getSensitive().booleanValue()) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineGetKeySpec", "Private key value is not exportable");
                            debug.exit(16384L, (Object)className, "engineGetKeySpec");
                        }
                        throw new PKCS11Exception("Private key value is not exportable");
                    }
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec", (Object)"DSAPrivateKeySpec");
                    }
                    return (T)new DSAPrivateKeySpec(dsaPrivKey.getValue(), dsaPrivKey.getPrime(), dsaPrivKey.getSubprime(), dsaPrivKey.getBase());
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineGetKeySpec", "Inappropriate key specification");
                    debug.exit(16384L, (Object)className, "engineGetKeySpec");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof java.security.interfaces.DSAPrivateKey) {
                dsaPrivKeySpec = Class.forName("java.security.spec.DSAPrivateKeySpec");
                if (dsaPrivKeySpec.isAssignableFrom(keySpec)) {
                    java.security.interfaces.DSAPrivateKey dsaPrivKey = (java.security.interfaces.DSAPrivateKey)key;
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec", (Object)"To trim value of X in DSA private key.");
                    }
                    BigInteger trimmed_X = this.getTrimmedKey(dsaPrivKey.getX(), true);
                    DSAParams dsaParms = dsaPrivKey.getParams();
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineGetKeySpec", (Object)"DSAPrivateKeySpec_1");
                    }
                    return (T)new DSAPrivateKeySpec(trimmed_X, dsaParms.getP(), dsaParms.getQ(), dsaParms.getG());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineGetKeySpec", "Inappropriate key specification");
                debug.exit(16384L, (Object)className, "engineGetKeySpec");
            }
            throw new InvalidKeySpecException("Inappropriate key type");
        }
        catch (ClassNotFoundException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGetKeySpec", (Throwable)e);
                debug.exit(16384L, (Object)className, "engineGetKeySpec");
            }
            throw new InvalidKeySpecException("Unsupported key specification: " + e.getMessage());
        }
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (debug != null) {
            String keyString = key.toString();
            debug.entry(16384L, (Object)className, "engineTranslateKey", (Object)keyString);
        }
        try {
            if (key instanceof java.security.interfaces.DSAPublicKey) {
                if (key instanceof DSAPublicKey) {
                    return key;
                }
                DSAPublicKeySpec dsaPubKeySpec = this.engineGetKeySpec(key, DSAPublicKeySpec.class);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineTranslateKey", (Object)"DSAPublicKey");
                }
                return this.engineGeneratePublic(dsaPubKeySpec);
            }
            if (key instanceof java.security.interfaces.DSAPrivateKey) {
                if (key instanceof DSAPrivateKey) {
                    return key;
                }
                DSAPrivateKeySpec dsaPrivKeySpec = this.engineGetKeySpec(key, DSAPrivateKeySpec.class);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "engineTranslateKey", (Object)"DSAPrivateKey");
                }
                return this.engineGeneratePrivate(dsaPrivKeySpec);
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineTranslateKey", "Wrong algorithm type");
                debug.exit(16384L, (Object)className, "engineTranslateKey");
            }
            throw new InvalidKeyException("Wrong algorithm type");
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineTranslateKey", (Throwable)e);
                debug.exit(16384L, (Object)className, "engineTranslateKey");
            }
            throw new InvalidKeyException("Cannot translate key: " + e.getMessage() + "  Ensure that the DSA key being translated is not longer than 1024.");
        }
    }

    private byte[] genID() {
        byte[] labelName = new byte[32];
        byte[] labelSaltData = new byte[24];
        byte[] labelTmp = null;
        int labelLength = 0;
        try {
            SecureRandom random = SecureRandom.getInstance("IBMSecureRandom", "IBMPKCS11Impl");
            random.nextBytes(labelSaltData);
        }
        catch (Exception e) {
            // empty catch block
        }
        BigInteger bigInt = new BigInteger(1, labelSaltData);
        try {
            labelTmp = bigInt.toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("Can not convert string");
        }
        labelLength = bigInt.toString().length();
        if (labelLength > 23) {
            labelLength = 23;
        }
        System.arraycopy(labelTmp, 0, labelName, 9, labelLength);
        labelName[0] = 73;
        labelName[1] = 66;
        labelName[2] = 77;
        labelName[3] = 80;
        labelName[4] = 75;
        labelName[5] = 67;
        labelName[6] = 83;
        labelName[7] = 49;
        labelName[8] = 49;
        return labelName;
    }

    private byte[] trimLeadingZeroes(BigInteger value, boolean trimPrivateKey) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "trimLeadingZeroes");
            debug.text(16384L, (Object)className, "trimLeadingZeroes", "The value upon entry is:");
            debug.text(16384L, (Object)className, "trimLeadingZeroes", DSAPKCS11KeyFactory.toHexString(value.toByteArray()));
            debug.text(16384L, (Object)className, "trimLeadingZeroes", "Length of the value upon entry = " + value.toByteArray().length);
        }
        byte[] currentDSAValue = new byte[value.toByteArray().length];
        boolean useCurrentDSAValue = true;
        byte[] newDSAValue = null;
        System.arraycopy(value.toByteArray(), 0, currentDSAValue, 0, value.toByteArray().length);
        int expectedLength = 128;
        if (trimPrivateKey) {
            expectedLength = 20;
        }
        if (currentDSAValue.length > expectedLength) {
            int numLeadingZeroes = currentDSAValue.length - expectedLength;
            newDSAValue = new byte[expectedLength];
            for (int i = 0; i < numLeadingZeroes; ++i) {
                if (currentDSAValue[i] == 0) continue;
                throw new InvalidKeySpecException("Invalid key value:  The DSA key contains more bytes than expected, and the leading bytes are not zero.  Ensure that the DSA key size is less than 1024. \n");
            }
            System.arraycopy(currentDSAValue, numLeadingZeroes, newDSAValue, 0, expectedLength);
            useCurrentDSAValue = false;
        } else if (currentDSAValue.length < expectedLength) {
            if ((currentDSAValue[0] & 0x80) != 0) {
                throw new InvalidKeySpecException("Invalid key value:  The DSA key contains less than" + expectedLength + " bytes and the most signifigant bit of the key is not zero. \n");
            }
            int numPadding = expectedLength - currentDSAValue.length;
            newDSAValue = new byte[expectedLength];
            for (int i = 0; i < numPadding; ++i) {
                newDSAValue[i] = 0;
            }
            System.arraycopy(currentDSAValue, 0, newDSAValue, numPadding, currentDSAValue.length);
            useCurrentDSAValue = false;
        } else if (currentDSAValue.length == expectedLength) {
            useCurrentDSAValue = true;
        }
        if (useCurrentDSAValue) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "trimLeadingZeroes", "\nReturning an unmodified value: ");
                debug.text(16384L, (Object)className, "trimLeadingZeroes", DSAPKCS11KeyFactory.toHexString(currentDSAValue));
                debug.text(16384L, (Object)className, "trimLeadingZeroes", "Length of unmodified value = " + currentDSAValue.length);
            }
            return currentDSAValue;
        }
        if (debug != null) {
            debug.text(16384L, (Object)className, "trimLeadingZeroes", "\nReturning a modified value: ");
            debug.text(16384L, (Object)className, "trimLeadingZeroes", DSAPKCS11KeyFactory.toHexString(newDSAValue));
            debug.text(16384L, (Object)className, "trimLeadingZeroes", "Length of modified value = " + newDSAValue.length);
        }
        return newDSAValue;
    }

    private BigInteger getTrimmedKey(BigInteger value, boolean trimPrivateKey) throws InvalidKeySpecException {
        byte[] trimmedValue = this.trimLeadingZeroes(value, trimPrivateKey);
        BigInteger valueToBeReturned = new BigInteger(trimmedValue);
        return valueToBeReturned;
    }

    public static String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int len = block.length;
        int high = 0;
        int low = 0;
        for (int i = 0; i < len; ++i) {
            if (i % 16 == 0) {
                buf.append('\n');
            }
            high = (block[i] & 0xF0) >> 4;
            low = block[i] & 0xF;
            buf.append(hexChars[high]);
            buf.append(hexChars[low]);
            buf.append(' ');
        }
        return buf.toString();
    }
}

