/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.commonNativeAdapterData.repositoryAdapter;

import com.ibm.cic.common.commonNativeAdapterData.NativeFileArtifact;
import com.ibm.cic.common.commonNativeAdapterData.ZipArtifact;
import com.ibm.cic.common.core.artifactrepo.IArtifactRepositoryAdapter;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.adapterdata.ArtifactTypeInfo;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.model.adapterdata.IArtifactTypeKeyMapper;
import com.ibm.cic.common.core.model.adapterdata.impl.ArtifactKey;
import com.ibm.cic.common.core.model.adapterdata.impl.ArtifactReferenceParseUtil;
import com.ibm.cic.common.core.utils.PathUtil;
import com.ibm.cic.common.core.utils.SplitIdVersionUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Version;

public class NativeRepositoryAdapter
implements IArtifactRepositoryAdapter {
    public static final String DIR_NATIVE = "native";
    public static final String DIR_FILES = "files";
    private static final String[] TOPLEVEL_DIRS = new String[]{"native", "files"};
    public static final String ID = "native";
    public static final String ZIP_QUALIFIER = "zip";
    public static final String FILE_QUALIFIER = "file";
    public static final String DEFAULT_FILE_EXTENSION_NO_DOT = "file";
    public static final String[] SUPPORTED_TYPES = new String[]{"zip", "file"};

    public IPath toNamespaceUniquePath(IArtifactKey key) {
        if (!"native".equals(key.getNamespace())) {
            throw new IllegalArgumentException();
        }
        String qual = key.getQualifier();
        if (ZIP_QUALIFIER.equals(qual)) {
            String prefix = "native/" + key.getId().getId() + '_' + key.getVersion().toString();
            IPath path = key.getPath();
            if (path.isEmpty()) {
                return new Path(String.valueOf(prefix) + CicConstants.getZipFileDotExt());
            }
            return new Path(prefix).append(path);
        }
        if ("file".equals(qual)) {
            String extensionNoDot = key.getPath().toString();
            if (extensionNoDot.length() == 0) {
                extensionNoDot = "file";
            }
            String path = "files/" + key.getId().getId() + '_' + key.getVersion().toString() + '.' + extensionNoDot;
            return new Path(path);
        }
        return null;
    }

    public String[] enumerateTopLevelDirs() {
        return TOPLEVEL_DIRS;
    }

    public String toUserString(IArtifactKey key, int options) {
        if (!"native".equals(key.getNamespace())) {
            throw new IllegalArgumentException();
        }
        String qual = key.getQualifier();
        if (ZIP_QUALIFIER.equals(qual)) {
            return ZipArtifact.toUserString(key, options);
        }
        if ("file".equals(qual)) {
            return NativeFileArtifact.toUserString(key, options);
        }
        throw new IllegalArgumentException();
    }

    public IArtifactKey toNamespaceArtifactKey(IPath relPath) {
        IArtifactKey key = this.privateToNamespaceArtifactKey(relPath);
        if (key == null) {
            return null;
        }
        IPath path2 = this.toNamespaceUniquePath(key);
        if (!relPath.equals((Object)path2)) {
            return null;
        }
        return key;
    }

    private IArtifactKey privateToNamespaceArtifactKey(IPath relPath) {
        if (relPath.segmentCount() >= 2) {
            String s0 = relPath.segment(0);
            if (s0.equals("native")) {
                return this.toNativeZipKey(relPath);
            }
            if (s0.equals(DIR_FILES)) {
                return this.toNativeFileKey(relPath);
            }
        }
        return null;
    }

    private IArtifactKey toNativeZipKey(IPath relPath) {
        String nameWithoutExtension;
        Path path = Path.EMPTY;
        if (relPath.segmentCount() > 2) {
            nameWithoutExtension = relPath.segment(1);
            path = path.removeFirstSegments(2);
        } else {
            if (!PathUtil.hasExtension((String)relPath.lastSegment(), (String)ZIP_QUALIFIER, (boolean)true)) {
                return null;
            }
            nameWithoutExtension = relPath.removeFileExtension().lastSegment();
        }
        Object[] idAndVersion = SplitIdVersionUtil.splitIdUnderscoreVersion((String)nameWithoutExtension);
        String id = (String)idAndVersion[0];
        Version version = (Version)idAndVersion[1];
        if (version == null) {
            return null;
        }
        return new ArtifactKey((IPath)path, "native", ZIP_QUALIFIER, (IIdentity)new SimpleIdentity(id), version);
    }

    private IArtifactKey toNativeFileKey(IPath relPath) {
        if (relPath.segmentCount() != 2) {
            return null;
        }
        String nameWithoutExtension = relPath.removeFileExtension().segment(1);
        Object[] idAndVersion = SplitIdVersionUtil.splitIdUnderscoreVersion((String)nameWithoutExtension);
        String id = (String)idAndVersion[0];
        Version version = (Version)idAndVersion[1];
        if (version == null) {
            return null;
        }
        String strExtension = relPath.getFileExtension();
        if (strExtension == null) {
            return null;
        }
        Path extension = null;
        extension = strExtension.equals("file") ? Path.EMPTY : new Path(strExtension);
        return new ArtifactKey((IPath)extension, "native", "file", (IIdentity)new SimpleIdentity(id), version);
    }

    public ArtifactTypeInfo getArtifactTypeInfo(String type) {
        if (ZIP_QUALIFIER.equals(type)) {
            ArtifactTypeInfo ati = new ArtifactTypeInfo();
            ati.setType(type);
            ati.setKeyNamespace("native");
            ati.setKeyQualifier(ZIP_QUALIFIER);
            return ati;
        }
        if ("file".equals(type)) {
            ArtifactTypeInfo ati = new ArtifactTypeInfo();
            ati.setType(type);
            ati.setKeyNamespace("native");
            ati.setKeyQualifier("file");
            ati.setTypeSpecificAttributeNames(new String[]{"ext"});
            return ati;
        }
        return null;
    }

    public String[] getSupportedArtifactTypes() {
        return SUPPORTED_TYPES;
    }

    public IArtifactTypeKeyMapper getTypeKeyMapper(String type) {
        if (ZIP_QUALIFIER.equals(type)) {
            ArtifactTypeInfo ati = this.getArtifactTypeInfo(type);
            ArtifactReferenceParseUtil.BaseArtifactsTypeKeyMapper refParser = new ArtifactReferenceParseUtil.BaseArtifactsTypeKeyMapper(ati);
            return refParser;
        }
        if ("file".equals(type)) {
            ArtifactTypeInfo ati = this.getArtifactTypeInfo(type);
            ArtifactReferenceParseUtil.ArtifactsTypeWithExtKeyMapper refParser = new ArtifactReferenceParseUtil.ArtifactsTypeWithExtKeyMapper(ati, "file");
            return refParser;
        }
        return null;
    }
}

