/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tivoli.omnibus.core.custompanel;

import com.ibm.cic.agent.core.api.ICustomPanelData;
import com.ibm.cic.agent.core.api.ILogger;
import com.ibm.cic.agent.core.api.IMLogger;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.custompanel.api.TemplateConstants;
import com.ibm.cic.agent.core.custompanel.api.TemplateCustomPanel;
import com.ibm.cic.agent.core.custompanel.api.TemplateWidgetContainer;
import com.ibm.tivoli.omnibus.core.custompanel.Messages;
import org.eclipse.core.runtime.IProgressMonitor;

public class Java8Panel
extends TemplateCustomPanel {
    private final String OMNIBUS = "omnibus.core.";
    private final String JAVA8_ACCEPTANCE = "user.omnibus.core.java8warning.accepted";
    private final TemplateCustomPanel.UserData java8Data = this.createUserData("user.omnibus.core.java8warning.accepted", "Accept Java 8 Warnings");
    private ILogger logger = IMLogger.getLogger((String)((Object)((Object)this)).getClass().getCanonicalName());

    public Java8Panel() {
        super(Messages.Java8PanelName);
    }

    public void createWidgets(TemplateWidgetContainer parentContainer) {
        TemplateWidgetContainer twcJava8 = parentContainer.layout(TemplateConstants.LayoutType.VERTICAL);
        twcJava8.createLabel(Messages.Java8Label).style(TemplateConstants.LabelStyle.BOLD);
        twcJava8.createLabel("");
        twcJava8.createLabel(Messages.Java8OSSupportLabel).style(TemplateConstants.LabelStyle.BOLD);
        twcJava8.createLabel(Messages.Java8OSSupport);
        twcJava8.createLabel("");
        twcJava8.createLabel(Messages.Java8MigrationLabel).style(TemplateConstants.LabelStyle.BOLD);
        twcJava8.createLabel(Messages.Java8Migration);
        twcJava8.createLabel("");
        twcJava8.createCheckBox(this.java8Data, Messages.Java8Acceptance, "true");
    }

    public void updateWidgets(TemplateCustomPanel.UserData userData) {
    }

    public void validate(IProgressMonitor monitor) {
        String boxChecked = this.java8Data.getValue();
        if (boxChecked == null || !boxChecked.equalsIgnoreCase("true")) {
            this.logger.warning("The Java8 notices not accepted or missing");
            this.java8Data.error(Messages.Java8WarningsNotAccepted, new Object[0]);
        } else {
            this.logger.debug("The Java 8 notices have been accepted");
        }
    }

    public boolean canAddPanelToWizard() {
        ICustomPanelData cpdata = this.getCustomPanelData();
        IProfile profile = cpdata.getProfile();
        if (profile == null) {
            return true;
        }
        String currentValue = profile.getOfferingUserData("user.omnibus.core.java8warning.accepted", "com.ibm.tivoli.omnibus.core");
        return currentValue == null || !currentValue.equalsIgnoreCase("true");
    }

    public boolean shouldSkip() {
        return false;
    }
}

