/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.oti.util.Msg;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import sun.reflect.CallerSensitive;

public final class AccessController {
    private static final SecurityPermission createAccessControlContext;

    private static native void initializeInternal();

    private AccessController() {
    }

    private static native Object[] getProtectionDomains(int var0);

    private static native Object[] getDoPrivilegedWithCombinerAccPDs(int var0);

    private static void throwACE(boolean debug, Permission perm, ProtectionDomain pDomain, boolean createACCdenied) {
        if (debug && (AccessControlContext.debugSetting() & 1) != 0) {
            DebugRecursionDetection.getTlDebug().set("");
            AccessControlContext.debugPrintAccess();
            if (createACCdenied) {
                System.err.println("access denied " + perm + " due to untrusted AccessControlContext since " + createAccessControlContext + " is denied.");
            } else {
                System.err.println("access denied " + perm);
            }
            DebugRecursionDetection.getTlDebug().remove();
        }
        if (debug && (AccessControlContext.debugSetting() & 8) != 0) {
            DebugRecursionDetection.getTlDebug().set("");
            new Exception("Stack trace").printStackTrace();
            if (createACCdenied) {
                System.err.println("domain that failed " + createAccessControlContext + " check " + pDomain);
            } else {
                System.err.println("domain that failed " + pDomain);
            }
            DebugRecursionDetection.getTlDebug().remove();
        }
        if (createACCdenied) {
            throw new AccessControlException(Msg.getString("K002d", perm, createAccessControlContext), perm);
        }
        throw new AccessControlException(Msg.getString("K002c", perm), perm);
    }

    public static void checkPermission(Permission perm) throws AccessControlException {
        ProtectionDomain callerPD;
        int length;
        ProtectionDomain[] pDomains;
        Object[] domains;
        AccessControlContext acc;
        if (perm == null) {
            throw new NullPointerException();
        }
        boolean debug = true;
        if (AccessControlContext.debugSetting() != 0 && DebugRecursionDetection.getTlDebug().get() != null) {
            debug = false;
        }
        if (debug && (AccessControlContext.debugSetting() & 2) != 0) {
            DebugRecursionDetection.getTlDebug().set("");
            new Exception("Stack trace").printStackTrace();
            DebugRecursionDetection.getTlDebug().remove();
        }
        if (AccessController.shouldInvokeDomainCombinerCombine(acc = (AccessControlContext)(domains = AccessController.getProtectionDomains(1))[0])) {
            if (debug && (AccessControlContext.debugSetting() & 1) != 0) {
                DebugRecursionDetection.getTlDebug().set("");
                AccessControlContext.debugPrintAccess();
                System.err.println("AccessController invoking the Combiner");
                DebugRecursionDetection.getTlDebug().remove();
            }
            pDomains = acc.domainCombiner.combine(AccessController.toArrayOfProtectionDomains(domains, null, 2), acc.context);
        } else {
            pDomains = AccessController.toArrayOfProtectionDomains(domains, acc, 2);
        }
        if (debug && (AccessControlContext.debugSetting() & 4) != 0) {
            DebugRecursionDetection.getTlDebug().set("");
            AccessControlContext.debugPrintAccess();
            if (pDomains == null || pDomains.length == 0) {
                System.err.println("domain (context is null)");
            } else {
                for (int i = 0; i < pDomains.length; ++i) {
                    System.err.println("domain " + i + " " + pDomains[i]);
                }
            }
            DebugRecursionDetection.getTlDebug().remove();
        }
        int n = length = pDomains == null ? 0 : pDomains.length;
        if (null != acc && null != acc.context && AccessControlContext.STATE_AUTHORIZED != acc.authorizeState && null != System.getSecurityManager() && null != (callerPD = (ProtectionDomain)domains[1]) && !callerPD.implies(createAccessControlContext)) {
            AccessController.throwACE(debug, perm, callerPD, true);
        }
        for (int i = 0; i < length; ++i) {
            if (pDomains[length - i - 1].implies(perm)) continue;
            AccessController.throwACE(debug, perm, pDomains[length - i - 1], false);
        }
        if (debug && (AccessControlContext.debugSetting() & 1) != 0) {
            DebugRecursionDetection.getTlDebug().set("");
            AccessControlContext.debugPrintAccess();
            System.err.println("access allowed " + perm);
            DebugRecursionDetection.getTlDebug().remove();
        }
    }

    private static void keepalive(AccessControlContext context) {
    }

    public static AccessControlContext getContext() {
        Object[] domains = AccessController.getProtectionDomains(1);
        AccessControlContext acc = (AccessControlContext)domains[0];
        ProtectionDomain callerPD = (ProtectionDomain)domains[1];
        if (AccessController.shouldInvokeDomainCombinerCombine(acc)) {
            ProtectionDomain[] pDomains = acc.domainCombiner.combine(AccessController.toArrayOfProtectionDomains(domains, null, 2), acc.context);
            if (pDomains != null && pDomains.length == 0) {
                pDomains = null;
            }
            AccessControlContext result = new AccessControlContext(pDomains, acc.authorizeState, callerPD);
            result.domainCombiner = acc.domainCombiner;
            return result;
        }
        return new AccessControlContext(AccessController.toArrayOfProtectionDomains(domains, acc, 2), AccessController.getNewAuthorizedState(acc, callerPD), callerPD);
    }

    private static boolean shouldInvokeDomainCombinerCombine(AccessControlContext acc) {
        return null != acc && null != acc.domainCombiner && (AccessControlContext.STATE_AUTHORIZED == acc.authorizeState || null == System.getSecurityManager());
    }

    private static int getNewAuthorizedState(AccessControlContext acc, ProtectionDomain callerPD) {
        int newAuthorizedState = null != acc && null != System.getSecurityManager() ? (AccessControlContext.STATE_UNKNOWN == acc.authorizeState ? (null == callerPD || callerPD.implies(createAccessControlContext) ? AccessControlContext.STATE_AUTHORIZED : AccessControlContext.STATE_NOT_AUTHORIZED) : acc.authorizeState) : AccessControlContext.STATE_AUTHORIZED;
        return newAuthorizedState;
    }

    private static ProtectionDomain[] toArrayOfProtectionDomains(Object[] domains, AccessControlContext acc, int startPos) {
        int len = 0;
        int extra = 0;
        int size = domains.length - startPos;
        if (null != acc && null != acc.context) {
            extra = acc.context.length;
        }
        ProtectionDomain[] answer = new ProtectionDomain[size + extra];
        for (int i = startPos; i < domains.length; ++i) {
            boolean found = false;
            answer[len] = (ProtectionDomain)domains[i];
            if (null == answer[len]) break;
            if (null != acc && null != acc.context) {
                for (int j = 0; j < acc.context.length; ++j) {
                    if (answer[len] != acc.context[j]) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            ++len;
        }
        if (0 == len && null != acc) {
            return acc.context;
        }
        if (0 == len + extra) {
            return null;
        }
        if (len < size) {
            ProtectionDomain[] copy = new ProtectionDomain[len + extra];
            System.arraycopy((Object)answer, 0, (Object)copy, 0, len);
            answer = copy;
        }
        if (null != acc && null != acc.context) {
            System.arraycopy((Object)acc.context, 0, (Object)answer, len, acc.context.length);
        }
        return answer;
    }

    @CallerSensitive
    public static <T> T doPrivileged(PrivilegedAction<T> action) {
        return action.run();
    }

    @CallerSensitive
    public static <T> T doPrivileged(PrivilegedAction<T> action, AccessControlContext context) {
        T result = action.run();
        AccessController.keepalive(context);
        return result;
    }

    @CallerSensitive
    public static <T> T doPrivileged(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        try {
            return action.run();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PrivilegedActionException(ex);
        }
    }

    @CallerSensitive
    public static <T> T doPrivileged(PrivilegedExceptionAction<T> action, AccessControlContext context) throws PrivilegedActionException {
        try {
            T result = action.run();
            AccessController.keepalive(context);
            return result;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new PrivilegedActionException(ex);
        }
    }

    @CallerSensitive
    private static AccessControlContext buildACCwithCombiner() {
        Object[] domains = AccessController.getDoPrivilegedWithCombinerAccPDs(2);
        AccessControlContext acc = (AccessControlContext)domains[0];
        ProtectionDomain callerPD = (ProtectionDomain)domains[1];
        AccessControlContext accWithCombiner = null;
        ProtectionDomain[] pDomains = null;
        if (null == acc || null == acc.domainCombiner) {
            pDomains = AccessController.toArrayOfProtectionDomains(domains, acc, 2);
        }
        accWithCombiner = new AccessControlContext(pDomains, AccessController.getNewAuthorizedState(acc, callerPD), callerPD);
        if (null != acc && null != acc.domainCombiner) {
            accWithCombiner.domainCombiner = acc.domainCombiner;
        }
        return accWithCombiner;
    }

    @CallerSensitive
    public static <T> T doPrivilegedWithCombiner(PrivilegedAction<T> action) {
        return AccessController.doPrivileged(action, AccessController.buildACCwithCombiner());
    }

    @CallerSensitive
    public static <T> T doPrivilegedWithCombiner(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        return AccessController.doPrivileged(action, AccessController.buildACCwithCombiner());
    }

    static {
        AccessController.initializeInternal();
        createAccessControlContext = new SecurityPermission("createAccessControlContext");
    }

    static class DebugRecursionDetection {
        private static ThreadLocal<String> tlDebug = new ThreadLocal();

        DebugRecursionDetection() {
        }

        static ThreadLocal<String> getTlDebug() {
            return tlDebug;
        }
    }
}

