/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.ComputedCalls;
import java.lang.invoke.DirectHandle;
import java.lang.invoke.IndirectHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkTable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

final class VirtualHandle
extends IndirectHandle {
    private static final ThunkTable _thunkTable = new ThunkTable();

    VirtualHandle(Method method) throws IllegalAccessException {
        super(VirtualHandle.virtualMethodType(method), method.getDeclaringClass(), method.getName(), 2);
        if (Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException();
        }
        boolean succeed = VirtualHandle.setVMSlotAndRawModifiersFromMethod(this, this.definingClass, method, this.kind, null);
        if (!succeed) {
            throw new IllegalAccessException();
        }
    }

    VirtualHandle(DirectHandle nonVirtualHandle) throws IllegalAccessException {
        super(nonVirtualHandle.type(), nonVirtualHandle.definingClass, nonVirtualHandle.name, 2);
        this.rawModifiers = nonVirtualHandle.rawModifiers;
        this.defc = nonVirtualHandle.defc;
        boolean succeed = VirtualHandle.setVMSlotAndRawModifiersFromSpecialHandle(this, nonVirtualHandle);
        if (!succeed) {
            throw new IllegalAccessException();
        }
    }

    VirtualHandle(VirtualHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
    }

    private static final MethodType virtualMethodType(Method method) {
        MethodType originalType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
        return VirtualHandle.virtualMethodType(originalType, method.getDeclaringClass());
    }

    private static final MethodType virtualMethodType(MethodType type, Class definingClass) {
        return type.insertParameterTypes(0, definingClass);
    }

    @Override
    protected final int vtableIndex(Object receiver) {
        return ((int)this.vmSlot - INTRP_VTABLE_OFFSET) / VTABLE_ENTRY_SIZE;
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    @MethodHandle.Invisible
    private final void invokeExact_thunkArchetype_V(Object receiver, int argPlaceholder) {
        ComputedCalls.dispatchVirtual_V(this.jittedMethodAddress(receiver), this.vtableIndexArgument(receiver), receiver, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final int invokeExact_thunkArchetype_I(Object receiver, int argPlaceholder) {
        return ComputedCalls.dispatchVirtual_I(this.jittedMethodAddress(receiver), this.vtableIndexArgument(receiver), receiver, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final long invokeExact_thunkArchetype_J(Object receiver, int argPlaceholder) {
        return ComputedCalls.dispatchVirtual_J(this.jittedMethodAddress(receiver), this.vtableIndexArgument(receiver), receiver, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final float invokeExact_thunkArchetype_F(Object receiver, int argPlaceholder) {
        return ComputedCalls.dispatchVirtual_F(this.jittedMethodAddress(receiver), this.vtableIndexArgument(receiver), receiver, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final double invokeExact_thunkArchetype_D(Object receiver, int argPlaceholder) {
        return ComputedCalls.dispatchVirtual_D(this.jittedMethodAddress(receiver), this.vtableIndexArgument(receiver), receiver, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final Object invokeExact_thunkArchetype_L(Object receiver, int argPlaceholder) {
        return ComputedCalls.dispatchVirtual_L(this.jittedMethodAddress(receiver), this.vtableIndexArgument(receiver), receiver, argPlaceholder);
    }

    @Override
    MethodHandle cloneWithNewType(MethodType newType) {
        return new VirtualHandle(this, newType);
    }
}

