/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.lang.ArgumentHelper;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import com.ibm.oti.vm.VMLangAccess;
import java.lang.invoke.ConstructorHandle;
import java.lang.invoke.ConvertHandle;
import java.lang.invoke.DirectHandle;
import java.lang.invoke.ExplicitCastHandle;
import java.lang.invoke.FieldGetterHandle;
import java.lang.invoke.FieldHandle;
import java.lang.invoke.FieldSetterHandle;
import java.lang.invoke.FilterReturnHandle;
import java.lang.invoke.InterfaceHandle;
import java.lang.invoke.InvokeExactHandle;
import java.lang.invoke.InvokeGenericHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ReceiverBoundHandle;
import java.lang.invoke.SecurityFrameInjector;
import java.lang.invoke.StaticFieldGetterHandle;
import java.lang.invoke.StaticFieldSetterHandle;
import java.lang.invoke.VirtualHandle;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import sun.reflect.CallerSensitive;

public class MethodHandles {
    static final native Class getStackClass(int var0);

    MethodHandles() {
    }

    @CallerSensitive
    public static Lookup lookup() {
        Class c = MethodHandles.getStackClass(1);
        return new Lookup(c);
    }

    public static Lookup publicLookup() {
        return Lookup.publicLookup;
    }

    public static MethodHandle exactInvoker(MethodType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        return new InvokeExactHandle(type);
    }

    public static MethodHandle invoker(MethodType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        return new InvokeGenericHandle(type);
    }

    public static MethodHandle spreadInvoker(MethodType type, int fixedArgCount) throws IllegalArgumentException, NullPointerException {
        int typeParameterCount = type.parameterCount();
        if (fixedArgCount < 0 || fixedArgCount > typeParameterCount) {
            throw new IllegalArgumentException(Msg.getString("K039c"));
        }
        MethodHandle invoker = MethodHandles.invoker(type);
        int spreadArgCount = typeParameterCount - fixedArgCount;
        return invoker.asSpreader(Object[].class, spreadArgCount);
    }

    public static MethodHandle guardWithTest(MethodHandle guard, MethodHandle trueTarget, MethodHandle falseTarget) throws NullPointerException, IllegalArgumentException {
        MethodType guardType = guard.type;
        MethodType trueType = trueTarget.type;
        MethodType falseType = falseTarget.type;
        if (!trueType.equals(falseType)) {
            throw new IllegalArgumentException();
        }
        int testArgCount = guardType.parameterCount();
        if (guardType.returnType != Boolean.TYPE || testArgCount > trueType.parameterCount()) {
            throw new IllegalArgumentException();
        }
        if (!Arrays.equals(guardType.arguments, Arrays.copyOfRange(trueType.arguments, 0, testArgCount))) {
            throw new IllegalArgumentException();
        }
        return MethodHandles.buildTransformHandle(new GuardWithTestHelper(guard, trueTarget, falseTarget), trueType);
    }

    public static MethodHandle catchException(MethodHandle tryHandle, Class<? extends Throwable> throwableClass, MethodHandle catchHandle) throws NullPointerException, IllegalArgumentException {
        if (tryHandle == null || throwableClass == null || catchHandle == null) {
            throw new NullPointerException();
        }
        MethodType tryType = tryHandle.type;
        MethodType catchType = catchHandle.type;
        if (tryType.returnType != catchType.returnType) {
            throw new IllegalArgumentException();
        }
        if (catchType.parameterType(0) != throwableClass) {
            throw new IllegalArgumentException();
        }
        int catchArgCount = catchType.parameterCount();
        if (catchArgCount - 1 > tryType.parameterCount()) {
            throw new IllegalArgumentException();
        }
        Class<?>[] tryParams = tryType.arguments;
        Class<?>[] catchParams = catchType.arguments;
        for (int i = 1; i < catchArgCount; ++i) {
            if (catchParams[i].equals(tryParams[i - 1])) continue;
            throw new IllegalArgumentException();
        }
        return MethodHandles.buildTransformHandle(new CatchHelper(tryHandle, catchHandle, throwableClass), tryType);
    }

    public static MethodHandle identity(Class<?> classType) throws NullPointerException, IllegalArgumentException {
        if (classType == Void.TYPE) {
            throw new IllegalArgumentException();
        }
        try {
            MethodType methodType = MethodType.methodType(classType, classType);
            if (classType.isPrimitive()) {
                return Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, "identity", methodType);
            }
            MethodHandle handle = Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, "identity", MethodType.methodType(Object.class, Object.class));
            return handle.asType(methodType);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    private static boolean identity(boolean x) {
        return x;
    }

    private static byte identity(byte x) {
        return x;
    }

    private static short identity(short x) {
        return x;
    }

    private static char identity(char x) {
        return x;
    }

    private static int identity(int x) {
        return x;
    }

    private static float identity(float x) {
        return x;
    }

    private static double identity(double x) {
        return x;
    }

    private static long identity(long x) {
        return x;
    }

    private static Object identity(Object x) {
        return x;
    }

    public static MethodHandle constant(Class<?> returnType, Object constantValue) throws NullPointerException, ClassCastException, IllegalArgumentException {
        if (returnType == null) {
            throw new NullPointerException();
        }
        if (returnType == Void.TYPE) {
            throw new IllegalArgumentException();
        }
        if (returnType.isPrimitive()) {
            if (constantValue == null) {
                throw new IllegalArgumentException();
            }
            Class<?> unwrapped = MethodType.unwrapPrimitive(constantValue.getClass());
            if (returnType != unwrapped && !ConvertHandle.FilterHelpers.checkIfWideningPrimitiveConversion(unwrapped, returnType)) {
                throw new ClassCastException();
            }
        } else {
            returnType.cast(constantValue);
        }
        MethodHandle boundObjectMH = MethodHandles.identity(Object.class).bindTo(constantValue);
        return boundObjectMH.asType(MethodType.methodType(returnType));
    }

    public static MethodHandle arrayElementGetter(Class<?> arrayType) throws IllegalArgumentException {
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException();
        }
        try {
            Class<?> componentType = arrayType.getComponentType();
            if (componentType.isPrimitive()) {
                String name = componentType.getCanonicalName();
                MethodType type = MethodType.methodType(componentType, arrayType, Integer.TYPE);
                return Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, name + "ArrayGetter", type);
            }
            MethodType type = MethodType.methodType(Object.class, Object[].class, Integer.TYPE);
            MethodHandle mh = Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, "objectArrayGetter", type);
            MethodType realType = MethodType.methodType(componentType, arrayType, Integer.TYPE);
            return mh.asType(realType);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    public static MethodHandle arrayElementSetter(Class<?> arrayType) throws IllegalArgumentException {
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException();
        }
        try {
            Class<?> componentType = arrayType.getComponentType();
            if (componentType.isPrimitive()) {
                String name = componentType.getCanonicalName();
                MethodType type = MethodType.methodType(Void.TYPE, arrayType, Integer.TYPE, componentType);
                return Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, name + "ArraySetter", type);
            }
            MethodType type = MethodType.methodType(Void.TYPE, Object[].class, Integer.TYPE, Object.class);
            MethodHandle mh = Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, "objectArraySetter", type);
            MethodType realType = MethodType.methodType(Void.TYPE, arrayType, Integer.TYPE, componentType);
            return mh.asType(realType);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    public static MethodHandle throwException(Class<?> returnType, Class<? extends Throwable> exception) {
        MethodType realType = MethodType.methodType(returnType, exception);
        try {
            MethodHandle handle;
            if (returnType.isPrimitive() || returnType.equals(Void.TYPE)) {
                MethodType type = MethodType.methodType(returnType, Throwable.class);
                String name = returnType.getCanonicalName();
                handle = Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, name + "ExceptionThrower", type);
            } else {
                MethodType type = MethodType.methodType(Object.class, Throwable.class);
                handle = Lookup.internalPrivilegedLookup.findStatic(MethodHandles.class, "objectExceptionThrower", type);
            }
            return handle.asType(realType);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    public static MethodHandle filterReturnValue(MethodHandle handle, MethodHandle filter) throws NullPointerException, IllegalArgumentException {
        MethodType filterType = filter.type;
        int filterArgCount = filterType.parameterCount();
        Class<?> handleReturnType = handle.type.returnType;
        if (handleReturnType == Void.TYPE && filterArgCount == 0) {
            return new FilterReturnHandle(handle, filter);
        }
        if (filterType.parameterCount() == 1 && filterType.parameterType(0) == handle.type.returnType) {
            return new FilterReturnHandle(handle, filter);
        }
        throw new IllegalArgumentException();
    }

    private static void voidExceptionThrower(Throwable t) throws Throwable {
        throw t;
    }

    private static int intExceptionThrower(Throwable t) throws Throwable {
        throw t;
    }

    private static char charExceptionThrower(Throwable t) throws Throwable {
        throw t;
    }

    private static byte byteExceptionThrower(Throwable t) throws Throwable {
        throw t;
    }

    private static boolean booleanExceptionThrower(Throwable t) throws Throwable {
        throw t;
    }

    private static short shortExceptionThrower(Throwable t) throws Throwable {
        throw t;
    }

    private static long longExceptionThrower(Throwable t) throws Throwable {
        throw t;
    }

    private static double doubleExceptionThrower(Throwable t) throws Throwable {
        throw t;
    }

    private static float floatExceptionThrower(Throwable t) throws Throwable {
        throw t;
    }

    private static Object objectExceptionThrower(Throwable t) throws Throwable {
        throw t;
    }

    private static int intArrayGetter(int[] array, int index) {
        return array[index];
    }

    private static char charArrayGetter(char[] array, int index) {
        return array[index];
    }

    private static short shortArrayGetter(short[] array, int index) {
        return array[index];
    }

    private static byte byteArrayGetter(byte[] array, int index) {
        return array[index];
    }

    private static long longArrayGetter(long[] array, int index) {
        return array[index];
    }

    private static double doubleArrayGetter(double[] array, int index) {
        return array[index];
    }

    private static float floatArrayGetter(float[] array, int index) {
        return array[index];
    }

    private static boolean booleanArrayGetter(boolean[] array, int index) {
        return array[index];
    }

    private static Object objectArrayGetter(Object[] array, int index) {
        return array[index];
    }

    private static void intArraySetter(int[] array, int index, int value) {
        array[index] = value;
    }

    private static void charArraySetter(char[] array, int index, char value) {
        array[index] = value;
    }

    private static void shortArraySetter(short[] array, int index, short value) {
        array[index] = value;
    }

    private static void byteArraySetter(byte[] array, int index, byte value) {
        array[index] = value;
    }

    private static void longArraySetter(long[] array, int index, long value) {
        array[index] = value;
    }

    private static void doubleArraySetter(double[] array, int index, double value) {
        array[index] = value;
    }

    private static void floatArraySetter(float[] array, int index, float value) {
        array[index] = value;
    }

    private static void booleanArraySetter(boolean[] array, int index, boolean value) {
        array[index] = value;
    }

    private static void objectArraySetter(Object[] array, int index, Object value) {
        array[index] = value;
    }

    public static MethodHandle filterArguments(MethodHandle handle, int startPosition, MethodHandle ... filters) throws NullPointerException, IllegalArgumentException {
        if (handle == null || filters == null) {
            throw new NullPointerException();
        }
        MethodType handleType = handle.type;
        if (startPosition < 0 || startPosition + filters.length > handleType.parameterCount()) {
            throw new IllegalArgumentException();
        }
        if (filters.length == 0) {
            return handle;
        }
        filters = (MethodHandle[])filters.clone();
        Class<?>[] newArgTypes = handleType.parameterArray();
        boolean containsNonNullFilters = false;
        for (int i = 0; i < filters.length; ++i) {
            MethodHandle filter = filters[i];
            if (filter == null) continue;
            containsNonNullFilters = true;
            MethodType filterType = filter.type;
            if (!newArgTypes[startPosition + i].equals(filterType.returnType)) {
                throw new IllegalArgumentException();
            }
            if (filterType.parameterCount() != 1) {
                throw new IllegalArgumentException();
            }
            newArgTypes[startPosition + i] = filterType.arguments[0];
        }
        if (!containsNonNullFilters) {
            return handle;
        }
        MethodType newType = MethodType.methodType(handleType.returnType, newArgTypes);
        return MethodHandles.buildTransformHandle(new FilterHelper(handle, startPosition, filters), newType);
    }

    public static MethodHandle foldArguments(MethodHandle handle, MethodHandle preprocessor) throws NullPointerException, IllegalArgumentException {
        if (handle == null || preprocessor == null) {
            throw new NullPointerException();
        }
        MethodType preprocessorType = preprocessor.type;
        Class<?> preprocessorReturnClass = preprocessorType.returnType;
        MethodType handleType = handle.type;
        if (preprocessorReturnClass == Void.TYPE) {
            if (handleType.parameterCount() < preprocessorType.parameterCount()) {
                throw new IllegalArgumentException();
            }
            if (preprocessorType.parameterCount() > 0 && !Arrays.equals(preprocessorType.arguments, Arrays.copyOfRange(handleType.arguments, 0, preprocessorType.parameterCount()))) {
                throw new IllegalArgumentException();
            }
            return MethodHandles.buildTransformHandle(new VoidFoldHelper(handle, preprocessor), handleType);
        }
        if (handleType.parameterCount() <= preprocessorType.parameterCount()) {
            throw new IllegalArgumentException();
        }
        if (!preprocessorReturnClass.equals(handleType.arguments[0])) {
            throw new IllegalArgumentException();
        }
        if (preprocessorType.parameterCount() > 0 && !Arrays.equals(preprocessorType.arguments, Arrays.copyOfRange(handleType.arguments, 1, preprocessorType.parameterCount() + 1))) {
            throw new IllegalArgumentException("Can't apply fold of type: " + preprocessorType + " to handle of type: " + handleType);
        }
        MethodType newType = handleType.dropParameterTypes(0, 1);
        return MethodHandles.buildTransformHandle(new FoldHelper(handle, preprocessor), newType);
    }

    public static MethodHandle permuteArguments(MethodHandle handle, MethodType permuteType, int ... permute) throws NullPointerException, IllegalArgumentException {
        if (handle == null || permuteType == null || permute == null) {
            throw new NullPointerException();
        }
        if (permute.length != handle.type.parameterCount()) {
            throw new IllegalArgumentException();
        }
        if (permuteType.returnType != handle.type.returnType) {
            throw new IllegalArgumentException();
        }
        permute = (int[])permute.clone();
        Class<?>[] permuteArgs = permuteType.arguments;
        Class<?>[] handleArgs = handle.type.arguments;
        for (int i = 0; i < permute.length; ++i) {
            int permuteIndex = permute[i];
            if (permuteIndex < 0 || permuteIndex >= permuteArgs.length) {
                throw new IllegalArgumentException();
            }
            if (handleArgs[i] == permuteArgs[permuteIndex]) continue;
            throw new IllegalArgumentException();
        }
        return MethodHandles.buildTransformHandle(new PermuteHelper(handle, permute), permuteType);
    }

    public static MethodHandle dropArguments(MethodHandle originalHandle, int location, Class<?> ... valueTypes) {
        if (null == originalHandle || null == valueTypes) {
            throw new NullPointerException(Msg.getString("K0337"));
        }
        if (location < 0 || location > originalHandle.type.parameterCount()) {
            throw new IllegalArgumentException(Msg.getString("K039c"));
        }
        for (Class<?> c : valueTypes) {
            if (null == c) {
                throw new NullPointerException(Msg.getString("K0337"));
            }
            if (!c.equals(Void.TYPE)) continue;
            throw new IllegalArgumentException(Msg.getString("K039c"));
        }
        MethodType mtype = originalHandle.type.insertParameterTypes(location, valueTypes);
        return MethodHandles.buildTransformHandle(new DropHelper(location, valueTypes.length, originalHandle), mtype);
    }

    public static MethodHandle dropArguments(MethodHandle originalHandle, int location, List<Class<?>> valueTypes) {
        if (null == originalHandle || null == valueTypes) {
            throw new NullPointerException(Msg.getString("K0337"));
        }
        if (location < 0 || location > originalHandle.type.parameterCount()) {
            throw new IllegalArgumentException(Msg.getString("K039c"));
        }
        for (Class<?> c : valueTypes) {
            if (null == c) {
                throw new NullPointerException(Msg.getString("K0337"));
            }
            if (!c.equals(Void.TYPE)) continue;
            throw new IllegalArgumentException(Msg.getString("K039c"));
        }
        MethodType mtype = originalHandle.type.insertParameterTypes(location, valueTypes);
        return MethodHandles.buildTransformHandle(new DropHelper(location, valueTypes.size(), originalHandle), mtype);
    }

    private static MethodHandle buildTransformHandle(ArgumentHelper helper, MethodType mtype) {
        MethodType helperType = MethodType.methodType(Object.class, Object[].class);
        try {
            return Lookup.internalPrivilegedLookup.bind(helper, "helper", helperType).asCollector(Object[].class, mtype.parameterCount()).asType(mtype);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    static final MethodHandle spreadHelper(Class<?> arrayClass, int spreadCount, MethodHandle handle, MethodType collectType) {
        return MethodHandles.buildTransformHandle(new SpreadHelper(arrayClass, spreadCount, handle), collectType);
    }

    public static MethodHandle explicitCastArguments(MethodHandle handle, MethodType type) throws NullPointerException, WrongMethodTypeException {
        if (handle == null || type == null) {
            throw new NullPointerException();
        }
        MethodType handleType = handle.type;
        if (handleType.equals(type)) {
            return handle;
        }
        MethodHandle mh = handle;
        if (handleType.returnType != type.returnType) {
            MethodHandle filter = ConvertHandle.FilterHelpers.getReturnFilter(handleType.returnType, type.returnType, true);
            mh = new FilterReturnHandle(handle, filter);
            if (mh.type == type) {
                return mh;
            }
        }
        return new ExplicitCastHandle(mh, type);
    }

    public static MethodHandle insertArguments(MethodHandle originalHandle, int location, Object ... values) {
        boolean noValuesToInsert;
        MethodType originalType = originalHandle.type;
        Class<?>[] arguments = originalType.parameterArray();
        boolean bl = noValuesToInsert = values.length == 0;
        if (location < 0 || location >= originalType.parameterCount()) {
            throw new IllegalArgumentException();
        }
        if (noValuesToInsert) {
            return originalHandle;
        }
        values = (Object[])values.clone();
        for (int i = 0; i < values.length; ++i) {
            Class<?> clazz = arguments[location + i];
            Object value = values[i];
            Class<Object> valueClazz = clazz;
            if (value != null) {
                valueClazz = value.getClass();
            }
            if (clazz.isPrimitive()) {
                Objects.requireNonNull(value);
                Class<?> unwrapped = MethodType.unwrapPrimitive(valueClazz);
                if (clazz != unwrapped && !ConvertHandle.FilterHelpers.checkIfWideningPrimitiveConversion(unwrapped, clazz)) {
                    clazz.cast(value);
                }
            } else {
                clazz.cast(value);
            }
            arguments[location + i] = valueClazz;
        }
        originalHandle = originalHandle.asType(MethodType.methodType(originalType.returnType, arguments));
        MethodType mtype = originalType.dropParameterTypes(location, location + values.length);
        MethodHandle result = MethodHandles.buildTransformHandle(new InsertHelper(location, values, originalHandle), mtype);
        return result;
    }

    private static final class PermuteHelper
    implements ArgumentHelper {
        private final MethodHandle handle;
        private final int[] permute;

        PermuteHelper(MethodHandle handle, int ... permute) {
            this.handle = handle;
            this.permute = permute;
        }

        @Override
        public Object helper(Object[] arguments) throws Throwable {
            Object[] newArgs = new Object[this.permute.length];
            for (int i = 0; i < this.permute.length; ++i) {
                newArgs[i] = arguments[this.permute[i]];
            }
            return this.handle.invokeWithArguments(newArgs);
        }
    }

    private static final class VoidFoldHelper
    implements ArgumentHelper {
        private final MethodHandle handle;
        private final MethodHandle preprocessor;

        VoidFoldHelper(MethodHandle handle, MethodHandle preprocessor) {
            this.handle = handle;
            this.preprocessor = preprocessor;
        }

        @Override
        public Object helper(Object[] arguments) throws Throwable {
            this.preprocessor.invokeWithArguments(Arrays.copyOfRange(arguments, 0, this.preprocessor.type.parameterCount()));
            return this.handle.invokeWithArguments(arguments);
        }
    }

    private static final class FoldHelper
    implements ArgumentHelper {
        private final MethodHandle handle;
        private final MethodHandle preprocessor;

        FoldHelper(MethodHandle handle, MethodHandle preprocessor) {
            this.handle = handle;
            this.preprocessor = preprocessor;
        }

        @Override
        public Object helper(Object[] arguments) throws Throwable {
            int length = arguments.length;
            Object[] newArgs = new Object[length + 1];
            if (length > 0) {
                System.arraycopy((Object)arguments, 0, (Object)newArgs, 1, length);
            }
            newArgs[0] = this.preprocessor.invokeWithArguments(Arrays.copyOfRange(arguments, 0, this.preprocessor.type.parameterCount()));
            return this.handle.invokeWithArguments(newArgs);
        }
    }

    private static final class FilterHelper
    implements ArgumentHelper {
        private final MethodHandle target;
        private final int startPos;
        private final MethodHandle[] filters;

        FilterHelper(MethodHandle target, int startPos, MethodHandle[] filters) {
            this.target = target;
            this.startPos = startPos;
            this.filters = filters;
        }

        @Override
        public Object helper(Object[] arguments) throws Throwable {
            Object[] filterArg = new Object[1];
            for (int i = 0; i < this.filters.length; ++i) {
                MethodHandle filter = this.filters[i];
                if (filter == null) continue;
                filterArg[0] = arguments[this.startPos + i];
                arguments[this.startPos + i] = filter.invokeWithArguments(filterArg);
            }
            return this.target.invokeWithArguments(arguments);
        }
    }

    private static final class CatchHelper
    implements ArgumentHelper {
        private final MethodHandle tryTarget;
        private final MethodHandle catchTarget;
        private final Class<? extends Throwable> exceptionClass;

        CatchHelper(MethodHandle tryTarget, MethodHandle catchTarget, Class<? extends Throwable> exceptionClass) {
            this.tryTarget = tryTarget;
            this.catchTarget = catchTarget;
            this.exceptionClass = exceptionClass;
        }

        @Override
        public Object helper(Object[] arguments) throws Throwable {
            try {
                return this.tryTarget.invokeWithArguments(arguments);
            }
            catch (Throwable t) {
                if (this.exceptionClass.isInstance(t)) {
                    int catchArgCount = this.catchTarget.type.parameterCount();
                    Object[] amendedArgs = new Object[catchArgCount];
                    amendedArgs[0] = t;
                    System.arraycopy((Object)arguments, 0, (Object)amendedArgs, 1, catchArgCount - 1);
                    return this.catchTarget.invokeWithArguments(amendedArgs);
                }
                throw t;
            }
        }
    }

    private static final class GuardWithTestHelper
    implements ArgumentHelper {
        private final MethodHandle guard;
        private final MethodHandle trueTarget;
        private final MethodHandle falseTarget;

        GuardWithTestHelper(MethodHandle guard, MethodHandle trueTarget, MethodHandle falseTarget) {
            this.guard = guard;
            this.trueTarget = trueTarget;
            this.falseTarget = falseTarget;
        }

        @Override
        public Object helper(Object[] arguments) throws Throwable {
            boolean result = (Boolean)this.guard.invokeWithArguments(Arrays.copyOfRange(arguments, 0, this.guard.type.parameterCount()));
            if (result) {
                return this.trueTarget.invokeWithArguments(arguments);
            }
            return this.falseTarget.invokeWithArguments(arguments);
        }
    }

    private static final class InsertHelper
    implements ArgumentHelper {
        private final MethodHandle nextMethodHandle;
        private final int pos;
        private final Object[] values;

        InsertHelper(int pos, Object[] values, MethodHandle mh) {
            this.pos = pos;
            this.values = (Object[])values.clone();
            this.nextMethodHandle = mh;
        }

        @Override
        public Object helper(Object[] arguments) throws Throwable {
            int length = arguments.length + this.values.length;
            Object[] amendedArray = new Object[length];
            if (this.pos != 0) {
                System.arraycopy((Object)arguments, 0, (Object)amendedArray, 0, this.pos);
            }
            System.arraycopy((Object)this.values, 0, (Object)amendedArray, this.pos, this.values.length);
            if (this.pos != arguments.length) {
                System.arraycopy((Object)arguments, this.pos, (Object)amendedArray, this.pos + this.values.length, arguments.length - this.pos);
            }
            return this.nextMethodHandle.asFixedArity().invokeWithArguments(amendedArray);
        }
    }

    private static final class SpreadHelper
    implements ArgumentHelper {
        private final MethodHandle nextMethodHandle;
        private final int spreadCount;
        private final Class<?> arrayClass;

        SpreadHelper(Class<?> arrayClass, int spreadCount, MethodHandle mh) {
            this.arrayClass = arrayClass;
            this.spreadCount = spreadCount;
            this.nextMethodHandle = mh;
        }

        @Override
        public Object helper(Object[] arguments) throws Throwable {
            int lastArgIndex = arguments.length - 1;
            Object spreadArg = arguments[lastArgIndex];
            this.arrayClass.cast(spreadArg);
            if (spreadArg == null) {
                if (this.spreadCount != 0) {
                    throw new IllegalArgumentException("cannot have null spread argument unless spreadCount is 0");
                }
            } else if (this.spreadCount != Array.getLength(spreadArg)) {
                throw new ArrayIndexOutOfBoundsException("expected '" + this.spreadCount + "' sized array; encountered '" + Array.getLength(spreadArg) + "' sized array");
            }
            Object[] amendedArray = new Object[this.nextMethodHandle.type.parameterCount()];
            System.arraycopy((Object)arguments, 0, (Object)amendedArray, 0, lastArgIndex);
            if (this.spreadCount != 0) {
                Class<?> componentType = this.arrayClass.getComponentType();
                if (!componentType.isPrimitive()) {
                    System.arraycopy(spreadArg, 0, (Object)amendedArray, lastArgIndex, this.spreadCount);
                } else {
                    SpreadHelper.boxArraycopy(spreadArg, componentType, amendedArray, lastArgIndex, this.spreadCount);
                }
            }
            return this.nextMethodHandle.invokeWithArguments(amendedArray);
        }

        static void boxArraycopy(Object spreadArg, Class<?> primitiveType, Object[] destination, int startPos, int length) {
            block9: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block8: {
                                            if (!primitiveType.equals(Integer.TYPE)) break block8;
                                            for (int i = 0; i < length; ++i) {
                                                destination[startPos + i] = ((int[])spreadArg)[i];
                                            }
                                            break block9;
                                        }
                                        if (!primitiveType.equals(Long.TYPE)) break block10;
                                        for (int i = 0; i < length; ++i) {
                                            destination[startPos + i] = ((long[])spreadArg)[i];
                                        }
                                        break block9;
                                    }
                                    if (!primitiveType.equals(Double.TYPE)) break block11;
                                    for (int i = 0; i < length; ++i) {
                                        destination[startPos + i] = ((double[])spreadArg)[i];
                                    }
                                    break block9;
                                }
                                if (!primitiveType.equals(Byte.TYPE)) break block12;
                                for (int i = 0; i < length; ++i) {
                                    destination[startPos + i] = ((byte[])spreadArg)[i];
                                }
                                break block9;
                            }
                            if (!primitiveType.equals(Character.TYPE)) break block13;
                            for (int i = 0; i < length; ++i) {
                                destination[startPos + i] = Character.valueOf(((char[])spreadArg)[i]);
                            }
                            break block9;
                        }
                        if (!primitiveType.equals(Float.TYPE)) break block14;
                        for (int i = 0; i < length; ++i) {
                            destination[startPos + i] = Float.valueOf(((float[])spreadArg)[i]);
                        }
                        break block9;
                    }
                    if (!primitiveType.equals(Short.TYPE)) break block15;
                    for (int i = 0; i < length; ++i) {
                        destination[startPos + i] = ((short[])spreadArg)[i];
                    }
                    break block9;
                }
                if (!primitiveType.equals(Boolean.TYPE)) break block9;
                for (int i = 0; i < length; ++i) {
                    destination[startPos + i] = ((boolean[])spreadArg)[i];
                }
            }
        }
    }

    private static final class DropHelper
    implements ArgumentHelper {
        private final MethodHandle nextMethodHandle;
        private final int dropPos;
        private final int dropCount;

        DropHelper(int pos, int count, MethodHandle mh) {
            this.dropPos = pos;
            this.dropCount = count;
            this.nextMethodHandle = mh;
        }

        @Override
        public Object helper(Object[] arguments) throws Throwable {
            int length = arguments.length - this.dropCount;
            Object[] amendedArray = new Object[length];
            if (this.dropPos != 0) {
                System.arraycopy((Object)arguments, 0, (Object)amendedArray, 0, this.dropPos);
            }
            System.arraycopy((Object)arguments, this.dropPos + this.dropCount, (Object)amendedArray, this.dropPos, length - this.dropPos);
            return this.nextMethodHandle.invokeWithArguments(amendedArray);
        }
    }

    public static final class Lookup {
        public static final int PUBLIC = 1;
        public static final int PRIVATE = 2;
        public static final int PROTECTED = 4;
        public static final int PACKAGE = 8;
        private static final int INTERNAL_PRIVILEGED = 16;
        private static final int FULL_ACCESS_MASK = 15;
        private static final int NO_ACCESS = 0;
        private static final String INVOKE_EXACT = "invokeExact";
        private static final String INVOKE = "invoke";
        static final int VARARGS = 128;
        static Lookup publicLookup = new Lookup(Object.class, 1);
        static Lookup internalPrivilegedLookup = new Lookup(MethodHandle.class, 16);
        final Class accessClass;
        final int accessMode;
        private boolean performSecurityCheck = true;

        Lookup(Class lookupClass, int lookupMode) {
            if (16 != lookupMode && lookupClass.getName().startsWith("java.lang.invoke")) {
                throw new IllegalArgumentException(Msg.getString("K0588", lookupClass.getName()));
            }
            this.accessClass = lookupClass;
            this.accessMode = lookupMode;
        }

        Lookup(Class lookupClass) {
            this(lookupClass, 15);
        }

        Lookup(Class lookupClass, boolean performSecurityCheck) {
            this(lookupClass, 15);
            this.performSecurityCheck = performSecurityCheck;
        }

        public int lookupModes() {
            return this.accessMode;
        }

        static boolean isVarargs(int modifiers) {
            return (modifiers & 0x80) != 0;
        }

        private static MethodHandle convertToVarargsIfRequired(MethodHandle handle) {
            if (Lookup.isVarargs(handle.rawModifiers)) {
                Class<?> lastClass = handle.type.parameterType(handle.type.parameterCount() - 1);
                return handle.asVarargsCollector(lastClass);
            }
            return handle;
        }

        @CallerSensitive
        public MethodHandle bind(Object receiver, String methodName, MethodType type) throws IllegalAccessException, NoSuchMethodException {
            this.nullCheck(receiver, methodName, type);
            MethodHandle handle = Lookup.handleForMHInvokeMethods(receiver.getClass(), methodName, type);
            if (handle == null) {
                this.initCheck(methodName);
                handle = new DirectHandle(receiver.getClass(), methodName, type, 1, receiver.getClass());
                handle = Lookup.convertToVarargsIfRequired(new ReceiverBoundHandle(handle, receiver));
            }
            Class<?> callingContext = this.getCallingContextDepth3();
            this.checkAccess(handle, false);
            this.checkSecurity(handle.defc, receiver.getClass(), handle.rawModifiers, callingContext);
            handle = SecurityFrameInjector.wrapHandleWithInjectedSecurityFrameIfRequired(this, handle, methodName, callingContext);
            return handle;
        }

        private Class<?> getCallingContextDepth3() {
            Class callerClass = this.accessClass;
            if (!Modifier.isPrivate(this.accessMode)) {
                callerClass = MethodHandles.getStackClass(2);
            }
            return callerClass;
        }

        private void nullCheck(Object a, Object b) {
            if (null == a || null == b) {
                throw new NullPointerException();
            }
        }

        private void nullCheck(Object a, Object b, Object c) {
            if (null == a || null == b || null == c) {
                throw new NullPointerException();
            }
        }

        private void nullCheck(Object a, Object b, Object c, Object d) {
            if (null == a || null == b || null == c || null == d) {
                throw new NullPointerException();
            }
        }

        private void initCheck(String methodName) throws NoSuchMethodException {
            if ("<init>".equals(methodName)) {
                throw new NoSuchMethodException("Invalid method name: \"<init>\"");
            }
            if ("<clinit>".equals(methodName)) {
                throw new NoSuchMethodException("Invalid method name: \"<clinit>\"");
            }
        }

        static final VMLangAccess getVMLangAccess() {
            return VMLangAccessGetter.vma;
        }

        private static boolean isSamePackage(Class<?> a, Class<?> b) {
            ClassLoader clb;
            if (a == b) {
                return true;
            }
            VMLangAccess vma = Lookup.getVMLangAccess();
            if (!vma.getPackageName(a).equals(vma.getPackageName(b))) {
                return false;
            }
            ClassLoader cla = vma.getClassloader(a);
            if (cla == (clb = vma.getClassloader(b))) {
                return true;
            }
            return vma.isAncestor(cla, clb) || vma.isAncestor(clb, cla);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void checkAccess(MethodHandle handle, boolean forVirtualHandle) throws IllegalAccessException {
            if (this.accessMode == 16) {
                return;
            }
            int handleModifiers = handle.rawModifiers;
            if (this.accessMode == 0) {
                throw new IllegalAccessException(this.toString());
            }
            if (Modifier.isPublic(handleModifiers)) {
                if (Modifier.isPublic(handle.defc.getModifiers())) {
                    if (Modifier.isPublic(this.accessMode)) {
                        return;
                    }
                } else {
                    if ((this.accessMode & 8) == 8 && Lookup.isSamePackage(this.accessClass, handle.defc)) {
                        return;
                    }
                    if (Modifier.isProtected(this.accessMode) && handle.defc.isAssignableFrom(this.accessClass)) {
                        return;
                    }
                }
            } else if (Modifier.isPrivate(handleModifiers)) {
                if (handle.defc == this.accessClass && Modifier.isPrivate(this.accessMode)) {
                    return;
                }
            } else if (Modifier.isProtected(handleModifiers)) {
                if (this.accessMode != 1) {
                    if (handle.definingClass.isArray()) {
                        return;
                    }
                    if (Lookup.isSamePackage(this.accessClass, handle.defc)) {
                        return;
                    }
                    if (Modifier.isProtected(this.accessMode) && handle.defc.isAssignableFrom(this.accessClass)) {
                        if (handle.kind != 9 && (handle.kind != 1 || forVirtualHandle)) return;
                        Class targetClass = handle.definingClass;
                        if (handle.kind == 1) {
                            targetClass = handle.specialCaller;
                        }
                        if (this.accessClass.isAssignableFrom(targetClass)) {
                            return;
                        }
                    }
                }
            } else if ((this.accessMode & 8) == 8 && Lookup.isSamePackage(this.accessClass, handle.defc)) {
                return;
            }
            String message = Msg.getString("K0587", this.toString(), handle.defc.getName() + "." + handle.name + ":" + handle.type + "/" + handle.mapKindToBytecode());
            throw new IllegalAccessException(message);
        }

        private void checkSpecialAccess(Class<?> callerClass) throws IllegalAccessException {
            if (this.isWeakenedLookup() || this.accessClass != callerClass) {
                throw new IllegalAccessException(Msg.getString("K0585"));
            }
        }

        @CallerSensitive
        public MethodHandle findSpecial(Class<?> clazz, String methodName, MethodType type, Class<?> specialToken) throws IllegalAccessException, NoSuchMethodException, SecurityException, NullPointerException {
            this.nullCheck(clazz, methodName, type, specialToken);
            this.checkSpecialAccess(specialToken);
            this.initCheck(methodName);
            MethodHandle handle = new DirectHandle(clazz, methodName, type, 1, specialToken);
            handle = this.restrictReceiver(handle);
            handle = Lookup.convertToVarargsIfRequired(handle);
            Class<?> callingContext = this.getCallingContextDepth3();
            if (handle.defc != this.accessClass && !handle.defc.isAssignableFrom(this.accessClass)) {
                throw new IllegalAccessException(Msg.getString("K0586", this.accessClass, handle.defc));
            }
            this.checkAccess(handle, false);
            this.checkSecurity(handle.defc, clazz, handle.rawModifiers, callingContext);
            handle = SecurityFrameInjector.wrapHandleWithInjectedSecurityFrameIfRequired(this, handle, methodName, callingContext);
            return handle;
        }

        @CallerSensitive
        public MethodHandle findStatic(Class<?> clazz, String methodName, MethodType type) throws IllegalAccessException, NoSuchMethodException {
            this.nullCheck(clazz, methodName, type);
            this.initCheck(methodName);
            MethodHandle handle = new DirectHandle(clazz, methodName, type, 0, null);
            Class<?> callingContext = this.getCallingContextDepth3();
            this.checkAccess(handle, false);
            this.checkSecurity(handle.defc, clazz, handle.rawModifiers, callingContext);
            handle = SecurityFrameInjector.wrapHandleWithInjectedSecurityFrameIfRequired(this, handle, methodName, callingContext);
            return Lookup.convertToVarargsIfRequired(handle);
        }

        @CallerSensitive
        public MethodHandle findVirtual(Class<?> clazz, String methodName, MethodType type) throws IllegalAccessException, NoSuchMethodException {
            this.nullCheck(clazz, methodName, type);
            MethodHandle handle = Lookup.handleForMHInvokeMethods(clazz, methodName, type);
            boolean adaptInterfaceHandle = false;
            if (handle == null) {
                this.initCheck(methodName);
                if (clazz.isInterface()) {
                    handle = new InterfaceHandle(clazz, methodName, type);
                    if (Modifier.isStatic(handle.rawModifiers)) {
                        throw new IllegalAccessException();
                    }
                    adaptInterfaceHandle = true;
                } else {
                    handle = new DirectHandle(clazz, methodName, type, 1, clazz);
                    if (!Modifier.isPrivate(handle.rawModifiers) && !Modifier.isFinal(handle.rawModifiers)) {
                        handle = new VirtualHandle((DirectHandle)handle);
                    }
                }
                handle = this.restrictReceiver(handle);
                handle = Lookup.convertToVarargsIfRequired(handle);
            }
            Class<?> callingContext = this.getCallingContextDepth3();
            this.checkAccess(handle, true);
            this.checkSecurity(handle.defc, clazz, handle.rawModifiers, callingContext);
            if (adaptInterfaceHandle) {
                handle = Lookup.adaptInterfaceLookupsOfObjectMethodsIfRequired(handle, clazz, methodName, type);
            }
            handle = SecurityFrameInjector.wrapHandleWithInjectedSecurityFrameIfRequired(this, handle, methodName, callingContext);
            return handle;
        }

        private MethodHandle restrictReceiver(MethodHandle handle) {
            if (!Modifier.isStatic(handle.rawModifiers) && Modifier.isProtected(handle.rawModifiers) && handle.defc != this.accessClass && !Lookup.isSamePackage(handle.defc, this.accessClass)) {
                handle = handle.cloneWithNewType(handle.type.changeParameterType(0, this.accessClass));
            }
            return handle;
        }

        static MethodHandle adaptInterfaceLookupsOfObjectMethodsIfRequired(MethodHandle handle, Class<?> clazz, String methodName, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            assert (handle instanceof InterfaceHandle);
            if (Object.class == handle.defc) {
                if (!Modifier.isPublic(handle.rawModifiers)) {
                    throw new NoSuchMethodException(clazz + "." + methodName + type);
                }
                handle = new VirtualHandle(new DirectHandle(Object.class, methodName, type, 1, Object.class));
                handle = handle.asType(handle.type.changeParameterType(0, clazz));
            }
            return handle;
        }

        static MethodHandle handleForMHInvokeMethods(Class clazz, String methodName, MethodType type) {
            if (MethodHandle.class.isAssignableFrom(clazz)) {
                if (INVOKE_EXACT.equals(methodName)) {
                    return new InvokeExactHandle(type);
                }
                if (INVOKE.equals(methodName)) {
                    return new InvokeGenericHandle(type);
                }
            }
            return null;
        }

        @CallerSensitive
        public MethodHandle findGetter(Class<?> clazz, String fieldName, Class<?> fieldType) throws IllegalAccessException, NoSuchFieldException, SecurityException, NullPointerException {
            this.nullCheck(clazz, fieldName, fieldType);
            FieldGetterHandle handle = new FieldGetterHandle(clazz, fieldName, fieldType, this.accessClass);
            Class<?> callingContext = this.getCallingContextDepth3();
            this.checkAccess(handle, false);
            this.checkSecurity(handle.defc, clazz, handle.rawModifiers, callingContext);
            return handle;
        }

        @CallerSensitive
        public MethodHandle findStaticGetter(Class<?> clazz, String fieldName, Class<?> fieldType) throws IllegalAccessException, NoSuchFieldException, SecurityException, NullPointerException {
            this.nullCheck(clazz, fieldName, fieldType);
            StaticFieldGetterHandle handle = new StaticFieldGetterHandle(clazz, fieldName, fieldType, this.accessClass);
            Class<?> callingContext = this.getCallingContextDepth3();
            this.checkAccess(handle, false);
            this.checkSecurity(handle.defc, clazz, handle.rawModifiers, callingContext);
            return handle;
        }

        @CallerSensitive
        public MethodHandle findSetter(Class<?> clazz, String fieldName, Class<?> fieldType) throws IllegalAccessException, NoSuchFieldException, SecurityException, NullPointerException {
            this.nullCheck(clazz, fieldName, fieldType);
            if (fieldType == Void.TYPE) {
                throw new NoSuchFieldException();
            }
            FieldSetterHandle handle = new FieldSetterHandle(clazz, fieldName, fieldType, this.accessClass);
            if (Modifier.isFinal(handle.rawModifiers)) {
                throw new IllegalAccessException("illegal setter on final field");
            }
            Class<?> callingContext = this.getCallingContextDepth3();
            this.checkAccess(handle, false);
            this.checkSecurity(handle.defc, clazz, handle.rawModifiers, callingContext);
            return handle;
        }

        @CallerSensitive
        public MethodHandle findStaticSetter(Class<?> clazz, String fieldName, Class<?> fieldType) throws IllegalAccessException, NoSuchFieldException, SecurityException, NullPointerException {
            this.nullCheck(clazz, fieldName, fieldType);
            if (fieldType == Void.TYPE) {
                throw new NoSuchFieldException();
            }
            StaticFieldSetterHandle handle = new StaticFieldSetterHandle(clazz, fieldName, fieldType, this.accessClass);
            if (Modifier.isFinal(handle.rawModifiers)) {
                throw new IllegalAccessException("illegal setter on final field");
            }
            Class<?> callingContext = this.getCallingContextDepth3();
            this.checkAccess(handle, false);
            this.checkSecurity(handle.defc, clazz, handle.rawModifiers, callingContext);
            return handle;
        }

        public Lookup in(Class<?> lookupClass) {
            Class l;
            Class a;
            if (lookupClass == null) {
                throw new NullPointerException();
            }
            if (lookupClass == this.accessClass) {
                return this;
            }
            int newAccessMode = this.accessMode & 0xFFFFFFFB;
            if (!Lookup.isSamePackage(this.accessClass, lookupClass)) {
                newAccessMode &= 0xFFFFFFF3;
            }
            if ((newAccessMode & 2) == 2 && (a = Lookup.getUltimateEnclosingClassOrSelf(this.accessClass)) != (l = Lookup.getUltimateEnclosingClassOrSelf(lookupClass))) {
                newAccessMode &= 0xFFFFFFFD;
            }
            if (!Modifier.isPublic(lookupClass.getModifiers())) {
                if (Lookup.isSamePackage(this.accessClass, lookupClass)) {
                    if ((this.accessMode & 8) == 0) {
                        newAccessMode = 0;
                    }
                } else {
                    newAccessMode = 0;
                }
            } else {
                VMLangAccess vma = Lookup.getVMLangAccess();
                if (vma.getClassloader(this.accessClass) != vma.getClassloader(lookupClass)) {
                    newAccessMode &= 0xFFFFFFF1;
                }
            }
            return new Lookup(lookupClass, newAccessMode);
        }

        private static Class getUltimateEnclosingClassOrSelf(Class c) {
            Class<?> previous = c;
            for (Class<?> enclosing = c.getEnclosingClass(); enclosing != null; enclosing = enclosing.getEnclosingClass()) {
                previous = enclosing;
            }
            return previous;
        }

        private static boolean doesClassLoaderDescendFrom(ClassLoader currentLoader, ClassLoader requestedLoader) {
            if (requestedLoader == null) {
                return true;
            }
            if (currentLoader != requestedLoader) {
                while (currentLoader != null) {
                    if (currentLoader == requestedLoader) {
                        return true;
                    }
                    currentLoader = currentLoader.getParent();
                }
                return false;
            }
            return true;
        }

        public Class<?> lookupClass() {
            return this.accessClass;
        }

        @CallerSensitive
        public MethodHandle unreflect(Method method) throws IllegalAccessException {
            MethodHandle handle;
            int methodModifiers = method.getModifiers();
            boolean forVirtualHandle = false;
            if (Modifier.isStatic(methodModifiers)) {
                handle = new DirectHandle(method, 0, null);
            } else if (method.getDeclaringClass().isInterface()) {
                handle = new InterfaceHandle(method);
            } else {
                handle = !Modifier.isPrivate(methodModifiers) && !Modifier.isFinal(methodModifiers) ? new VirtualHandle(method) : new DirectHandle(method, 1, method.getDeclaringClass());
                forVirtualHandle = true;
                handle = this.restrictReceiver(handle);
            }
            if (!method.isAccessible()) {
                this.checkAccess(handle, forVirtualHandle);
            }
            Class<?> callingContext = this.getCallingContextDepth3();
            handle = SecurityFrameInjector.wrapHandleWithInjectedSecurityFrameIfRequired(this, handle, method.getName(), callingContext);
            return Lookup.convertToVarargsIfRequired(handle);
        }

        public MethodHandle unreflectConstructor(Constructor method) throws IllegalAccessException {
            ConstructorHandle handle = new ConstructorHandle(method);
            if (!method.isAccessible()) {
                this.checkAccess(handle, false);
            }
            return Lookup.convertToVarargsIfRequired(handle);
        }

        @CallerSensitive
        public MethodHandle findConstructor(Class<?> declaringClass, MethodType type) throws IllegalAccessException, NoSuchMethodException {
            this.nullCheck(declaringClass, type);
            if (type.returnType() != Void.TYPE) {
                throw new NoSuchMethodException();
            }
            ConstructorHandle handle = new ConstructorHandle(declaringClass, type);
            Class<?> callingContext = this.getCallingContextDepth3();
            this.checkAccess(handle, false);
            this.checkSecurity(handle.defc, declaringClass, handle.rawModifiers, callingContext);
            return Lookup.convertToVarargsIfRequired(handle);
        }

        @CallerSensitive
        public MethodHandle unreflectSpecial(Method method, Class<?> specialToken) throws IllegalAccessException {
            this.nullCheck(method, specialToken);
            this.checkSpecialAccess(specialToken);
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers)) {
                throw new IllegalAccessException();
            }
            MethodHandle handle = Lookup.convertToVarargsIfRequired(new DirectHandle(method, 1, specialToken));
            if (!method.isAccessible()) {
                this.checkAccess(handle, false);
            }
            Class<?> callingContext = this.getCallingContextDepth3();
            handle = SecurityFrameInjector.wrapHandleWithInjectedSecurityFrameIfRequired(this, handle, method.getName(), callingContext);
            return handle;
        }

        public MethodHandle unreflectGetter(Field field) throws IllegalAccessException {
            int modifiers = field.getModifiers();
            FieldHandle handle = Modifier.isStatic(modifiers) ? new StaticFieldGetterHandle(field) : new FieldGetterHandle(field);
            if (!field.isAccessible()) {
                this.checkAccess(handle, false);
            }
            return handle;
        }

        public MethodHandle unreflectSetter(Field field) throws IllegalAccessException {
            int modifiers = field.getModifiers();
            if (Modifier.isFinal(modifiers)) {
                throw new IllegalAccessException("illegal setter on final field");
            }
            FieldHandle handle = Modifier.isStatic(modifiers) ? new StaticFieldSetterHandle(field) : new FieldSetterHandle(field);
            if (!field.isAccessible()) {
                this.checkAccess(handle, false);
            }
            return handle;
        }

        public String toString() {
            String toString = this.accessClass.getName();
            switch (this.accessMode) {
                case 0: {
                    toString = toString + "/noaccess";
                    break;
                }
                case 1: {
                    toString = toString + "/public";
                    break;
                }
                case 9: {
                    toString = toString + "/package";
                    break;
                }
                case 11: {
                    toString = toString + "/private";
                }
            }
            return toString;
        }

        boolean isWeakenedLookup() {
            return 2 != (this.accessMode & 2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkSecurity(Class<?> definingClass, Class<?> referenceClass, int modifiers, Class<?> callingContext) throws IllegalAccessException {
            SecurityManager secmgr;
            if (this.accessMode == 16) {
                return;
            }
            if (null == definingClass) {
                throw new IllegalAccessException();
            }
            if (this.performSecurityCheck && (secmgr = System.getSecurityManager()) != null) {
                while (definingClass.isArray()) {
                    definingClass = definingClass.getComponentType();
                }
                while (referenceClass.isArray()) {
                    referenceClass = referenceClass.getComponentType();
                }
                try {
                    Lookup.setAccessClassForSecuritCheck(this.accessClass);
                    VMLangAccess vma = Lookup.getVMLangAccess();
                    secmgr.checkMemberAccess(referenceClass, 0);
                    boolean checkCallerClass = this.accessClass != callingContext;
                    ClassLoader referenceClassLoader = referenceClass.getClassLoader();
                    if (!Lookup.doesClassLoaderDescendFrom(referenceClassLoader, this.accessClass.getClassLoader()) || checkCallerClass && !Lookup.doesClassLoaderDescendFrom(referenceClassLoader, callingContext.getClassLoader())) {
                        String packageName = vma.getPackageName(referenceClass);
                        secmgr.checkPackageAccess(packageName);
                    }
                    if (!Modifier.isPublic(modifiers)) {
                        secmgr.checkMemberAccess(definingClass, 1);
                        if (definingClass.getClassLoader() != referenceClass.getClassLoader() && !Lookup.doesClassLoaderDescendFrom(definingClass.getClassLoader(), this.accessClass.getClassLoader())) {
                            secmgr.checkPackageAccess(vma.getPackageName(definingClass));
                        }
                    }
                }
                finally {
                    Lookup.setAccessClassForSecuritCheck(null);
                }
            }
        }

        private static native void setAccessClassForSecuritCheck(Class<?> var0);

        private static final class VMLangAccessGetter {
            public static final VMLangAccess vma = VM.getVMLangAccess();

            private VMLangAccessGetter() {
            }
        }
    }
}

