/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.AsTypeHandle;
import java.lang.invoke.CallSite;
import java.lang.invoke.CollectHandle;
import java.lang.invoke.ComputedCalls;
import java.lang.invoke.ConvertHandle;
import java.lang.invoke.DirectHandle;
import java.lang.invoke.FilterReturnHandle;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.IndirectHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.ReceiverBoundHandle;
import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkTable;
import java.lang.invoke.ThunkTuple;
import java.lang.invoke.VarargsCollectorHandle;
import java.lang.invoke.VirtualHandle;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import sun.misc.SharedSecrets;
import sun.misc.Unsafe;
import sun.reflect.ConstantPool;

public abstract class MethodHandle {
    static final int KIND_STATIC = 0;
    static final int KIND_SPECIAL = 1;
    static final int KIND_VIRTUAL = 2;
    static final int KIND_INTERFACE = 3;
    static final int KIND_BOUND = 4;
    static final int KIND_GETFIELD = 5;
    static final int KIND_GETSTATICFIELD = 6;
    static final int KIND_PUTFIELD = 7;
    static final int KIND_PUTSTATICFIELD = 8;
    static final int KIND_CONSTRUCTOR = 9;
    static final int KIND_COLLECT = 10;
    static final int KIND_INVOKEEXACT = 11;
    static final int KIND_INVOKEGENERIC = 12;
    static final int KIND_ASTYPE = 13;
    static final int KIND_DYNAMICINVOKER = 14;
    static final int KIND_FILTERRETURN = 15;
    static final int KIND_EXPLICITCAST = 16;
    static final int KIND_VARARGSCOLLECT = 17;
    static final int KIND_PASSTHROUGH = 18;
    private static final int NUMBER_OF_DISPATCH_TARGETS = 19;
    static final long[] vmDispatchTargets = new long[19];
    static Unsafe myUnsafe;
    final MethodType type;
    long vmSlot;
    final long vmDispatchTarget;
    int rawModifiers;
    final int kind;
    final Class definingClass;
    Class defc;
    final ThunkTuple thunks;
    static final int VTABLE_ENTRY_SIZE;
    static final int J9CLASS_OFFSET;
    static final int INTRP_VTABLE_OFFSET;
    static final int HEADER_SIZE;
    final String name;
    Class specialCaller;
    private MethodHandle previousAsType;
    private static final int BSM_ARGUMENT_SIZE = 2;
    private static final int BSM_ARGUMENT_COUNT_OFFSET = 2;
    private static final int BSM_ARGUMENTS_OFFSET = 4;
    private static final int BSM_LOOKUP_ARGUMENT_INDEX = 0;
    private static final int BSM_NAME_ARGUMENT_INDEX = 1;
    private static final int BSM_TYPE_ARGUMENT_INDEX = 2;
    private static final int BSM_OPTIONAL_ARGUMENTS_START_INDEX = 3;

    static final Unsafe getUnsafe() {
        if (myUnsafe == null) {
            myUnsafe = Unsafe.getUnsafe();
        }
        return myUnsafe;
    }

    abstract ThunkTable thunkTable();

    ThunkTuple computeThunks(Object arg) {
        return this.thunkTable().get(new ThunkKey(ThunkKey.computeThunkableSignature(this.type().toMethodDescriptorString())));
    }

    final long invokeExactTargetAddress() {
        return this.thunks.invokeExactThunk();
    }

    static long getJ9ClassFromClass(Class c) {
        if (VTABLE_ENTRY_SIZE == 4) {
            return MethodHandle.getUnsafe().getInt(c, J9CLASS_OFFSET);
        }
        return MethodHandle.getUnsafe().getLong(c, J9CLASS_OFFSET);
    }

    abstract MethodHandle cloneWithNewType(MethodType var1);

    private static MethodHandle asType(MethodHandle mh, MethodType newType) {
        return mh.asType(newType);
    }

    MethodHandle(MethodType type, Class definingClass, String name, int kind, Object thunkArg) {
        this.definingClass = definingClass;
        this.defc = definingClass;
        this.name = name;
        this.kind = kind;
        this.vmDispatchTarget = vmDispatchTargets[kind];
        this.type = this.computeHandleType(type);
        MethodHandle.enforceArityLimit(this.type);
        this.thunks = this.computeThunks(thunkArg);
        MethodHandle.getUnsafe();
    }

    MethodHandle(MethodHandle original, MethodType newType) {
        this.definingClass = original.definingClass;
        this.defc = original.defc;
        this.name = original.name;
        this.kind = original.kind;
        this.vmDispatchTarget = original.vmDispatchTarget;
        this.type = newType;
        MethodHandle.enforceArityLimit(newType);
        this.thunks = original.thunks;
        this.rawModifiers = original.rawModifiers;
        this.specialCaller = original.specialCaller;
        this.vmSlot = original.vmSlot;
        this.previousAsType = original.previousAsType;
    }

    @PolymorphicSignature
    public final native Object invokeExact(Object ... var1) throws Throwable, WrongMethodTypeException;

    @PolymorphicSignature
    public final native Object invoke(Object ... var1) throws Throwable, WrongMethodTypeException, ClassCastException;

    private native Class lookupMethod(Class var1, String var2, String var3, int var4, Class var5);

    final native Class lookupField(Class var1, String var2, String var3, int var4, Class var5);

    static native boolean setVMSlotAndRawModifiersFromField(MethodHandle var0, Field var1);

    static native boolean setVMSlotAndRawModifiersFromMethod(MethodHandle var0, Class var1, Method var2, int var3, Class var4);

    static native boolean setVMSlotAndRawModifiersFromConstructor(MethodHandle var0, Constructor var1);

    private static native boolean lookupVMDispatchTargets(long[] var0);

    MethodType computeHandleType(MethodType incomingType) {
        return incomingType;
    }

    static native boolean setVMSlotAndRawModifiersFromSpecialHandle(VirtualHandle var0, DirectHandle var1);

    final Class finishMethodInitialization(Class specialToken, MethodType oldType) throws NoSuchMethodException, IllegalAccessException {
        try {
            String signature = oldType.toMethodDescriptorString();
            return this.lookupMethod(this.definingClass, this.name, signature, this.kind, specialToken);
        }
        catch (NoSuchMethodError e) {
            throw new NoSuchMethodException(e.getMessage());
        }
        catch (IncompatibleClassChangeError e) {
            throw new IllegalAccessException(e.getMessage());
        }
    }

    public MethodType type() {
        return this.type;
    }

    public MethodHandle asSpreader(Class<?> arrayClass, int spreadCount) throws IllegalArgumentException, WrongMethodTypeException {
        MethodType collectType;
        if (!arrayClass.isArray()) {
            throw new IllegalArgumentException();
        }
        if (spreadCount < 0 || spreadCount > this.type.parameterCount()) {
            MethodHandle.throwIllegalArgumentExceptionForMHArgCount();
        }
        MethodHandle adapted = this;
        if (spreadCount == 0) {
            collectType = this.type.appendParameterTypes(arrayClass);
        } else {
            int length = this.type.parameterCount();
            Class<?> componentType = arrayClass.getComponentType();
            collectType = this.type.changeParameterType(length - spreadCount, arrayClass);
            if (spreadCount > 1) {
                collectType = collectType.dropParameterTypes(length + 1 - spreadCount, length);
            }
            Object[] parameters = (Class[])this.type.arguments.clone();
            Arrays.fill(parameters, length - spreadCount, length, componentType);
            adapted = this.asType(MethodType.methodType(this.type.returnType, parameters));
        }
        return MethodHandles.spreadHelper(arrayClass, spreadCount, adapted, collectType);
    }

    public MethodHandle asCollector(Class<?> arrayClass, int collectCount) throws IllegalArgumentException, WrongMethodTypeException, NullPointerException {
        if (this.type.parameterCount() == 0 || collectCount < 0 || collectCount > 255) {
            throw new IllegalArgumentException();
        }
        if (arrayClass == null) {
            throw new NullPointerException();
        }
        int index = this.type.parameterCount() - 1;
        Class<?> lastClass = this.type.parameterType(index);
        if (!arrayClass.isArray() || !lastClass.isAssignableFrom(arrayClass)) {
            throw new IllegalArgumentException("Cannot assign '" + arrayClass + "' to methodtype '" + this.type + "'");
        }
        return new CollectHandle(this.asType(this.type.changeParameterType(index, arrayClass)), collectCount);
    }

    public MethodHandle asType(MethodType newType) throws ClassCastException {
        if (this.type.equals(newType)) {
            return this;
        }
        MethodHandle localPreviousAsType = this.previousAsType;
        if (localPreviousAsType != null && localPreviousAsType.type == newType) {
            return localPreviousAsType;
        }
        MethodHandle handle = this;
        Class<?> fromReturn = this.type.returnType;
        Class<?> toReturn = newType.returnType;
        if (fromReturn != toReturn) {
            MethodHandle filter = ConvertHandle.FilterHelpers.getReturnFilter(fromReturn, toReturn, false);
            handle = new FilterReturnHandle(this, filter);
        }
        if (handle.type != newType) {
            handle = new AsTypeHandle(handle, newType);
        }
        this.previousAsType = handle;
        return handle;
    }

    private static final native int vtableOffset();

    private static final native int objectOffset();

    private static final native int addressSize();

    private static final native int vmRefFieldOffset();

    public Object invokeWithArguments(Object ... args) throws Throwable, WrongMethodTypeException, ClassCastException {
        return MethodHandle.invokeWithArgumentsHelper(this.asType(MethodType.genericMethodType(args.length)), args);
    }

    private static native Object invokeWithArgumentsHelper(MethodHandle var0, Object[] var1);

    public Object invokeWithArguments(List<?> args) throws Throwable, WrongMethodTypeException, ClassCastException, NullPointerException {
        return this.invokeWithArguments(args.toArray());
    }

    public MethodHandle asVarargsCollector(Class<?> arrayParameter) throws IllegalArgumentException {
        if (!arrayParameter.isArray()) {
            throw new IllegalArgumentException();
        }
        int lastArgPos = this.type().parameterCount() - 1;
        Class<?> lastArgType = this.type().parameterType(lastArgPos);
        if (!lastArgType.isAssignableFrom(arrayParameter)) {
            throw new IllegalArgumentException();
        }
        return new VarargsCollectorHandle(this, arrayParameter);
    }

    public boolean isVarargsCollector() {
        return this instanceof VarargsCollectorHandle;
    }

    public MethodHandle asFixedArity() {
        return this;
    }

    public MethodHandle bindTo(Object value) throws IllegalArgumentException, ClassCastException {
        Class<?> firstParameterType = this.type().parameterType(0);
        if (firstParameterType.isPrimitive()) {
            throw new IllegalArgumentException();
        }
        value = firstParameterType.cast(value);
        if (this.getClass() == DirectHandle.class) {
            return new ReceiverBoundHandle(this, value);
        }
        if (value != null && this instanceof IndirectHandle) {
            try {
                return MethodHandles.Lookup.internalPrivilegedLookup.bind(value, this.name, this.type().dropParameterTypes(0, 1));
            }
            catch (IllegalAccessException e) {
                throw new Error(e);
            }
            catch (NoSuchMethodException e) {
                throw new Error(e);
            }
        }
        return MethodHandles.insertArguments(this, 0, value);
    }

    private static final native int getCPTypeAt(Class var0, int var1);

    private static final native MethodType getCPMethodTypeAt(Class var0, int var1);

    private static final native MethodHandle getCPMethodHandleAt(Class var0, int var1);

    private static MethodHandle resolveInvokeDynamic(Class clazz, String name, String methodDescriptor, long bsmData) {
        Unsafe unsafe = MethodHandle.getUnsafe();
        MethodHandle result = null;
        MethodType type = null;
        try {
            type = MethodType.fromMethodDescriptorString(methodDescriptor, VM.getVMLangAccess().getClassloader(clazz));
            short bsmIndex = unsafe.getShort(bsmData);
            int bsmArgCount = unsafe.getShort(bsmData + 2L);
            long bsmArgs = bsmData + 4L;
            MethodHandle bsm = MethodHandle.getCPMethodHandleAt(clazz, bsmIndex);
            if (null == bsm) {
                throw new NullPointerException("unable to resolve 'bootstrap_method_ref' in '" + clazz + "' at index " + bsmIndex);
            }
            Object[] staticArgs = new Object[3 + bsmArgCount];
            staticArgs[0] = new MethodHandles.Lookup(clazz, false);
            staticArgs[1] = name;
            staticArgs[2] = type;
            ConstantPool cp = SharedSecrets.getJavaLangAccess().getConstantPool(clazz);
            boolean treatLastArgAsVarargs = bsm.isVarargsCollector();
            Class<?> varargsComponentType = bsm.type.lastParameterType().getComponentType();
            int bsmTypeArgCount = bsm.type.parameterCount();
            for (int i = 0; i < bsmArgCount; ++i) {
                int staticArgIndex = 3 + i;
                short index = unsafe.getShort(bsmArgs + (long)(i * 2));
                int cpType = MethodHandle.getCPTypeAt(clazz, index);
                Object cpEntry = null;
                switch (cpType) {
                    case 1: {
                        cpEntry = cp.getClassAt((int)index);
                        break;
                    }
                    case 2: {
                        cpEntry = cp.getStringAt((int)index);
                        break;
                    }
                    case 3: {
                        int cpValue = cp.getIntAt((int)index);
                        Class<?> argClass = treatLastArgAsVarargs && staticArgIndex >= bsmTypeArgCount - 1 ? varargsComponentType : bsm.type().parameterType(staticArgIndex);
                        if (argClass == Short.TYPE) {
                            cpEntry = (short)cpValue;
                            break;
                        }
                        if (argClass == Boolean.TYPE) {
                            cpEntry = cpValue == 0 ? Boolean.FALSE : Boolean.TRUE;
                            break;
                        }
                        if (argClass == Byte.TYPE) {
                            cpEntry = (byte)cpValue;
                            break;
                        }
                        if (argClass == Character.TYPE) {
                            cpEntry = Character.valueOf((char)cpValue);
                            break;
                        }
                        cpEntry = cpValue;
                        break;
                    }
                    case 4: {
                        cpEntry = Float.valueOf(cp.getFloatAt((int)index));
                        break;
                    }
                    case 5: {
                        cpEntry = cp.getLongAt((int)index);
                        break;
                    }
                    case 6: {
                        cpEntry = cp.getDoubleAt((int)index);
                        break;
                    }
                    case 13: {
                        cpEntry = MethodHandle.getCPMethodTypeAt(clazz, index);
                        break;
                    }
                    case 14: {
                        cpEntry = MethodHandle.getCPMethodHandleAt(clazz, index);
                        break;
                    }
                }
                if (cpEntry == null) {
                    throw new NullPointerException();
                }
                staticArgs[staticArgIndex] = cpEntry;
            }
            CallSite cs = (CallSite)bsm.invokeWithArguments(staticArgs);
            if (cs != null) {
                if (!cs.getTarget().type().equals(type)) {
                    throw new WrongMethodTypeException();
                }
                result = cs.dynamicInvoker();
            }
        }
        catch (Throwable e) {
            if (type == null) {
                throw new BootstrapMethodError();
            }
            try {
                MethodHandle thrower = MethodHandles.throwException(type.returnType(), BootstrapMethodError.class);
                MethodHandle constructor = MethodHandles.Lookup.internalPrivilegedLookup.findConstructor(BootstrapMethodError.class, MethodType.methodType(Void.TYPE, Throwable.class));
                result = MethodHandles.foldArguments(thrower, constructor.bindTo(e));
                result = MethodHandles.dropArguments(result, 0, type.parameterList());
            }
            catch (IllegalAccessException iae) {
                throw new Error(iae);
            }
            catch (NoSuchMethodException nsme) {
                throw new Error(nsme);
            }
        }
        return result;
    }

    public String toString() {
        return "MethodHandle" + this.type.toString();
    }

    private final MethodHandle forGenericInvoke(MethodType newType, boolean dropFirstArg) {
        if (this.type.equals(newType)) {
            return this;
        }
        if (dropFirstArg) {
            return this.asType(newType.dropParameterTypes(0, 1));
        }
        return this.asType(newType);
    }

    private static final MethodHandle sendResolveMethodHandle(int cpRefKind, Class currentClass, Class definingClass, String name, String typeDescriptor, ClassLoader loader) throws ClassNotFoundException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException {
        MethodHandles.Lookup lookup = new MethodHandles.Lookup(currentClass, false);
        MethodType type = null;
        switch (cpRefKind) {
            case 1: {
                return lookup.findGetter(definingClass, name, MethodHandle.resolveFieldHandleHelper(typeDescriptor, loader));
            }
            case 2: {
                return lookup.findStaticGetter(definingClass, name, MethodHandle.resolveFieldHandleHelper(typeDescriptor, loader));
            }
            case 3: {
                return lookup.findSetter(definingClass, name, MethodHandle.resolveFieldHandleHelper(typeDescriptor, loader));
            }
            case 4: {
                return lookup.findStaticSetter(definingClass, name, MethodHandle.resolveFieldHandleHelper(typeDescriptor, loader));
            }
            case 5: {
                type = MethodType.fromMethodDescriptorString(typeDescriptor, loader);
                return lookup.findVirtual(definingClass, name, type);
            }
            case 6: {
                type = MethodType.fromMethodDescriptorString(typeDescriptor, loader);
                return lookup.findStatic(definingClass, name, type);
            }
            case 7: {
                type = MethodType.fromMethodDescriptorString(typeDescriptor, loader);
                return lookup.findSpecial(definingClass, name, type, currentClass);
            }
            case 8: {
                type = MethodType.fromMethodDescriptorString(typeDescriptor, loader);
                return lookup.findConstructor(definingClass, type);
            }
            case 9: {
                type = MethodType.fromMethodDescriptorString(typeDescriptor, loader);
                return lookup.findVirtual(definingClass, name, type);
            }
        }
        throw new UnsupportedOperationException();
    }

    private static final Class<?> resolveFieldHandleHelper(String typeDescriptor, ClassLoader loader) {
        MethodType mt = MethodType.fromMethodDescriptorString("(" + typeDescriptor + ")V", loader);
        return mt.parameterType(0);
    }

    private MethodHandle returnFilterPlaceHolder() {
        return this;
    }

    private static Object constructorPlaceHolder(Object newObjectRef) {
        return newObjectRef;
    }

    static void enforceArityLimit(MethodType type) {
        if (type.argSlots > 254) {
            MethodHandle.throwIllegalArgumentExceptionForMTArgCount(type.argSlots);
        }
    }

    static void throwIllegalArgumentExceptionForMTArgCount(int argSlots) {
        throw new IllegalArgumentException(Msg.getString("K0578", argSlots + 1));
    }

    static void throwIllegalArgumentExceptionForMHArgCount() {
        throw new IllegalArgumentException(Msg.getString("K0579"));
    }

    String mapKindToBytecode() {
        switch (this.kind) {
            case 5: {
                return "getField";
            }
            case 6: {
                return "getStatic";
            }
            case 7: {
                return "putField";
            }
            case 8: {
                return "putStatic";
            }
            case 2: 
            case 4: {
                return "invokeVirtual";
            }
            case 0: {
                return "invokeStatic";
            }
            case 1: {
                return "invokeSpecial";
            }
            case 9: {
                return "newInvokeSpecial";
            }
            case 3: {
                return "invokeInterface";
            }
            case 17: {
                return ((VarargsCollectorHandle)this).next.mapKindToBytecode();
            }
        }
        return "KIND_#" + this.kind;
    }

    static {
        if (!MethodHandle.lookupVMDispatchTargets(vmDispatchTargets)) {
            throw new InternalError("MethodHandle.vmDispatchTargets unavailable");
        }
        myUnsafe = null;
        VTABLE_ENTRY_SIZE = MethodHandle.addressSize();
        J9CLASS_OFFSET = MethodHandle.vmRefFieldOffset();
        INTRP_VTABLE_OFFSET = MethodHandle.vtableOffset();
        HEADER_SIZE = MethodHandle.objectOffset();
        ComputedCalls.load();
        ThunkKey.load();
        ThunkTuple.load();
        ILGenMacros.load();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    static @interface Invisible {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface PolymorphicSignature {
    }
}

