/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.console.preferences;

import com.ibm.cic.agent.internal.console.Messages;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPrefsBase;
import com.ibm.cic.agent.internal.console.manager.ConDataCtxtPrefsSSL;
import com.ibm.cic.agent.internal.console.preferences.ConPagePrefsBase;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.views.AConViewContentProvider;
import com.ibm.cic.common.core.console.views.ConViewListEntry;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.console.views.ConViewTreeList;
import com.ibm.cic.common.core.console.views.ConViewTreeListEntry;
import com.ibm.cic.common.core.console.views.IConView;
import com.ibm.cic.common.core.console.views.IConViewContentProvider;
import com.ibm.cic.common.core.utils.OutputFormatter;

public class ConPagePrefsSSL
extends ConPagePrefsBase {
    private ConViewTreeList useNonSecureModeView;
    private ConDataCtxtPrefsSSL m_dataCtxtSSL;

    public ConPagePrefsSSL(IConManager manager) {
        super(manager);
    }

    @Override
    protected ConDataCtxtPrefsBase initializeDataContext() {
        this.m_dataCtxtSSL = (ConDataCtxtPrefsSSL)this.conManager().getDataContext(ConDataCtxtPrefsSSL.class);
        return this.m_dataCtxtSSL;
    }

    @Override
    public void init() {
        this.setHeaderView(com.ibm.cic.agent.core.sharedUI.Messages.PreferencePage_Internet_SSLGroup);
        this.addView((IConView)new ConViewText(String.valueOf(com.ibm.cic.agent.core.sharedUI.Messages.PreferencePage_Internet_Note) + " " + com.ibm.cic.agent.core.sharedUI.Messages.PreferencePage_Internet_NoteMsg));
        this.addView((IConView)new ConViewText(""));
        this.addView((IConView)new ConViewText(com.ibm.cic.agent.core.sharedUI.Messages.PreferencePage_Internet_SSLLabel));
        this.addView((IConView)new ConViewText(""));
        this.addView((IConView)new ConViewText(com.ibm.cic.agent.core.sharedUI.Messages.PreferencePage_Internet_SessionNote));
        this.addView((IConView)new ConViewText(""));
        this.useNonSecureModeView = new ConViewTreeList(true);
        this.addView((IConView)this.useNonSecureModeView);
        super.init();
        this.useNonSecureModeView.setContentProvider((IConViewContentProvider)new NonSecureModeContentProvider());
    }

    @Override
    public void present(OutputFormatter a_output) {
        this.useNonSecureModeView.refresh();
        super.present(a_output);
    }

    static class ConActCheckUseNonSecureMode
    extends AConActionEntry<ConViewListEntry> {
        ConActCheckUseNonSecureMode() {
        }

        public void run(IConManager a_conManager) {
            ConDataCtxtPrefsSSL context = (ConDataCtxtPrefsSSL)a_conManager.getDataContext(ConDataCtxtPrefsSSL.class);
            if (context.isPreferenceEditable()) {
                context.setUseNonSecureMode(!context.getUseNonSecureMode());
            }
            super.run(a_conManager);
        }
    }

    static class ConActionFlipSessionOnly
    extends AConActionEntry {
        ConActionFlipSessionOnly() {
        }

        public void run(IConManager a_conManager) {
            ConDataCtxtPrefsSSL context;
            context.setSessionOnly(!(context = (ConDataCtxtPrefsSSL)a_conManager.getDataContext(ConDataCtxtPrefsSSL.class)).getSessionOnly());
            super.run(a_conManager);
        }
    }

    class NonSecureModeContentProvider
    extends AConViewContentProvider {
        NonSecureModeContentProvider() {
        }

        public String getLabel(Object element) {
            return element.toString();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof String && Messages.PreferencePage_Internet_NonsecureModeButton.equals(parentElement) && ConPagePrefsSSL.this.m_dataCtxtSSL.getUseNonSecureMode()) {
                return new String[]{Messages.PreferencePage_Internet_Permanent, Messages.PreferencePage_Internet_SessionOnly};
            }
            return null;
        }

        public Object[] getElements() {
            return new String[]{Messages.PreferencePage_Internet_NonsecureModeButton};
        }

        public void updateEntry(ConViewTreeListEntry entry) {
            Object element = entry.getElement();
            if (Messages.PreferencePage_Internet_NonsecureModeButton.equals(element)) {
                if (ConPagePrefsSSL.this.m_dataCtxtSSL.getUseNonSecureMode()) {
                    entry.setSelected(true);
                } else {
                    entry.setSelected(false);
                }
            } else if (Messages.PreferencePage_Internet_Permanent.equals(element)) {
                if (ConPagePrefsSSL.this.m_dataCtxtSSL.getSessionOnly()) {
                    entry.setSelected(false);
                } else {
                    entry.setSelected(true);
                }
            } else if (Messages.PreferencePage_Internet_SessionOnly.equals(element)) {
                if (ConPagePrefsSSL.this.m_dataCtxtSSL.getSessionOnly()) {
                    entry.setSelected(true);
                } else {
                    entry.setSelected(false);
                }
            }
        }

        public AConActionEntry getAction(Object element) {
            if (Messages.PreferencePage_Internet_NonsecureModeButton.equals(element)) {
                return new ConActCheckUseNonSecureMode();
            }
            if (Messages.PreferencePage_Internet_Permanent.equals(element)) {
                return new ConActionFlipSessionOnly();
            }
            if (Messages.PreferencePage_Internet_SessionOnly.equals(element)) {
                return new ConActionFlipSessionOnly();
            }
            return super.getAction(element);
        }
    }
}

